#!/usr/bin/perl
########################################################################################
#                             Syslog to Firewall
# Perl scrip to obtain auth.log, if intruders are present then add them to the Firewall
########################################################################################

#############################################
#Philosophy: Shoot first, ask questions later 
#############################################


#Please Note: 
#During the first startup without any status informations will end up in a error but this is not critical and to be ignored.
	#iptables v1.4.8: Couldn't load target `ScriptDynamic':/lib/xtables/libipt_ScriptDynamic.so: cannot open shared object file: No such file or directory
	#Try `iptables -h' or 'iptables --help' for more information.
	#iptables: No chain/target/match by that name.
#The reason is that the script doesnt know that iptables has not set the chain name yet.
#Thats no problem because the script adds the chain later and the error disappears on the next run.



# This program is distributed in the hope that it will be useful,
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE.  


#OCT2013"
#Check ReadMail - Done
#Check Syslog - Open
#Check ReadFTP - Open

#To document:
#Needed to enhance Sqirellmail to get the looger to work
#Needed to enhance Dovecot to get the looger to work - see /etc/dovecot/conf.d/10-logging.conf

#todo 16Oct2013 - no handling yet for  SSH PKI Login:
#Accepted publickey for motion from 212.19.51.190 port 34296 ssh2

#1.0.1 Fix a racing problem with the epoche saving, need to set the startdate properly
#Info for Raspberry: Check Logrotate for a daiely rotation of /var/log/auth.log

#1.0.2 Fix wrong whitelist condition - 20oct2014

#1.0.3 - Add Roundcube - Nov2014

#Splunk Fields!
#SRV=$host
#M=S2F
#LFR=$FWRule
#LOF=$tmpuser logoff
#WID=1 (Whitelisted entry)
#DIP= detected ip
#IDU=$tmpuser
#LOU Logon User
#TGE=TimeGenerated
#PROTO=protocl (mail,ftp,auth) - SQM (squirrelmail)
#LCK=1 user/ip get locked
#SUC=1  Success login
#IEI=Intrusion expired ip

use strict;
#use Win32::OLE('in');
use POSIX;
use HTTP::Date qw/str2time/;
use XML::Simple;      #=>Read my XML Config
#use Net::Syslog;
use Time::Local;
use Data::Dumper;
use Sys::Hostname;
use Cwd 'abs_path';
use File::Basename;
use Mail::Sendmail;

my $dirname = dirname(abs_path($0));  #get my working directory


	
my ($TimeBack,$BlockTimeDelta,$ExpireDelta,$MaxRequest,$IPTABLESCHAIN,$FirewallAllowAllLoggededIn,$FirewallInsertPosition,$gmt_offset_in_seconds,$UseGMT,@syslogip,@whitelistip,@resp,$WriteLog,$WriteSplunkLog,$Syslog,$gmt_offset_in_seconds,$startLastToken,$startLastSucToken,$LogAge,$DoNotBlock);
my ($Mailto,$Mailfrom,$Mailbody,$Mailserver,$Mailsubject,$MailLevel,$tmpRequestSendLevel,$AllowLoggededInToFirewall,$FirewallUserRuleName,$CheckMailLog,$CheckFTPLog,$CheckApacheLog,$MailIgnoreLocalNetwork,$MailIgnoreWhitelist,$CheckRoundCubeLog,$RoundCubeLogName);


	



#AllowLoggededInToFirewall
#FirewallUserRuleName



#################################################################################################
my $stime=time; #first thing to do...  #1.0.1
$stime=$stime-1;  #Raspberry special, remove on fast this on recent CPU's
my $IgnoreSystemWhitelist;
#Not needed anymore Oct2013
#my $IgnoreSystemWhitelist=1; #Do this!!!, we will whitelist by default all internal ip addresses
#														# Note: This can be overwritten by ReadConfig !
my $Conffile=$dirname ."/syslog2fw.xml";
my @internalwhitelist= ('0.0.0.0','127.0.0.1','10.0','172.22','192.168');  #NEVER EVER BLOCK THIS!!!
my $host = hostname;
my $iptables='/sbin/iptables';
my $AutoAddChain=1;
my $CachedRecordWindow=6;  #5 seconds to ignore duplicate warnings in auth.log
#################################################################################################

############
&ReadConfig;
############


#Open syslog dat filehandle
my $tldate = strftime("%Y%m%d", localtime(time));
my $evtflog="$tldate-syslog2fw.log";

if ($WriteLog) {
 if (! -d "/var/log/syslog2fw/") {
	 mkdir('/var/log/syslog2fw/',0755);
 }	
 open (FHLog, ">>/var/log/syslog2fw/$evtflog") or die "no such file";
}

if ($WriteSplunkLog){
	 open (FHSPLUNK, ">>/var/log/splunk-s2f.log") or die "no such file s2f";
}








my (%hDatRecords,%hDatSucRecords,%IPCnt,%IPSucCnt,$fwCNT,$Expiredrecords,%hDatExpiredRecords);
my (@resp,$FWRule);  #=> Check if thos can be deleted
my ($csvtoken,$csvSuctoken,@IPTableArgs,$IPTablesRet,$IPTablesRetChain);


my $GetLastStartDate=&getLastStartDate;

#Check for datechange
#############
&CheckLogAge;
#############




###############
&ReadTimeBack;
###############



################################
#Get results from local database
&ReadDatFile;
################################




###################################################
#Get results from Syslog
if ($CheckMailLog eq 1){
&ReadMaillogRecords;  #Check before switch on ...
} 
if ($CheckFTPLog eq 1){
 &ReadFTPRecords;
} 

if ($CheckApacheLog eq 1){
 &ReadApacheRecords;
} 

if ($CheckRoundCubeLog eq 1){ #1.0.3 => Use me as default ...
 &ReadRoundCubeLog;
} 


&ReadSyslogRecords;
###################################################


#Add to IP / Job Counter 
for my $pntepoche ( sort keys %hDatRecords ){   
 if ($pntepoche > (time-$BlockTimeDelta)) {
  for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  #Get IPs and count them
   $IPCnt{$pntip}++;  #==>> Job Counter	
  } 
 }	
}



for my $pntepoche ( sort keys %hDatSucRecords ){   
 if ($pntepoche > (time-$BlockTimeDelta)) {
  for my $pntip( sort keys %{$hDatSucRecords{$pntepoche}} ) {  #Get IPs and count them
 	 $IPSucCnt{$pntip}++;  #==>> Job Counter	
  } 
 }	
}


$csvSuctoken=undef;
for my $pntIP ( sort keys %IPSucCnt ){   #Copy my previous status back to memory!
 #syslog ("SUCCESS LIST $pntIP");
 $csvSuctoken.="$pntIP,";
}	

 
#print "=>$startLastToken<=\n";
#Building preview!! 
for my $pntIP ( sort keys %IPCnt ){   #Copy my previous status back to memory!
 if ($IPCnt{$pntIP} >= $MaxRequest){
 	#syslog ("CSV Add $pntIP $IPCnt{$pntIP} $MaxRequest");
 	$csvtoken.="$pntIP,";
 }	
}	

syslog ("STO==>$startLastToken");
syslog ("CSV==>$csvtoken");
syslog ("SLS==>$startLastSucToken");
syslog ("SUT==>$csvSuctoken");




#print "=>$csvtoken<=\n";
#$startLastSucToken=$slastToken[0];
#$startLastSucToken ne $startLastToken
 
 
 
 ########### ($startLastSucToken ne $csvSuctoken)
 ###########or ($startLastSucToken ne $csvSuctoken)
 #if (($startLastToken ne $csvtoken) and ($DoNotBlock ne 1)) {   #Status File differs from current IP list -> recreate firewall rules!
 #if (( ($startLastToken ne $csvtoken)  ) and ($DoNotBlock ne 1)) {   #Status File differs from current IP list -> recreate firewall rules!
 
 if (( ($startLastToken ne $csvtoken) or ($startLastSucToken ne $csvSuctoken) ) and ($DoNotBlock ne 1)) {   #Status File differs from current IP list -> recreate firewall rules!
  
  
 	#To Do: Write .STA FILE !!!!
  SendToSyslog("Apply iptables: M=S2F"); 
  
  @IPTableArgs = ($iptables, "-D", "INPUT", "-j", $IPTABLESCHAIN);  #Remove Input -j rule to add back later - DO THIS!!!!
  syslog("Apply: @IPTableArgs "); 	
  #print "==> @IPTableArgs\n";
  $IPTablesRetChain=system(@IPTableArgs);  #Errors may occure - depending if the chain exists or not
  #if ($IPTablesRetChain) {  #Can not create chain - check system
  # syslog("Error using iinput rule"); 	
  #}
 
  @IPTableArgs = ("$iptables", "-F", "$IPTABLESCHAIN");  #We flush the given Chain Name
  syslog("DEB: @IPTableArgs "); 	
  $IPTablesRet=system(@IPTableArgs);
  
  
  @IPTableArgs = ("$iptables", "-X", "$IPTABLESCHAIN");  #We delete the given Chain Name
  syslog("DEB: @IPTableArgs "); 	
  $IPTablesRet=system(@IPTableArgs);
  
  @IPTableArgs = ("$iptables", "-Z");  #We reset all counters
  syslog("DEB: @IPTableArgs "); 	
  $IPTablesRet=system(@IPTableArgs);
  
  
  #if ($IPTablesRet) { #IGNORE THIS SINCE ERRORS MAY OCCURING - WE GO AHEAD!!!
   syslog ("Flush Chain $IPTABLESCHAIN returned a error: with $?");
   if ($AutoAddChain){
    @IPTableArgs = ("$iptables", "-N", "$IPTABLESCHAIN");  #We add the new chain
    $IPTablesRetChain=system(@IPTableArgs);
    syslog("Apply: @IPTableArgs "); 	
    if ($IPTablesRetChain) {  #Can not create chain - check system
     syslog("Can not create chain: $IPTABLESCHAIN - Check System!"); 	
     #exit;
    } else {
   	 syslog("Succesfully Created Iptables Chain: $IPTABLESCHAIN"); 	
    }	
   } else {
    syslog("ERROR: Can not continue, chain does not exist: $IPTABLESCHAIN"); 	
    #exit;
   } 
  #}  #Chain does exist and is flushed - go ahead!

  my $tmpipcnt; #Temp Counter
  my $tmpmessage;
  
  
  for my $pntIP ( sort keys %IPSucCnt ){   
    syslog("ALLOW !!!!  $IPSucCnt{$pntIP} = $pntIP");
    @IPTableArgs = ($iptables, "-A", $IPTABLESCHAIN,"-s",$pntIP,"-j","ACCEPT");  
    syslog("Apply: @IPTableArgs "); 	
    $IPTablesRetChain=system(@IPTableArgs);
    $tmpipcnt++;  #Do it!
  }
  
  for my $pntIP ( sort keys %IPCnt ){   
   if ($IPCnt{$pntIP} >= $MaxRequest){
    
    if (!subCheckInternalWhitelist($pntIP)){
    
     
     syslog("BLOCK $IPCnt{$pntIP} = $pntIP");
     $tmpmessage.="BLOCK $IPCnt{$pntIP} = $pntIP\n";
     $tmpipcnt++;
     @IPTableArgs = ($iptables, "-A", $IPTABLESCHAIN,"-s",$pntIP,"-j","LOG","--log-prefix","DropBy=$IPTABLESCHAIN ");  #set a space at the end ...
     syslog("Apply: @IPTableArgs "); 	
     
     $IPTablesRetChain=system(@IPTableArgs);

     if ($IPTablesRetChain) {  #Can not create chain - check system
      syslog("Error using rule / $pntIP"); 	
     } 


   #@internalwhitelist


     #syslog("Appy iptables, Drop: $pntIP"); 	
     @IPTableArgs = ($iptables, "-A", $IPTABLESCHAIN,"-s",$pntIP,"-j","DROP");  
     SendToSyslog("Add to iptables (drop): M=S2F DIP=$pntIP LCK=1"); 
     syslog("Apply: @IPTableArgs "); 	
     $IPTablesRetChain=system(@IPTableArgs);
    
    
    
     if ($IPTablesRetChain) {  #Can not create chain - check system
      syslog("Error using rule / $pntIP"); 	
     }
    } else {
     syslog("Ignor sys whitelist $pntIP"); 	
    }    #subCheckInternalWhitelist
   }
  }	
  if ($tmpmessage){
   &Sendmail(3,"Appy iptables\n$tmpmessage");
  } 
  
  if ($tmpipcnt) { #Apply "INPUT -j Scriptrule" BUT ONLY if there is a rule applying to this chain
   #SendToSyslog("Apply iptables!");
   #@IPTableArgs = ($iptables, "-A", "INPUT", "-j", $IPTABLESCHAIN);  
   @IPTableArgs = ($iptables, "-I", "INPUT", "2", "-j", $IPTABLESCHAIN);  
   syslog("Apply iptables: @IPTableArgs "); 	
   #print "==> @IPTableArgs\n";
   $IPTablesRetChain=system(@IPTableArgs);
   if ($IPTablesRetChain) {  #Can not create chain - check system
    syslog("Error using Input rule."); 	
   }
  }
 } else {  #if ($startLastToken ne $csvtoken)
 	 if ($DoNotBlock ne 1){
 	  syslog("NOTHING TO DO"); 	
 	 } 
 	#syslog("NOTHING TO DO \n=>$startLastToken\n=>$csvtoken"); 	
 } #if ($startLastToken ne $csvtoken)


&WriteSTAT;


#exit;
 #rewrite DAT File and mark the firewalled records
 open (FHDAT, ">$dirname/syslog2fw.dat") or die "no such file";
 print FHDAT "#success;epoche;ip;firewalled\n"; #CSV Header
 for my $pntepoche ( sort keys %hDatRecords ){   
  for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  
   if (($pntepoche) and ($pntepoche)){
    if (!$hDatSucRecords{$pntepoche}{$pntip}) {
     if ($IPCnt{$pntip} >= $MaxRequest){
      print FHDAT "0;$pntepoche;$pntip;1\n";
     } else {
      print FHDAT "0;$pntepoche;$pntip;$hDatRecords{$pntepoche}{$pntip}\n";
     }
    } else {
     #if ($FirewallAllowAllLoggededIn) {
   	 # print FHDAT "1;$pntepoche;$pntip;1\n"; #Success Record
     #}
    }
   } else {
   	#syslog("Empty record? $pntepoche/$pntip");
   } 
  }
 }


 if ($FirewallAllowAllLoggededIn) {
  close (FHDAT);
  open (FHDAT, ">>$dirname/syslog2fw.dat") or die "no such file";
  for my $pntepoche ( sort keys %hDatSucRecords ){   
   for my $pntip( sort keys %{$hDatSucRecords{$pntepoche}} ) {  
    if (($pntepoche) and ($pntepoche)){
   	 print FHDAT "1;$pntepoche;$pntip;1\n"; #Success Record
    } 
   }
  }
 }
###################
##### FINISHED ####
###################





sub WriteSTAT {
 open (FHSTAT, ">$dirname/syslog2fw.sta") or die "no such file";
 #print "=>" . time .  "\n";
 #This might be a bug!!!                                         #1.0.1
 #Think of slow CPUs which may write a wrong datestamp           #1.0.1
 #print FHSTAT (time);                                           #1.0.1
 print FHSTAT ($stime);  #1.0.1
 if ($csvtoken){
	print FHSTAT ";$csvtoken";
 }	
 #print  "\n";
 print FHSTAT "\n";
 if ($FirewallAllowAllLoggededIn) {
  if ($csvSuctoken){
	 print FHSTAT "$csvSuctoken";
	 print FHSTAT "\n";
  }	
 }
 close FHSTAT;
}


sub ReadMaillogRecords {
 ##########################
 #MAIL MODULE
 #Parse: /var/log/mail.log
 ##########################
 
 #my %hTempDatRecords; 
 open FHL, "</var/log/mail.log" or die "mail.log does not exist";
 my $cnt=0;
 my ($tmpIP,$tmpUser,$whiteIP,$sysIP);
 #my ($tmpPID,%cacheIP,$cachedRecord); #RuntimeCache Vars
 my ($tmpIP,$tmpUser);
 while (<FHL>){
	
  ######################################################################################################################################################### 
  #                                               IMAP PLUGIN
  #########################################################################################################################################################

  
  ################
  #  AUTH FAIL
  ################  
  #Oct 13 19:19:06 vm-mk01 dovecot: imap-login: Aborted login (auth failed, 1 attempts in 4 secs): user=<joe>, method=PLAIN, rip=127.0.0.1, lip=127.0.0.1, secured, session=<bwA+jKLo7QB/AAAB>
  #Dec 12 20:07:53 vm-mk01 dovecot: imap-login: Disconnected (auth failed, 1 attempts): user=<matthias>, method=PLAIN, rip=95.222.246.70, lip=78.47.152.76, TLS: Disconnected
  if (/auth failed/i){   #incorrect pwd
   if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get Date
		my $tmpEpoche=str2time("$1 $2 $3");
		my $tmpDate="$1 $2 $3";
   	if ((time-$TimeBack) < $tmpEpoche ){  #Filter the time
	   if (/imap-login/i){   #
	 	  if (/user\=\<([^\>]*)/i){   
	 		 $tmpUser=$1;
	 	   if (/rip\=(\d+)\.(\d+)\.(\d+)\.(\d+)/i){   
  	    $tmpIP=$1.".".$2.".".$3.".".$4;
  	    $whiteIP=&subCheckWhitelist($tmpIP);  #Ignore whitelist from config
        $sysIP=&subCheckInternalWhitelist($tmpIP);  #Ignore system whitelist
        if ((!$whiteIP) and (!$sysIP)){
         syslog("Blacklist (mail): $tmpEpoche $tmpIP");
         SendToSyslog("Intrusion Detection: SRV=$host M=S2F WID=0 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=MAIL");
         $hDatRecords{($tmpEpoche)}{$tmpIP}="1"; # !!!MARK AS INTRUDER!!!	
        } else {
         &syslog(" =IMAP FAIL FROM INTERNAL $tmpIP / $tmpUser");  	
         SendToSyslog("Failed Login: SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=MAIL");
        } #if (!$whiteIP)
  	   }  
  	  } 
     } 
    } 
   } 
  }

  ############################
  #   SMTP-AUTH SUCCESS PLUGIN
  ############################
  #Simply log only all successful imap logins
  #Blackberry login/reboot sequence SM-MTA
  #Oct 15 19:15:17 vm-mk01 sm-mta[26732]: AUTH=server, relay=tmo-109-189.customers.d1-online.com [80.187.109.189], authid=matthias, mech=PLAIN, bits=0
  #Oct 15 19:15:18 vm-mk01 sm-mta[26732]: r9FHF9O9026732: tmo-109-189.customers.d1-online.com [80.187.109.189] did not issue MAIL/EXPN/VRFY/ETRN during connection to MTA-v4
	if (/sm-mta/i){   #P
   my $tmpEpoche=undef;
	 my $tmpDate=undef;
   
   if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get Date
		$tmpEpoche=str2time("$1 $2 $3");
		$tmpDate="$1 $2 $3";
 	  if ((time-$TimeBack) < $tmpEpoche ){  #Filter the time
	   if (/AUTH\=server/i){   #P
      $tmpIP=undef;
      $tmpUser=undef;
      #&syslog(" =LOGINXXXX $_");  	
      #user=<matthias>, method=PLAIN, rip=80.187.109.189
      if (/authid=([^,]*)/){
      #if (/user=\<([^\>]*)/){
    	  #&syslog(" =USERXXXX $1");  	
    	 $tmpUser=$1;
      }
      if (/\[(\d+)\.(\d+)\.(\d+)\.(\d+)\]/){
       #&syslog(" =IIIPPPPP $1.$2.$3.$4");  	
       $tmpIP=$1.".".$2.".".$3.".".$4;
      }
      if (($tmpIP) and ($tmpUser)){  #Watch for defaults
       &syslog(" =IMAP LOGIN $tmpIP / $tmpUser");  	
       SendToSyslog("Successful Login: SRV=$host M=S2F DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=MTA-AUTH SUC=1 LCK=0");
      }     #if (($tmpIP) and ($tmpUser))
     }      #if (/AUTH\=server/i)
    }       #if ((time-$TimeBack) < $tmpEpoche ){  #Filter the time
   }        #if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/)  #Get Date
  }         #if (/sm-mta/i)  






  ######################################################################################################################################################### 
  #                                               DOVECOT PLUGIN
  #########################################################################################################################################################
  
  if (/dovecot\:/i){   
   if (/Authentication failure/i){  
    if (/^([^ ]*) *([^ ]*) *([^ ]*)/){  
     my $tmpEpoche=str2time("$1 $2 $3");
		 my $tmpDate="$1 $2 $3";
     if ((time-$TimeBack) < $tmpEpoche ){ 
   	  if (/pam\(([^,]*)\,([^)]*)/){
  	   syslog("DOVECOT!$tmpEpoche! $1-$2 ==>>> $_");
       $tmpIP=$2;
       $tmpUser=$1;
       $whiteIP=&subCheckWhitelist($tmpIP);  #Ignore whitelist from config
       $sysIP=&subCheckInternalWhitelist($tmpIP);  #Ignore system whitelist
       if ((!$whiteIP) and (!$sysIP)){
        SendToSyslog("Intrusion Detection. SRV=$host M=S2F WID=0 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=MAIL LCK=0 SUC=0");
        syslog("     =>****  REAL INTRUSION   ****");
        $hDatRecords{($tmpEpoche)}{$tmpIP}="1"; # !!!MARK AS INTRUDER!!!	
       } else { 
        SendToSyslog("Failed Login. SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=MAIL LCK=0 SUC=0");
        syslog("     =>****  REAL INTRUSION   ****");
       }    #if ((!$whiteIP) and (!$sysIP))
  	  }     #if (/pam\(([^,]*)\,([^)]*)){
  	 }      #if ((time-$TimeBack) < $tmpEpoche )  #Filter the time
  	}       #if (/^([^ ]*) *([^ ]*) *([^ ]*)/)  #Get Date
   }        #if (/Authentication failure/i)   #dovecot message 
  }	        #if (/dovecot\:/i) #dovecot message






  ######################################################################################################################################################### 
  #                                               QPOPPER PLUGIN
  #########################################################################################################################################################



	if (/in\.qpopper/){
   if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get Date
		my $tmpEpoche=str2time("$1 $2 $3");
		my $tmpDate="$1 $2 $3";
    #&syslog(" =DEEB==$TimeBack / $tmpEpoche");
    if ((time-$TimeBack) < $tmpEpoche ){  #Filter the time
     if (/incorrect/i){   #incorrect pwd
     	#&syslog(" =USER==GETBACK $1 = $_");  	
     	if (/supplied for "([^"]*)/){
     	 &syslog(" =INVALID: $1");  	
      }
     	if (/ \((\d+)\.(\d+)\.(\d+)\.(\d+)\)/){
     		#&syslog(" =IPXX== $1 $2 $3 $4");  	
     		$tmpIP="$1.$2.$3.$4";

        $whiteIP=&subCheckWhitelist($tmpIP);  #Ignore whitelist from config
        $sysIP=&subCheckInternalWhitelist($tmpIP);  #Ignore system whitelist
        if ((!$whiteIP) and (!$sysIP)){
         SendToSyslog("Intrusion Detection. SRV=$host M=S2F WID=0 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=MAIL LCK=0 SUC=0");
         syslog("     =>****  REAL INTRUSION   ****");
         $hDatRecords{($tmpEpoche)}{$tmpIP}="1"; # !!!MARK AS INTRUDER!!!	
        } else {
         SendToSyslog("Failed Login. SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=MAIL LCK=0 SUC=0" );
         syslog("Blacklist: $tmpEpoche $tmpIP");
        }  #if (!$whiteIP)
   		  #&Sendmail(5,$_);
   		  #$hDatRecords{($tmpEpoche)}{$tmpIP}="1";
     	} 
     }    #incorrect pwd  
	   if (/POP login by user \"([^"]*)/){	#"UE Special ...
      #???
      #SendToSyslog("Intrusion Detection. SRV=$host M=S2F WID=0 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate");
     }
    }		  #Filter the time
   }      #Get Date
	}       #if (/in\.qpopper/)
	
  ######################################################################################################################################################### 
  #                                               SQUIRRELMAIL PLUGIN
  #########################################################################################################################################################


  my ($successlogin,$sfailedlogin,$sip,$successlogout);
  if (/squirrelmail\:/) {
   #print "Failx $_\n";
   if ((/Failed webmail/) or (/Webmail logout/) or (/Successful webmail login/)) {
    if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get Date
		 my $tmpEpoche=str2time("$1 $2 $3");
		 my $tmpDate="$1 $2 $3";
     #&syslog(" =DEEB==$TimeBack / $tmpEpoche");
     if ((time-$TimeBack) < $tmpEpoche ){  #Filter the time
      #(\d+).(\d+).(\d+).(\d+)

      #if (/\: Failed webmail login: by ([^ ]*) *([^at]*)\s+(\d+)\./) {
      if (/\: Failed webmail login: by ([^ ]*)/) {
       #print "Fail $1  == $_\n";
       $sfailedlogin=$1;
      }     #if (/\: Failed webmail login: by ([^ ]*)/) 
      
      if (/\: Successful webmail login: by ([^ ]*)/) {
       #print "Success $1  == $_\n";
       $successlogin=$1;
      }     #if (/\: Failed webmail login: by ([^ ]*)/) 
      
      
      if (/\: Successful webmail login: by ([^ ]*)/) {
       #print "Success $1  == $_\n";
       $successlogin=$1;
      }     #if (/\: Failed webmail login: by ([^ ]*)/) 
      
      if (/\: Webmail logout: by ([^ ]*)/) {
       #print "Success Logout $1  == $_\n";
       $successlogout=$1;
      }     #if (/\: Failed webmail login: by ([^ ]*)/) 
      
      
      #Better skip the dat, it's not our zone anyway...
      #if (/on ([^\: ]*)/) {
      # print "YY Fail Time $1 == $_\n";
      #}


      if (/at (\d+).(\d+).(\d+).(\d+) /) {
       #print "XX Fail IP $1.$2.$3.$4  == $_\n";
       $sip="$1.$2.$3.$4";
      }



      if (($successlogout) and ($sip)){  
        SendToSyslog("Squirrelmail Logout: SRV=$host M=S2F DIP=$sip LOF=$successlogout SUC=1");
        syslog("SQM Login: $tmpEpoche $sip");
      }

      
      if (($successlogin) and ($sip)){  #Success Login
        SendToSyslog("Squirrelmail Login: SRV=$host M=S2F DIP=$sip LOU=$successlogin SUC=1");
        syslog("SQM Login: $tmpEpoche $sip");
      }

      if (($sfailedlogin) and ($sip)){  #Block!
       $whiteIP=&subCheckWhitelist($sip);  #Ignore whitelist from config
       $sysIP=&subCheckInternalWhitelist($sip);  #Ignore system whitelist
       if ((!$whiteIP) and (!$sysIP)){
        SendToSyslog("Intrusion Detection. SRV=$host M=S2F WID=0 DIP=$sip IDU=$sfailedlogin TGE=$tmpDate PROTO=SQM");
        syslog("     =>****  REAL INTRUSION   ****");
        syslog("Blacklist: $tmpEpoche $sip");
        $hDatRecords{($tmpEpoche)}{$sip}="1"; # !!!MARK AS INTRUDER!!!	
       } else {
        syslog("Blacklist: $tmpEpoche $sip");
        SendToSyslog("Failed Login. SRV=$host M=S2F WID=1 DIP=$sip IDU=$sfailedlogin TGE=$tmpDate PROTO=SQM");
 		    syslog ("Add $sip-$sfailedlogin-".$tmpEpoche);
       }  #if (!$whiteIP)
      }  #if (($sfailedlogin) and ($sip))  #Block!

      
     }      #if ((time-$TimeBack) < $tmpEpoche )  #Filter the time
    }       #if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/)  #Get Date
   }        #if ((/Failed webmail/) or (/Webmail logout/))
  }         #if (/squirrelmail\:/) 
  ######################################################################################################################################################### 
  #########################################################################################################################################################

  
 }	        #while (<FHL>)
}         #SUB


sub ReadFTPRecords {
 
 my %hTempDatRecords; 
 
 my ($tmpEpoche,$tmpUser,$tmpIP,$tmpDate,$tmpAuth);
 my $tmpProto="ftp";

 my $filename = "/var/log/vsftpd.log";
 
 if (-e $filename) {
  open FHL, "<$filename" or die "$filename does not exist";
 } else {
 	syslog("FTP Log does not exist: $filename");
 }
 my $cnt=1;
 my ($tmpPID,%cacheIP,$cachedRecord); #RuntimeCache Vars
 while (<FHL>){
	chomp;
	$tmpUser=undef;
	$tmpIP=undef;
	$tmpAuth=undef;
	$cnt++;

  #syslog("=>$cnt == $_");
	if (/(FAIL LOGIN|OK LOGIN)/i) {  #This is just a precheck to speed up things ...
	 #if (m/^([^ ]*) ([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) \[([^\]]*)/){  #Get the epoche date from the log record, also the special PID ...
	 if (m/^([^ ]*) ([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Same as above but ignore tmppid ...
	  #syslog("Get Epoche  $1 $2 $3 $4 $5 -- $_");
	  $tmpEpoche=str2time("$2 $3 $4");
	  $tmpDate="$2 $3 $4";
	  #if ($5 =~ /\[(\d+)\]/) {
	  	#syslog("PID $6");
	  	#$tmpPID=$6;  
	  #} 
   }	
	 if ((time-$TimeBack) < $tmpEpoche ){  #Filter the time
	  #syslog("=>$cnt xx==xx $tmpEpoche-$tmpDate-$tmpPID xxxxxxxxx =>$6<=");
    if (/Client "(\d+)\.(\d+)\.(\d+)\.(\d+)"/){  #Get IP
     $tmpIP="$1.$2.$3.$4";
    }

    if ((/\[(\w+)\] OK LOGIN/) or (/\[(\w+)\] FAIL LOGIN/)){
     $tmpUser=$1;
    }

    if (/OK LOGIN/){
     $tmpAuth=1;
    } 
	  
	  
	  if (/Accepted publickey for/){
	  	$tmpAuth=1;
	  }
	  
	  #syslog("=>$cnt xx==xx $tmpEpoche-$tmpDate-$tmpIP-$tmpUser");
	  
	  

	  #MUA ALOA
	  if ($tmpAuth){
	  	syslog("AUTH OK");
	  } else {
	  	syslog("****  AUTH FAIL  *****");
	  }

    if (!$tmpAuth){

     my $whiteIP=undef; #leave me here!
     #Ignore whitelist from config
     foreach (@whitelistip){ #Checking whitelist before we block this ip
	    if ($tmpIP =~ /^$_/){
		   syslog("==>> $_ / Ignore because this is a IP of config whitelist: $tmpIP   ");
		   SendToSyslog("Config Whitelisted Intrusion Detection SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=FTP");
		   $whiteIP=$_; #Set Whitelist!
		   last;
	    }
     }
     if (!$whiteIP) {   ##Checking whitelist before we block this ip
      #Ignore system whitelist
      
      if ((!$IgnoreSystemWhitelist) or ($IgnoreSystemWhitelist eq "0")){  #Default is undef unless you switch this off in our configuration
       foreach (@internalwhitelist){ #Checking system whitelist before we block this ip
        if ($tmpIP =~ /^$_/){
         SendToSyslog("System Whitelisted Intrusion Detection SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=FTP");
         syslog("Ignore because this is a IP of system whitelist: $_ --> $tmpIP --  Ignore!");
         $whiteIP=$_; #Set Whitelist!
         last;
        }  
       }
      }
     } 
     if (!$whiteIP) {   ##Checking whitelist before we block this ip
      syslog("     =>****  REAL INTRUSION   ****");
      SendToSyslog("Intrusion Detection. SRV=$host M=S2F WID=0 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=FTP");
		  syslog ("Add $tmpIP-$tmpUser-$tmpEpoche from ftp");
   	  &Sendmail(5,$_);
   	  $hDatRecords{($tmpEpoche)}{$tmpIP}="1";
     } else {
      syslog(" ==> Info: whitlist address: / $whiteIP // $tmpIP ");
	   }  #whitelist
	  }   #$tmpAuth
	 }    #if ((time-$TimeBack) < $tmpEpoche )  #Filter the time
  }     #if (/(FAIL LOGIN|OK LOGIN)/i)   #This is just a precheck to speed up things ...
 }      #While ....
}       #FTP Sub










sub ReadApacheRecords {
 my %hTempDatRecords; 
 my ($tmpEpoche,$tmpUser,$tmpIP,$tmpDate,$tmpAuth);
 my $tmpProto="ftp";
 my $filename = "/var/log/apache2/error.log";
 
 if (-e $filename) {
  open FHL, "<$filename" or die "$filename does not exist";
 } else {
 	syslog("Apache Log does not exist: $filename");
 }

 my $cnt=1;
 my ($tmpPID,%cacheIP,$cachedRecord); #RuntimeCache Vars
 while (<FHL>){
	chomp;
	$tmpUser=undef;
	$tmpIP=undef;
	$tmpAuth=undef;
	$cnt++;
	if ((/user *([^ ]*): authentication failure/) or (/user *([^ ]*) not found:/)){
	 if ($1){
	  $tmpUser=$1;
	 } else {
	 	$tmpUser="NA";
	 } 
	 
	 if (/\[*([^\]]*)/){
	  $tmpEpoche=str2time("$1");
	  $tmpDate="$1";
   }

   #print "HW $tmpUser $TimeBack " . time . " - " . (time-$TimeBack) . "  $tmpEpoche $_\n";	
	 if ((time-$TimeBack) < $tmpEpoche ){  #Filter the time
	  #syslog("=>$cnt xx==xx $tmpEpoche-$tmpDate-$tmpPID xxxxxxxxx =>$6<=");
  
    
    if (/client (\d+)\.(\d+)\.(\d+)\.(\d+)/){  #Get IP
     $tmpIP="$1.$2.$3.$4";
    }
    #print "HWWWWW $tmpUser - $tmpIP\n";
	  
	  syslog("Error Login from: $tmpUser / $tmpIP   ");
	

    my $whiteIP=undef; #leave me here!
    #Ignore whitelist from config
    foreach (@whitelistip){ #Checking whitelist before we block this ip
	   if ($tmpIP =~ /^$_/){
		  syslog("==>> $_ / Ignore because this is a IP of config whitelist: $tmpIP   ");
		  
		  SendToSyslog("Config Whitelisted Intrusion Detection SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=Apache2");
		  $whiteIP=$_; #Set Whitelist!
		  last;
	   }
    }
    if (!$whiteIP) {   ##Checking whitelist before we block this ip
     #Ignore system whitelist
     if ((!$IgnoreSystemWhitelist) or ($IgnoreSystemWhitelist ne "0")){  #Default is undef unless you switch this off in our configuration
      foreach (@internalwhitelist){ #Checking system whitelist before we block this ip
       if ($tmpIP =~ /^$_/){
        SendToSyslog("System Whitelisted Intrusion Detection SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=Apache2");
        syslog("Ignore because this is a IP of system whitelist: $_ --> $tmpIP --  Ignore!");
        $whiteIP=$_; #Set Whitelist!
        last;
       }  
      }
     }
    } 
    if (!$whiteIP) {   ##Checking whitelist before we block this ip
     syslog("     =>****  REAL INTRUSION   ****");
     SendToSyslog("Intrusion Detection. SRV=$host M=S2F WID=0 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=Apache2");
		 syslog ("Add $tmpIP-$tmpUser-$tmpEpoche from www");
   	 &Sendmail(5,$_);
   	 $hDatRecords{($tmpEpoche)}{$tmpIP}="1";
    } else {
     syslog(" ==> Info: whitlist address: / $whiteIP // $tmpIP ");
	  }  #whitelist
	 }    #if ((time-$TimeBack) < $tmpEpoche )  #Filter the time
  }     #if (/(FAIL LOGIN|OK LOGIN)/i)   #This is just a precheck to speed up things ...
 }      #While ....
}       #Apache Sub









sub ReadSyslogRecords {
 
my %hTempDatRecords; 
open FHL, "</var/log/auth.log" or die "Auth.log does not exist";
my ($tmpEpoche,$tmpUser,$tmpIP,$tmpDate,$tmpAuth,$tmpPKUser,$tmpPKIP,$tmpPKEpoche,$tmpPKDate);
my $tmpProto="ssh";

 #exit;
#my $TimeBack=600000; #Let me take the .sta date
my $cnt=1;
my ($tmpPID,%cacheIP,$cachedRecord); #RuntimeCache Vars
while (<FHL>){
	chomp;
	$tmpUser=undef;
	$tmpIP=undef;
	$cnt++;

  if (/Accepted publickey for ([^ ]*) from (\d+)\.(\d+)\.(\d+)\.(\d+)/){ 
   #print "$1 $2-$3-$4-$5\n";
   
   $tmpPKUser=$1; #Dont do this!
   $tmpPKIP="$2.$3.$4.$5"; #Dont do this!
   if (m/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get the epoche date from the log record
		#syslog("Get Epoche  $1 $2 $3 $4 $5 -- $_");
		
		$tmpPKEpoche=str2time("$1 $2 $3");
		$tmpPKDate="$1 $2 $3"; 
   }  #if (m/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/)  #Get the epoche date from the log record
   
   if ((time-$tmpPKDate) < $tmpPKEpoche ){  #Filter the time
    #Do something   	
   	SendToSyslog("Accepted publickey SRV=$host M=S2F WID=0 DIP=$tmpPKIP IDU=$tmpPKUser TGE=$tmpPKDate PROTO=AUTH LCK=0 SUC=1");
   	syslog("INFO: Accepted publickey: $tmpUser/$tmpIP");
   }	
  } 


	if (/(invalid user|Authentication failure|Accepted|FAILED su|Successful su|session closed|Failed password)/i) {  #This is just a precheck to speed up things ...
	 
	 if ((!/keyboard/) or /Accepted/){     #Disclaimer for "keyboard" - we do not want duplicate records due to ssh debug logging
	  if ((/$tmpProto/) or (/su/)){        #Filter by protocol or su / superuser
		 #Nov 10 14:38:21 vm-mk01 sshd[24927]:
		 
		 if (m/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get the epoche date from the log record
		  #syslog("Get Epoche  $1 $2 $3 $4 $5 -- $_");
		  $tmpEpoche=str2time("$1 $2 $3");
		  $tmpDate="$1 $2 $3";
		  if ($5 =~ /\[(\d+)\]/) {
		  	#syslog("PID $1");
		  	$tmpPID=$1;
		  } 
	   }	
     
     
     #syslog("Check Record: " . (time-$TimeBack) . " - $tmpEpoche -- $_" );
     
     if ((time-$TimeBack) < $tmpEpoche ){  #Filter the time
    	if (/invalid user *([^ ]*)/){  #Get NON Existing User
    		#syslog("INVALID: $_");
    		$tmpUser=$1;
    	} else {	
    	 if (/Failed password for *([^ ]*)/){     #Get Existing User - That covers the above "precheck" rule - DO NOT REMOVE
    		syslog("INVALID: $_");
    		$tmpUser=$1;
    	 } else {
    	 	if (/Authentication failure for *([^ ]*)/){     #Get Existing User - Patched SSh Version
    		 #syslog("INVALID: $_");
    		 $tmpUser=$1;
    	  }
    	 }
    	}
    	
    	
    	if ((/FAILED su for *([^ ]*) by *([^ ]*)/)){
    	 SendToSyslog("FAILED SU SRV=$host M=S2F IDU=$2 LOU=0 TGE=$tmpDate PROTO=AUTH LCK=0");
    	 #$tmpRequestSendLevel=1;
       &Sendmail(1,$_);
    	 syslog("FAILED SU for $1 from $2");
    	 $tmpUser=$1;
    	 
      }

    	if ((/Successful su for *([^ ]*) by *([^ ]*)/)){
    	 SendToSyslog("Successful su SRV=$host M=S2F IDU=0 LOU=$2 TGE=$tmpDate PROTO=AUTH LCK=0 SUC=1");
    	 syslog("Successful SU for $1 from $2");
    	 if ("nobody" ne $1){
    	  &Sendmail(4,$_);
    	 } 
      }
 
   	  if ((/session closed for user *([^ ]*)/)){
    	 SendToSyslog("session closed SRV=$host M=S2F LOF=$1 TGE=$tmpDate PROTO=AUTH LCK=0");
    	 
    	 syslog("session closed for $1 ");
    	 if ("nobody" ne $1){
    	  &Sendmail(4,$_);
    	 } 
      }
 
    	if (/from (\d+)\.(\d+)\.(\d+)\.(\d+)/){  #Get IP
    	 #syslog("INVALID (Add IP): $_");
    	 $tmpIP="$1.$2.$3.$4";
      }
      
      
   
    	if ((/Accepted password for *([^ ]*)/) or (/Accepted keyboard-interactive\/pam for *([^ ]*)/)){
       #print "$_=\n";   
       syslog("Successful SSH Login: $tmpEpoche/$tmpIP");
       SendToSyslog("Successful SSH Login: SRV=$host M=S2F SUC=1 LOU=$1 TGE=$tmpDate PROTO=AUTH LCK=0");
       if ($FirewallAllowAllLoggededIn) {
     	  $hDatSucRecords{($tmpEpoche)}{$tmpIP}="1"; #09Dez
     	  syslog("Successful SSH MARK SUCC: $tmpEpoche/$tmpIP");
     	  
       } 
       my $tmpFound;
       if ($MailIgnoreWhitelist eq 1) {
        foreach (@whitelistip){ #Checking whitelist before we block this ip
	       if ($tmpIP =~ /^$_/){
		      $tmpFound=1;
		      last;
		     }
		    } 
		   } 

       if ($MailIgnoreLocalNetwork eq 1) {
        foreach (@internalwhitelist){ 
	       if ($tmpIP =~ /^$_/){
		      $tmpFound=1;
		      last;
		     }
		    } 
		   } 


      
       if (!$tmpFound){
        &Sendmail(2,"Successful SSH login\nUser $1\nFrom $tmpIP\nDate: $tmpDate");
       } else {
       	syslog("**SKIP** sendmail as adviced by configuration, this was the mail body:\nSuccessful SSH login\nUser $1\nFrom $tmpIP\nDate: $tmpDate");
       } 
   
       for my $pntepoche ( sort keys %hDatRecords ){   
        for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  
         if ($pntip eq $tmpIP){
         	SendToSyslog("Release Record SRV=$host M=S2F WID=0 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=AUTH LCK=0");
         	syslog("DELETE RECORD BECAUSE OF A ACCEPTED LOGON: $pntepoche/$pntip");
         	delete $hDatRecords{$pntepoche}{$pntip};  #Delete old - locked - errors BECAUSE of successfull login
         	&Sendmail(4,$_);
         }	
        }
       }
    	}
    	
            
      #$cacheIP{$tmpEpoche}{$tmpPID}=$tmpIP;	      
      $cachedRecord=undef;
   
      for my $pnt ( sort keys %cacheIP ){ #Check RuntimeCache for duplicate records within time range  
          for my $pntip( sort keys %{$cacheIP{$pnt}} ) {  
        if (($tmpEpoche-$pnt) < $CachedRecordWindow ) {
         syslog("==>> Cached record will be ignored!!! - $tmpEpoche $pnt $pntip $cacheIP{$pnt}{$pntip}");
         $cachedRecord=1;
        } 
       }
      } 	

            
            
      if (($tmpIP) and ($tmpUser) and (!$cachedRecord)) {
       $cacheIP{$tmpEpoche}{$tmpPID}=$tmpIP;	
       my $whiteIP=undef; #leave me here!
       
       #Ignore whitelist from config
       foreach (@whitelistip){ #Checking whitelist before we block this ip
	      if ($tmpIP =~ /^$_/){
		     syslog("==>> $_ / Ignore because this is a IP of config whitelist: $tmpIP   ");
		     SendToSyslog("Config Whitelisted Intrusion Detection SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=AUTH LCK=0");
		     $whiteIP=$_; #Set Whitelist!
		     last;
	      }
       }
        
       if (!$whiteIP) {   ##Checking whitelist before we block this ip
        #Ignore system whitelist
        if ((!$IgnoreSystemWhitelist) or ($IgnoreSystemWhitelist eq "0")){  #Default is undef unless you switch this off in our configuration
         foreach (@internalwhitelist){ #Checking system whitelist before we block this ip
          if ($tmpIP =~ /^$_/){
           SendToSyslog("System Whitelisted Intrusion Detection SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=AUTH LCK=0");
           syslog("Ignore because this is a IP of system whitelist: $_ --> $tmpIP --  Ignore!  == $IgnoreSystemWhitelist");
           $whiteIP=$_; #Set Whitelist!
           last;
          } 
         }
        }
       } 
       if (!$whiteIP) {   ##Checking whitelist before we block this ip
        syslog("     =>****  REAL INTRUSION   ****");
        SendToSyslog("Intrusion Detection. SRV=$host M=S2F SUC=0 WID=0 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=AUTH LCK=0");
   		  syslog ("Add $tmpIP-$tmpUser-".$tmpEpoche);
   		  &Sendmail(5,$_);
   		  $hDatRecords{($tmpEpoche)}{$tmpIP}="1";
       } else {
        syslog(" ==> Info: whitlist address: / $whiteIP // $tmpIP ");
       }
      }
     }    #if ((time-$TimeBack) < $tmpEpoche )
	  }     #if ((/(authentication failure|Failed password)/)
	 }      #if (!/keyboard/) 
	}       #if (/fail/) 
 }        #While ...

 
} #Sub



sub ReadDatFile {
 my $tmpfnd;
 open (FHDAT, "<$dirname/syslog2fw.dat") or syslog("No Dat File!");
 while (<FHDAT>) {
 	chomp;
 	s/#.*//;             #No Comments #
  s/'.*//;             #No Comments '
  s/^\s+//;            #No leading spaces
  s/\s+$//;            #No trailing spaces
 	my @hrecordToken = split(/;/,$_);
 	#if (($hrecordToken[0]) and ($hrecordToken[1])){  #DO NOT ADD EMPTY TOKENS
 	if ($hrecordToken[0] ne 1){
 	 $hDatRecords{$hrecordToken[1]}{$hrecordToken[2]}=$hrecordToken[3];
 	 #syslog("Read DAT $hrecordToken[0]=$hrecordToken[1]=$hrecordToken[2]=$hrecordToken[3] " );
 	} else {
   if ($FirewallAllowAllLoggededIn) {
 	  $hDatSucRecords{$hrecordToken[1]}{$hrecordToken[2]}=1;
 	  #syslog("Read SUCCESS DAT $hrecordToken[0]=$hrecordToken[1]=$hrecordToken[2]=$hrecordToken[3] " );	
 	 } 
 	}
 }

 ##Check and delete expired records
 for my $pntepoche ( sort keys %hDatSucRecords ){   
  for my $pntip( sort keys %{$hDatSucRecords{$pntepoche}} ) {  
 	 #syslog("Record: $pntip " . (time-$ExpireDelta) . " =>$hDatSucRecords{$pntepoche}{$pntip}");
 	 if (($pntepoche) and ($pntepoche<(time-$ExpireDelta))){
    syslog("Delete expired success Record: $pntip " . (time-$ExpireDelta) . " =>$hDatSucRecords{$pntepoche}{$pntip}");
    SendToSyslog("Delete expired record: M=S2F DIP=$pntip LCK=0"); 
    delete $hDatSucRecords{$pntepoche}{$pntip};  #Delete hash
   }
  }
 }


 
 ##Check and delete expired records
 for my $pntepoche ( sort keys %hDatRecords ){   
  for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  
 	 #syslog("--Record: $pntip Exp:$pntepoche-" . (time-$ExpireDelta) . " =>$hDatRecords{$pntepoche}{$pntip}");
 	 if (($pntepoche) and ($pntepoche<(time-$ExpireDelta))){
    syslog("Delete expired Record: $pntip " . (time-$ExpireDelta) . " =>$hDatRecords{$pntepoche}{$pntip}");
    if (!$hDatExpiredRecords{$pntip}){
     if ($hDatExpiredRecords{$pntip} ne 1){
      $hDatExpiredRecords{$pntip}=$hDatRecords{$pntepoche}{$pntip}; #copy record to build diff. later
     } 
    } 
    delete $hDatRecords{$pntepoche}{$pntip};  #Delete hash
    delete $hDatSucRecords{$pntepoche}{$pntip};  #Delete hash
   }
  }
 }

 for my $pntip ( sort keys %hDatExpiredRecords){   
  $tmpfnd=undef;  
  for my $pntepoche ( sort keys %hDatRecords ){   
   if ($hDatRecords{$pntepoche}{$pntip}){
    syslog("Exist $pntepoche / $pntip ");
    $tmpfnd=1;
    last;
   } 
  } 
  
  if ($hDatExpiredRecords{$pntip} eq 1){
   if (!$tmpfnd){  #send only to syslog if the record has fully gone
  	$Expiredrecords=1;  #Expired records are occuring, that means that we inventory all data new
  	SendToSyslog("Fully ExpiredRecord M=S2F IEI=$pntip LCK=0");
  	syslog("Firewall record has fully expired: $pntip ==> $hDatExpiredRecords{$pntip}");
   } else {
   	SendToSyslog("Single ExpiredRecord M=S2F IEI=$pntip LCK=1");
  	syslog("Firewall record has expired: $pntip ==> $hDatExpiredRecords{$pntip}");	
   } 
  } else {
   if (!$tmpfnd){ #send only to syslog if the record has fully gone
  	$Expiredrecords=1;  #Expired records are occuring, that means that we inventory all data new
  	SendToSyslog("A non firewalled record expired, M=S2F IDE=$pntip LCK=0");
  	syslog("Record has fully expired: $pntip ==> $hDatExpiredRecords{$pntip}");
   } else {
  	syslog("NON Firewall Record has expired: $pntip ==> $hDatExpiredRecords{$pntip}");
   }
  }
 }

 #set inventory flag $fwCNT
 for my $pntepoche ( sort keys %hDatRecords ){   
  for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  
 	 if ($hDatRecords{$pntepoche}{$pntip} eq 1) {
    $fwCNT++;   #Generic FW counter, this will tell us that there are at least some records on the firewall
    #syslog ("Count=$fwCNT / collect: $Expiredrecords" );
   } 
  }
 }



}



sub syslog {
  if ($WriteLog) {
    my $tldate = strftime("%d-%m-%Y %H:%M:%S", localtime(time));
    print FHLog "$tldate $_[0]\n";
    #print "$_[0]\n";
  }  
}  


sub SendToSyslog {
 my $s;

 if ($WriteSplunkLog eq 1) {
 	 my $tldate = strftime("%d-%m-%Y %H:%M:%S", localtime(time));
 	 print FHSPLUNK "$tldate $_[0]\n";
 }    #if ($WriteSplunkLog) 
 
 if ($Syslog eq 1){
  foreach (@syslogip){
   $s=new Net::Syslog(Facility=>'local4',Priority=>'debug',SyslogHost=>$_);
   $s->send($_[0],Priority=>'info');
  } 
 } 

}



sub ReadConfig {
 #######################################
 #Read My XML Config given in $Conffile
 #######################################
 #Getting arrays first ....
 my $data = eval {XMLin($Conffile,ForceArray => 1)};
 
 for( @{$data->{Syslog}}){
  syslog("Push: $_->{IP}");
  push(@syslogip,$_->{IP});
 } 
 for( @{$data->{Whitelist}}){
  syslog("Push: $_->{IP}");
  #print("Push: $_->{IP}\n");
  push(@whitelistip,$_->{IP});
 } 
 
 #Getting the setup (non array)
 my $xml = new XML::Simple (KeyAttr=>[]); 
 my $data = $xml->XMLin("$Conffile");
 
 $TimeBack=undef;
 #TimeBack Data
 #Set the time delta where you want me to check WMI for ip addresses in seconds
 #12h=43200
 #24h=86400
 #2h GMT+2
 #my $TimeBack=86400;
 $TimeBack=$data->{Setup}->{TimeBack};

 #Set the time delta where we check how many times a ip address had access our system
 $BlockTimeDelta=$data->{Setup}->{BlockTimeDelta};
 #Set the time delta where the existing DAT records expires
 $ExpireDelta=$data->{Setup}->{ExpireDelta};
 
 #IgnoreSystemWhitleist
 
 
 
 
 #Set the maximum amount of requests until we firewall the sender address
 $MaxRequest=$data->{Setup}->{MaxRequest};   
 #Firewall Rule Name
 $IPTABLESCHAIN=$data->{Setup}->{FirewallRuleName};   
 
 $FirewallInsertPosition=$data->{Setup}->{FirewallInsertPosition};   
 
 #Use GMT Time for WMI
 $UseGMT=$data->{Setup}->{UseGMT};   
 #Write Syslog 
 $WriteLog=$data->{Setup}->{WriteLog};   
 #Logrotate
 
 #write splunk file to /var/log/
 $WriteSplunkLog=$data->{Setup}->{WriteSplunkLog};   
 
 #Write Syslog
 $Syslog=$data->{Setup}->{Syslog};   
 
 $LogAge=$data->{Setup}->{Logage};   
 #Never start IPTables
 $DoNotBlock=$data->{Setup}->{DoNotBlock};   
 

 #Path to IPTables
 $iptables=$data->{Setup}->{IPTablesCmd};   
 
 #Add chain automatically
 $AutoAddChain=$data->{Setup}->{AutoAddChain};   

 
 #Disable SystemWhitleist
 if ($data->{Setup}->{IgnoreSystemWhitelist} eq 1) {   
  $IgnoreSystemWhitelist=1;
 } else {
 	$IgnoreSystemWhitelist=undef;
 } 


  $FirewallAllowAllLoggededIn=$data->{Setup}->{FirewallAllowAllLoggededIn};   
	$CheckMailLog=$data->{Setup}->{CheckMailLog};   
	$CheckFTPLog=$data->{Setup}->{CheckFTPLog};   
  $CheckApacheLog=$data->{Setup}->{CheckApacheLog};   
	
	$CheckRoundCubeLog=$data->{Setup}->{CheckRoundCubeLog};   
	$RoundCubeLogName=$data->{Setup}->{RoundCubeLogName};   
	

  $MailLevel=$data->{Mail}->{Level};   
 	$MailIgnoreLocalNetwork=$data->{Mail}->{IgnoreLocalNetwork};   
	$MailIgnoreWhitelist=$data->{Mail}->{IgnoreWhitelist};   
  $Mailserver=$data->{Mail}->{Mailserver};    
  $Mailto=$data->{Mail}->{To};    
  $Mailfrom=$data->{Mail}->{From};    
 
 
 
 if ($UseGMT eq 1) {  #Add the GMT Offset to our local timezone if set in config.
  my @t = localtime(time);
  $gmt_offset_in_seconds = timegm(@t) - timelocal(@t);
 } 

}





sub getLastStartDate {
 $startLastToken=undef;	
 $startLastSucToken=undef;
 my $lastRecord;
 
 my @slastToken;
 my $scnt;
 open (FHSTAT, "<$dirname/syslog2fw.sta") or syslog("no status file?");
 while (<FHSTAT>){
	chomp;
  s/#.*//;             #No Comments #
  s/'.*//;             #No Comments '
  s/^\s+//;            #No leading spaces
  s/\s+$//;            #No trailing spaces
 	#####s/,$//;              #No comma ending    ### NOOOOOOOOO
  
  $scnt++;
  @slastToken  = split(/;/,$_);  #We first split semi colums to array IF apply ...
  
  #foreach (@slastToken){
  #	syslog("==>>>> $_");
  #}
  #for my $pntepoche ( sort keys %hDatRecords ){   
  # 	my @hrecordToken = split(/;/,$_);
 	#$hDatRecords{$hrecordToken[0]}{$hrecordToken[1]}=$hrecordToken[2];
  #}
  #syslog("==>>>> $slastToken[1]");
  
  if ($scnt eq 1){  #Has to be line number one
   #syslog ("YEEEPPPP");
   if ($slastToken[0]){
   $lastRecord=$slastToken[0];  #Do this! Return a proper datetime of my last execution ...
    #syslog ("Geeeeeeeeet syslog2fw.sta = " . $lastRecord);
   } 
   
   if ($slastToken[1]){
  	#syslog ("Geeeeeeeeet syslog2fw.sta = " . $slastToken[1]);
  	$startLastToken=$slastToken[1];
   }	   
   
   $lastRecord=$_;
	 #syslog ("Get syslog2fw.sta = " . $lastRecord);
	 
 }
 
  if ($FirewallAllowAllLoggededIn) {
   if ($scnt eq 2){
    if ($slastToken[0]){
     $startLastSucToken=$slastToken[0];
    }
    #syslog ("SUCC REC $startLastSucToken");
    #exit;
   }
  }
 
 if ($scnt > 2){  
  return $lastRecord;
 }


 #return $lastRecord;
 
 #return 2592000;  #Walk back for about 4 weeks if no file is given
 
 
 
}
return $lastRecord;



}

sub CheckLogAge {

 my $curdir=getcwd;
 my $curdir="/var/log/syslog2fw/";
 if (($LogAge) and ($LogAge ne 0)){
  my $lage=time-($LogAge*60*60*24);
  my $lday = strftime("%d", localtime($GetLastStartDate));
  my $cday = strftime("%d", localtime(time));
  if ($lday ne $cday) {
   syslog ("Daychange occured");	
   opendir(DIR, $curdir);
   my @logfiles = grep(/\.*$/,readdir(DIR));
   foreach (@logfiles){
 	  if (/log/i){
 	   open(FHVER, "$curdir$_");
     #print " -- " .((stat FHVER)[9]) . " --\n";
     if ( ((stat FHVER)[9]) lt $lage){
     	close FHVER;
     	syslog("delete $curdir/$_");
     	syslog("DEB " .((stat FHVER)[9]) . " - $lage ");
#DEB REMOVED 05Apr13
#     	unlink "$curdir/$_";
     }
 	  } 
   }
  }
 } 
}



sub ReadTimeBack {
 if (!$TimeBack) {   #Get reverse time
  #$TimeBack=(time-$GetLastStartDate)+60; #testing to see if we get better results trying 60 sec offset
  $TimeBack=(time-$GetLastStartDate)+1; #testing to see if we get better results trying 60 sec offset
  $TimeBack+=$gmt_offset_in_seconds; #Add GMT Offset!!!!
 }
} 



sub Sendmail {
if ($_[0] <= $MailLevel){
 $Mailsubject="Syslog event on $host";
 $Mailbody="Message:($_[0]/$MailLevel\n$_[1]";

 my %mail = ( 
       To      => "$Mailto",
       From    => "$Mailfrom",
       Subject => "$Mailsubject",
       Message => "$Mailbody",
       smtp    => "$Mailserver"
     );
  sendmail(%mail) or die $Mail::Sendmail::error;
  syslog ("OK. Log says: " . $Mail::Sendmail::log);
 }

}

sub subCheckWhitelist {
 #$_[0] = $tmpIP
 #syslog("==>> Whitelist:  $_[0]");
 foreach (@whitelistip){ #Checking whitelist before we block this ip
 	#syslog("Check WhiteList==>>   $_");
  #if ($_[0] =~ /^$_/){
  if ($_[0] =~ /$_/){
   #syslog("==>> $_ / Ignore because this is a IP of config whitelist: $tmpIP   ");
   #SendToSyslog("Config Whitelisted Intrusion Detection SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate");
   #syslog("==>> Whitelist: $_ / $_[0]");
   return $_[0];
  }
 }
 return undef;
}

sub subCheckInternalWhitelist {
 #$_[0] = $tmpIP
 
 #syslog("==>> 1st Whitelist:  $_[0] / $IgnoreSystemWhitelist");
 if ($IgnoreSystemWhitelist ne 1) {
  foreach (@internalwhitelist){ #Checking whitelist before we block this ip
 	 #syslog("==>>  WHITE $_");
   if ($_[0] =~ /^$_/){
    #syslog("==>> $_ / Ignore because this is a IP of config whitelist: $tmpIP   ");
    #SendToSyslog("Config Whitelisted Intrusion Detection SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate");
    syslog("==>> Whitelist: $_ / $_[0]");
    return $_[0];
   }
  } 
 }
 return undef;
}


sub ReadRoundCubeLog {                   #1.0.14
 

 my (%abbr,$curepoche,$myWhite,$tmpIP,$tmpUser,$tmpDate);
 my @t = localtime(time);
 #Read Month Abbreviation Names
 $abbr{'JAN'}="01";
 $abbr{'FEB'}="02";
 $abbr{'MAR'}="03";
 $abbr{'APR'}="04";
 $abbr{'MAY'}="05";
 $abbr{'JUN'}="06";
 $abbr{'JUL'}="07";
 $abbr{'AUG'}="08";
 $abbr{'SEP'}="09";
 $abbr{'OCT'}="10";
 $abbr{'NOV'}="11";
 $abbr{'DEC'}="12";

 
 if (-e $RoundCubeLogName) {
  open FHR, "<$RoundCubeLogName" or die "$RoundCubeLogName does not exist";
  #syslog("Open: $RoundCubeLogName");
 } else {
 	#syslog("Roundcube Log does not exist: $RoundCubeLogName");
 }
 
 #Roundcube logs in UTC
 $gmt_offset_in_seconds = timegm(@t) - timelocal(@t);
 #syslog("UTC is $gmt_offset_in_seconds");

 #Log sample: 
 #[20-Nov-2014 19:44:20 +0000]: IMAP Error: Login failed for xyz from 80.138.96.158. AUTHENTICATE PLAIN: Authentication failed. in /usr/local/www/roundcube/program/lib/Roundcube/rcube_imap.php on line 184 (POST /rc/?_task=login?_task=login&_action=login)
 
 while (<FHR>){
 	chomp;
  if (/\[(\d{2})-(\w{3})-(\d{4}) (\d+):(\d+):(\d+)/){  #Get Log Date
   $curepoche=str2time("$1-$2-$3 $4:$5:$6")+$gmt_offset_in_seconds; #1.0.12 - Watch the offset because the Log Date is given in UTC so wee need to ADD the offset
   #syslog("\t=>$1-$2-$3 $4:$5:$6 " .(time+$TimeBack). " CUREPOCHE=$curepoche  GMTO=$gmt_offset_in_seconds TimeBack=$TimeBack");
   if ((time-$TimeBack) < $curepoche ){  #Filter the time to see if we should become active 	
   	$tmpDate="$1-$2-$3 $4:$5:$6";
   	syslog("\t=>$1-$2-$3 $4:$5:$6 $curepoche - $gmt_offset_in_seconds");
   	#syslog("\t=>Orig: $_");
    if (/failed for ([^\s+]*)/){
   	 syslog("\tUser=$1");
   	 $tmpUser=$1;
    }
    if (/ from (\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})/){
   	 $tmpIP="$1.$2.$3.$4";
   	 syslog("\tFrom=$1-$2-$3-$4");
   	 $myWhite=checkWhitelits("$1.$2.$3.$4");
   	 if (!$myWhite){
      syslog("\tProcess this IP");
      syslog("     =>****  REAL INTRUSION   ****");
      SendToSyslog("Intrusion Detection. SRV=$host M=S2F WID=0 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=RoundCube");
		  #syslog ("Add $tmpIP-$tmpUser- from www");
   	  &Sendmail(5,$_);
   	  $hDatRecords{($curepoche)}{"$1.$2.$3.$4"}="1";

      
      
   	 } else {
      syslog("     =>****  REAL INTRUSION ON WHITELIST IP   ****");
      SendToSyslog("Whitelist Intrusion Detection. SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=RoundCube");
   	 }
    }      #Whitelist
   }       #Time match  	
  }	       #LogDate
 }	       #While
}          #Sub 



sub checkWhitelits {
 my $tmpIP=$_[0];	
 foreach (@whitelistip){ #Checking whitelist before we block this ip
  if ($tmpIP =~ /^$_/){
   syslog("==>> $_ / Ignore because this is a IP of config whitelist: $tmpIP   ");
   #SendToSyslog("Config Whitelisted Intrusion Detection SRV=$host M=S2F WID=1 DIP=$tmpIP IDU=$tmpUser TGE=$tmpDate PROTO=Apache2");
   #$whiteIP=$_; #Set Whitelist!
   #last;
   return defined;
  }
 }
 return undef;
}            #Sub