#!/bin/perl
#Perl script as a alternative to Windows Scheduled Task Manager.
#Register:
#sc create Perl-Scheduled-Task binPath= C:\Windows\System32\srvany.exe DisplayName= Perl-Scheduled-Task
#SubKey: Parameters
# Application c:\perl64\bin\perl.exe d:/maintain/scheduled-task/st.pl -c d:/maintain/scheduled-task/st.xml
#Active State:
#ppm install win32-process-list
#Document: http://coolscript.org


# This program is distributed in the hope that it will be useful,
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE.   


#1.1 - Fix endless weekly schedule for saturday - 11Jul2019

use strict;
use POSIX;
use Win32::Process::List;
use Win32::Process qw(IDLE_PRIORITY_CLASS BELOW_NORMAL_PRIORITY_CLASS NORMAL_PRIORITY_CLASS ABOVE_NORMAL_PRIORITY_CLASS HIGH_PRIORITY_CLASS);
use Date::Manip;
use Getopt::Long;
use HTTP::Date qw/str2time/;
use XML::Simple;      #=>Read my XML Config
#use Data::Dumper;
#use Date::Calc qw(:all);

my (%JListName,%JListMode,%JListFrequencyUnit,%JListFrequencyInterval,%JListFrequencyOffset);
my (%JListEnabled,%JListApplicationPath,%JListApplicationParameter,%JListIsUnique,%JListFrequencyTime,%JListFrequencyDay,%JListApplicationPriority);
my (%JListFrequencyMEMInterval,%JListFrequencyMEMProcess,%tmpJListStart,%tmpJListStop);    #Keep memory vars
my ($ApplicationDirectory,$LogDir,$StatusFile,$LogAge,$Log,$tmpPrevDay,$tmpDay);
my ($tmpEpoche,$tmpOffset,$tmpDayOffset,$tmpMidnight,$tmpDate,$opt_c,$err,$tldate);
my $PROGNAME="st.pl";

Getopt::Long::Configure('bundling');
GetOptions 	(	 "c=s"   => \$opt_c);
if (!$opt_c){
	print "No config specified\n";
	print_usage();
	exit 0;
}



my $datefrom=&UnixDate(DateCalc("now","+ 120 seconds",\$err),"%Y-%m-%d %H:%M:%S");
my @WDAbbr2 = qw(Mo Tu We Th Fr Sa Su);
my @WDAbbr3 = qw(Mon Tue Wed Thu Fri Sat Sun);
my @WDFull = qw(Monday Tuesday Wednesday Thuesday Friday Saturday Sunday);
my @WDNumber = qw(0 1 2 3 4 5 6);
my @WD; #Save Weekday Custom Matrix
my ($tmpCnt,$prtCnt);
$prtCnt=10;  #Process print frequency
my $Conffile="$opt_c";
&ReadConfig;
mkdir $LogDir;

$tldate = strftime("%Y-%m-%d %H:%M:%S", localtime(time));
my $myPID=$$;
my $myStart=$tldate;
syslog("Application is starting on pid:" . $$);


##################################
######   Calculate Offset   ######
##################################
for my $pnt ( sort keys %JListName ){   
 if ($JListEnabled{$pnt} eq 1){
  if ($JListMode{$pnt} eq "Repeat"){
   if ($JListFrequencyUnit{$pnt} eq "M") {
    syslog(" ==>> Set Starttime and Offset for: $JListName{$pnt} /  $JListFrequencyInterval{$pnt} / $JListFrequencyOffset{$pnt}");
    $tmpEpoche = getstartdate_minute($JListFrequencyInterval{$pnt},$JListFrequencyOffset{$pnt});
    $tmpDate = strftime("%Y-%m-%d %H:%M:%S", localtime($tmpEpoche));
    $JListFrequencyMEMInterval{$pnt}=$tmpEpoche;
    syslog ("  Next Schedule (every minute) for $JListName{$pnt} = $tmpEpoche / Date: $tmpDate");
   } 
   if ($JListFrequencyUnit{$pnt} eq "D") {
   	syslog(" ==>> Set Daily Starttime for: $JListName{$pnt} ");
   	$tmpMidnight=str2time(&UnixDate(DateCalc("today","- 0 days",\$err),"%Y%m%d"));
   	if ($JListFrequencyTime{$pnt} =~ /(\d+):(\d+)/){
   	 $tmpEpoche = (($1*60*60)  + ($2*60)) + $tmpMidnight;
   	 $tmpDate = strftime("%Y-%m-%d %H:%M:%S", localtime($tmpEpoche));
   	 #syslog(" ==>> Set $tmpDate");
    }
    if (time > $tmpEpoche){
    	#syslog(" ==>> Set +1Day");
    	$tmpEpoche=$tmpEpoche+(24*60*60);
    	$tmpDate = strftime("%Y-%m-%d %H:%M:%S", localtime($tmpEpoche));
    }   	
    $JListFrequencyMEMInterval{$pnt}=$tmpEpoche;
   	syslog ("  Next Schedule (Daily) for $JListName{$pnt} = $tmpEpoche / Date: $tmpDate");
   }	 #if ($JListFrequencyUnit{$pnt} eq "D") 

   
   if ($JListFrequencyUnit{$pnt} eq "W") {
   	$tmpMidnight=str2time(&UnixDate(DateCalc("today","- 0 days",\$err),"%Y%m%d"));
   	$tmpDate = strftime("%Y-%m-%d %H:%M:%S", localtime($tmpMidnight));
   	syslog(" ==>> Set Weekly Starttime for: $JListName{$pnt} - Midnight: $tmpMidnight/$tmpDate");
   	#$tmpOffset = &GetWeekdayOffset($pnt,1); 
   	#Get the ccurrent weekday and deduct it with the tmpoffset
   	#my $tmptmpOffset = ((localtime(time))[6] -1);  #set minus one (-1) to match our scalar index // double offset
   	#$tmpOffset = ($tmpOffset - $tmptmpOffset);
   	
    syslog ("  Return Offset: $tmpOffset");
   	if ($JListFrequencyTime{$pnt} =~ /(\d+):(\d+)/){
   		#syslog ("  DEB: Return Time: $1 - $2");
   		$tmpDayOffset = (($1*60*60)  + ($2*60));
   		#syslog ("  DEB: DayOffset: $tmpDayOffset");
   		$tmpEpoche= ($tmpMidnight + $tmpDayOffset + ($tmpOffset * (24*60*60)));
   		#syslog ("  DEB: tmpEpoch: $tmpEpoche");
   		$tmpDate = strftime("%Y-%m-%d %H:%M:%S", localtime($tmpEpoche));
   		#syslog ("  DEB: tmpDate: $tmpDate");
      $JListFrequencyMEMInterval{$pnt}=$tmpEpoche;
      #syslog ("  DEB: JListFrequencyMEMInterval - $JListFrequencyMEMInterval{$pnt} - PNT $pnt");
      if (($tmpMidnight + $tmpDayOffset) > time) {
   		 #syslog ("  DEB is (tmpMidnight + tmpDayOffset) > time // $tmpMidnight + $tmpDayOffset > " . time );
   		 $JListFrequencyMEMInterval{$pnt}=$tmpEpoche;
   		 #syslog ("  DEB $tmpMidnight + $tmpDayOffset - $tmpEpoche - " . time );
   		} else {
   		 #syslog ("  DEB is NOT (tmpMidnight + tmpDayOffset) > time // $tmpMidnight + $tmpDayOffset > " . time );
       $tmpOffset = &GetWeekdayOffset($pnt,1);  #Get again the current weekday +1 !!
       #syslog ("  DEB MORE tmpOffset -- $tmpOffset "  );       
    	 $tmpDayOffset = (($1*60*60)  + ($2*60));
    	 #syslog ("  DEB MORE tmpDayOffset -- $tmpDayOffset "  );       
   		 $tmpEpoche= ($tmpMidnight + $tmpDayOffset + ($tmpOffset * (24*60*60)));
       #syslog ("  DEB MORE tmpEpoch -- $tmpEpoche - $tmpMidnight + $tmpDayOffset + ($tmpOffset) x ... "  );       
   		 $tmpDate = strftime("%Y-%m-%d %H:%M:%S", localtime($tmpEpoche));
       #syslog ("  DEB MORE $tmpDate -- $tmpEpoche - " . localtime($tmpEpoche) );       
       $JListFrequencyMEMInterval{$pnt}=$tmpEpoche;
       #syslog ("  DEB MORE $tmpMidnight + $tmpDayOffset - $tmpEpoche - " . time );
   		} 
   	} else {	 
   	}	#if ($JListFrequencyTime{$pnt} =~ /(\d+):(\d+)/)
   	
   	
   	syslog ("  Next Schedule (Weekly) for $JListName{$pnt} = $tmpEpoche / Date: $tmpDate");
   
   
   
   
   }	 #if ($JListFrequencyUnit{$pnt} eq "W") 
  }    #if ($JListMode{$pnt} eq "Repeat")
 }     #if ($JListEnabled{$pnt} eq 1)
}      #for my $pnt ( sort keys %JListName )

&WriteStatus;


###########################
######   CORE LOOP   ######
###########################
while (1) {
 #$tmpDate = strftime("%Y-%m-%d %H:%M:%S", localtime(time));
 #syslog(" Now: $tmpDate - " . time);
 
 &CheckDatechange;
 
 for my $pnt ( sort keys %JListName ){   
 	if ($JListEnabled{$pnt} eq 1){
 	 if ($JListMode{$pnt} eq "Repeat"){
    if (($JListFrequencyUnit{$pnt} eq "M") or ($JListFrequencyUnit{$pnt} eq "D")  or ($JListFrequencyUnit{$pnt} eq "W")) {
 	   $tmpEpoche = $JListFrequencyMEMInterval{$pnt};
 	   $tmpDate = strftime("%Y%m%d %H:%M:%S", localtime($tmpEpoche));
 	   #syslog("\tDEB: $JListName{$pnt} - $tmpEpoche / $tmpDate / " . time );
 	   #syslog(" \tNext Check $JListName{$pnt}");
 	   #syslog(" \t\t $JListFrequencyUnit{$pnt} $tmpEpoche / $tmpDate " . time );
     if (time >= $tmpEpoche){
   	  syslog(" \t\t MATCH TIMER EVENT FOR: $JListName{$pnt}");
      if ($JListFrequencyUnit{$pnt} eq "M") {
       $tmpEpoche+=$JListFrequencyInterval{$pnt}*60;    	  #Save the next schedule 
      } 
   	  if ($JListFrequencyUnit{$pnt} eq "D") {
       $tmpEpoche=$JListFrequencyMEMInterval{$pnt} + (24*60*60);
   	  }	
   	  if ($JListFrequencyUnit{$pnt} eq "W") {
   	   $tmpOffset = &GetWeekdayOffset($pnt,1);  #offensichtlich brauchts +1 ...
       #syslog("DEB: Week Offset: $tmpOffset");
       #my $tmptmpOffset = ((localtime(time))[6] -1);  #set minus one (-1) to match our scalar index // double offset
   	   #$tmpOffset = ($tmpOffset - $tmptmpOffset);
   	
       
       
       $tmpEpoche=$JListFrequencyMEMInterval{$pnt} + ($tmpOffset*24*60*60);
   	  }	
      $JListFrequencyMEMInterval{$pnt}=$tmpEpoche;
   	  $tmpDate = strftime("%Y-%m-%d %H:%M:%S", localtime($JListFrequencyMEMInterval{$pnt}));
   	  syslog(" \t\t Set Next Schedule: $JListFrequencyMEMInterval{$pnt} / $tmpDate");
   	  if (($JListIsUnique{$pnt} eq 1) and ($JListFrequencyMEMProcess{$pnt})){
   	   syslog(" \t\t Refuse Process - already running! - $pnt");   	  	
   	  }	else {   #if (($JListIsUnique{$pnt} eq 1) and ($JListFrequencyMEMProcess{$pnt}))
       $JListFrequencyMEMProcess{$pnt}=StartJProcess($JListApplicationPath{$pnt},$JListApplicationParameter{$pnt}); #START JOB
   	   syslog(" \t\t Started Process - PID: $JListFrequencyMEMProcess{$pnt} / Name: $JListName{$pnt} / isUnique: $JListIsUnique{$pnt} / $JListApplicationParameter{$pnt} / $JListApplicationPriority{$pnt}");
   	   $tmpJListStart{$pnt} = strftime("%Y-%m-%d %H:%M:%S", localtime(time));
   	   #tmpDate = strftime("%Y-%m-%d %H:%M:%S", localtime(time);
   	   &WriteStatus($pnt);
   	  } #if (($JListIsUnique{$pnt} eq 1) and ($JListFrequencyMEMProcess{$pnt}))
     }  #if (time >= $tmpEpoche)	   
    }	  #if ($JListFrequencyUnit{$pnt} eq "M") 
   }    #if ($JListMode{$pnt} eq "Repeat")
  }     #if ($JListEnabled{$pnt} eq 1)
 }      #for my $pnt ( sort keys %JListName )
 #######
 #REAPER
 #######
 my $tmpKeyCount= keys %JListFrequencyMEMProcess;
 if ($tmpKeyCount > 0){
 	my ($tmpFound,$tmpPID);
  if (!$tmpCnt){
   syslog(" \t *** Processes: $tmpKeyCount ***");
  } 
  $tmpCnt++;
  if ($tmpCnt > $prtCnt) {$tmpCnt=undef;}
  
  for my $pnt ( sort keys %JListFrequencyMEMProcess ){  #Check all processes for existance 
   #$tmpPID=$pnt;
 	 if (!GetPID($JListFrequencyMEMProcess{$pnt})){	
    syslog(" \t ==>> PID HAS GONE $JListFrequencyMEMProcess{$pnt} / $JListName{$pnt} ***");
    $tmpJListStop{$pnt} = strftime("%Y-%m-%d %H:%M:%S", localtime(time));
   	&WriteStatus($pnt);
    delete $JListFrequencyMEMProcess{$pnt};
    &WriteStatus;
    last;  	 	
	 }#if (!GetPID($JListFrequencyMEMProcess{$pnt}))	
  } #for my $pnt ( sort keys %JListFrequencyMEMProcess )  #Check all processes for existance 
 }  #if ($tmpKeyCount > 0)
 sleep 1;  ##Main Clock!!
}   #while (1) 
###########################
######   CORE LOOP   ######
###########################








#########
#FINISHED
#########








sub syslog {
 if ($Log eq 1){
  $tldate = strftime("%Y%m%d", localtime(time));
  open (FH, ">>$LogDir/$tldate" . "-st.log") or die "no such file $LogDir/$tldate\- st.log";
  $tldate = strftime("%Y%m%d %H:%M:%S", localtime(time));
  print FH "$tldate $_[0]\n";
  print  "$_[0]\n";
  close FH;
 } 
} 



sub CountPreprocesses {

 #my $spfprocess=0;
 my $P = Win32::Process::List->new(); 
 my %list = $P->GetProcesses();    
 foreach my $key ( keys %list ) {
  #if (uc($pfprocname) eq uc($list{$key})){
  # $spfprocess++;
  #}
  syslog("ProcList: $key: $list{$key}");
 }
 return 0; #$spfprocess;
}



sub GetPID {
 #Return true if pid/$_[0] was found or undef if not ...
 my $P = Win32::Process::List->new(); 
 my %list = $P->GetProcesses();    
 foreach my $key ( keys %list ) {
  if ($key eq $_[0]){
   #syslog("\tRunning: $key  $list{$key}");
   return 1;  #Process is running	
  }	
 }
 return undef; #$spfprocess;
}





sub StartJProcess {
 #Init:
 #$cmdparam = $_[0]
 #$cmdstdout = $_[1]
 
 my $procid;
 #my $cmdparam="c:/perl/bin/perl.exe";  #TESTING
 #my $cmdstdout="C:/projects/scheduled-task/fake.pl";	 #TESTING
  my $cmdprio;
 my $cmdparam=$_[0];
 my $cmdstdout=$_[1];	
 if ($_[3] eq "Normal"){
  $cmdprio="NORMAL_PRIORITY_CLASS";	
 } 
 if ($_[3] eq "Below"){
 	$cmdprio="BELOW_NORMAL_PRIORITY_CLASS";	
 }	
 if (!$cmdprio){
  $cmdprio="NORMAL_PRIORITY_CLASS";	 
 } 
  
 
  

 Win32::Process::Create( $procid, $ENV{COMSPEC}, "/c $cmdparam $cmdstdout", 1, $cmdprio, "." );
  sleep 1;   
  my $child_pid = $procid->GetProcessID();
  return $child_pid;
}


sub ReadConfig {
 #######################################
 #Read My XML Config given in $Conffile
 #######################################
 #Getting arrays first ....
 my $data = eval {XMLin($Conffile)};
 $ApplicationDirectory=$data->{System}->{ApplicationDirectory};
 $LogDir=$data->{System}->{LogDirectory};
 $LogAge=$data->{System}->{LogAge};
 $Log=$data->{System}->{Log};
 $StatusFile=$data->{System}->{StatusFile};
 my $data = eval {XMLin($Conffile,ForceArray => 1)};
 my $jCnt=10000;  #can be a high number for sorting optimization and assigning unique id's
 foreach my $e (@{$data->{ScheduledTask}}){	 
  $JListName{$jCnt}="$e->{Name}";
  $JListMode{$jCnt}="$e->{Mode}";
  $JListFrequencyUnit{$jCnt}="$e->{FrequencyUnit}";
  $JListFrequencyInterval{$jCnt}="$e->{FrequencyInterval}";
  $JListFrequencyOffset{$jCnt}="$e->{FrequencyOffset}";
  $JListEnabled{$jCnt}="$e->{Enabled}";
  $JListApplicationPath{$jCnt}="$e->{ApplicationPath}";
  $JListApplicationParameter{$jCnt}="$e->{ApplicationParameter}";
  $JListApplicationPriority{$jCnt}="$e->{ApplicationPriority}";
  $JListIsUnique{$jCnt}="$e->{IsUnique}";
  $JListFrequencyTime{$jCnt}="$e->{FrequencyTime}";
  $JListFrequencyDay{$jCnt}="$e->{FrequencyDay}";  
  $jCnt++;
 }   #foreach my $e (@{$data->{ScheduledTask}})	 
}    #sub ReadConfig




sub getstartdate_minute {
 #$_[0] - Frequency
 #$_[1] - Offset
 #Ausprobieren vom offset
 #heutiges midnight epoche
 my $midnight=str2time(&UnixDate(DateCalc("today","- 0 days",\$err),"%Y%m%d"));
 my $cnow=time;
 #To be used at startup only!
 my ($offset,$frequency,$resEpoche,$resdate);
 $offset=$_[1]*60;
 $frequency=$_[0]*60;
 my $i=$midnight+$offset;
 while($i <= $cnow) {
  $i+=$frequency;
  $resdate = strftime("%Y%m%d %H:%M:%S", localtime($i));
  $resEpoche=$i;
 }
 #print "  Next Schedule == $resdate ==  $resEpoche \n";
 return $resEpoche;
}


sub print_usage {
	print "Usage: $PROGNAME -c <Configfile>\n";
}


sub GetdayOfWeek {
 my $tmpYear = strftime("%Y", localtime($_[0]));
 my $tmpMonth = strftime("%m", localtime($_[0]));
 my $tmpDay = strftime("%d", localtime($_[0]));
 return Day_of_Week($tmpYear,$tmpMonth,$tmpDay);
}

sub GetWeekdayOffset {
	 my $curWDCnt=0;
	 my $DayOffset=($_[1] * 24 * 60 *60 );  #Day counter ....
   #print " ==>> $WDAbbr[6] \n";
   #my @WDAbbr2 = qw(Mo Tu We Th Fr Sa So);
   #my @WDAbbr3 = qw(Mon Tue Wed Thu Fri Sat Sun);
   #my @WDFull = qw(Monday Tuesday Wedmesday Thuesday Friday Saturday Sunday);
   #my @WDNumber = qw(1 2 3 4 5 6 7 );
   #my %WD; #Save Weekday Custom Matrix
   @WD = qw(0 0 0 0 0 0 0 ); #Empty weekday matrix
   my @curWD;
   if ($JListFrequencyUnit{$_[0]} eq "W"){
   	#syslog("DEB Calculate Weekdays / $JListName{$_[0]} / $JListFrequencyTime{$_[0]}");
   	@curWD = split(/\,/,$JListFrequencyDay{$_[0]});   
   	$curWDCnt=0;	
   	my $CurWD;
   	foreach (@curWD) {
   		#syslog ("Week: $_ / $curWDCnt");
   		$CurWD=$_;
   	  ###########################
   	  #   Mapping of @WDAbbr2
   	  ###########################
   	  $curWDCnt=0;	
   		foreach (@WDAbbr2) {
   		 if (uc($_) eq uc($CurWD)){
   		  $WD[$curWDCnt]=1;
   		  #syslog("DEB MAP 2: $curWDCnt / $WD[$curWDCnt]");
   		 } 
   		 $curWDCnt++;	 
   		}
   		###########################
   		

   	  ###########################
   	  #   Mapping of @WDAbbr3
   	  ###########################
   	  $curWDCnt=0;	
   		foreach (@WDAbbr3) {
   		 if (uc($_) eq uc($CurWD)){
   		  $WD[$curWDCnt]=1;
   		  #syslog("DEB MAP 3: $curWDCnt / $WD[$curWDCnt]");
   		 } 
   		 $curWDCnt++;	 
   		}
   		###########################
   		

   	  ###########################
   	  #   Mapping of @WDFull
   	  ###########################
   	  $curWDCnt=0;	
   		foreach (@WDFull) {
   		 if (uc($_) eq uc($CurWD)){
   		  $WD[$curWDCnt]=1;
   		  #syslog("DEB MAP F: $curWDCnt / $WD[$curWDCnt]");
   		 } 
   		 $curWDCnt++;	 
   		}
   		###########################
   		


   	  ###########################
   	  #   Mapping of @WDNumber
   	  ###########################
   	  $curWDCnt=0;	
   		foreach (@WDNumber) {
   		 if (uc($_) eq uc($CurWD)){
   		  $WD[$curWDCnt]=1;
   		  #syslog("DEB MAP N: $curWDCnt / $WD[$curWDCnt]");
   		 } 
   		 $curWDCnt++;	 
   		}
   		###########################
   		
   	}  #foreach (@curWD) 
   }
   #Weekday collection is complete! 

   my ($wday) = ((localtime(time))[6] -1);  #set minus one (-1) to match our scalar index
   my $origwday = $wday;
   if ($DayOffset > 0){
   	   $wday = (((localtime(time+$DayOffset))[6]) -1);  #set minus one (-1) to match our scalar index
   	   #syslog("DEB MIN1 Cur Weekday: $wday ");
   }
   #syslog("DEB Cur. Weekday: $wday ");
   $curWDCnt=0;	
   foreach (@WDFull) {
    #syslog("DEB - $_ = $WD[$curWDCnt] / $curWDCnt");
    if ($WD[$curWDCnt] eq 1){
    	#syslog("DEB Check  $wday > $curWDCnt / $WD[$curWDCnt] ");
      if ($curWDCnt >= $wday) {
      	#syslog("DEB Match!  $origwday $wday $curWDCnt / $WD[$curWDCnt] = $WDFull[$curWDCnt]");
        $curWDCnt = ($origwday - $curWDCnt);
        #syslog("DEB xMatch!  $curWDCnt");
        if ($curWDCnt < 0 ){
        	$curWDCnt = ($curWDCnt * -1);
        }
        if ($curWDCnt == 0 ){ #Appears if weekday = saturday
        	$curWDCnt=7;
        }	
        #syslog("DEB xRet!  $curWDCnt");
      	return $curWDCnt;  #Return todays offset!
      	#last;
      }
    }
    $curWDCnt++;
   }	  #foreach (@WDFull)

   #If I come here then try the other way around  
   $curWDCnt=0;	
   foreach (@WDFull) {
    if ($WD[$curWDCnt] eq 1){
     $curWDCnt = ($curWDCnt);
     #syslog("DEB Match YY!   $curWDCnt - Offset: " . ($curWDCnt+(7-$wday+1)). " Days");
     return $curWDCnt+(7-$wday+1);  #Return todays offset!
     last;
    }
    $curWDCnt++;
   }	  #foreach (@WDFull)



}  #sub GetWeekdayOffset 



sub WriteStatus {
 if (($StatusFile) and ($StatusFile ne 0)){	
	open (FHS, ">$StatusFile") or die "no such xml file";
	print FHS '<?xml version="1.0"?>'."\n";
	print FHS '<STATUS>'."\n";
  print FHS ' <Process'."\n";
  print FHS '  PID="'.$myPID.'"'."\n";
  $tldate = strftime("%Y-%m-%d %H:%M:%S", localtime(time));
  print FHS '  StartDate="'.$myStart.'"'."\n";
  print FHS '  LastCheckDate="'.$tldate.'"'."\n";
  print FHS ' />'."\n";
  my ($tmpJListPID,$tmpNextSchedule);
  for my $pnt ( sort keys %JListName ){   
  	print FHS ' <ScheduledTask'."\n";
  	print FHS '  Name="'.$JListName{$pnt}.'"'."\n";
  	
  	if (!$JListFrequencyMEMProcess{$pnt}){
 		 $tmpJListPID=0;
  	} else {	
  	 $tmpJListPID=$JListFrequencyMEMProcess{$pnt};	
    }
    print FHS '  ENABLED="'.$JListEnabled{$pnt}.'"'."\n";  	
    print FHS '  PID="'.$tmpJListPID.'"'."\n";  	
    print FHS '  START="'.$tmpJListStart{$pnt}.'"'."\n";  	
    print FHS '  END="'.$tmpJListStop{$pnt}.'"'."\n";  	
    if ($JListEnabled{$pnt} eq 1){
     $tmpNextSchedule=strftime("%Y-%m-%d %H:%M:%S", localtime($JListFrequencyMEMInterval{$pnt}));
     print FHS '  NEXT="'."$tmpNextSchedule".'"'."\n";  	
    } else {
     print FHS '  NEXT=""'."\n";  	
    } 
  	print FHS ' />'."\n";
  }	#for my $pnt ( sort keys %JListName )
  print FHS '</STATUS>'."\n";
	close FHS;
 }	#if ($StatusFile ne 0)
}   #Sub


sub CheckLogFile {
 if (($LogAge) and ($LogAge gt 0)){
  my $datedelete=str2time(&UnixDate(DateCalc("today","- $LogAge days",\$err),"%Y-%m-%d %H:%M:%S"));
  opendir(DIR, $LogDir);
  my @logfiles = grep(/\.*$/,readdir(DIR));
  foreach (@logfiles) {
   if (~/^\./){	
    my $fileage=(stat ($LogDir.$_))[9];
    #print "$datedelete $LogDir$_ - $fileage\n";
    if ($fileage < $datedelete){
 	   syslog ("unlink $LogDir$_");
 	   unlink $LogDir.$_;
    }
   }  
  }
 } 
}


sub CheckDatechange{
 $tmpDay = strftime("%d", localtime(time));
 if ($tmpPrevDay ne $tmpDay) {
  syslog("Datechange occured! ($tmpPrevDay/$tmpDay)");
  $tmpPrevDay = $tmpDay;
  &CheckLogFile;
 } 
} 
 
 

