#!/usr/bin/perl

#Perl / Nagios plugin to check the status of the scheduled task manager (st.pl)
#Sample: perl check_text.pl -t "Bla" -f c:/file.txt

#Document Page: http://test.coolscript.org/index.php/Scheduled_Task_for_Windows

# Disclaimer:
# This program is distributed in the hope that it will be useful,
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE.   


require 5.004;
use strict;
use Getopt::Long;
use XML::Simple;
use Win32::Process::List;
use HTTP::Date qw/str2time/;

my ($PID,%JListName,%JEnabled,%JPID,%JSTART,%JEND,%JNEXT,$WarnPresent,$StartDate,$LastCheckDate);


 



################################################################################
##Nagios specific
use vars qw($opt_c $opt_w $PROGNAME) ;
$PROGNAME="check_st";
Getopt::Long::Configure('bundling');
GetOptions 
(
 "c=s" => \$opt_c,
 "w=s" => \$opt_w,
 
);
###############################################################################

if (!$opt_c) {
	print "Config File is missing\n";
	&print_usage;
	exit;
}

if (!$opt_w) {
	print "Warning value is missing\n";
	&print_usage;
	exit;
}

 if (! -e $opt_c) {
  print "File does not exist - $opt_c!";
  exit 2;
 } 


&ReadConfig;


if (!GetPID($PID)){
  print "Process does not run: $PID";
  exit 2;
}


my $tmpChkDate=str2time($LastCheckDate);

print "PID: $PID OK\n";
print "Started: $StartDate\n";

if (($tmpChkDate + ($opt_w * 60)) > time){
 print "LastCheck: $LastCheckDate - OK\n";
} else { 
 print "LastCheck: $LastCheckDate - WARNING\n";
 $WarnPresent=1;
} 

print "\nName::PID::Start::End::Next:;Status\n";
for my $pnt ( sort keys %JListName ){   
 if ($JEnabled{$pnt} eq 1){
  #print " Name: $JListName{$pnt}\n";		
  my $tmpDate=str2time($JNEXT{$pnt});
  if ($tmpDate > time){
   print "$JListName{$pnt}::$JPID{$pnt}::$JSTART{$pnt}::$JEND{$pnt}::$JNEXT{$pnt}/OK\n";		
  }	else {
   print "$JListName{$pnt}::$JPID{$pnt}::$JSTART{$pnt}::$JEND{$pnt}::$JNEXT{$pnt}/WARNING\n";		
   $WarnPresent=1;
  }
 }
}	

if ($WarnPresent){
	exit 1;
}
exit 0;




sub ReadConfig {
 my $data = eval {XMLin($opt_c)};
 $PID=$data->{Process}->{PID};
 $StartDate=$data->{Process}->{StartDate};
 $LastCheckDate=$data->{Process}->{LastCheckDate};
 my $data = eval {XMLin($opt_c,ForceArray => 1)};
 my $jCnt=10000;  #can be a high number for sorting optimization and assigning unique id's
 foreach my $e (@{$data->{ScheduledTask}}){	 
  $JListName{$jCnt}="$e->{Name}";
  $JEnabled{$jCnt}="$e->{ENABLED}";
  $JPID{$jCnt}="$e->{PID}";
  $JSTART{$jCnt}="$e->{START}";
  $JEND{$jCnt}="$e->{END}";
  $JNEXT{$jCnt}="$e->{NEXT}";
  $jCnt++;
 }
 
 
} 



sub print_usage {
 print "$PROGNAME -c Path to st-status.xml -w warning interval";
}



sub GetPID {
 #Return true if pid/$_[0] was found or undef if not ...
 my $P = Win32::Process::List->new(); 
 my %list = $P->GetProcesses();    
 foreach my $key ( keys %list ) {
  if ($key eq $_[0]){
   #print "\tRunning: $key  $list{$key}\n";
   return 1;  #Process is running	
  }	
 }
 return undef; #$spfprocess;
}
