#!/usr/bin/perl

# This program is distributed in the hope that it will be useful,
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE.   

#See: http://coolscript.org



#1.0.0 - Easy going archive script - mk Feb2007
#1.0.1 - Add logrotate mode mk Mar2012
#1.0.2 - Re Enable move mk Mar2012
#        New Config val: CheckTargetDir
#        Additional copy mode
#1.0.3 - Add sftp
#      - Add tar.gz, same way as zip
#1.0.4 - Add target directory tree mirror on target if copy or move - 21Apr2012MK	
#1.0.5 - Abort if path is empty!

use strict; 
use XML::Simple;
use POSIX;
use HTTP::Date qw/str2time/;  #will be used for others as well
use File::Path;
use File::Find;
use File::stat;
use File::Basename;
use File::Path;
use File::Copy;
use Digest::MD5;
my $xml = new XML::Simple (KeyAttr=>[]);  # create XML object
use Archive::Zip qw( :ERROR_CODES :CONSTANTS );
my $zip = Archive::Zip->new(); 
use Archive::Tar;
my $tar = Archive::Tar->new;
use Sys::Hostname;
my $host = hostname;
###########################################################################
#########################  EXPERIMENTAL SFTP  #############################
###########################################################################
#Requires Putty, SCP   
#Linux/Debian: apt-get install putty-tools
#Windows: http://www.chiark.greenend.org.uk/~sgtatham/putty/download.html
#Note: you need to cache the key first by using eg plink user@server
my $os = $^O;
#print "Running in: $os\n";
use Net::SFTP::Foreign;
if ($os=~/ms/i){
 #no warnings 'Net::SFTP::Foreign';
} 
###########################################################################
###########################################################################

my $tmpdate;


#my $sim=1;
my $sim=undef;






#my $OperatingMode=2;  #New setup, trying to archive single files (hh-log), mode 1 = default, mode 2 = simular to linux logrotate
#my $tempdir = '/usr/local/dev/logd/tempdir/';
#my $rstdaemon ='/etc/init.d/sysklogd restart';

#####################################################################
my $logdconf="logd.xml";
if ($ARGV[0]) {
	$logdconf=$ARGV[0]; #Config via param
}	
my $oneday = (60 * 60 * 24);
my @abbr = qw( Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec );
my $DayCalc = 1;
my $logoverhead = 20;  #Value in minutes, Some Loghandles are still open after midnight, wait for them!
#####################################################################



my (%Logpath,%Logmode,%OperatingMode,%TempPath,%Protocol,%RestartDaemon,%MD5File,%Logage,%IncludeLogmask,%Logtarget,%Logfound,$WriteLog,$WriteLogPath,$RandomDelayMin,$RandomDelayMax,$RandomDelay,$fcnt,%ZipParents,%CreateDateDir,%LeaveFiles,%DirectoryCleanUp,%CheckTargetDir,%Recursive,%LogTagFile,%LogTagFileAge,%LogSuffix,%ExcludeLogmask,%logfile,%logdate,$mvtarget,$movecnt,$zipcnt);
my ($writeOK,$lpointer,$logtargetsuffix,$temparchivename,$tags_present,$acnt,$temparchiveprefix,@files,@path,@filesg,$var,$singlefile,@IncludeTokens,@ExcludeTokens,$searchrequest,$FileTimeEpoche,$fulldate,$compareepoche,$resp,$file_member,$archivename,$diff,$archivedate,$archiveprefix);
my (%sftpfile,$tmpzippath,%User,%Password,%Server,%KeyFile,%UseTodaysDate,%UseHostname,$filename); #1.0.3
my ($filename,$dirname,$val,$var);

&getConfig;

if (($RandomDelayMax) and ($RandomDelayMin)){
 $RandomDelay=int(rand($RandomDelayMax))  ;
 $RandomDelay=$RandomDelayMin+$RandomDelay;
 syslog ("Delay: $RandomDelay sec.");
 sleep $RandomDelay;   #Security - nobody should guess the effective start of logd (think of the restart of syslog)
}



&syslog("**************");
&syslog("Starting Logd");
&syslog("**************");

if ($sim) {
 for my $logs ( sort keys %LogSuffix ){  
  &syslog("$logs DUMP:: $LogSuffix{$logs} $Logpath{$logs}");
 }
}

for my $logs ( sort keys %Logpath ){  #Logpath is equal to the xml profile
 @files=undef;
 $zip = Archive::Zip->new(); 
 $tar = Archive::Tar->new;
 my %sftpfile; #Reset hash!
 &syslog("Set Profile: $LogSuffix{$logs}");
 &syslog("Source: $Logpath{$logs}");
 &syslog("Target: $Logtarget{$logs}");
 #&syslog("Checking Files for: " . $LogSuffix{$logs} . " at: $Logpath{$logs} -- Key: $logs - $Logpath{$logs} -- Mode: $Logmode{$logs}");
 #getRecursiveFiles 
 if ($Recursive{$logs}) {
 	#print "Get Rec. for $Logpath{$logs}\n";
 	syslog ("Get Rec. for $Logpath{$logs}");

  #***Read File Inventory - no filters here, just reading***
 	find(\&getRecursiveFiles, $Logpath{$logs});
  foreach my $file (@files) {     #Add filepath to scalar
   if (-d $file) { 
  		&syslog("=>Check Dir: $file");
   } else {
  	 #&syslog("=>Check File: $file");	
   }
  }
 } else {              #if ($Recursive{$logs})
  opendir(DIR,$Logpath{$logs});
  @filesg = grep(/\.*$/,readdir(DIR));
  #print grep(/\.*$/,readdir(DIR));
  closedir(DIR);
  $fcnt=0;
  $Logfound{$logs}=undef;	
  foreach my $file (@filesg) {     #Add filepath to scalar
   if (($file !~ /\/\.$/) and ($file) and ($file !~ /\.\./) and (! -d $file)) {
    push(@files,$Logpath{$logs}.$file);
    &syslog("=>Check File/Dir: $file");
   } 
  }
 }
 #***Done with Read File Inventory***


 my @IncludeTokens = split(/,/,$IncludeLogmask{$logs});
 my @ExcludeTokens = split(/,/,$ExcludeLogmask{$logs});
 
 
 
 #Transfer scalar to array, use timestamp as hash key, we do this to create a zip archive for each day
 %logfile=();
 %logdate=();
 foreach my $file (@files) {   
  if (($file !~ /\/\.$/) and ($file) and ($file !~ /\.\./) and (! -d $file)) {
	  #syslog ("DEBXXXX:  $file\n");
 	  eval{$logfile{$file}=$file}; &syslog ("Error: " . $@ ." => $file" ) if $@;
 	  eval{$logdate{$file}=(stat($file)->mtime)}; &syslog ("Error: " . $@ ." => $file" ) if $@;
 	  eval{print "Hash=> $file " . (stat($file)->mtime) . " \n";};
 	  #syslog ("DEBXXXX:  $logdate{$file}\n");
 	}
 }
 
 
 
 $temparchiveprefix=undef;
 $acnt=0;
   
 #***Walk through all known logs***
 if ($OperatingMode{$logs} eq 1) {
  for my $pointer ( sort keys %logfile ){   
   $writeOK=1;  #Default val if no compression is given
   my @pTokens = split(/\//,$logfile{$pointer});
   my $tok=scalar(@pTokens);
   $singlefile=$pTokens[$tok-1];
   $searchrequest=undef;
 
   foreach my $token (@IncludeTokens){
 	  if ( $logfile{$pointer} =~ /$token/i) {
	   &syslog ("Search Token Found => $token <==> $logfile{$pointer} = Key: $logs = $Logpath{$logs}"); 	
 	   $searchrequest=1;
  	}	#if ( $singlefile =~ /$token/i) 
   }   #foreach my $token (@IncludeTokens)
   foreach my $token (@ExcludeTokens){
 	  if ( $logfile{$pointer} =~ /$token/i) {
  	   &syslog ("\t\tExclude Token Found => $token <==> $logfile{$pointer} "); 	
  	   $searchrequest=undef;
  	}  #if ( $singlefile =~ /$token/i)	
   }   #foreach my $token (@ExcludeTokens)
  
   if ($searchrequest){   # - means that include and exclude had matched
    
     $acnt++;
     
     $fulldate=strftime("%d-%m-%Y  00:".$logoverhead.":00", localtime($logdate{$pointer}));
     $compareepoche=str2time($fulldate);  
     $diff = time - $compareepoche;
     
     if ($UseTodaysDate{$logs} eq 1) {	#1.0.3
      $archiveprefix = strftime("%Y%m%d", localtime(time));
     } else { 
      $archiveprefix = strftime("%Y%m%d", localtime($logdate{$pointer}));
     } 
     if ($UseHostname{$logs} eq 1) {	#1.0.3
      $archiveprefix = $archiveprefix."-".$host	     ;
     }
     
     if (($Logmode{$logs} =~ /tgz/i)) {	#1.0.3
      syslog ("Set Archivename $archiveprefix-$LogSuffix{$logs}.tar.gz");
      $archivename	= "$archiveprefix-$LogSuffix{$logs}.tar.gz"; #Set Archivename
     } else {
      syslog ("Set Archivename $archiveprefix-$LogSuffix{$logs}-".time.".zip");
      $archivename	= "$archiveprefix-$LogSuffix{$logs}-".time.".zip"; #Set Archivename
     }
     	     
     	     
     
     
     #&syslog("Set X ArchiveName: $archivename - $logs $pointer => " . &SetTarget($logs,$logdate{$pointer}).$archivename);
     $archivename=&SetTarget($logs,$logdate{$pointer},$logfile{$pointer}).$archivename;
     
     #Add per day option here, $temparchiveprefix is the current day given is a daychange occured
     if ((($temparchiveprefix ne $archiveprefix) and ($acnt gt 1)) and ($tags_present) ){
      if (($tags_present) ){
       &syslog ("CREATE ARCHIVE $Logtarget{$logs}$logtargetsuffix$temparchivename - $LogSuffix{$logs} - $logs - $Logpath{$logs}");
       if (!$sim) {
        unless ( $zip->writeToFileNamed("$Logtarget{$logs}$logtargetsuffix$temparchivename") == AZ_OK ) {
         #die 'write error';
         &syslog ("Error during Archive: " . $@  );
         $writeOK=undef;
        } else {
        	$writeOK=1;
        	&syslog ("CREATE ARCHIVE => FINISHED OK!");
        }    
        $zip = Archive::Zip->new(); 
       } 
  	    $tags_present=undef;
      } else {
     	
      }
     }
     
     if ((($oneday * $Logage{$logs}) < $diff) or ($Logage{$logs} eq "0" )){
      #print "GO $archivename\n";
      $Logfound{$logs}=1;	
      $fcnt++;
      $LogTagFile{$fcnt}=$logfile{$pointer};
      $LogTagFileAge{$fcnt}=((time - $logdate{$pointer})/$oneday);
      if (($Logmode{$logs} =~ /ZipAndDelete/i) or ($Logmode{$logs} =~ /Zip/i)) {
       #&syslog ("Zip!!" . $Logpath{$logs}.$file . " to $archivename");
       &syslog("\tTag for Archive: $logfile{$pointer}" . " DayDiff: " . int($diff/$oneday) . "/$Logage{$logs} - Diff:" . $diff . " Fileage: $fulldate => $Logtarget{$logs}$logtargetsuffix$temparchivename");
       if ($ZipParents{$logs} eq 1) {
        $tags_present=1;
        $file_member = $zip->addFile( $logfile{$pointer} );
       } else {
        $tags_present=1;
        $file_member = $zip->addFile( $logfile{$pointer},$singlefile );
    	 }	 
      
      } else {   #if (($Logmode{$logs} =~ /ZipAndDelete/i) or ($Logmode{$logs} =~ /Zip/i))
       if (($Logmode{$logs} =~ /tgz/i)) {	#1.0.3
        &syslog("\tTag for TGZ Archive: $logfile{$pointer}" . " DayDiff: " . int($diff/$oneday) . "/$Logage{$logs} - Diff:" . $diff . " Fileage: $fulldate => $Logtarget{$logs}$logtargetsuffix$temparchivename");
        $tar->add_files($logfile{$pointer});    	 
        $tags_present=1;
    	 } else {
    	  if (($Logmode{$logs} !~ /Move/i) and ($Logmode{$logs} !~ /Delete/i) and ($Logmode{$logs} !~ /Copy/i)){
         &syslog("No compression method found (Mode: $Logmode{$logs})");
        }
       }  
      } 
     } else { #if (($oneday * $Logage{$logs}) < $diff) 
      &syslog ("\t\tDo not touch: $logfile{$pointer} DateDiff: " .  int($diff/$oneday) . "/$Logage{$logs} Diff:".$diff);
     }  
     $temparchiveprefix=$archiveprefix;
     $temparchivename=$archivename;
     $lpointer=$pointer;
    
   }  #searchrequest - means that include and exclude had matched
  
  
  }   #for my $pointer ( sort keys %logfile )
  #***Done Walk through all known logs***
 
 	
  #########################################################
  #################   Zip Tagged Files  ###################
  #########################################################
  if ($tags_present) {
   #&syslog ("==> $logs -- $CreateDateDir{$logs}");
   #$logtargetsuffix=&SetTarget($logs,$lpointer);
   #&syslog ("CREATE ARCHIVE! $Logtarget{$logs}$archivename");
   

  
   	
   	
   if (!$sim) {
    #unless ( $zip->writeToFileNamed("$Logtarget{$logs}$logtargetsuffix$archivename") == AZ_OK ) {
    #TO DO!!!
    #IF RECURSIVE SET THEN ZIPPARENTS MUST SET 1
    if ($Protocol{$logs} =~ /sftp/) {
   	 $tmpzippath=$TempPath{$logs};
   	 $sftpfile{$archivename}=$tmpzippath;
   	 &syslog ("USE SFTP TEMP DIR! $sftpfile{$archivename}$archivename");
    } else {
    	$tmpzippath=$Logtarget{$logs};
    }
    
    if (($Logmode{$logs} =~ /ZipAndDelete/i) or ($Logmode{$logs} =~ /Zip/i)) {
     &syslog ("Write ZIP to: $tmpzippath - $logs - $archivename");
     unless ( $zip->writeToFileNamed("$tmpzippath$archivename") == AZ_OK ) {
      #die 'write error';
      &syslog ("Error during Archive: " . $@  );
      $writeOK=undef;
     } else {
    	$writeOK=1;
     }    
     $zip = Archive::Zip->new(); 
    }  
    if (($Logmode{$logs} =~ /tgz/i)) {	#1.0.3
     if ($TempPath{$logs}){
      subDelDir($TempPath{$logs});	
     } 
     $tar->write($tmpzippath.$archivename,COMPRESS_GZIP);                  
     syslog("Write Tar Archive to: ".$tmpzippath.$archivename);	
     $tar = Archive::Tar->new;
    } 

   }
   $tags_present=undef;
  }   else {
  }
  
  &syslog ("");
  &syslog ("List of Tagged Files:");
  for my $movelogs ( sort keys %LogTagFile ){  
  	&syslog ("TAGS: $movelogs $LogTagFile{$movelogs} - ". int($LogTagFileAge{$movelogs}));
  }	
  
  ########################################################################################  
  ###########################  EXPERIMENTAL SFTP  #######################################
  ########################################################################################
  
  
  
  
  #$KeyFile{$logs}
  #my $sftp = Net::SFTP::Foreign->new('hhbackup@svn',ssh_cmd => 'plink',more => [qw(-i c:/private.ppk)]);
  #$sftp->mkdir( '/bla1' );
	#if ($os=~/ms/i){
   #$sftp->die_on_error;
  #} 

  if ($Protocol{$logs} =~ /sftp/) {
   &syslog ("CONNECT TO $User{$logs}" . '@' . "$Server{$logs}");
   #Good on MS
   #my $sftp = Net::SFTP::Foreign->new( $User{$logs} . '@' . $Server{$logs},ssh_cmd => 'plink',password => $Password{$logs});
   #Good on Linux AND MS
   #my $sftp = Net::SFTP::Foreign->new('magrathea@svn',ssh_cmd => 'plink',more => [-pw => $Password{$logs}]);
   my $sftp=undef;
   my $sftp;
   if ($KeyFile{$logs}){
   	syslog ("==> $KeyFile{$logs}");
    $sftp = Net::SFTP::Foreign->new($User{$logs} . '@' . $Server{$logs},ssh_cmd => 'plink',more => [-i => $KeyFile{$logs}]);  
   } else {
   	$sftp = Net::SFTP::Foreign->new($User{$logs} . '@' . $Server{$logs},ssh_cmd => 'plink',more => [-pw => $Password{$logs}]);
   }
   #$sftp->die_on_error("Unable to establish SFTP connection");
   &syslog ("CONNECT OK");
   if ($Protocol{$logs} =~ /sftp/) {
    $zip = Archive::Zip->new(); #Reset Handle!
    $tar = Archive::Tar->new; #Reset Handle!
    for my $sftpfiles ( sort keys %sftpfile ){  
     &syslog ("SFTP FROM: $sftpfile{$sftpfiles}$sftpfiles to $User{$logs}" . '@' . "$Server{$logs}:/$sftpfiles");
     $sftp->put("$sftpfile{$sftpfiles}$sftpfiles", "/$sftpfiles", late_set_perm => 1 ) or syslog("SFTP PUT FAILED! => " . $sftp->error);
     syslog("Delete Temp File: $sftpfile{$sftpfiles}$sftpfiles");
     unlink($sftpfile{$sftpfiles}.$sftpfiles); #Delete from Temp
     delete $sftpfile{$sftpfiles}; #Delete from hash
    }
   }
  } 
  
  
  ########################################################################################
  ########################################################################################
  
  
  ####################################################################################  
  #################################    MOVE/COPY     ######################################
  ####################################################################################
  #1.0.2
  my $ccnt=0;
  my $chkmove=undef;
  if (($Logmode{$logs} =~ /Move/i) or ($Logmode{$logs} =~ /Copy/i)) {
   foreach my $movelogs (sort hashValueDescendingNum (keys(%LogTagFileAge))) {  
    $ccnt++;
    if (($LeaveFiles{$logs}) and ($LeaveFiles{$logs} ne "0")) {
     if (($fcnt-$ccnt) < $LeaveFiles{$logs}){
     	$chkmove=undef;
     } else {
     	$chkmove=1;
     }	
    } else {
    	$chkmove=1;
    }
    if (($Logmode{$logs} !~ /^Move/i) and ($Logmode{$logs} !~ /^Copy/i)){  #ChkDel only valid with move Mode/Copy
    	$chkmove=1;
    }
    if ($writeOK) {
     if (!$sim){
      if ($chkmove){
       $tmpdate=(stat($LogTagFile{$movelogs})->mtime); # 	&syslog ("Error: " . $@ ." => $LogTagFile{$movelogs}" ) if $@;
       $archivename=&SetTarget($logs,$tmpdate,$LogTagFile{$movelogs});

       if (!$CheckTargetDir{$logs} eq 1){  
        $archivename=$Logtarget{$logs}.$archivename;
        &syslog ("Set Archivexx: $archivename");
       } 
       

       
       if ($Logmode{$logs} =~ /Move/i){
        #&syslog ("Move: $LogTagFile{$movelogs} - Age/Amount/Curcnt/Hash/Leave-" . int($LogTagFileAge{$movelogs}) . "/$fcnt/$ccnt/$movelogs/$LeaveFiles{$logs}"  );
        #move($LogTagFile{$movelogs}, $archivename) or &syslog ("move to $archivename failed: $!");
        if ($UseTodaysDate{$logs} eq 1) {	#1.0.3
         $archiveprefix = strftime("%Y%m%d", localtime(time));
         $filename = basename($LogTagFile{$movelogs});
         &syslog ("Move: $LogTagFile{$movelogs} to $archivename$archiveprefix$filename - Age/Amount/Curcnt/Hash/Leave-" . int($LogTagFileAge{$movelogs}) . "/$fcnt/$ccnt/$movelogs/$LeaveFiles{$logs}"  );
         move($LogTagFile{$movelogs}, $archivename.$archiveprefix."-".$filename) or &syslog ("copy to $archivename.$archiveprefix."-".$filename failed: $!");
        } else {
         &syslog ("Move: $LogTagFile{$movelogs} - Age/Amount/Curcnt/Hash/Leave-" . int($LogTagFileAge{$movelogs}) . "/$fcnt/$ccnt/$movelogs/$LeaveFiles{$logs}"  );
         move($LogTagFile{$movelogs}, $archivename) or &syslog ("copy to $archivename failed: $!");
        } 

       } 
       if ($Logmode{$logs} =~ /Copy/i){
        if ($UseTodaysDate{$logs} eq 1) {	#1.0.3
         $archiveprefix = strftime("%Y%m%d", localtime(time));
         $filename = basename($LogTagFile{$movelogs});
         &syslog ("Copy: $LogTagFile{$movelogs} to $archivename$archiveprefix-$filename - Age/Amount/Curcnt/Hash/Leave-" . int($LogTagFileAge{$movelogs}) . "/$fcnt/$ccnt/$movelogs/$LeaveFiles{$logs}"  );
         copy($LogTagFile{$movelogs}, $archivename.$archiveprefix."-".$filename) or &syslog ("copy to $archivename.$archiveprefix."-".$filename failed: $!");
        } else {
         &syslog ("Copy: $LogTagFile{$movelogs} - to: $archivename Age/Amount/Curcnt/Hash/Leave-" . int($LogTagFileAge{$movelogs}) . "/$fcnt/$ccnt/$movelogs/$LeaveFiles{$logs}"  );
         copy($LogTagFile{$movelogs}, $archivename) or &syslog ("copy to $archivename failed: $!");
        } 
       } 

      } else {
       &syslog ("SKIP Move/Copy: $LogTagFile{$movelogs} - Age/Amount/Curcnt/Hash/Leave-" . int($LogTagFileAge{$movelogs}) . "/$fcnt/$ccnt/$movelogs/$LeaveFiles{$logs}"  );
      } 
     } else {
      &syslog ("Simulate move/copy: $movelogs - " . $LogTagFile{$movelogs});
     } 
    } else {
     &syslog ("DISABLE MOVE/COPY - COMPRESSION ERROR: $movelogs - " . $LogTagFile{$movelogs});
    }
   }   ##foreach my $movelogs (sort hashValueDescendingNum (keys(%LogTagFileAge))) 
  }     #if ((($Logmode{$logs} =~ /ZipAndDelete/i) or ($Logmode{$logs} =~ /Delete/i)) and ($Logfound{$logs} eq 1)) 
  ####################################################################################  
  ####################################################################################
  ####################################################################################


  
 
 
  ###############################
  #         DELETE FILES
  ###############################

  my $ccnt=0;
  my $chkDel;
  
  
  if ((($Logmode{$logs} =~ /ZipAndDelete/i) or ($Logmode{$logs} =~ /Delete/i)) and ($Logfound{$logs} eq 1)) {
   foreach my $dellogs (sort hashValueDescendingNum (keys(%LogTagFileAge))) {  
    $ccnt++;
    if (($LeaveFiles{$logs}) and ($LeaveFiles{$logs} ne "0")) {
     if (($fcnt-$ccnt) < $LeaveFiles{$logs}){
     	$chkDel=undef;
     } else {
     	$chkDel=1;
     }	
    } else {
    	$chkDel=1;
    }
    
    if ($Logmode{$logs} !~ /^Delete/i){  #ChkDel only valid with delete Mode
    	$chkDel=1;
    }
    
    
    if ($writeOK) {
     if (!$sim){
      if ($chkDel){
       &syslog ("Delete: $LogTagFile{$dellogs} - Age/Amount/Curcnt/Hash/Leave-" . int($LogTagFileAge{$dellogs}) . "/$fcnt/$ccnt/$dellogs/$LeaveFiles{$logs}"  );
       if (unlink($LogTagFile{$dellogs}) == 1) {
       } else {
       #&syslog ("File was not deleted.");
       } 
      } else {
       &syslog ("SKIP Delete: $LogTagFile{$dellogs} - Age/Amount/Curcnt/Hash/Leave-" . int($LogTagFileAge{$dellogs}) . "/$fcnt/$ccnt/$dellogs/$LeaveFiles{$logs}"  );
      } 
     } else {
      &syslog ("Simulate delete: $dellogs - " . $LogTagFile{$dellogs});
     } 
    } else {
     &syslog ("DISABLE DELETE - COMPRESSION ERROR: $dellogs - " . $LogTagFile{$dellogs});
    }
   }   ##foreach my $dellogs (sort hashValueDescendingNum (keys(%LogTagFileAge))) 
  }     #if ((($Logmode{$logs} =~ /ZipAndDelete/i) or ($Logmode{$logs} =~ /Delete/i)) and ($Logfound{$logs} eq 1)) 



  
  if (($DirectoryCleanUp{$logs} eq "1") and (($Logmode{$logs} =~ /^Delete/i) or ($Logmode{$logs} =~ /^Move/i))and ($Recursive{$logs} eq "1")){
    #Directory cleanup - only valid with the delete or move mode
    &syslog("Directory Cleanup: $Logpath{$logs}");
    
    foreach my $filed (@files) {     #Add filepath to scalar
     if (-d $filed) { 
  	  opendir(DIR,$filed);
  	  @filesg = grep(/\.*$/,readdir(DIR));
      closedir(DIR);
      my $isDirEmpty=1;
      foreach my $dir (@filesg) {     
       if (($dir ne ".") and ($dir ne "..")){
     	  $isDirEmpty=undef;
     	  last;
       }
      } 
  	  if ($isDirEmpty) {
  	   &syslog(" ==>Delete empty directory: $filed");
  	   rmdir ($filed) || &syslog("Error deleting directory $filed: $!");
  	  }
     }
    }   #foreach my $file (@files) {     #Add filepath to scalar
  }    

  %LogTagFileAge=();
  %LogTagFile=();
  $archivename="";
  $fcnt=0;


 } #mode eq 1   


 
 if ($OperatingMode{$logs} eq 2) {   #mode 2 runslike logrotate, compress keep each file single and keep the original name
 	if ($TempPath{$logs}){
 	 subDelDir($TempPath{$logs});
 	} 
 	for my $pointer ( sort keys %logfile ){   
   #$writeOK=1;  #Default val if no compression is given
   #&syslog ("XX $logfile{$pointer}"); 	
	 $searchrequest=undef;
   foreach my $token (@IncludeTokens){
 	  if ( $logfile{$pointer} =~ /$token/i) {
	   &syslog ("Search Token Found => $token <==> $logfile{$pointer} = Key: $logs = $Logpath{$logs}"); 	
 	   $searchrequest=1;
  	}	#if ( $singlefile =~ /$token/i) 
   }   #foreach my $token (@IncludeTokens)
   foreach my $token (@ExcludeTokens){
 	  if ( $logfile{$pointer} =~ /$token/i) {
  	 &syslog ("\t\tExclude Token Found => $token <==> $logfile{$pointer} "); 	
  	 $searchrequest=undef;
  	}  #if ( $singlefile =~ /$token/i)	
   }   #foreach my $token (@ExcludeTokens)
   if ($searchrequest) {
   	&syslog ("Move $logfile{$pointer} to $TempPath{$logs}"); 	
    move($logfile{$pointer}, $TempPath{$logs}) or &syslog("move failed: $!");
    $movecnt++;
   }	
  }
 	
 	#Moving files to temp dir done - restart daemon if apply
 	if ($searchrequest){
 	 if ($RestartDaemon{$logs}) {
 	 syslog ("Apply: $RestartDaemon{$logs}");
 	 `$RestartDaemon{$logs}`;
   }

	 #Reread Temp Directory
   my (@fileslg,$ziptarget);
   opendir(DIR,$TempPath{$logs});
   @fileslg = grep(/\.*$/,readdir(DIR));
   $archiveprefix = strftime("%Y%m%d", localtime(time));
   $archivename=&SetTarget($logs,time); 
   $archivename=$Logtarget{$logs}.$archivename;
   $archivename=$archivename.$archiveprefix;
   my $archivepathprefix=$archivename;
   
   if ($MD5File{$logs}){
    foreach (@fileslg) {
   	 if (($_ !~ /\/\.$/) and ($_) and ($_ !~ /\.\./) and (! -d $_)) {
       my $md5 = Digest::MD5->new;
       $md5->add($TempPath{$logs}.$_);
       my $md5result = $md5->hexdigest;
       my $moddate = strftime("%d-%m-%Y %H:%M:%S", localtime(stat($TempPath{$logs}.$_)->mtime));
       my $filesize = -s "$TempPath{$logs}$_";
       print "==>> $TempPath{$logs}$_  == $md5result\n";
       open (MD5, ">$TempPath{$logs}$_".".md5") or syslog ("can not open md5 file")	;       
       print MD5 "File=$_\n";
       print MD5 "MD5=$md5result\n";
       print MD5 "ModSizeBytes=$filesize\n";
       print MD5 "ModSizeKiloBytes=".int($filesize/1024)."\n";
       print MD5 "ModSizeMegaBytes=".int($filesize/1024/1024)."\n";
       print MD5 "ModDateTime=$moddate \n";
       print MD5 "ModEpocheTime=".(stat($TempPath{$logs}.$_)->mtime)."\n";
       close MD5; 
     }  #if (($_ !~ /\/\.$/) and ...
    }   #foreach (@fileslg) 
   }    #if ($MD5File{$logs}) 


   
   foreach (@fileslg) {
   	if (($_ !~ /\/\.$/) and ($_) and ($_ !~ /\.\./) and (! -d $_)) {
   	 $ziptarget=$archivename.'-'.$_.".zip";
 	   #syslog ("Add to archive: $TempPath{$logs}$_ ");
 	   #Compress file by file, use date as prefix and #numbering if the file exists on target
     $file_member = $zip->addFile( $TempPath{$logs}.$_,$_ );
     #Check for MD5 file
     my $tmpfile ="$TempPath{$logs}$_".".md5";
     #print "Check: $tmpfile\n";
     if (-e $tmpfile) {
     	syslog ("Add to archive: " . $tmpfile."-".$_.".md5");
      $file_member = $zip->addFile( $tmpfile,$_.".md5" );
     } 
     
     #Check the target and loop until we found a archive name which doesnt exist
   	 if (-e $ziptarget) {  #Check if target exist
   		#syslog ("ARCHIVE ALREADY EXIST: $ziptarget =>$archivename<=>$_<=");
   		my $end_archive=undef;
   		my $filehcnt=0;
   		until ($end_archive) {       
       $filehcnt++;
       my $tmpziptarget=$archivename.'#'.$filehcnt.'-'.$_.".zip";
       if (-e $tmpziptarget) {
       	#syslog ("ARCHIVE EXIST: $tmpziptarget");
       }else {
       	syslog ("ARCHIVE ALREADY EXIST, SET INSTEAD: $tmpziptarget<=");
       	$end_archive=1;
       	$ziptarget=$tmpziptarget;
       }
      } 
   	 }	#if (-e $ziptarget)
     syslog ("Create Archive: $ziptarget ");
     unless ( $zip->writeToFileNamed("$ziptarget") == AZ_OK ) {
      #die 'write error';
      &syslog ("Error during Archive: " . $@  );
      $writeOK=undef;
     } else {
    	$writeOK=1;
    	$zipcnt++;
     }    
     $zip = Archive::Zip->new(); 
   	} #if (($_ !~ /\/\.$/) and ($_) ... 
   }  #foreach (@fileslg)
  }   #if ($searchrequest)
  if ($zipcnt eq $movecnt){
   syslog("Quality Check OK ($movecnt/$zipcnt)");
   if ($TempPath{$logs}){
    subDelDir($TempPath{$logs});
   } 
  } else {
   syslog("Quality Check FAIL ($movecnt/$zipcnt)");
  }
 }	  #if ($OperatingMode eq 2) {
}     #for my $logs ( sort keys %Logpath )



&syslog ("Script finished!!");
   
   
sub hashValueDescendingNum {
   $LogTagFileAge{$b} <=> $LogTagFileAge{$a};
}   

sub getConfig {
 my $data = $xml->XMLin("$logdconf",ForceArray => 1);	
 my ($tcnt,$skey);
 for( @{$data->{LogPath}} ){
  $tcnt++;
  $skey=$_->{Name} . "-" . $tcnt;   #Modified sort ordering
  #print "=> Preread Path: " . $_->{Path} . "\n";
  #print "=> Preread Target: " . $_->{Target} . "\n";
  #print "=> Preread MaxFileage: " . $_->{MaxFileage} . "\n";
  #print "=> Preread Mode: " . $_->{Mode} . "\n";
  #print &convert_path($bla);
  $Logpath{$skey}=&convert_path($_->{Path});
  #print "=> Log Path:  $Logpath{$skey} \n";
  #1.0.5
  if ((!$Logpath{$skey}) or ($Logpath{$skey} eq "/")){
   print "Check profile $skey\n";
   print "Path is empty - abort!\n";
   exit;
  }

  $Logmode{$skey}=$_->{Mode};
  $OperatingMode{$skey}=$_->{OperatingMode}; #1.0.1
  if (!$OperatingMode{$skey}){$OperatingMode{$skey}=1}  #SEt DEFAULT TO 1 IF UNDEF !!! #1.0.1
  $TempPath{$skey}=$_->{TempPath}; #1.0.1
  if (($OperatingMode{$skey} eq 2) and (!$TempPath{$skey})){ #1.0.1
  	&syslog ("Error: No Temp Path given - Abort"); #1.0.1
  	exit; #1.0.1
  }	
  $Protocol{$skey}=$_->{Protocol}; #1.0.3
  
  $User{$skey}=$_->{User}; #1.0.3
  $Password{$skey}=$_->{Password}; #1.0.3
  $Server{$skey}=$_->{Server}; #1.0.3
  $KeyFile{$skey}=$_->{KeyFile}; #1.0.3
  
  
  
  $MD5File{$skey}=$_->{MD5File}; #1.0.1
  $RestartDaemon{$skey}=$_->{RestartDaemon}; #1.0.1
  $Logage{$skey}=$_->{MaxFileage}; #1.0.1
  $IncludeLogmask{$skey}=$_->{IncludeMask};
  $ExcludeLogmask{$skey}=$_->{ExcludeMask};
  $Logtarget{$skey}=&convert_path($_->{Target});
  #print "=> Read Target: $Logtarget{$skey}\n";
  $ZipParents{$skey}=$_->{ZipParents};
  $CreateDateDir{$skey}=$_->{CreateDateDir};
  if (!$CreateDateDir{$skey}) {$CreateDateDir{$skey}="0"}; #Set to 0 if not defined
  $LeaveFiles{$skey}=$_->{LeaveFiles};
  $DirectoryCleanUp{$skey}=$_->{DirectoryCleanUp};
  $CheckTargetDir{$skey}=$_->{CheckTargetDir};  #1.0.2
  $Recursive{$skey}=$_->{Recursive};
  $LogSuffix{$skey}=$_->{Name};
  $UseTodaysDate{$skey}=$_->{UseTodaysDate};
  $UseHostname{$skey}=$_->{UseHostname};
 }

 my $xmlconfig = XMLin($logdconf);
 $WriteLog=$xmlconfig->{Setting}->{WriteLog};
 $WriteLogPath=$xmlconfig->{Setting}->{LogPath};
 $RandomDelayMin=$xmlconfig->{Setting}->{RandomDelayMin};
 $RandomDelayMax=$xmlconfig->{Setting}->{RandomDelayMax};
}


sub syslog {
	
	my $tldate = strftime("%d-%m-%Y %H:%M:%S", localtime(time));
	my $tllog = strftime("%Y%m%d", localtime(time));
	
  if ( $WriteLog ) {
  	open (LOGGING, ">>$WriteLogPath$tllog-logd.txt") or die "no such file";
    print LOGGING "$tldate $_[0]\n";
    close LOGGING
  }
 print "$_[0]\n";
}            # sub Syslog 


sub getRecursiveFiles() {
 #Recursive scan	
 if ($_ ne ".") {
  push(@files,$File::Find::name);
 }
}


sub DescSort{
 $logfile{$b} <=> $logfile{$a};
}



sub convert_path {
 #convert backslash to forwardslash nad add a traling slash if not exist and if no trailing backslash is present
 if ((substr($_[0],length($_[0])-1,1) ne chr(92)) and not (substr($_[0],length($_[0])-1,1) eq chr(47))){
	$_[0].='/';   #add a forward slash at the end if not exist
 }
 my $ii=0;
 my $tmptt="";
 for (0..length($_[0])){
  if (substr($_[0],$ii,1) eq chr(92)){
   $tmptt.='/';   
  } else {
   $tmptt.=substr($_[0],$ii,1);   	
  }
   ++$ii; 
 }
 return $tmptt;
}


sub SetTarget {
 #$_[0] = Profile Name
 #$_[1] = Epoche Date
 #$_[2] = Cur.Filename (Used with move only)
 
 if (($CreateDateDir{$_[0]} eq 1) and ($CheckTargetDir{$_[0]} eq 1)){
 	&syslog ("Invalid Setting: CreateDateDir=$CreateDateDir{$_[0]} - CheckTargetDir=$CheckTargetDir{$_[0]}");
 	return "";
 }
 my $tcnt;
 &syslog ("pre start target $_[0] $_[1] - $_[2]");
 if (($CreateDateDir{$_[0]} eq 1) and (($Logmode{$_[0]} =~ /ZipAndDelete/i) or ($Logmode{$_[0]} =~ /Zip/i) or ($Logmode{$_[0]} =~ /Move/i) or ($Logmode{$_[0]} =~ /Copy/i) or ($OperatingMode{$_[0]} eq 2))) {
     &syslog ("start target $_[0] $_[1] $Logtarget{$_[0]} - $CheckTargetDir{$_[0]}");
     my $Montname=$abbr[strftime("%m", localtime($_[1]))-1];
     my $Year=strftime("%Y", localtime($_[1]));
     if (!$sim) {
      #unless(-d $Logtarget{$_[0]}.$Year){
       mkpath($Logtarget{$_[0]}.$Year,  0711);
       mkpath($Logtarget{$_[0]}.$Year.'/'.$Montname,  0711);
      #} 
     } 
     &syslog("Set Abbr: $Year/$Montname");
     return $Year.'/'.$Montname.'/';
 } 	else {  #if (($CreateDateDir{$_[0]} eq 1)
  
  #1.0.2 Autocreate target dir
  if (($CreateDateDir{$_[0]} eq 0) and ($CheckTargetDir{$_[0]} eq 1) and (($Logmode{$_[0]} =~ /Move/i) or ($Logmode{$_[0]} =~ /Copy/i))) {
    &syslog("Set TEST Abbr: $Logpath{$_[0]} $_[2]");
    my $tmppath;
    $filename = basename($_[2]);
    $dirname = dirname($_[2]);
    #&syslog("Debxy $filename");
    #&syslog("Debxy $dirname");
    ($val,$var) = split(/$Logpath{$_[0]}/,$dirname,2);  
    $tmppath="$Logtarget{$_[0]}$var/";
    if (! -d $tmppath){
     &syslog("mkdir target: $tmppath");
     mkpath([$tmppath], 1, 0711);
    } 
    return $tmppath;  
    #used with 1.0.2 
    #my @lvals=split("/",$_[2]);    
    #my $tmppath;
    #$tmppath=$Logtarget{$_[0]};
    #foreach (@lvals){
    #	$tcnt++;
    #	if (($_) and ($tcnt gt 1) and  ($tcnt lt scalar(@lvals))){
    #	 $tmppath=$tmppath.$_."/";
    #	 if (! -d $tmppath){
    #	  syslog("==> mkdir $tmppath");
    #	  mkpath($tmppath,  0711);
    #	 } 
    #	} 
    #}
   #return $tmppath;  
  }
 } 	  #if (($CreateDateDir{$_[0]} eq 1)
 return ""; 
}


sub subDelDir {
 #Delete all files from directory ($_[0])
 my @filedel;
 opendir (DIR, $_[0]) or die $!;
 @filedel = grep(/\.*$/,readdir(DIR));
 closedir DIR;
 foreach my $filed (@filedel) {
 	if (($filed !~ /\/\.$/) and ($filed) and ($filed !~ /\.\./) and (! -d $filed)) {
 	 syslog ("Delete: $_[0]$filed");
   unlink ($_[0].$filed);
  } 
 }  
}