#!/usr/bin/perl

#All source code, binaries, documentation, and information contained
#in this distribution are provided AS IS with NO WARRANTY OF ANY KIND,
#INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY, AND FITNESS FOR
#A PARTICULAR PURPOSE. 

#i2Mobile - Setup Session Cookie
#See the documentation at: http://coolscript.org/index.php/I2Mobile

use strict;
use POSIX;
use CGI;
use XML::Simple;
use HTTP::Date qw/str2time/;  


#CGI related init
my $cgi = new CGI; 
my ($ack,$key,%input,$curid,$curidvalid,$Protocol);
my $ServerName=$ENV{'SERVER_NAME'};
my $SSL=$ENV{'HTTPS'};
my $USER=$ENV{'REMOTE_USER'};
my $URI=$ENV{'REQUEST_URI'};
my ($Configfile,$request_host,$userpass,$cookieauthentication,%cEnabled,%cCookieID,%cName,%cExpire,$contact); #User access data

$Configfile='/etc/i2mobile.xml';
###############
&ReadMyConfig;
###############


for my $key ( $cgi->param() ) {
 $input{$key} = $cgi->param($key);
 if ($key eq "id"){
  $curid=$input{$key}; 
 } 
}

#Authentication:
my ($query,$csName,$csExpire);
 for my $ident ( sort keys %cCookieID ) {	
  #print "$cName{$ident}\n";
  if ($cEnabled{$ident}){
   if ($cCookieID{$ident} eq $curid){  #Found valid cookie
    $csName=$cName{$ident};
    $csExpire=$cExpire{$ident};
    $curidvalid=1;
   } 
  }	
 } 

if ($curidvalid){
 my $tmpTime;
 if ($csExpire =~ /(\d{4})(\d{2})(\d{2})/){ 
  $tmpTime=str2time("$3-$2-$1 00:00:00"); #Get local epoch datetime
 } 

 #Sample Date Format: '28-Dec-2016 12:30:00 GMT'
 my $tldate = strftime("%d-%b-%Y %H:%M:%S GMT", gmtime($tmpTime));
 ###################################
 #            SET COOKIE
 ###################################
 $query = new CGI;
 #Sample:
 #-expires=>'28-Dec-2016 12:30:00 GMT',
 my $cookie = $query->cookie(-name=>'i2Mobile',
  -value=>$curid,
  -expires=>$tldate,
   -path=>'/');
 print $query->header(-cookie=>$cookie);			 
}


if ($SSL eq "on"){
	$Protocol="https";
}	else {
	$Protocol="http";
}

my $tldate = strftime("%a %d %b %Y - %H:%M:%S", localtime(time));
if (!$curidvalid)   {
 print "Content-type: text/html\n\n";
} 
print '
<!DOCTYPE HTML PUBLIC>
<html>
 <head>
  <title>i2Mobile</title>
   <link type="text/css" rel="stylesheet" href="'.$Protocol.'://'.$ServerName.'/css/ibase.css">
   <meta name="resource-type" content="document">
   <meta http-equiv="pragma" content="no-cache">
   <meta name="revisit-after" content="15">
   <meta name="classification" content="System Administration">
   <meta name="description" content="icinga2 Mobile">
   <meta name="keywords" content="icinga2">
   <meta name="robots" CONTENT="nofollow">
   <meta name="distribution" content="Global">
   <meta name="rating" content="General">
   <meta name="language" content="en">
   <meta name="doc-type" content="Public">
   <meta name="doc-class" content="Completed">
   <meta name="doc-rights" content="Private"> 
   </head>
   <body>
    <div id="main">
     <div id="main" style="text-align: left;">
      <div id="wrapper" class="shadow">
       <div id="header"></div>   
        <div id="header-top-bar"> 
         <h1 id="header-text">i2Mobile</h1> 
        </div>   
        <div class="about_description">';
  if ((!$curid) or  (!$curidvalid)) {
   print '        
         <h3>No valid session cookie given.<br><br>
         Please contact:<br><br>'.$contact.'<br><br><br><br></h3>';
         
  }       
  if ($curidvalid)   {
  	
  print "        	
         <h3>Your session cookie has been <br>setup on your browser<br><br>Thank you!<br><br>
         <a href='$Protocol://$ServerName' class='greyrefresh'>Home</a><br><br><br></h3>";       
  }	

print "      
     </div>
    </div>
   </div>
  </div> 
 </body>
</html>
";

####
#END
####








sub ReadMyConfig {
   my $tcnt;
   my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
   my $data = $xml->XMLin("$Configfile");
   $request_host=$data->{System}->{IcingaHost};
   $userpass=$data->{System}->{Password};
   $cookieauthentication=$data->{System}->{CookieAuthentication};
   $contact=$data->{System}->{Contact};
   my $data = $xml->XMLin("$Configfile",ForceArray => 1);	
   #if ($cookieauthentication eq "1" ) {
    for( @{$data->{Authentication}} ){
     $tcnt++;
     $cEnabled{$tcnt}=$_->{Enabled};
     $cCookieID{$tcnt}=$_->{CookieID};
     $cName{$tcnt}=$_->{Name};
     $cExpire{$tcnt}=$_->{Expire};
    }
}
	
	
	
	 
 
