#!/usr/bin/perl


#All source code, binaries, documentation, and information contained
#in this distribution are provided AS IS with NO WARRANTY OF ANY KIND,
#INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY, AND FITNESS FOR
#A PARTICULAR PURPOSE. 

#i2Mobile 1.0.0 - Show services via rest api
#See the documentation at: http://coolscript.org/index.php/I2Mobile


use strict;
use POSIX;
use CGI;
use XML::Simple;

#Icinga REST related modules
use REST::Client;
use MIME::Base64;
use JSON;
use Data::Dumper;


#CGI related init
my $cgi = new CGI; 
my ($ack,$key,%input);
my $ServerName=$ENV{'SERVER_NAME'};
my $SSL=$ENV{'HTTPS'};
my $USER=$ENV{'REMOTE_USER'};
my $URI=$ENV{'REQUEST_URI'};
my $serviceSCRIPT="service.pl";


my ($Configfile,$request_host,$userpass,$cookieauthentication,%cEnabled,%cCookieID,%cName,%cExpire,$contact); #User access data
$Configfile='/etc/i2mobile.xml';
###############
&ReadMyConfig;
###############

#Authentication:
my ($query,$Cookie,$csName,$csExpire);
if ($cookieauthentication eq "1"){ #Cookie Authentication is set!
 $query = new CGI;
 $Cookie = $query->cookie('i2Mobile');
 for my $ident ( sort keys %cCookieID ) {	
  if ($cEnabled{$ident}){
   if ($cCookieID{$ident} eq $Cookie){  #Found valid cookie
    $csName=$cName{$ident};
    $csExpire=$cExpire{$ident};
   } 
  }	
 } 
}


#Icinga2 API Vars
my ($Protocol,$smode,$issrvntr);
my ($sHostOK,$sHostError,$ServiceOK,$ServiceWarning,$ServiceCritical,$probAck);
my ($restStatus,$restHost,$restName,$restOutput,$restAcknowledgement,$restLastExecute);
my (%hServiceAcknowledgement,%hServiceProblemStatus,%hServiceProblemOutput,%hServiceProblemLastExecute);
my (%hServiceProblemStatusUnknown,%hServiceProblemStatusWarning,%hServiceProblemStatusError,%hServiceProblemStatusWarningAck,%hServiceProblemStatusErrorAck);
my (%hServiceOKOutput,%hServiceOKLastExecute);
my ($ServiceOK,$ServiceWarning,$ServiceError,$ServiceUnknown,$ServiceWarningAck,$ServiceErrorAck);
my (%hHostProblemStatusError,%hHostOKOutput,%hHostLastExecute,%hHostAcknowledgement);
my ($srvState,$srvCNT);

#Icinga2 API Init
$ENV{'PERL_LWP_SSL_VERIFY_HOSTNAME'} = 0; #Switch off SSL verifycation
my $client = REST::Client->new();
$client->setHost($request_host);
#$client->setCa("ca.crt");
#Thanks: http://community.brocade.com/t5/vADC-Docs/Tech-Tip-Using-the-RESTful-Control-API-with-Perl/ta-p/73763
$client->getUseragent()->ssl_opts( SSL_verify_mode => 0 );
$client->addHeader("Accept", "application/json");
$client->addHeader("X-HTTP-Method-Override", "GET");
$client->addHeader("Authorization", "Basic " . encode_base64($userpass));


#*** Get Service Data ***
($ServiceOK,$ServiceWarning,$ServiceError,$ServiceUnknown,$ServiceWarningAck,$ServiceErrorAck)=getServiceData();
#print "==> ServicesOK: $ServiceOK ServicesWarning: $ServiceWarning/$ServiceWarningAck ServicesError: $ServiceError/$ServiceErrorAck ServicesUnknown: $ServiceUnknown\n";

if (($ServiceWarningAck) or ($ServiceErrorAck)){
	$probAck=$ServiceWarningAck+$ServiceErrorAck;
	#Consider to do something with acknowledged services ...
}

$srvState=1;  #0/1/2 - This will get overwritten by url param !!


if ($SSL eq "on"){
	$Protocol="https";
}	else {
	$Protocol="http";
}

for $key ( $cgi->param() ) {
 $input{$key} = $cgi->param($key);
 if ($key eq "mode"){
  $srvState=$input{$key};
 }	
} 



print "Content-type: text/html\n\n";
print '
<!DOCTYPE HTML PUBLIC>
<html>
 <head>
  <title>i2Mobile</title>
   <link type="text/css" rel="stylesheet" href="'.$Protocol.'://'.$ServerName.'/css/ibase.css">
   <meta name="resource-type" content="document">
   <meta http-equiv="pragma" content="no-cache">
   <meta name="revisit-after" content="15">
   <meta name="classification" content="System Administartion">
   <meta name="description" content="icinga2 Mobile">
   <meta name="keywords" content="icinga2">
   <meta name="robots" CONTENT="nofollow">
   <meta name="distribution" content="Global">
   <meta name="rating" content="General">
   <meta name="language" content="en">
   <meta name="doc-type" content="Public">
   <meta name="doc-class" content="Completed">
   <meta name="doc-rights" content="Private"> 
   <style>
    table {
     border-collapse: collapse;
 	   table-layout:fixed;
	   width:910px; 

    }
    th, td {
     text-align: left;
     padding: 8px;
     font-family:Arial;
     font-size:40px;
     color:#777777;
     overflow: hidden;
    }
    tr:nth-child(even){background-color: #f2f2f2}


   .td_size {    
    width:200px; 
    height:50px;
    max-width:200px;
    min-width:100px; 
    max-height:50px; 
    min-height:50px;
    
    }

   </style>
   
  ';
print '
 </head>';
#<form action="http://'.$ServerName.'" name="form1" method="get" > 
print ' 
 <body>
  <div id="main">
 
   <div id="main" style="text-align: left;">
    <div id="wrapper" class="shadow">
     <div id="header"></div>   
      <div id="header-top-bar"> 
	    <h1 id="header-text">i2Mobile</h1> 
	  </div>   
    <div class="about_description">';
 my $tldate = strftime("%a %d %b %Y - %H:%M:%S", localtime(time));
 print ' 
      <div class="about_description">';

if (($cookieauthentication eq "1") and (!$csName)) {
  print '        
         <h3>No valid session cookie found!<br><br>
         Please contact:<br><br>'.$contact.'<br><br><br><br></h3>';
} else {


 print ' 
      <h3>'.$tldate.'</h3>';


if ($srvState eq 2){
#<table class='fixed'>
print "
       <div class='about_description'>
       <h3>State ERROR<br>$ServiceError Services</h3>
       <table>
";

for my $pnt ( sort keys %hServiceProblemStatusError ){   
	#print "$pnt - $hServiceProblemStatusError{$pnt} - $hServiceProblemStatusError{$pnt} - $hServiceProblemOutput{$pnt} \n";
	$srvCNT++;
	my ($tmpHost,$tmpService) = split(/\|\|/,$pnt);   
	print "       <tr>\n";
  print "       <td><a href='$Protocol://$ServerName/$serviceSCRIPT?host=$tmpHost&srv=$tmpService' class='tabletext'>$srvCNT:$tmpHost</a></td>\n";
  print "       <td><a href='$Protocol://$ServerName/$serviceSCRIPT?host=$tmpHost&srv=$tmpService' class='tabletext'>$tmpService</a></td>\n";
  print "       </tr>\n";
}	  #for my $pnt ( sort keys %hServiceProblemStatusError )
  print "</table>\n";
  print "       </div>\n";
}   #if ($srvState eq 2)


if ($srvState eq 1){
#<table class='fixed'>
print "
       <div class='about_description'>
       <h3>State WARNING<br>$ServiceWarning Services</h3>
       <table>
";

for my $pnt ( sort keys %hServiceProblemStatusWarning ){   
	#print "$pnt - $hServiceProblemStatusError{$pnt} - $hServiceProblemStatusError{$pnt} - $hServiceProblemOutput{$pnt} \n";
	my ($tmpHost,$tmpService) = split(/\|\|/,$pnt);   
	#$tmpHost=substr($tmpHost,0,16);
	#$tmpService=substr($tmpService,0,20);
  $srvCNT++;
	print "       <tr>\n";
  print "       <td><a href='$Protocol://$ServerName/$serviceSCRIPT?host=$tmpHost&srv=$tmpService' class='tabletext'>$srvCNT:$tmpHost</a></td>\n";
  print "       <td><a href='$Protocol://$ServerName/$serviceSCRIPT?host=$tmpHost&srv=$tmpService' class='tabletext'>$tmpService</a></td>\n";
  print "       </tr>\n";
}	  #for my $pnt ( sort keys %hServiceProblemStatusWarning )
  print "      </table>\n";
  print "     </div>\n";
}   #if ($srvState eq 2)


if ($srvState eq 0){
#<table class='fixed'>
print "
       <div class='about_description'>
       <h3>State OK<br>$ServiceOK Services</h3>
       <table>
";



for my $pnt ( sort keys %hServiceOKOutput ){   
 #print "$pnt - $hServiceProblemStatusError{$pnt} - $hServiceProblemStatusError{$pnt} - $hServiceProblemOutput{$pnt} \n";
 my ($tmpHost,$tmpService) = split(/\|\|/,$pnt);   
 $srvCNT++;
 print "       <tr>\n";
  
  #print "<td>$srvCNT:$tmpHost</td>\n";
  #print "<td>$tmpService</td>\n";
  
  print "       <td><a href='$Protocol://$ServerName/$serviceSCRIPT?host=$tmpHost&srv=$tmpService' class='tabletext'>$srvCNT:$tmpHost</a></td>\n";
  print "       <td><a href='$Protocol://$ServerName/$serviceSCRIPT?host=$tmpHost&srv=$tmpService' class='tabletext'>$tmpService</a></td>\n";
  print "       </tr>\n";
}	  #for my $pnt ( sort keys %hServiceOKOutput )
  print "      </table>\n";
  print "     </div>\n";
}   #if ($srvState eq 2)


print "
        <br><br><br><br><br>
        <div class='refresh_description'>
        <a href='javascript:history.back()' class='greyrefresh'>Return</a> <a href='$Protocol://$ServerName$URI' class='greyrefresh'>Refresh</a><br><br><br><br><br>
        </div>";


 
#########
#END PAGE
#########

}    #if (($cookieauthentication eq "1") and (!$csName))


print ' 
     </div>
    </div>
   </div>
  </div> 
 </body>
</html>
';

####
#END
####





sub getServiceData {
 my %json_data = (
         attrs => ['name', 'state', 'last_check_result','acknowledgement'],
         joins => ['host.name', 'host.state', 'host.last_check_result','service.acknowledgement'],
         filter => 'match("*", service.state) && (!service.vars.is_ignore)',
         
 );
 #joins => ['host.name', 'host.state', 'host.last_check_result','host.acknowledgement','service.acknowledgement'],
 #       filter => 'match("4", service.state) || match("4", service.state) || match("1", host.state) || match("2", host.state)',
 #sample: filter => 'match("0", service.state)',
 #sample: filter => 'match("*", service.name)',
 
 my $data = encode_json(\%json_data);
 
 ###############################################
 $client->POST("/v1/objects/services", $data);
 ###############################################
 my $status = $client->responseCode();
 #print "Status: " . $status . "\n";
 my $response = $client->responseContent();
 if ($status == 200) {
  my $VAR1=decode_json($response);
  #print "==***====>  Result: " . Dumper($VAR1) . "\n";
  my $cnt;
  for my $v (@{$VAR1->{results}}){
   $restHost=undef;
   $restStatus=undef;
   $restName=undef;
   $restOutput=undef;
   $restAcknowledgement=undef;
   for my $w (keys (%{$v})){ 
    if ($w eq 'attrs'){
     $restStatus=$v->{$w}->{'state'}; 
     $restName=$v->{$w}->{'name'};  
     $restOutput=$v->{$w}->{'last_check_result'}->{'output'}; 
     $restLastExecute=$v->{$w}->{'last_check_result'}->{'execution_start'}; 
     if ($restStatus) {
       $restAcknowledgement=$v->{$w}->{'acknowledgement'};
     } 
     #print "==>> ResultSTATE: " . Dumper($v->{$w}) . " <=>$restStatus<=> -- $restName -- $w\n";	
    } 
    if ($w eq 'joins'){
      $restHost=$v->{$w}->{'host'}->{'name'};  #Sample of holding our STATE!
    }
    
    if (($restHost) and ($restStatus) ){
     my $tldate = strftime("%Y-%m-%d %H:%M:%S", localtime($restLastExecute));  
     #print "State error $restStatus -- $restHost -- $restName -- $restOutput -- $restAcknowledgement --$tldate\n";
     $hServiceAcknowledgement{"$restHost||$restName"}=$restOutput;
     $hServiceProblemStatus{"$restHost||$restName"}=$restStatus;
     if ($restStatus eq 1){
      if ($restAcknowledgement) {
       $hServiceProblemStatusWarningAck{"$restHost||$restName"}=$restStatus;
      } else {		
       $hServiceProblemStatusWarning{"$restHost||$restName"}=$restStatus;
      }
     } 
   
     if ($restStatus eq 2){
      if ($restAcknowledgement) {
       $hServiceProblemStatusErrorAck{"$restHost||$restName"}=$restStatus;
      } else {
       $hServiceProblemStatusError{"$restHost||$restName"}=$restStatus;
      } 
     } 
    	
     if ($restStatus eq 3){
      $hServiceProblemStatusUnknown{"$restHost||$restName"}=$restStatus;
     }  
    	
     $hServiceProblemOutput{"$restHost||$restName"}=$restOutput;
     $hServiceProblemLastExecute{"$restHost||$restName"}=$restLastExecute;
    	
     $restHost=undef;
     $restStatus=undef;
     $restName=undef;
     $restOutput=undef;
     $restAcknowledgement=undef;
     $restLastExecute=undef;
    } else {
     if (($restHost) and ($restName)){ 
      $cnt++;
      #print "$cnt OK $restHost $restName $restOutput\n";
      $hServiceOKOutput{"$restHost||$restName"}=$restOutput;
      $hServiceOKLastExecute{"$restHost||$restName"}=$restLastExecute;
     }       #if (($restHost) and ($restName))
    }        #if (($restHost) and ($restStatus) )
   }         #if ($w eq 'attrs')
  }          #for my $v (@{$VAR1->{results}})
 } else {    #if ($status == 200) 
  print "Error: " . $response . "\n";
 }           #if ($status == 200) 
 
 my $TmpServiceOK=keys %hServiceOKOutput;
 my $TmpServiceWarning=keys %hServiceProblemStatusWarning;
 my $TmpServiceWarningAck=keys %hServiceProblemStatusWarningAck;
 my $TmpServiceErrorAck=keys %hServiceProblemStatusErrorAck;
 my $TmpServiceError=keys %hServiceProblemStatusError;
 my $TmpServiceUnknown=keys %hServiceProblemStatusUnknown;
 
 #print "$TmpServiceOK,$TmpServiceWarning,$TmpServiceError,$TmpServiceUnknown";
 return ($TmpServiceOK,$TmpServiceWarning,$TmpServiceError,$TmpServiceUnknown,$TmpServiceWarningAck,$TmpServiceErrorAck);
}   #SUB




sub getHostData {
 my %json_data = (
  attrs => ['name', 'state', 'last_check_result','acknowledgement'],
  joins => ['host.name', 'host.state', 'host.last_check_result','host.acknowledgement'],
  filter => 'match("*", host.state) && (!host.vars.is_ignore)',
 );
 
 #       filter => 'match("4", service.state) || match("4", service.state) || match("1", host.state) || match("2", host.state)',
 #sample: filter => 'match("0", service.state)',
 #sample: filter => 'match("*", service.name)',
 
 my $data = encode_json(\%json_data);
 
 ###############################################
 $client->POST("/v1/objects/hosts", $data);
 ###############################################
 my $status = $client->responseCode();
 #print "Status: " . $status . "\n";
 my $response = $client->responseContent();
 if ($status == 200) {
  my $VAR1=decode_json($response);
  #print "Result: " . Dumper($VAR1) . "\n";
  #See: http://wiki.intern/index.php/Perl_hacks#Hash
  for my $v (@{$VAR1->{results}}){
   $restStatus=undef;
   $restHost=undef;
   $restOutput=undef;
   for my $w (keys (%{$v})){ ###Get the element as HASH ref and print 
    if ($w eq 'attrs'){
     $restStatus=$v->{$w}->{'state'}; 
     $restHost=$v->{$w}->{'name'};  
     $restAcknowledgement=$v->{$w}->{'acknowledgement'};  
     $restOutput=$v->{$w}->{'last_check_result'}->{'output'};  #Sample of holding our STATE!
     $restLastExecute=$v->{$w}->{'last_check_result'}->{'execution_start'}; 
    }     #if ($w eq 'attrs')
    if (($restHost) and ($restStatus) ){
     #print "State error $restStatus -- -- $restHost -- $restOutput\n";
     $hHostProblemStatusError{$restHost}=$restOutput;
     $hHostLastExecute{$restHost}=$restLastExecute;
     $hHostAcknowledgement{$restHost}=$restAcknowledgement;
     #***$restAcknowledgement
     $restHost=undef;
     $restStatus=undef;
     $restHost=undef;
     $restOutput=undef;
    } else {       #if (($restHost) and ($restStatus) )
     if ( ($restHost)){ 
      #print "OK  $restHost - $restOutput - $restLastExecute\n";
      $hHostOKOutput{$restHost}=$restOutput;
      $hHostLastExecute{$restHost}=$restLastExecute;
     }	           #if ( ($restHost))
    }              #if (($restHost) and ($restStatus) )
   }               #for my $w (keys (%{$v})) ###Get the element as HASH ref and print 
  }                #for my $v (@{$VAR1->{results}})
 } else {          #if ($status == 200) 
  #print "Error: " . $response . "\n";
 }                 #if ($status == 200) 

 my $TmpHostOK=keys %hHostOKOutput;
 my $TmpHosteError=keys %hHostProblemStatusError;
  #print "$TmpHostOK,$TmpHosteError\n";
 return ($TmpHostOK,$TmpHosteError);

}                  #SUB  

sub ReadMyConfig {
   my $tcnt;
   my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
   my $data = $xml->XMLin("$Configfile");
   $request_host=$data->{System}->{IcingaHost};
   $userpass=$data->{System}->{Password};
   $cookieauthentication=$data->{System}->{CookieAuthentication};
   $contact=$data->{System}->{Contact};
   my $data = $xml->XMLin("$Configfile",ForceArray => 1);	
   if ($cookieauthentication eq "1" ) {
    for( @{$data->{Authentication}} ){
     $tcnt++;
     $cEnabled{$tcnt}=$_->{Enabled};
     $cCookieID{$tcnt}=$_->{CookieID};
     $cName{$tcnt}=$_->{Name};
     $cExpire{$tcnt}=$_->{Expire};
    }
   } 
}
