#!/usr/bin/perl

#All source code, binaries, documentation, and information contained
#in this distribution are provided AS IS with NO WARRANTY OF ANY KIND,
#INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY, AND FITNESS FOR
#A PARTICULAR PURPOSE. 

#i2Mobile 1.0.0 - Show host and service status via rest api
#See the documentation at: http://coolscript.org/index.php/I2Mobile

use strict;
use POSIX;
use CGI;
use XML::Simple;

#Icinga REST related modules, see samples here: http://docs.icinga.org/icinga2/latest/doc/module/icinga2/chapter/icinga2-api
use REST::Client;
use MIME::Base64;
use JSON;
use Data::Dumper;


#CGI related init
my $cgi = new CGI; 
my ($ack,$key,%input);
my $ServerName=$ENV{'SERVER_NAME'};
my $SSL=$ENV{'HTTPS'};
my $USER=$ENV{'REMOTE_USER'};
my $URI=$ENV{'REQUEST_URI'};
my ($Configfile,$request_host,$userpass,$cookieauthentication,%cEnabled,%cCookieID,%cName,%cExpire,$contact); #User access data

$Configfile='/etc/i2mobile.xml';
###############
&ReadMyConfig;
###############
my $serviceSCRIPT="services.pl";  #Script naming
my $hostSCRIPT="hosts.pl";        #Script naming

#Authentication:
my ($query,$Cookie,$csName,$csExpire);
if ($cookieauthentication eq "1"){ #Cookie Authentication is set!
 $query = new CGI;
 $Cookie = $query->cookie('i2Mobile');
 for my $ident ( sort keys %cCookieID ) {	
  if ($cEnabled{$ident}){
   if ($cCookieID{$ident} eq $Cookie){  #Found valid cookie
    $csName=$cName{$ident};
    $csExpire=$cExpire{$ident};
   } 
  }	
 } 
}


#i2Mobile API Vars
my ($Protocol,$hmode,$smode,$isrvpntr,$issrvntr,$tmpAck,$tmpAckPnt,$tmpHostAck,$tmpHostAckPnt);
my ($sHostOK,$sHostError,$ServiceOK,$ServiceWarning);
my ($restStatus,$restHost,$restName,$restOutput,$restAcknowledgement,$restLastExecute);
my (%hServiceAcknowledgement,%hServiceProblemStatus,%hServiceProblemOutput,%hServiceProblemLastExecute);
my (%hServiceProblemStatusUnknown,%hServiceProblemStatusWarning,%hServiceProblemStatusError,%hServiceProblemStatusWarningAck,%hServiceProblemStatusErrorAck);
my (%hServiceOKOutput,%hServiceOKLastExecute);
my ($ServiceOK,$ServiceWarning,$ServiceError,$ServiceUnknown,$ServiceWarningAck,$ServiceErrorAck);
my (%hHostProblemStatusError,%hHostOKOutput,%hHostLastExecute,%hHostAcknowledgement);

  

#i2Mobile API Init
$ENV{'PERL_LWP_SSL_VERIFY_HOSTNAME'} = 0; #Switch off SSL verification
my $client = REST::Client->new();
$client->setHost($request_host);
#$client->setCa("ca.crt");
#Thanks: http://community.brocade.com/t5/vADC-Docs/Tech-Tip-Using-the-RESTful-Control-API-with-Perl/ta-p/73763
$client->getUseragent()->ssl_opts( SSL_verify_mode => 0 );
$client->addHeader("Accept", "application/json");
$client->addHeader("X-HTTP-Method-Override", "GET");
$client->addHeader("Authorization", "Basic " . encode_base64($userpass));


#*** Get my Host Data ***
my ($sHostOK,$sHostError,$sHostAck)=getHostData();
my $hstTOT=$sHostOK+$sHostError;


#*** Get Service Data ***
($ServiceOK,$ServiceWarning,$ServiceError,$ServiceUnknown,$ServiceWarningAck,$ServiceErrorAck)=getServiceData();
my $srvTOT=$ServiceOK+$ServiceWarning+$ServiceError+$ServiceUnknown;
my $probAck=$ServiceWarningAck+$ServiceErrorAck;

#Hosts are using binary values, the sum of all values:
#2=OK
#1=Error

#Services are using binary values, the sum of all values:
#4=OK
#2=WARN
#1=Crit

#Sample, OK and Crit = 5
#Sample, OK and Warn = 6
#Sample, OK only =4


if ($ServiceOK){
 $isrvpntr+=4;
}

if ($ServiceWarning){
 $isrvpntr+=2;
}

if ($ServiceError){
 $isrvpntr+=1;
}
$smode=$isrvpntr;
 
if ($sHostOK){
 $issrvntr+=2;
} 
 
if ($sHostError){
 $issrvntr+=1;
} 
$hmode=$issrvntr; 


if ($SSL eq "on"){
	$Protocol="https";
}	else {
	$Protocol="http";
}
	

my $tldate = strftime("%a %d %b %Y - %H:%M:%S", localtime(time));
#if ($sHostAck) {
# $tmpHostAck=" Ack: $sHostAck";
# $tmpHostAckPnt="/$sHostAck";
#}

#if ($probAck){
# $tmpAck=" Ack: $probAck";
# $tmpAckPnt="/$probAck";
#}

print "Content-type: text/html\n\n";
print '
<!DOCTYPE HTML PUBLIC>
<html>
 <head>
  <title>i2Mobile</title>
   <link type="text/css" rel="stylesheet" href="'.$Protocol.'://'.$ServerName.'/css/ibase.css">
   <meta name="resource-type" content="document">
   <meta http-equiv="pragma" content="no-cache">
   <meta name="revisit-after" content="15">
   <meta name="classification" content="System Administration">
   <meta name="description" content="i2Mobile">
   <meta name="keywords" content="i2Mobile">
   <meta name="robots" CONTENT="nofollow">
   <meta name="distribution" content="Global">
   <meta name="rating" content="General">
   <meta name="language" content="en">
   <meta name="doc-type" content="Public">
   <meta name="doc-class" content="Completed">
   <meta name="doc-rights" content="Private"> 
   </head>
   <body>
    <div id="main">
     <div id="main" style="text-align: left;">
      <div id="wrapper" class="shadow">
       <div id="header"></div>   
        <div id="header-top-bar"> 
         <h1 id="header-text">i2Mobile</h1> 
        </div>   
        <div class="about_description">';

if (($cookieauthentication eq "1") and (!$csName)) {
  print '        
         <h3>No valid session cookie found!<br><br>
         Please contact:<br><br>'.$contact.'<br><br><br><br></h3>';
} else {

  print '        
         <h3>'.$tldate.'</h3>';

if ($hmode eq 3){

print "
        <h2>Hosts ($hstTOT) $tmpHostAck</h2>
        <a href='$Protocol://$ServerName/$hostSCRIPT?mode=0' class='greentwoHost'>OK ($sHostOK$tmpHostAckPnt)</a>
        <a href='$Protocol://$ServerName/$hostSCRIPT?mode=1' class='redtwoHost'>Critcal ($sHostError)</a>
        <br><br><br>";
}

if ($hmode eq 2){
print "
        <h2>Hosts ($hstTOT) $tmpHostAck</h2>
        <a href='$Protocol://$ServerName/$hostSCRIPT?mode=0' class='greenoneHost'>OK($sHostOK$tmpHostAckPnt)</a>
        <br><br><br>";
}

if ($hmode eq 1){
print "
        <h2>Hosts ($hstTOT) $tmpHostAck</h2>
        <a href='$Protocol://$ServerName/$hostSCRIPT?mode=1' class='redoneHost'>Critical ($sHostError)</a>
        <br><br><br>";
}



if ($smode eq 1){
print "
        <h2>Services ($srvTOT) $tmpAck</h2>
        <table class='fixed'>
         <col width='980px' />
         <tr> 
          <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=2' class='rednull'>CRITICAL ($ServiceError)</a></td>
         </tr>
        </table>
        <br><br><br><br>";
}


if ($smode eq 2){
print "
        <h2>Services ($srvTOT) $tmpAck</h2>
        <table class='fixed'>
         <col width='980px' />
        <tr> 
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=1' class='orangenull'>WARNING ($ServiceWarning)</a></td>
        </tr>
       </table>
       <br><br><br><br>";
}


if ($smode eq 3){
#one neighbour (warn/crit)
print "
        <h2>Services ($srvTOT) $tmpAck</h2>
        <table class='fixed'>
         <col width='640px' />
         <col width='320px' />
        <tr> 
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=1' class='orangeone'>Warning ($ServiceWarning)</a></td>
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=2' class='redtwo'>Critical ($ServiceError)</a></td>
        </tr>
       </table>
       <br><br><br><br>";
}



if ($smode eq 4){
#null neighbours - OK
print "
        <h2>Services ($srvTOT) $tmpAck</h2>
        <table class='fixed'>
         <col width='980px' />
        <tr> 
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=0' class='greennull'>OK ($ServiceOK$tmpAckPnt)</a></td>
        </tr>
       </table>
       <br><br><br><br>";
}

if ($smode eq 5){
#one neighbour (ok/warn)
print "
        <h2>Services ($srvTOT) $tmpAck</h2>
        <table class='fixed'>
         <col width='640px' />
         <col width='320px' />
        <tr> 
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=0' class='greenone'>OK ($ServiceOK$tmpAckPnt)</a></td>
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=2' class='redtwo'>Critical ($ServiceError)</a></td>
        </tr>
       </table>
       <br><br><br><br>";
}


if ($smode eq 6){
#one neighbours (crit)
print "
        <h2>Services ($srvTOT) $tmpAck</h2>
        <table class='fixed'>
         <col width='640px' />
         <col width='320px' />
        <tr> 
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=0' class='greenone'>OK ($ServiceOK$tmpAckPnt)</a></td>
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=1' class='orangetwo'>Warning ($ServiceWarning)</a></td>
        </tr>
       </table>
       <br><br><br><br>";
}


#two neighbours
if ($smode eq 7){
print "
        <h2>Services ($srvTOT) $tmpAck</h2>
        <table class='fixed'>
          <col width='320px' />
          <col width='320px' />
          <col width='320px' />
        <tr> 
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=0' class='greentwo'>OK ($ServiceOK$tmpAckPnt)</a></td>
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=1' class='orangetwo'>Warning ($ServiceWarning)</a></td>
         <td><a href='$Protocol://$ServerName/$serviceSCRIPT?mode=2' class='redtwo'>Critcal ($ServiceError)</a></td>
        </tr>
       </table>
       <br><br><br><br>";
}



print "
      </div>
      <br>
      <div class='refresh_description'>
       <a href='$Protocol://$ServerName$URI' class='greyrefresh'>Refresh</a><br><br><br><br>
      </div>";
 }   #if (($cEnabled{$ident}) and (!$csName))       
#print "$Cookie    	$csName 	$csExpire <br>\n";      
print "      
     </div>
    </div>
   </div>
  </div> 
 </body>
</html>
";

####
#END
####







sub getServiceData {
 my %json_data = (
         attrs => ['name', 'state', 'last_check_result','acknowledgement'],
         joins => ['host.name', 'host.state', 'host.last_check_result','service.acknowledgement'],
         filter => 'match("*", service.state) && (!service.vars.is_ignore)',
         
 );
 #Playing ...
 #joins => ['host.name', 'host.state', 'host.last_check_result','host.acknowledgement','service.acknowledgement'],
 #       filter => 'match("4", service.state) || match("4", service.state) || match("1", host.state) || match("2", host.state)',
 #sample: filter => 'match("0", service.state)',
 #sample: filter => 'match("*", service.name)',
 
 my $data = encode_json(\%json_data);
 
 ###############################################
 $client->POST("/v1/objects/services", $data);
 ###############################################
 my $status = $client->responseCode();
 #print "Debug Status: " . $status . "\n";
 my $response = $client->responseContent();
 if ($status == 200) {
  my $VAR1=decode_json($response);
  #print "==***====>  Result: " . Dumper($VAR1) . "\n";
  my $cnt;
  for my $v (@{$VAR1->{results}}){
   $restHost=undef;
   $restStatus=undef;
   $restName=undef;
   $restOutput=undef;
   $restAcknowledgement=undef;
   for my $w (keys (%{$v})){ 
    if ($w eq 'attrs'){
     $restStatus=$v->{$w}->{'state'}; 
     $restName=$v->{$w}->{'name'};  
     $restOutput=$v->{$w}->{'last_check_result'}->{'output'}; 
     $restLastExecute=$v->{$w}->{'last_check_result'}->{'execution_start'}; 
     if ($restStatus) {
      $restAcknowledgement=$v->{$w}->{'acknowledgement'};
     } 
     #print "==>> ResultSTATE: " . Dumper($v->{$w}) . " <=>$restStatus<=> -- $restName -- $w\n";	
    } 
    if ($w eq 'joins'){
      $restHost=$v->{$w}->{'host'}->{'name'};  #Sample of holding our STATE!
    }
    
    if (($restHost) and ($restStatus) ){
     my $tldate = strftime("%Y-%m-%d %H:%M:%S", localtime($restLastExecute));  
     #print "State error $restStatus -- $restHost -- $restName -- $restOutput -- $restAcknowledgement --$tldate\n";
     $hServiceAcknowledgement{"$restHost||$restName"}=$restOutput;
     $hServiceProblemStatus{"$restHost||$restName"}=$restStatus;
   
     if ($restStatus eq 1){
      if ($restAcknowledgement) {
       $hServiceProblemStatusWarningAck{"$restHost||$restName"}=$restStatus;
      } else {		
       $hServiceProblemStatusWarning{"$restHost||$restName"}=$restStatus;
      }
     } 
   
     if ($restStatus eq 2){
      if ($restAcknowledgement) {
       $hServiceProblemStatusErrorAck{"$restHost||$restName"}=$restStatus;
      } else {
       $hServiceProblemStatusError{"$restHost||$restName"}=$restStatus;
      } 
     } 
    	
     if ($restStatus eq 3){
      $hServiceProblemStatusUnknown{"$restHost||$restName"}=$restStatus;
     } 
    	
     $hServiceProblemOutput{"$restHost||$restName"}=$restOutput;
     $hServiceProblemLastExecute{"$restHost||$restName"}=$restLastExecute;
     $restHost=undef;
     $restStatus=undef;
     $restName=undef;
     $restOutput=undef;
     $restAcknowledgement=undef;
     $restLastExecute=undef;
    } else {
     if (($restHost) and ($restName)){ 
      $cnt++;
      #print "$cnt OK $restHost $restName $restOutput\n";
      $hServiceOKOutput{"$restHost||$restName"}=$restOutput;
      $hServiceOKLastExecute{"$restHost||$restName"}=$restLastExecute;
     }       #if (($restHost) and ($restName))
    }        #if (($restHost) and ($restStatus) )
   }         #if ($w eq 'attrs')
  }          #for my $v (@{$VAR1->{results}})
 } else {    #if ($status == 200) 
  print "Error: " . $response . "\n";
 }           #if ($status == 200) 
 
 
 my $TmpServiceOK=keys %hServiceOKOutput;
 my $TmpServiceWarning=keys %hServiceProblemStatusWarning;
 my $TmpServiceWarningAck=keys %hServiceProblemStatusWarningAck;
 my $TmpServiceErrorAck=keys %hServiceProblemStatusErrorAck;
 my $TmpServiceError=keys %hServiceProblemStatusError;
 my $TmpServiceUnknown=keys %hServiceProblemStatusUnknown;
 #print "$TmpServiceOK,$TmpServiceWarning,$TmpServiceError,$TmpServiceUnknown";
 return ($TmpServiceOK,$TmpServiceWarning,$TmpServiceError,$TmpServiceUnknown,$TmpServiceWarningAck,$TmpServiceErrorAck);
}   #SUB






sub getHostData {
 my %json_data = (
  attrs => ['name', 'state', 'last_check_result','acknowledgement'],
  joins => ['host.name', 'host.state', 'host.last_check_result','host.acknowledgement'],
  filter => 'match("*", host.state) && (!host.vars.is_ignore)',
 );
 
 #       filter => 'match("4", service.state) || match("4", service.state) || match("1", host.state) || match("2", host.state)',
 #sample: filter => 'match("0", service.state)',
 #sample: filter => 'match("*", service.name)',
 
 my $data = encode_json(\%json_data);
 
 ###############################################
 $client->POST("/v1/objects/hosts", $data);
 ###############################################
 my $status = $client->responseCode();
 #print "Status: " . $status . "\n";
 my $response = $client->responseContent();
 if ($status == 200) {
  my $VAR1=decode_json($response);
  #print "Result: " . Dumper($VAR1) . "\n";
  #See: http://wiki.intern/index.php/Perl_hacks#Hash
  for my $v (@{$VAR1->{results}}){
   $restStatus=undef;
   $restHost=undef;
   $restOutput=undef;
   $restAcknowledgement=undef;
   for my $w (keys (%{$v})){ ###Get the element as HASH ref and print 
    if ($w eq 'attrs'){
     $restStatus=$v->{$w}->{'state'}; 
     $restHost=$v->{$w}->{'name'};  
     $restAcknowledgement=$v->{$w}->{'acknowledgement'};  
     $restOutput=$v->{$w}->{'last_check_result'}->{'output'};  #Sample of holding our STATE!
     $restLastExecute=$v->{$w}->{'last_check_result'}->{'execution_start'}; 
    }     #if ($w eq 'attrs')
    if (($restHost) and ($restStatus) ){
     #print "State error $restStatus -- -- $restHost -- $restOutput\n";
     if ($restAcknowledgement) {
      $hHostAcknowledgement{$restHost}=$restAcknowledgement;	
     } else {
      $hHostProblemStatusError{$restHost}=$restOutput;
      $hHostLastExecute{$restHost}=$restLastExecute;
     }
     #***$restAcknowledgement
     $restHost=undef;
     $restStatus=undef;
     $restHost=undef;
     $restOutput=undef;
    } else {       #if (($restHost) and ($restStatus) )
     if ( ($restHost)){ 
      #print "OK  $restHost - $restOutput - $restLastExecute\n";
      $hHostOKOutput{$restHost}=$restOutput;
      $hHostLastExecute{$restHost}=$restLastExecute;
     }	           #if ( ($restHost))
    }              #if (($restHost) and ($restStatus) )
   }               #for my $w (keys (%{$v})) ###Get the element as HASH ref and print 
  }                #for my $v (@{$VAR1->{results}})
 } else {          #if ($status == 200) 
  #print "Error: " . $response . "\n";
 }                 #if ($status == 200) 

 my $TmpHostOK=keys %hHostOKOutput;
 my $TmpHostError=keys %hHostProblemStatusError;
 my $TmpHostAck=keys %hHostAcknowledgement;
 #print "$TmpHostOK,$TmpHosteError\n";
 return ($TmpHostOK,$TmpHostError,$TmpHostAck);

}                  #SUB  


sub ReadMyConfig {
   my $tcnt;
   my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
   my $data = $xml->XMLin("$Configfile");
   $request_host=$data->{System}->{IcingaHost};
   $userpass=$data->{System}->{Password};
   $cookieauthentication=$data->{System}->{CookieAuthentication};
   $contact=$data->{System}->{Contact};
   
   my $data = $xml->XMLin("$Configfile",ForceArray => 1);	
   if ($cookieauthentication eq "1" ) {
    for( @{$data->{Authentication}} ){
     $tcnt++;
     $cEnabled{$tcnt}=$_->{Enabled};
     $cCookieID{$tcnt}=$_->{CookieID};
     $cName{$tcnt}=$_->{Name};
     $cExpire{$tcnt}=$_->{Expire};
    }
   } 
}
	
	