#!/usr/bin/perl

#All source code, binaries, documentation, and information contained
#in this distribution are provided AS IS with NO WARRANTY OF ANY KIND,
#INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY, AND FITNESS FOR
#A PARTICULAR PURPOSE. 

#i2Mobile - Dump session environmend
#See the documentation at: http://coolscript.org/index.php/I2Mobile

use strict;
use POSIX;
use CGI;
use XML::Simple;
use HTTP::Date qw/str2time/;  


#CGI related init
my $cgi = new CGI; 
my ($ack,$key,%input,$curid,$curidvalid,$Protocol);
my $ServerName=$ENV{'SERVER_NAME'};
my $SSL=$ENV{'HTTPS'};
my $USER=$ENV{'REMOTE_USER'};
my $URI=$ENV{'REQUEST_URI'};
my ($Configfile,$request_host,$userpass,$cookieauthentication,%cEnabled,%cCookieID,%cName,%cEMail,%cExpire,$contact,$csEMail,$Cookierequired); #User access data

$Configfile='/etc/i2mobile.xml';
###############
&ReadMyConfig;
###############


#Authentication:
my ($query,$Cookie,$csName,$csExpire);
if ($cookieauthentication eq "1"){ #Cookie Authentication is set!
 $query = new CGI;
 $Cookie = $query->cookie('i2Mobile');
 for my $ident ( sort keys %cCookieID ) {	
  if ($cEnabled{$ident}){
   if ($cCookieID{$ident} eq $Cookie){  #Found valid cookie
    $csName=$cName{$ident};
    $csExpire=$cExpire{$ident};
    $csEMail=$cEMail{$ident};
   } 
  }	
 } 
}
if ($cookieauthentication eq "1"){
 $Cookierequired="Yes";
} else {
 $Cookierequired="No";	
} 

if ($SSL eq "on"){
	$Protocol="https";
}	else {
	$Protocol="http";
}

my $tldate = strftime("%a %d %b %Y - %H:%M:%S", localtime(time));
if (!$curidvalid)   {
 print "Content-type: text/html\n\n";
} 
print '
<!DOCTYPE HTML PUBLIC>
<html>
 <head>
  <title>i2Mobile</title>
   <link type="text/css" rel="stylesheet" href="'.$Protocol.'://'.$ServerName.'/css/ibase.css">
   <meta name="resource-type" content="document">
   <meta http-equiv="pragma" content="no-cache">
   <meta name="revisit-after" content="15">
   <meta name="classification" content="System Administartion">
   <meta name="description" content="icinga2 Mobile">
   <meta name="keywords" content="icinga2">
   <meta name="robots" CONTENT="nofollow">
   <meta name="distribution" content="Global">
   <meta name="rating" content="General">
   <meta name="language" content="en">
   <meta name="doc-type" content="Public">
   <meta name="doc-class" content="Completed">
   <meta name="doc-rights" content="Private"> 
 <style>
    table {
     border-collapse: collapse;
     table-layout:fixed;
     width:910px; 
    }
    th, td {
     text-align: left;
     padding: 8px;
     font-family:Arial;
     font-size:40px;
     color:#777777;
     overflow: hidden;
    }
    tr:nth-child(even){background-color: #f2f2f2}
   .td_size {    
    width:200px; 
    height:50px;
    max-width:200px;
    min-width:100px; 
    max-height:50px; 
    min-height:50px;
   }
   </style>   <body>
    <div id="main">
     <div id="main" style="text-align: left;">
      <div id="wrapper" class="shadow">
       <div id="header"></div>   
        <div id="header-top-bar"> 
         <h1 id="header-text">i2Mobile</h1> 
        </div>   
        <div class="about_description">
        <h3>'.$tldate.'</h3>

       <table>

       <tr>
       <td>Cookie required:</td>
       <td>'.$Cookierequired.'</td>
       </tr>
       
       <tr>
       <td>Cookie:</td>
       <td>'.$Cookie.'</td>
       </tr>

       <tr>
       <td>Expire:</td>
       <td>'.$csExpire.'</td>
       </tr>

       <tr>
       <td>Name:</td>
       <td>'.$csName.'</td>
       </tr>

       <tr>
       <td>EMail:</td>
       <td>'.$csEMail.'</td>
       </tr>
       

';


for my $code ( sort keys %ENV ){
print '
       <tr>
       <td>'.$code.':</td>
       <td>'.$ENV{$code}.'</td>
       </tr>';
 
}


print "      
      </table>
     </div>
    </div>
   </div>
  </div> 
 </body>
</html>
";

####
#END
####



sub ReadMyConfig {
   my $tcnt;
   my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
   my $data = $xml->XMLin("$Configfile");
   $request_host=$data->{System}->{IcingaHost};
   $userpass=$data->{System}->{Password};
   $cookieauthentication=$data->{System}->{CookieAuthentication};
   $contact=$data->{System}->{Contact};
   my $data = $xml->XMLin("$Configfile",ForceArray => 1);	
   #if ($cookieauthentication eq "1" ) {
    for( @{$data->{Authentication}} ){
     $tcnt++;
     $cEnabled{$tcnt}=$_->{Enabled};
     $cCookieID{$tcnt}=$_->{CookieID};
     $cName{$tcnt}=$_->{Name};
     $cEMail{$tcnt}=$_->{MailTo};
     $cExpire{$tcnt}=$_->{Expire};
    }
   #} 
}
	
	
	
	 
 
