#!/usr/bin/perl

use strict;
use Data::GUID;  #libdata-guid-perl
use XML::Writer;
use IO::File;
use XML::Simple;
my $guid = Data::GUID->new;
my $guidstring = $guid->as_string; # or "$guid"
#print "$guidstring\n";

my ($Configfile,$request_host,$userpass,$cookieauthentication,%cEnabled,%cCookieID,%cName,%cExpire,$contact,%cMailTo,$tcnt,$url); #User access data
$Configfile='/etc/i2mobile.xml';
my $Cookiepage="setsessioncookie.pl";
###############
&ReadMyConfig;
###############


print "Enter a name to be used with the session cookie: ";
my $nName= readline(*STDIN);  
$nName =~ s/\R//g;

print "Enter the email for this user: ";
my $nMailto= readline(*STDIN);  
$nMailto =~ s/\R//g;

print "Enter the expire date (yyyymmdd): ";
my $nExpire= readline(*STDIN);  
$nExpire =~ s/\R//g;

$tcnt++;
$cEnabled{$tcnt}=1;
$cCookieID{$tcnt}=$guidstring;
$cName{$tcnt}=$nName;
$cExpire{$tcnt}=$nExpire;
$cMailTo{$tcnt}=$nMailto;


print "\nPlease forward this link to your client: $url/$Cookiepage?id=$guidstring\n\n";

#Dump records
#for my $ident ( sort keys %cCookieID ) {	
# print "$cEnabled{$ident}\n";
# print "$cCookieID{$ident}\n";
# print "$cName{$ident}\n";
# print "$cExpire{$ident}\n";
# print "$cMailTo{$ident}\n";
#}	





###############
&WriteMyConfig;
###############



sub WriteMyConfig {
 my $output = IO::File->new(">/etc/i2mobile.xml");
 my $writer = XML::Writer->new(
   OUTPUT      => $output,
   DATA_MODE   => 1,
   DATA_INDENT => 1
 );
 $writer->xmlDecl('UTF-8');
 $writer->startTag('CONFIG');


 $writer->startTag('INFO','Text' => 'This file has been edited by ' . $0 );
 $writer->endTag('INFO');
 $writer->startTag('System', 
  'IcingaHost' => $request_host, 
  'Password' => $userpass, 
  'CookieAuthentication' => $cookieauthentication, 
  'Contact' => $contact, 
  'URL' => $url, 
  
  );
 $writer->endTag('System');
 
 for my $ident ( sort keys %cCookieID ) {	
 	$writer->startTag('Authentication', 
 	 'Enabled' => $cEnabled{$ident}, 
 	 'CookieID' => $cCookieID{$ident}, 
 	 'Name' => $cName{$ident}, 
 	 'MailTo' => $cMailTo{$ident}, 
 	 'Expire' => $cExpire{$ident}, 
 	);
  $writer->endTag('Authentication');	
 }
 $writer->endTag('CONFIG');
 $writer->end();
 $output->close();
}



sub ReadMyConfig {
	 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
   my $data = $xml->XMLin("$Configfile");
   $request_host=$data->{System}->{IcingaHost};
   $userpass=$data->{System}->{Password};
   $cookieauthentication=$data->{System}->{CookieAuthentication};
   $contact=$data->{System}->{Contact};
   $url=$data->{System}->{URL};
   
   my $data = $xml->XMLin("$Configfile",ForceArray => 1);	
   #if ($cookieauthentication eq "1" ) {
    for( @{$data->{Authentication}} ){
     $tcnt++;
     $cEnabled{$tcnt}=$_->{Enabled};
     $cCookieID{$tcnt}=$_->{CookieID};
     $cName{$tcnt}=$_->{Name};
     $cExpire{$tcnt}=$_->{Expire};
     $cMailTo{$tcnt}=$_->{MailTo};
    }
   #} 
   
   
}
	
