#!/usr/bin/perl
#This the the GeoMailSearch Updater
#See: http://coolscript.org/index.php/GeoMailSearch

use strict;
use warnings;
use POSIX;
use DBI;
use IO::Uncompress::Unzip qw(unzip $UnzipError);
use XML::Simple;     
use LWP::Simple;
use IO::Uncompress::Gunzip qw(gunzip $GunzipError) ;
use File::Basename;
use Cwd;
use Net::Syslog;
use File::Find;

my ($HttpIPList,$HttpASNList,$HttpCityList,$HttpIPLoad,$HttpASNLoad,$HttpCityLoad,@csvdata,$CSVIPList,$FileCity,$myDownload,$DeleteTempDataOnStartup,$DeleteTempDataOnExit);
my ($FCBlc,$FCLoc,$FASN,$FCityPath,$GeoServer,$GeoDatabase,$GeoUser,$GeoPassword,$dbh,$dbtest,$strglobal,$SyslogIP,$duration,@delfiles);
my $Conffile = "gms-loader.xml";
my $verbose=1;    #Be verbose with console printing
my $startuptime = time;
my $cwd = cwd;
if ($cwd !~ /^\/$/){
 mkdir $cwd . "/download";
 $myDownload="$cwd/download/";
 #mkdir cwd . "/data";
} else {
 print "EXIT: Do not run me in the root filesystem\n";	
 exit;
} 




&ReadConfig;   #=> Read my XML Config
syslog("****   STARTING GMS-LOADER   ****"); 
if ($DeleteTempDataOnStartup eq 1){
 &DeleteGeoFiles($myDownload);
}
$dbh = DBI->connect("DBI:mysql:$GeoDatabase:$GeoServer:3306",$GeoUser,$GeoPassword,{PrintError => 0}); 
if ($dbh) {
  syslog("CHECK OK - Success with DB Conection to $GeoDatabase:$GeoServer");
  $dbtest=1;
} else {
	syslog("CHECK FAIL - Failed DB Conection to $GeoDatabase:$GeoServer");
	exit;
}
 



if ($dbtest) {
 &GetHTTPData;  #=> Download and uncompress data
}






if ($FCBlc) {
 syslog("Maintain: $FCBlc");
 if ($FCLoc) {  #Need both files !!
	syslog("Maintain: $FCLoc");
 
  &processGeoCity($FCLoc);
  &processGeoCityBlocks($FCBlc);
 
 }	 #if ($FCLoc) 
}    #if ($FCBlc) 




if ($FASN) {
 syslog("Maintain: $FASN");
 &processASN($FASN);
}


if ($FCityPath){
	syslog("Maintain: $FCityPath");
	&processCities($FCityPath);
}	


syslog("Finished: $strglobal");
#Write upploader statis to sql
$duration = time - $startuptime;
my $tldate = strftime("%Y-%m-%d %H:%M:%S", localtime(time));
#$sqlstr="insert into $GeoDatabase.tblUpdate (Date,Description) values ('".$tldate."',"Update complete - Duration: $duration - $strglobal)";
my $sqlstr="insert into $GeoDatabase.tblUpdate (Date,Description) values ('$tldate','Update complete - Duration: $duration - $strglobal')";

my $sqlret  = $dbh->do($sqlstr);
if (! $sqlret) {
	syslog("Insert Fail\n$sqlstr");
}

if ($DeleteTempDataOnExit eq 1){
 &DeleteGeoFiles($myDownload);
}



#############
#  FINISHED #
#############

sub subGMSUnzip {
	my $tmpName;
	my $tmpPath;
	my $tfcnt;
	my $zipfile = $_[0];
	syslog("ZIP File: $zipfile");
  my $u = new IO::Uncompress::Unzip $zipfile
    or die "Cannot open $zipfile: $UnzipError";

  die "Zipfile has no members"
   if ! defined $u->getHeaderInfo;

  for (my $status = 1; $status > 0; $status = $u->nextStream) {
  	$tfcnt++;
    my $name = $u->getHeaderInfo->{Name};
    warn "Processing member $name\n" ;
    $tmpName=$name;
    if ($name =~ /\/$/) {
       mkdir $name;  #may never applied
    } else {
     if ($name =~ /(.*)\/(.*)/) {
        $tmpPath=$1;
        $tmpName=$2;
        #mkdir $tmpPath;
        mkdir $myDownload.$tmpPath;
        syslog("MKDIR: $myDownload => $tmpPath");
        syslog("Name: $tmpName");
     }
    	syslog("unzip ($status) : $myDownload$name");
    	
    	push(@csvdata,"$myDownload$name");  #not needed yet ..
      #unzip $zipfile => "<$myDownload$name/#1.txt>"
      #unzip $zipfile => $name, Name =>  $name
      # or die "unzip failed: $UnzipError\n";
      #unzip $zipfile => $name ;
      #my $output = "$myDownload$name";
      ##########################################################
      unzip $zipfile => ($myDownload.$name), Name =>  $name ;
      ##########################################################
      #unzip $zipfile => $output
      # or die "unzip failed: $UnzipError\n";
      if ($tfcnt >= 2) {  #Workaround
       last;
      } 
    }
   }
   return $tmpPath;
}	 #sub

 
 sub subGMSGUnzip {
    my $input = $_[0];
    my $output = $_[1];
    print "xxx   $input - $output\n";
    gunzip $input => $output
    or die "gunzip failed: $GunzipError\n";
 } 
 
sub subGetHTTPFile {
 #HTTP Get $_[0] and save it to $_[1]
 my $url = $_[0];
 my $file = $_[1];
 
 
 getstore($url, $file);
 print "Save $url, $file\n";
	
}

sub ReadConfig {
 #######################################
 #Read My XML Config given in $Conffile
 #######################################
 #Getting arrays first ....
 #my $data = eval {XMLin($Conffile,ForceArray => 1)};

 #Getting the setup (non array)
 my $xml = new XML::Simple (KeyAttr=>[]); 
 my $data = $xml->XMLin("$Conffile");
 $HttpIPList=$data->{HTTP_Download}->{IPLIST};
 $HttpASNList=$data->{HTTP_Download}->{ASNLIST};
 $HttpCityList=$data->{HTTP_Download}->{CITYLIST};



 $HttpIPLoad=$data->{HTTP_Maintain}->{IPLIST};
 $HttpASNLoad=$data->{HTTP_Maintain}->{ASNLIST};
 $HttpCityLoad=$data->{HTTP_Maintain}->{CITYLIST};


 $GeoServer=$data->{GeoDatabase}->{Server};
 $GeoDatabase=$data->{GeoDatabase}->{Database};
 $GeoServer=$data->{GeoDatabase}->{Server};
 $GeoUser=$data->{GeoDatabase}->{Username};
 $GeoPassword=$data->{GeoDatabase}->{Password};


 $SyslogIP=$data->{System}->{SyslogIP};
 $DeleteTempDataOnStartup=$data->{System}->{DeleteTempDataOnStartup};
 $DeleteTempDataOnExit=$data->{System}->{DeleteTempDataOnExit};

}



sub syslog {
	
 if ($verbose){
	print "$_[0]\n"; 	
 }		
	
	
 if ($SyslogIP =~ /(\d+)\.(\d+)\.(\d+)\.(\d+)/){
 	my $s; 
  $s=new Net::Syslog(Facility=>'local4',Priority=>'debug',SyslogHost=>$SyslogIP);
  $s->send(" gms-loader " . $_[0],Priority=>'info');
 } 

	
} #SUB



sub GetHTTPData {
 #syslog("$HttpIPLoad,$HttpASNLoad,$HttpCityLoad");
 #syslog("$HttpIPList");
 #syslog("$HttpASNList");
 #syslog("$HttpCityList");
 #Get Blocks and locations and unextract
 


 if ($HttpIPLoad eq 1){
  &subGetHTTPFile($HttpIPList,"$myDownload/HTTPIPLIST.zip");
  $CSVIPList=subGMSUnzip("$myDownload/HTTPIPLIST.zip");
  syslog("PATH  $myDownload/$CSVIPList/GeoLiteCity-Location.csv");
  syslog("PATH  $myDownload/$CSVIPList/GeoLiteCity-Blocks.csv");
  
  if (-e "$myDownload/$CSVIPList/GeoLiteCity-Blocks.csv") {
   $FCBlc="$myDownload/$CSVIPList/GeoLiteCity-Blocks.csv";
   #syslog("OK oo1");
  }


  if (-e "$myDownload/$CSVIPList/GeoLiteCity-Location.csv") {
   $FCLoc="$myDownload/$CSVIPList/GeoLiteCity-Location.csv";
   #syslog("OK oo1");
  }


  
 } else {
	syslog("Skip Loading: $HttpIPList");
 } 
 #Get ASN and unextract
 if ($HttpASNLoad eq 1){
  &subGetHTTPFile($HttpASNList,"$myDownload/HTTPASNLIST.zip");
  $CSVIPList=subGMSUnzip("$myDownload/HTTPASNLIST.zip");
  
  if (-e "$myDownload/GeoIPASNum2.csv") {
   $FASN="$myDownload/GeoIPASNum2.csv";
   #syslog("OK ASN $FASN");
  }
  
 } else {
  syslog("Skip Loading: $HttpASNList");	
 } 
 #Get WorldCity
 if ($HttpCityLoad eq 1){
  &subGetHTTPFile("$HttpCityList","$myDownload/worldcitiespop.txt.gz");
  $FileCity = fileparse("$HttpCityList", ".gz");  #GetBaseName
  &subGMSGUnzip("$myDownload$FileCity.gz","$myDownload$FileCity");
  
  if (-e "$myDownload/worldcitiespop.txt") {
   $FCityPath="$myDownload/worldcitiespop.txt";
   #syslog("OK $FCityPath");
  }

  
  
 } else {
  syslog("Skip Loading: $myDownload/$HttpCityList");	
 } 
}   #SUB





sub processGeoCity {
 #SQL Process of CityLocation
 my ($tacnt,$tcnt,$tfcnt,@lvals,$curscalar,$cntCities,$sqlstr,$sqlret,$sql);
 my ($CNTlocId,$CNTcountry,$CNTregion,$CNTcity,$CNTlatitude,$CNTlongitude,$CNTmetroCode,$CNTareaCode);
 syslog("PROCESS: $_[0]");	
 my $FileLoc=$_[0];
 $tfcnt=0;
 open (FH, "<$FileLoc") or die "no such file"; 
 syslog ("Open: $FileLoc");

 $sqlstr="truncate table  $GeoDatabase.CityLocation";
 $sql = $dbh->prepare($sqlstr);  
 $sql->execute;

 while (<FH>){
  chomp;
  #syslog("$_");
  $sqlstr=undef;
  if (/^locid,/i){  #Automatic assign the field description, protect against field changes
   #CSV Mapping
   #locId,country,region,city,postalCode,latitude,longitude,metroCode,areaCode
   @lvals=split(",",$_);    
   foreach (@lvals) {
    #syslog("===>> $_");
    $tcnt++;	
    if (/locId/i) {$CNTlocId=$tcnt-1;} 
    if (/country/i){$CNTcountry=$tcnt-1;}
    if (/region/i){$CNTregion=$tcnt-1;}
    if (/city/i){$CNTcity=$tcnt-1;}
    if (/latitude/i){$CNTlatitude=$tcnt-1;}
    if (/longitude/i){$CNTlongitude=$tcnt-1;}
    if (/metroCode/i){$CNTmetroCode=$tcnt-1;}
    if (/areaCode/i){$CNTareaCode=$tcnt-1;}
   }
   #print " => $CNTlocId,$CNTcountry,$CNTregion,$CNTcity,$CNTlatitude,$CNTlongitude\n";
  }  #if (/^locid,/i)  #Field description
  s/\"//g;
  s/\'//g;
  s/\;//g;
  @lvals=split(",",$_);    
  $curscalar= scalar @lvals . "\n";
  if ($curscalar >= 7){
 	 $cntCities++;
   $sqlstr="insert into $GeoDatabase.CityLocation (locID,Country,City,Region,Latitude,Longitude,metroCode,areaCode) values ("; 	
   $sqlstr.="'$lvals[$CNTlocId]',";
   $sqlstr.="'$lvals[$CNTcountry]',";
   $sqlstr.="'$lvals[$CNTcity]',";
   $sqlstr.="'$lvals[$CNTregion]',";
   $sqlstr.="$lvals[$CNTlatitude],";
   $sqlstr.="$lvals[$CNTlongitude],";
   if ($lvals[$CNTmetroCode]){
    $sqlstr.="'$lvals[$CNTmetroCode]',";
   } else {
   	$sqlstr.="'',";
   } 
   if ($lvals[$CNTareaCode]){
    $sqlstr.="'$lvals[$CNTareaCode]')";
   } else {
    $sqlstr.="'')";
   } 
  }
  if ($sqlstr) {
   my $sqlret  = $dbh->do($sqlstr);
   if (! $sqlret) {
  	syslog("Insert Fail\n$sqlstr");
  	syslog("\t$cntCities $_");
    $tfcnt++;	
   }
   $tacnt++;	
   #syslog ("AddRecord: $sqlstr");
  } 
 }  #while
 $strglobal.=" - CityLocation - Records: $tacnt / Failed: $tfcnt";
 syslog("Finished adding $GeoDatabase.CityLocation - Records: $tacnt / Failed: $tfcnt");
}   #Sub




sub processGeoCityBlocks {
 #SQL Process City Blocks
 my ($idcnt,$tcnt,@lvals,$sqlstr,$sql,$CNTstartIp,$CNTendIpNum,$CNTlocId,$curscalar,$tffcnt,$taacnt);
 syslog("PROCESS: $_[0]");	
 my $FileBlocks=$_[0];
 $tffcnt=0;
 open (FH, "<$FileBlocks") or die "no such file"; 
 
 
 $sqlstr="truncate table  $GeoDatabase.CityBlocks";
 $sql = $dbh->prepare($sqlstr);  
 $sql->execute;

 
 while (<FH>){
  chomp;
  #print "$_ \n";
  #GLOBAL REPLACE!!!!
  s/\"//g;

  $sqlstr=undef;
  if (/^startIpNum,/i){  #Automatic assign the field description, protect against field changes
   #CSV Mapping
   #startIpNum,endIpNum,locId
   @lvals=split(",",$_);    
   foreach (@lvals) {
    #syslog("===>> $_");
    $tcnt++;	
    if (/startIp/i) {$CNTstartIp=$tcnt-1;} 
    if (/endIpNum/i){$CNTendIpNum=$tcnt-1;}
    if (/locId/i){$CNTlocId=$tcnt-1;}
   }
   #print "$CNTstartIp,$CNTendIpNum,$CNTlocId\n";
  }  #if (/^locid,/i)  #Field description

  @lvals=split(",",$_);    
  $curscalar= scalar @lvals . "\n";
  if ($curscalar >= 3){
   $idcnt++;
   $sqlstr="insert into $GeoDatabase.CityBlocks (ID,startIpNum,endIpNum,locId) values ("; 	
   $sqlstr.="$idcnt,";
   $sqlstr.="'$lvals[$CNTstartIp]',";
   $sqlstr.="'$lvals[$CNTendIpNum]',";
   $sqlstr.="'$lvals[$CNTlocId]');";

   #print "$sqlstr\n";
   
   
   if ($sqlstr) {
    my $sqlret  = $dbh->do($sqlstr);
    if (! $sqlret) {
  	 syslog("Insert Fail\n$sqlstr");
  	 syslog("\t $_");
     $tffcnt++;	
    }
    $taacnt++;	
    #syslog ("AddRecord: $sqlstr");
   } 
  }   #if ($curscalar >= 3){
 }  #while (<FH>)
 $strglobal.=" - CityBlocks - Records: $taacnt / Failed: $tffcnt";
 syslog("Finished adding $GeoDatabase.CityBlocks - Records: $taacnt / Failed: $tffcnt");


}   #SUB




sub processASN {
 #SQL Process ASN
 my ($taffcnt,$curscalar,@lvals,$cntASN,$cntBlock,$startIpNum,$endIpNum,$ASNumber,$ASName,$sqlstr,$taaacnt,$sql);
 syslog("PROCESS: $_[0]");	
 my $FileASN=$_[0];
 $taffcnt=0;
 open (FH, "<$FileASN") or die "no such file"; 


 $sqlstr="truncate table  $GeoDatabase.ASNumber";
 $sql = $dbh->prepare($sqlstr);  
 $sql->execute;



 while (<FH>){
  chomp;
  #GLOBAL REPLACE!!!!
  s/\"//g;
  @lvals=split(",",$_);    
  $curscalar= scalar @lvals . "\n";
  if ($curscalar >= 3){
   $cntASN++;
   $cntBlock++;
   #Beter do a reset first ...
   $startIpNum=$lvals[0];
   $endIpNum=$lvals[1];
   if ($lvals[2] =~ /(\w+)\s{1}(.*)$/){
    $ASNumber=$1;
    $ASName=$2;
    $ASName=substr($ASName,0,127);
    $ASName=~s/\'/-/g;            #No leading spaces  #1.0.62
   }
   #print " $cntBlock $startIpNum $endIpNum $locId\n";
   #$cntBlock,$startIpNum,$endIpNum,$locId
   $sqlstr="insert into $GeoDatabase.ASNumber (ID,startIpNum,endIpNum,ASNumber,ASName) values ("; 	
 	 $sqlstr.="$cntBlock,";
   $sqlstr.="$startIpNum,";
   $sqlstr.="$endIpNum,";
   $sqlstr.="'$ASNumber',";
   $sqlstr.="'$ASName');";
   #print "$sqlstr\n";
   my $sqlret  = $dbh->do($sqlstr);
   if (! $sqlret) {
  	syslog("Insert Fail\n$sqlstr");
  	$taffcnt++;
   } else {
    $taaacnt++;
   }
   #print "AddRecord: $cntBlock\r";
  }  #if ($curscalar >= 3)
 }   #while
 $strglobal.=" - ASNumber - Records: $taaacnt / Failed: $taffcnt";
 syslog("Finished adding ASNumber - Records: $taaacnt / Failed: $taffcnt");
}    #Sub



sub processCities {
 #SQL Process Cities
 my ($tcffcnt,$sqlstr,$sql,@lvals,$cntCities,$sqlret,$curscalar,$tccnt);
 syslog("PROCESS: $_[0]");	
 my $FileCities=$_[0];
 $tcffcnt=0;
 open (FH, "<$FileCities") or die "no such file"; 



 $sqlstr="truncate table  $GeoDatabase.Cities";
 $sql = $dbh->prepare($sqlstr);  
 $sql->execute;

 while (<FH>){
  chomp;
  #print "$_\n";
  s/\"//g;
  s/\'//g;
  @lvals=split(",",$_);    
  $curscalar= scalar @lvals . "\n";
  if ($curscalar >= 7){
 	 $cntCities++;
   $sqlstr="insert into $GeoDatabase.Cities (Country,City,Region,Population,Latitude,Longitude) values ("; 	
   $sqlstr.="'$lvals[0]',";
   $sqlstr.="'$lvals[1]',";
   $sqlstr.="'$lvals[3]',";
  
   if ($lvals[4]){
    $sqlstr.="$lvals[4],";
   } else {
    $sqlstr.="0,";
   }
   $sqlstr.="$lvals[5],";
   $sqlstr.="$lvals[6])";
  
  }
 
  my $sqlret  = $dbh->do($sqlstr);
  if (! $sqlret) {
  	syslog ("Insert Fail\n$sqlstr");
  	$tcffcnt++;
  } else {
  	$tccnt++;
  }
  #print "AddRecord: $cntBlock\r";
 } #While
 $strglobal.=" - Cities - Records: $tccnt / Failed: $tcffcnt";
 syslog("Finished adding $GeoDatabase.Cities - Records: $tccnt / Failed: $tcffcnt");

} #Sub


sub DeleteGeoFiles {
 my $mytmpDownload = $_[0];
 if ($mytmpDownload =~ /^\/$/) {return undef}; #make sure we have not root set
 find(\&getRecursiveFiles, $mytmpDownload);
 foreach (@delfiles){  #Delete files first
  if (/(csv|zip|gz|geo|world)/i){  #security filter
   unlink ($_);
  } 
 }
 foreach (@delfiles){ #delete subdires
  if (/(csv|zip|gz|geo|world)/i){  #security filter
   if (-d $_) { 
	  rmdir ($_) || &syslog("Error deleting directory $_: $!");
   }
  } 
 }
}   #sub

sub getRecursiveFiles() {
 #Recursive scan	
 if ($_ ne ".") {
  push(@delfiles,$File::Find::name);
 }
}
