-- This script adds the geoip database used for GeoMailSearch
CREATE DATABASE IF NOT EXISTS geoip;
USE geoip;


DROP TABLE IF EXISTS `ASNumber`;
CREATE TABLE `ASNumber` (
  `ID` int(10) unsigned NOT NULL,
  `startIpNum` int(10) unsigned NOT NULL,
  `endIpnum` int(10) unsigned NOT NULL,
  `ASNumber` varchar(16) CHARACTER SET latin1 NOT NULL,
  `ASName` varchar(128) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `ASNumber` (`ASNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='GeoIPASNum2.csv';


DROP TABLE IF EXISTS `Cities`;
CREATE TABLE `Cities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Country` varchar(2) CHARACTER SET latin1 NOT NULL,
  `City` varchar(45) CHARACTER SET latin1 NOT NULL,
  `Region` varchar(2) CHARACTER SET latin1 NOT NULL,
  `Latitude` double NOT NULL,
  `Longitude` double NOT NULL,
  `population` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `LatLon` (`Latitude`,`Longitude`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='worldcitiespop.txt';


DROP TABLE IF EXISTS `CityBlocks`;
CREATE TABLE `CityBlocks` (
  `ID` int(10) unsigned NOT NULL,
  `startIpNum` int(10) unsigned NOT NULL,
  `endIpNum` int(10) unsigned NOT NULL,
  `locId` int(10) unsigned NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `StartEnd` (`startIpNum`,`endIpNum`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='GeoLiteCity-Blocks.csv';


DROP TABLE IF EXISTS `CityLocation`;
CREATE TABLE `CityLocation` (
  `locId` int(10) unsigned NOT NULL,
  `country` varchar(2) NOT NULL,
  `region` varchar(2) DEFAULT NULL,
  `city` varchar(64) DEFAULT NULL,
  `postalCode` varchar(12) DEFAULT NULL,
  `latitude` varchar(12) NOT NULL,
  `longitude` varchar(12) NOT NULL,
  `metroCode` varchar(3) DEFAULT NULL,
  `areaCode` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`locId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='GeoLiteCity-Location.csv';



DROP TABLE IF EXISTS `tblUpdate`;
CREATE TABLE `tblUpdate` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Date` varchar(45) DEFAULT NULL,
  `Description` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=100 DEFAULT CHARSET=utf8 COMMENT='Info Table about updates';


DROP TABLE IF EXISTS `CustomCityLocation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CustomCityLocation` (
  `IpNum` int(10) unsigned NOT NULL,
  `latitude` varchar(12) DEFAULT NULL,
  `longitude` varchar(12) DEFAULT NULL,
  `city` varchar(64) DEFAULT NULL,
  `region` varchar(12) DEFAULT NULL,
  `country` varchar(16) DEFAULT NULL,
  `hostname` varchar(64) DEFAULT NULL,
  `organization` varchar(64) DEFAULT NULL,
  `isp` varchar(64) DEFAULT NULL,
  `updateTime` int(11) DEFAULT NULL,
  PRIMARY KEY (`IpNum`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */; 