#GeoMailSearch for Spamassassin
#See: http://coolscript.org/index.php/GeoMailSearch

#Path: /usr/share/perl5/Mail/SpamAssassin/Plugin/
#
#Set the following in your config:
#/etc/spamassassin/local.cf
#loadplugin     Mail::SpamAssassin::Plugin::GeoMailSearch
#header         GeoMailSearch eval:check_geomailsearch()
##DB CONNECTION:
#geomailsearch_sql_database geoip
#geomailsearch_sql_server   127.0.0.1
#geomailsearch_sql_user     geo
#geomailsearch_sql_pwd      xxx
##BASIC SETTINGS
#geomailsearch_score  1.5
##geomailsearch_non_office_hours 20:00-07:00
##geomailsearch_non_business_day 1
#geomailsearch_score_country  AA:BB:CC

#Versions
#1.0.0  - First beta run, 10Feb2014
#1.0.1  - Add loglevel
#1.0.2  - Add more stuff to splunk 
#1.0.3  - Add getACity
#1.0.4  - Minor chnange for basic rules 13Feb2014


#Interesting
#http://spamassassin.apache.org/full/3.1.x/doc/Mail_SpamAssassin_Plugin.html
#http://wiki.apache.org/spamassassin/CustomPlugins
#http://comments.gmane.org/gmane.mail.spam.spamassassin.general/109871
#http://people.apache.org/~parker/presentations/SAPluginSlides.pdf
#http://www.heise.de/ix/foren/S-SpamAssassin-Plugin-fuer-Hash-Abfrage/forum-48292/msg-8047869/read/
#http://www.hostip.info/
#http://wiki.apache.org/spamassassin/PluginWritingTips

#Test me:
#perl /usr/share/perl5/Mail/SpamAssassin/Plugin/GeoMailSearch.pm

#Look also:
#less /tmp/geomailsearch.log
#less /var/log/mail.log

#Reload
#service spamassassin restart


#Begin
use strict;
package Mail::SpamAssassin::Plugin::GeoMailSearch;
use Mail::SpamAssassin::Plugin;
use Mail::SpamAssassin::Conf::Parser;
use POSIX;	
use DBI;
use HTTP::Date qw/str2time/;
use Math::Trig qw(deg2rad pi great_circle_distance);
#############################
#Required modules:
# cpan "install Net::Syslog"
############################# 
use Net::Syslog;

our @ISA = qw(Mail::SpamAssassin::Plugin);
sub dbg { Mail::SpamAssassin::dbg (@_); }

################################
#####  ATTENTION LOGGING  ######
################################
#Before you switch this on, please run eg:
#touch /tmp/geomailsearch.log
#chmod 666 /tmp/geomailsearch.log
#my $Debug=undef;


my @syslogip = qw(localhost);
#SWITCH ON SYSLOGFF FILE DEBUGGING!
my $Syslog =1;
#SWITCH OFF FILE DEBUGGING!
my $Debug=undef;

################################


###Global Vars###
my ($sql_user,$sql_pwd,$sql_server,$sql_db);
my ($geomailsearch_non_office_hours,@CountryTokens,@AdvancedCountryTokens,@AdvancedASNTokens,$ip_country,$ip_asn,$score,$perm_msg,$geomailsearch_non_business_day,$cscore,$llevel,$geomailsearch_syslog,$strsplunk);
my (%h_radius_score_lat,%h_radius_score_lon,%h_radius_score_radius,%h_radius_score_score,%h_radius_score_hour,@AdvancedRadiusTokens);
my (%h_advanced_block_country_score,%h_advanced_block_country_time,%h_advanced_block_asn_score,%h_advanced_block_asn_time,%h_tmp_advanced_block_country_code,@AdvancedCountryTokensSet,@AdvancedCountryASNSet);
my ($tmpCountry,$tmpASN,$tmpTimeRange,$tmpScore,$iptonum); 


# constructor: register the eval rule
sub new {
  my $class = shift;
  my $mailsaobject = shift;
  # some boilerplate...
  $class = ref($class) || $class;
  my $self = $class->SUPER::new($mailsaobject);
  bless ($self, $class);
  # the important bit!
  $self->register_eval_rule ("check_geomailsearch");
  #print "registered == Mail::SpamAssassin::Plugin::Test: $self\n";
  dbg ("Check GeoMailsearch!");
  $self->set_config($mailsaobject->{conf});
  return $self;
}


sub check_geomailsearch  {
 my ($self, $permsgstatus) = @_;
 syslog ("***START GeoMailSeearch (GMS)***");
 dbg ("Start");
 $score=0;   #Jan2014
 $strsplunk="";
 
 #Settings:
 $cscore =  $permsgstatus->{conf}->{geomailsearch_score}; 
 if ($permsgstatus->{conf}->{geomailsearch_syslog}){  #Be careful if this setting is set to false
  $llevel = $permsgstatus->{conf}->{geomailsearch_syslog}; 
 } 
 syslog ("Reading geomailsearch_score:\t $cscore");


 ######################################################################################################## 
 #     Basic scoring, good for demo
 ######################################################################################################## 
 my $suspicious_score_country =  $permsgstatus->{conf}->{geomailsearch_score_country}; 
 syslog ("Reading geomailsearch_score_country:\t $suspicious_score_country");
 @CountryTokens = split(/:/,$suspicious_score_country);
 foreach (@CountryTokens){
 	syslog ("\t*** Scoring Country:***\t $_");
 }
 ######################################################################################################## 
 
 
 
 ######################################################################################################## 
 #     Advanced ASN Scoring
 ######################################################################################################## 
 my $tadv_block_asn =  $permsgstatus->{conf}->{geomailsearch_advanced_score_asn}; 
 syslog ("Reading geomailsearch_advanced_score_asn:\t $tadv_block_asn");
 @AdvancedASNTokens = split(/\|/,$tadv_block_asn);
 foreach (@AdvancedASNTokens){
	s/^\s+//;            #No leading spaces
  s/\s+$//;            #No trailing spaces 
  @AdvancedCountryASNSet = split(/\,/,$_);
  if ((scalar(@AdvancedCountryASNSet) eq 3 ) or (scalar(@AdvancedCountryASNSet) eq 2 )){
   foreach (@AdvancedCountryASNSet){
    #syslog("ASN: $_");
    $tmpTimeRange=undef;
    syslog ("\tScoring ASN Set:\t\t $_");	
    #if (/^\w[A-Z]$|^\w[A-Z]\:\w[A-Z]/i){
    if (/^AS/i){
  	 $tmpASN=$_;
  	 syslog ("\t\tScoring ASN: $tmpASN");	
    }
    if (/^(\d{2}):(\d{2})-(\d{2}):(\d{2})$/){
  	 $tmpTimeRange=$_;
  	 syslog ("\t\tScoring ASN Range: $tmpTimeRange");	
    }
    if (/^\d+$|^\d+\.\d+$/i){
  	 $tmpScore=$_;
    }
   }           #foreach (@AdvancedCountryTokensSet)
   $h_advanced_block_asn_score{$tmpASN}=$tmpScore;
   $h_advanced_block_asn_time{$tmpASN}=$tmpTimeRange;

  } else {
  	syslog ("Error in config: $_");
  }            #if ((scalar(@AdvancedCountryTokensSet) eq 3 ) or (scalar(@AdvancedCountryTokensSet) eq 2 ))
 }             #foreach (@AdvancedASNTokens)
 ######################################################################################################## 
 

 ######################################################################################################## 
 #     Advanced Radius Scoring
 ######################################################################################################## 

 #geomailsearch_radius_score 37.4192,-122.0574,5,5,18:00-23:00|7.4192,-22.0574,5,5,18:00-23:00
 my $tadv_geo_score =  $permsgstatus->{conf}->{geomailsearch_radius_score}; 
 my $tmpGeoCnt;
 syslog ("Reading geomailsearch_radius_score:\t $tadv_geo_score");
 @AdvancedRadiusTokens = split(/\|/,$tadv_geo_score);
 foreach (@AdvancedRadiusTokens){
	s/^\s+//;            #No leading spaces
  s/\s+$//;            #No trailing spaces 
  syslog ("\tBlocking Radius Set:\t\t $_");	
 	if (/([^,]*),([^,]*),([^,]*),([^,]*)(,([^,]*)|)/){
 		#syslog ("\tBlocking GeoData:\t\t xx  $1, $2, $3, $4, $5 ");
 		$tmpGeoCnt++;
 		$h_radius_score_lat{$tmpGeoCnt}=$1;
 		$h_radius_score_lon{$tmpGeoCnt}=$2;
 		$h_radius_score_radius{$tmpGeoCnt}=$3;
 		$h_radius_score_score{$tmpGeoCnt}=$4;
 		if ($5){
 			$h_radius_score_hour{$tmpGeoCnt}=$5;
 			$h_radius_score_hour{$tmpGeoCnt} =~ s/,//g;  #No comma
      
 		}

    syslog ("\t\tLatitude:\t\t $h_radius_score_lat{$tmpGeoCnt}");
    syslog ("\t\tLongitude:\t\t $h_radius_score_lon{$tmpGeoCnt}");
    syslog ("\t\tRadius:   \t\t $h_radius_score_radius{$tmpGeoCnt}");
    syslog ("\t\tScore:    \t\t $h_radius_score_score{$tmpGeoCnt}");
    if ($h_radius_score_hour{$tmpGeoCnt}) {
    	syslog ("\t\tHour:     \t\t $h_radius_score_hour{$tmpGeoCnt}");
    }
 	}
 }   #foreach (@AdvancedRadiusTokens)


 ######################################################################################################## 




 ######################################################################################################## 
 #     Advanced Country Scoring
 ######################################################################################################## 
 my $tadv_block_country =  $permsgstatus->{conf}->{geomailsearch_advanced_score_country}; 
 syslog ("Reading geomailsearch_advanced_score_country:\t $tadv_block_country");
 @AdvancedCountryTokens = split(/\|/,$tadv_block_country);

 foreach (@AdvancedCountryTokens){
	s/^\s+//;            #No leading spaces
  s/\s+$//;            #No trailing spaces 
  syslog ("\tScoring Set:\t $_");
  @AdvancedCountryTokensSet = split(/\,/,$_);
  $tmpCountry=undef;
  $tmpTimeRange=undef;
  $tmpScore=undef;
  if ((scalar(@AdvancedCountryTokensSet) eq 3 ) or (scalar(@AdvancedCountryTokensSet) eq 2 )){
   foreach (@AdvancedCountryTokensSet){
    syslog ("\tScoring Set:\t\t $_");	
    if (/^\w[A-Z]$|^\w[A-Z]\:\w[A-Z]/i){
  	 $tmpCountry=$_;
    }
    if (/^(\d{2}):(\d{2})-(\d{2}):(\d{2})$/){
  	 $tmpTimeRange=$_;
    }
    if (/^\d+$|^\d+\.\d+$/i){
  	 $tmpScore=$_;
    }
   } #foreach (@AdvancedCountryTokensSet)
   syslog ("\t\tScoring Country: $tmpCountry");	
   if ($tmpTimeRange){ #Errors during startup? 20130727
    syslog ("\t\tScoring Range: $tmpTimeRange");	
   } 
   syslog ("\t\tScoring Score: $tmpScore");	
   my $tmpTR;
   if (!$tmpTimeRange){ #Don't use undef hash keys
   	$tmpTR="-";
   }else {
   	$tmpTR=$tmpTimeRange;
   }	
   $h_tmp_advanced_block_country_code{$tmpCountry.$tmpTR.$tmpScore}=$tmpCountry;
   $h_advanced_block_country_score{$tmpCountry.$tmpTR.$tmpScore}=$tmpScore;
   $h_advanced_block_country_time{$tmpCountry.$tmpTR.$tmpScore}=$tmpTimeRange;
  } else { #if (scalar(@AdvancedCountryTokensSet) eq 3 )
   syslog ("Error in config: $_");
  } #if (scalar(@AdvancedCountryTokensSet) eq 3 )
 }  #foreach (@AdvancedCountryTokens)
 syslog ("Config Loop");
 for my $pointer ( sort keys %h_advanced_block_country_score ) {
	if ($h_advanced_block_country_time{$pointer}){  
		syslog ("\t\tScoreData: $pointer - Score:$h_advanced_block_country_score{$pointer} / TimeRange:$h_advanced_block_country_time{$pointer}");	
	} else {	
	  syslog ("\t\tScoreData: $pointer - Score:$h_advanced_block_country_score{$pointer}");	
	} 
 }
 ######################################################################################################## 

 
 
 
 ######################################################################################################## 
 #   SQL Data
 ######################################################################################################## 
 $geomailsearch_syslog =  $permsgstatus->{conf}->{geomailsearch_syslog};  #1.0.1
 syslog ("Reading geomailsearch_syslog:\t $geomailsearch_syslog");

 $geomailsearch_non_office_hours =  $permsgstatus->{conf}->{geomailsearch_non_office_hours}; 
 syslog ("Reading geomailsearch_non_office_hours:\t $geomailsearch_non_office_hours");

 $geomailsearch_non_business_day =  $permsgstatus->{conf}->{geomailsearch_non_business_day}; 
 syslog ("Reading geomailsearch_non_business_day:\t $geomailsearch_non_business_day");
 
 $sql_server  =  $permsgstatus->{conf}->{geomailsearch_sql_server};
 syslog ("Reading geomailsearch_sql_server:\t $sql_server");    

 $sql_db  =  $permsgstatus->{conf}->{geomailsearch_sql_database};
 syslog ("Reading geomailsearch_sql_database:\t $sql_db");    

 $sql_user  =  $permsgstatus->{conf}->{geomailsearch_sql_user};
 syslog ("Reading geomailsearch_sql_user:\t $sql_user");    
 
 $sql_pwd  =  $permsgstatus->{conf}->{geomailsearch_sql_pwd};
 syslog ("Reading geomailsearch_sql_pwd:\t xxxxx");    
 ######################################################################################################## 


 syslog("Start");



 my $lasthop = $permsgstatus->{relays_untrusted}->[0];
 my $ip = $lasthop->{ip};
 my $helo = $lasthop->{helo};
 my $msgid = $lasthop->{id};
 my $head = $permsgstatus->get( 'ALL' );
 


 my $sender;  #1.0.2
 foreach my $from ($permsgstatus->get('EnvelopeFrom:addr')) {
   next unless defined $from;
   $from =~ tr/././s; 
   if ($from =~ /(\S+)\@(\S+\.\S+)/) {
     $sender = "$1\@$2";
     last;
   }
 }

 my $receiver;  #1.0.2
 foreach my $from ($permsgstatus->get('To')) {
   next unless defined $from;
   $from =~ tr/././s; 
   if ($from =~ /(\S+)\@(\S+\.\S+)/) {
     $receiver = "$1\@$2";
     $receiver =~ s/\<//g;  #remove angel brackets
     $receiver =~ s/\>//g;  #remove angel brackets
     last;
   }
 }

 if (($helo) and ($ip)) {
 	$iptonum=&ip_to_number($ip); 
 	$ip_country=&getcountry($iptonum);
 	$ip_asn=&get_ASN($iptonum);
  $perm_msg="RESULTS FOR $ip - Localtime:" . strftime("%H:%M:%S", localtime(time));
  syslog("**********************");
 	syslog("IP Country: $ip_country ");
 	syslog("ASN       : $ip_asn");
  syslog("Country ip: $ip");
  syslog("IP Number : $iptonum");
  syslog("MSGID     : $msgid");
  syslog("HELO      : $helo");
  syslog("SENDER    : $sender");  #1.0.2
  syslog("RECIEVER  : $receiver");#1.0.2
  
  $strsplunk.="COU=$ip_country ASN=$ip_asn IP=$ip MFROM=$sender MTO=$receiver MSGID=$msgid HELO=$helo IPN=$iptonum ";

  
  ################
  #Starting checks
  ################
  &check_basic;
  &check_country;
  &check_ASN;
  &check_GEO($iptonum);
  ################

  
  syslog("Finished check");

  dbg ("Finished check: $score");
  syslog("Finished check: $score");
  syslog("GSCORE=$score $strsplunk");
  
  if ($llevel >= 2) {  #1.0.1
  	syslog("GSCORE=$score $strsplunk",2);
  }	

  $permsgstatus->_handle_hit("GEO_MAIL_SEARCH", $score, "$perm_msg", "$perm_msg:-\n");
 } #if (($helo) and ($ip))
 
 #2014
 return 0;
 
}  #Sub


#...methods...
sub set_config {
  my($self, $conf) = @_;
  my @cmds = ();
 
  push (@cmds, {
   setting => 'geomailsearch_score',
   is_admin => 1,
   default => '',
   type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });

  push (@cmds, {
   setting => 'geomailsearch_syslog',
   is_admin => 1,
   default => '',
   type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });


  push (@cmds, {
   setting => 'geomailsearch_non_office_hours',
   is_admin => 1,
   default => '',
   type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });

  push (@cmds, {
   setting => 'geomailsearch_advanced_score_country',
   is_admin => 1,
   default => '',
   type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });

  push (@cmds, {
   setting => 'geomailsearch_radius_score',
   is_admin => 1,
   default => '',
   type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });


  push (@cmds, {
   setting => 'geomailsearch_advanced_score_asn',
   is_admin => 1,
   default => '',
   type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });


 push (@cmds, {
    setting => 'geomailsearch_sql_user',
    is_admin => 1,
    default => '',
    type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });


  push (@cmds, {
    setting => 'geomailsearch_sql_pwd',
    is_admin => 1,
    default => '',
    type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });

  push (@cmds, {
    setting => 'geomailsearch_sql_server',
    is_admin => 1,
    default => '',
    type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });


 
  push (@cmds, {
    setting => 'geomailsearch_sql_database',
    is_admin => 1,
    default => '',
    type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });


  push (@cmds, {
    setting => 'geomailsearch_score_country',
    is_admin => 1,
    default => '',
    type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });

  push (@cmds, {
    setting => 'geomailsearch_non_business_day',
    is_admin => 1,
    default => '',
    type => $Mail::SpamAssassin::Conf::CONF_TYPE_STRING
  });


 
  $conf->{parser}->register_commands(\@cmds);      
}   #sub set_config 



sub syslog {
	#return 0;
 
 if ( $Debug ) {
	my $tldate = strftime("%d-%m-%Y %H:%M:%S", localtime(time));
	open (LOGGING, ">>/tmp/geomailsearch.log") or die "can not open file";
  print LOGGING "$tldate $_[0]\n";
  close LOGGING
 }
 
 if ($Syslog){
 	my $gmstmp=$_[0];
 	$gmstmp =~ s/\t/ /g;
 	
 	#if ($geomailsearch_syslog eq 1) {
 	if ($llevel){
 	 if ($llevel == 1) {
 	  &SendToSyslog(" GMS  $gmstmp");
 	 }
 	} 
 	
 	if ($_[1]) {
 	 if ($_[1] >= 2) {  #LogLevel2
 	  &SendToSyslog("$gmstmp");
 	 }
 	} 
 	
 	 
 }
 
 
 
}            # sub Syslog 
	
sub SendToSyslog {
 my $s;
 foreach (@syslogip){
  $s=new Net::Syslog(Facility=>'local4',Priority=>'debug',SyslogHost=>$_);
  $s->send($_[0],Priority=>'info');
 } 
} 




sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);
  $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
} 

sub getcountry {
 #Expect $_[0] = IPMumber
 my ($dbh,$country,$country_name);
 #my $tmpipnum=&ip_to_number($_[0]);	
 my $tmpipnum=$_[0];	
 #syslog("DEY: $sql_string");
 #$dbh = DBI->connect("$sql_string",$sql_user,$sql_pwd); 
 $dbh = DBI->connect("DBI:mysql:$sql_db:$sql_server:3306",$sql_user,$sql_pwd); 
 my $sqlstr = "SELECT CityLocation.Country FROM CityBlocks,CityLocation where CityBlocks.startIPNum <= $tmpipnum and CityBlocks.endIPNum >= $tmpipnum and CityLocation.locId = CityBlocks.locId";
 my $sql = $dbh->prepare($sqlstr);
 $sql->execute ; 
 (my($subcountry)=$sql->fetchrow_array);
 if ($subcountry) {
  syslog("Receive $subcountry");
  $sql->finish;  #Close DB Handle
  return $subcountry;
 } else {
  syslog("Receive failed!");
 } 
 $sql->finish;  #Close DB Handle
 return undef;
} 

sub CheckWeekend {
 #return defined if we have weekend	
 my ($wday) = (localtime(time))[6];
 if ($wday >=1 and $wday <=5) {
   return undef;   #1.0.4
 } else  {
   return 1;
 }
}


 
sub CheckOfficeHour {
 my ($thour,$tmin,$tsec,$tnhour,$tnmin,$tnsec,$BlFrom,$BlTo);
 my $year = strftime("%Y", localtime(time));
 my $tyear=strftime("20%y", localtime(time));   
 my $month = strftime("%m", localtime(time));
 my $day = strftime("%d", localtime(time));
 if ($_[0] =~ m/(\d{2}):(\d{2})-(\d{2}):(\d{2})/){
  $thour=$1;
  $tmin=$2;
  $tsec="00";
  $tnhour=$3;
  $tnmin=$4;
  $tnsec="00";      
   
  $BlFrom=str2time("$tyear-$month-$day $thour:$tmin:$tsec");
  $BlTo=str2time("$tyear-$month-$day $tnhour:$tnmin:$tnsec");
  if (($BlTo < $BlFrom)){ #Day Offset
   if ((time < $BlFrom) and ((time < $BlTo))){
   	syslog("TimeFrom AND TimeTo is in the furure, sub 1 day offset to TimeFrom");
   	$BlFrom=$BlFrom-(24*60*60);
   }
   $BlTo=$BlTo+(24*60*60);
  }	
  syslog("$ip_country / FromTime(epoche):\t" . $BlFrom . " - " . "ToTime:(epoche)  \t" . $BlTo);
  if ((time > $BlFrom) and (time < $BlTo)) {
   &syslog ("==>>HOURS ARE NOT ALLOWED<<==  $_[0]/$ip_country ");
   return 1;
  } else {
   #&syslog ("Office Hour");
   return undef;
  }
 }
}  #Sub CheckOfficeHour


sub check_basic {
  #####################
  #Basic Check Country	
  ##################### 
  my ($tmpweekscorechange,$tmpweekscoredetect,$tmpscorechange,$tmpscoredetect);	
  foreach (@CountryTokens){
	 $tmpweekscorechange=undef;	
   $tmpweekscoredetect=undef;	
	 $tmpscorechange=undef;	
   $tmpscoredetect=undef;	
   if (uc($ip_country) eq uc($_)){
  	syslog ("Found matching Country (basic):\t $_");
    if ($geomailsearch_non_business_day){
     $tmpweekscoredetect=1;
     syslog("Check Weekend (basic)");
     if (&CheckWeekend) {
  	  $tmpweekscorechange=1;
  	  syslog("WE SCORECHANGE");
  	 }   #if (&CheckWeekend)
  	}    #if ($geomailsearch_non_business_day)
    if ($geomailsearch_non_office_hours) {
     $tmpscoredetect=1;	
     syslog("Check Non office hour(basic) - $geomailsearch_non_office_hours");
     if (&CheckOfficeHour($geomailsearch_non_office_hours)){
  	  $tmpscorechange=1;	
  	  syslog("Is NOT Office Hour - $geomailsearch_non_office_hours");
  	  syslog("OH Scorechange ...");
     } else {
      syslog("Is Office Hour - $geomailsearch_non_office_hours");
     }   #if (&CheckOfficeHour)
    }    #if ($geomailsearch_non_office_hours)
    
    #1.0.4      
    if (((($tmpscorechange) and ($tmpscoredetect))  or (!$tmpscoredetect)) or ((($tmpweekscorechange) and ($tmpweekscoredetect))  or (!$tmpweekscoredetect))) { 
	   $perm_msg.="\n\t\t\t\tSCORE: Basic $_/$cscore ";
	   syslog("SCORE - +$cscore");
	   $score += $cscore;  
	   last;
	  }    #any trigger ...
   }     #if (uc($ip_country) eq uc($_))
  }      #foreach (@CountryTokens)
} #Sub


sub check_ASN { #Rebuild 02Feb2014
 my ($tmpscorechange,$tmpscoredetect);	
 for my $pointer ( sort keys %h_advanced_block_asn_score ) {
 	$tmpscorechange=undef;	
  $tmpscoredetect=undef;	
  syslog("check ASN: $pointer ");
  my @tmASN = split(/\:/,$pointer);
  foreach (@tmASN){
   if (uc($_) eq $ip_asn){
  	syslog ("Found matching ASN:\t $_"); 
  	if ($h_advanced_block_asn_time{$pointer}){
  	 $tmpscoredetect=1;
  	 syslog ("Analyze ASN Date: $h_advanced_block_asn_time{$pointer} - $h_advanced_block_asn_score{$pointer} - $_ ");	
     if (&CheckOfficeHour($h_advanced_block_asn_time{$pointer})){
  	  $tmpscorechange=1;  
  	  syslog ("Matching time range for ASN: $_ but mark only to block: $h_advanced_block_asn_time{$pointer} - would score: /$h_advanced_block_asn_score{$pointer}");
  	  last;
     } else {  	
    	syslog ("Found NO matching ASN Timerange:\t $h_advanced_block_asn_time{$pointer} - SKIP - OFFICE HOUR");
     }
  	} else {  	
  		syslog("INFO: No ASN date config present for $_");
  	}
   } 
  }
  foreach (@tmASN){
   if (uc($_) eq $ip_asn){
    if ((($tmpscorechange) and ($tmpscoredetect))  or (!$tmpscoredetect)){ #Either there is NO block time active or block time AND block time matching active ...!
     $score += $h_advanced_block_asn_score{$pointer};  
     syslog("SCORE: $score");
     syslog ("Found matching ASN to block:\t $_ Score: $score/$h_advanced_block_asn_score{$pointer}");
     $strsplunk.="SASN=$_ SASNSC=$h_advanced_block_asn_score{$pointer} ";
     $perm_msg.="\n\t\t\t\tSCORE: $ip_asn/$h_advanced_block_asn_score{$pointer} ";
     last;
    } else {
   	 syslog ("No ASN match, either there is no office time specified or the time does not match  ");
    }
   }   #if (uc($_) eq $ip_asn)
  }    #foreach (@tmASN)
 }     #for my $pointer ..
} #sub  check_ASN



sub check_GEO {
 my ($tmpscorechange,$tmpscoredetect);	
 my @GeoRet;
 my ($ccity,$clat,$clon);
 @GeoRet=get_GeoDataByIP($iptonum);
 syslog("\t *********************  ");
 $ccity=$GeoRet[3];
 $clat=$GeoRet[1];
 $clon=$GeoRet[2];
  syslog("\t Sender City tmp:      $ccity  ");
 if ($ccity eq "0"){  #1.0.3
 	syslog("\t Check additional city $ccity -- $iptonum");
 	my @sRet;
	@sRet=getACity($iptonum); #1.0.3
  if ($sRet[0] ne "0") {
   $clat=$sRet[0];
  } 
  if ($sRet[1] ne "0") {
   $clon=$sRet[1];
  } 
  if ($sRet[2] ne "0") {
   $ccity=$sRet[2]; 
  } else {
   $ccity="0";
  }
 } 


 syslog("\t Sender Country:   $GeoRet[0]  ");
 syslog("\t Sender Latitude:  $clat  ");
 syslog("\t Sender Longitude: $clon  ");
 syslog("\t Sender City:      $ccity  ");
 syslog("\t Sender Link:      https://maps.google.com/?q=$clat,$clon&t=k");
 syslog("\t *********************  ");
 
 $strsplunk.="LAT=$clat LON=$clon ";
 
 if ($ccity ne "0"){
 	$strsplunk.="CTY=$ccity ";
 } else {
	$strsplunk.="CTY=0 ";
 }
 
 for my $pnt ( sort keys %h_radius_score_lat ) {
  #syslog("\t GetDistance1:  $GeoRet[1]-$GeoRet[2]");
  syslog("\t ***********  ");
  syslog("\t Reference Lat/Lon:  ($h_radius_score_radius{$pnt}) LAT:$h_radius_score_lat{$pnt} LON: $h_radius_score_lon{$pnt}");
  my $tmpDistance=int(&GreatCircle($GeoRet[1],$GeoRet[2], $h_radius_score_lat{$pnt},$h_radius_score_lon{$pnt})); 
  syslog("\t DISTANCE:     $tmpDistance KM");

  if ($h_radius_score_hour{$pnt}) {
   $tmpscoredetect=1;
   syslog("\t Radius Score Time:   $h_radius_score_hour{$pnt}");
   if (&CheckOfficeHour($h_radius_score_hour{$pnt})){
  	syslog("\t Radius Score Time MATCH");
  	$tmpscorechange=1;  
   }
  }

  if ((($tmpscorechange) and ($tmpscoredetect))  or (!$tmpscoredetect)){ #Either there is NO block time active or block time AND block time matching active ...!
   if ($h_radius_score_radius{$pnt}>$tmpDistance) {
    $score += $h_radius_score_score{$pnt};  
    syslog("\t DISTANCE MATCH=>SCORING!!!:  $h_radius_score_radius{$pnt} -vs- $tmpDistance ++ $score/$h_radius_score_score{$pnt}");
   }
  } 

  syslog("\t ***********  ");
 }     #for my $pnt ( sort keys %h_radius_score_lat ) 



}      #sub



sub check_country {   #complete rebuild 16Jan14
 my ($tmpscorechange,$tmpscoredetect);	
 for my $pointer ( sort keys %h_advanced_block_country_score ) {
 	$tmpscorechange=undef;	
  $tmpscoredetect=undef;	
	my @tmpCountry = split(/\:/,$h_tmp_advanced_block_country_code{$pointer});
	foreach (@tmpCountry){ #Check config countries against
	 if (uc($ip_country) eq uc($_)){
	  if ($h_advanced_block_country_time{$pointer}){  
	   $tmpscoredetect=1;
	   syslog ("Analyze Date: $h_tmp_advanced_block_country_code{$pointer} - Score:$h_advanced_block_country_score{$pointer} / TimeRange:$h_advanced_block_country_time{$pointer}");	
     if (&CheckOfficeHour($h_advanced_block_country_time{$pointer})){
  	  $tmpscorechange=1;  
  	  syslog ("Matching time range for: $ip_country but mark only to block: $h_advanced_block_country_time{$pointer} - would score: /$h_advanced_block_country_score{$pointer}");
  	  last;
     }  else {    #if (&CheckOfficeHour($h_advanced_block_country_time{$pointer})) 
      syslog ("Found NO matching Timerange:\t $h_advanced_block_country_score{$pointer} - SKIP - OFFICE HOUR");
     }    #if (&CheckOfficeHour($h_advanced_block_country_time{$pointer})) 
    
    } else {
    	syslog("INFO: No date config present for $h_tmp_advanced_block_country_code{$pointer}");
    }     #if ($h_advanced_block_country_time{$pointer}) 
   }      #if (uc($ip_country) eq uc($_))
  }       #foreach   
  foreach (@tmpCountry){
   if (uc($ip_country) eq uc($_)){
   	syslog ("Analyze Country:\t $_ vs $ip_country");
    if ((($tmpscorechange) and ($tmpscoredetect))  or (!$tmpscoredetect)){ #Either there is NO block time active or block time AND block time matching active ...!
     syslog ("Found matching country in advanced setting - !!! SCORING !!!:\t $_ Score: $score/$h_advanced_block_country_score{$pointer}");
     $score += $h_advanced_block_country_score{$pointer};  
     $perm_msg.="\n\t\t\t\tSCORE: $ip_country/$h_advanced_block_country_score{$pointer} ";
     syslog("SCORE: $score");
     $strsplunk.="COU=$_ SCTYSC=$h_advanced_block_country_score{$pointer} ";
     last;
    } else {
   	 syslog ("No match, either there is no office time specified or the time does not match \t  $ip_country == $_");
    } #if ((($tmpscorechange) and ...
   }  #if (uc($ip_country) eq uc($_))
  }   #foreach (@tmpCountry)
 }    #for my $pointer ( sort keys %h_advanced_block_country_score ) 
}     #Sub




sub get_ASN {   #2013
 #Returns the AS-Number given by IPNumber ($_[0])
 my $sql_database13 = $sql_db;
 syslog("Received: $_[0]");
 my ($dbh,$ASNumber);
 my $tmpipnum=$_[0];
 $tmpipnum =~ s/(\D+)//g;  #No chars ...
 $dbh = DBI->connect("DBI:mysql:$sql_database13:$sql_server:3306",$sql_user,$sql_pwd); 
 my $sql = $dbh->prepare("SELECT ASNumber FROM ASNumber where startIpNum<=$tmpipnum and endIpNum>=$tmpipnum;" );
 $sql->execute ; 
 #&syslog ("SQL Query: SELECT ASNumber FROM ASNumber where startIpNum<=$tmpipnum and endIpNum>=$tmpipnum;");
 while (($ASNumber)=$sql->fetchrow_array) {
  #&syslog (" ==>>  $ASNumber ");
  $sql->finish;  #Close DB Handle
  return $ASNumber;
 }
 $sql->finish;  #Close DB Handle
 return 0;
}

sub get_GeoDataByIP {
 #Get GeoData by IPNum given in $_[0]
 #Return a array: CityLocation_Country,CityLocation_Latitude,CityLocation_Longitude,CityLocation_City
 
 use DBI;
 my @subRet;	
 my $sql_database13 = "geoip";
 my ($dbh,$ASNumber);
 #my $tmpipnum=&ip_to_number($_[0]);	
 $dbh = DBI->connect("DBI:mysql:$sql_database13:$sql_server:3306",$sql_user,$sql_pwd); 
 my $sqlq= "
 SELECT ".$sql_db.".CityLocation.Country,".$sql_db.".CityLocation.Latitude,".$sql_db.".CityLocation.Longitude,".$sql_db.".CityLocation.City 
 FROM ".$sql_db.".CityBlocks,geoip.CityLocation
 where
  ".$sql_db.".CityBlocks.startIPNum <= ".$_[0]."
 and
  ".$sql_db.".CityBlocks.endIPNum >= ".$_[0]."
 and
  ".$sql_db.".CityLocation.locId = ".$sql_db.".CityBlocks.locId
 ";
 #&syslog (" ==>> EXECUTE ");
 &syslog (" ==>> $sqlq ");
 my $sql = $dbh->prepare($sqlq);
 $sql->execute ; 
 while (my( $sqlCityLocation_Country,$sqlCityLocation_Latitude,$sqlCityLocation_Longitude,$sqlCityLocation_City)=$sql->fetchrow_array) { 
  syslog ("\t=>$sqlCityLocation_Country,$sqlCityLocation_Latitude,$sqlCityLocation_Longitude,$sqlCityLocation_City");
  
  my $CityLocation_Country=$sqlCityLocation_Country;
  my $CityLocation_Latitude=$sqlCityLocation_Latitude;
  my $CityLocation_Longitude=$sqlCityLocation_Longitude;
  my $CityLocation_City=$sqlCityLocation_City;
  
  #Never return undef in an Spamassassin plugin
  if (!$CityLocation_Country){$CityLocation_Country=0}
  if (!$CityLocation_Latitude){$CityLocation_Latitude=0}
  if (!$CityLocation_Longitude){$CityLocation_Longitude=0};
  if (!$CityLocation_City){$CityLocation_City=0};
  
  @subRet=($CityLocation_Country,$CityLocation_Latitude,$CityLocation_Longitude,$CityLocation_City);
 }
 $sql->finish;  #Close DB Handle
 return @subRet;	
}

sub GreatCircle {
 my ($lat1, $long1, $lat2, $long2) = @_;
 my $r=3956;
 my @zip1 = (deg2rad($long1), deg2rad(90-$lat1));
 my @zip2 = (deg2rad($long2), deg2rad(90-$lat2));
 my $dist = great_circle_distance(@zip1, @zip2,$r);
 $dist=$dist/ 0.621371192237;  #convert miles to km
 return $dist;
} 

sub getACity { #1.0.3
 my @sRet;
 my $dbh;
 $dbh = DBI->connect("DBI:mysql:$sql_db:$sql_server:3306",$sql_user,$sql_pwd); 
 
 my $sql = $dbh->prepare("SELECT latitude,longitude,city FROM geoip.CustomCityLocation where ipNum = ".$_[0].";");
 $sql->execute ; 
 my($SQLLat,$SQLLon,$SQLCity)=$sql->fetchrow_array;
 
 if (($SQLLat) and ($SQLLon) and ($SQLCity)){
 	@sRet=($SQLLat,$SQLLon,$SQLCity);
 	syslog ("\t=>GETCITY $SQLLat,$SQLLon,$SQLCity");
  $sql->finish;  #Close DB Handle
  return @sRet;	
 }
  
 syslog ("\t=>GETCITY -- NONE");
 @sRet=(0,0,0);
 $sql->finish;  #Close DB Handle
 return @sRet;	
}

1;

