# Fail2Nft - The script to block unwanted ssh/smtp/imap/ftp users - More infromation please see https://coolgeo.org/fail2nft
# *** FTP Module ***
# The only function here is ->ReadSyslogRecords<-
# Param:
# Epoch Time (time of last scan)
# Return:
# Hash of IP Address


# This program is distributed in the hope that it will be useful,
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE.    

package vsftpd;
require Exporter;
use strict;
use POSIX;
use HTTP::Date qw/str2time/;


sub ReadFTPRecords {
 #Param:
 #LastKnownEpochTime = Epoch time of last run;
 #Return:
 #ReturnHash =  Hash of return values
 
 my $LastKnownEpochTime = shift;
 my ($FTP_ReturnHash) = @_;

 $FTP_ReturnHash->{'IP_ALLOW'}->{'-'}='-'; #Need a base init as we never deliver a successful authetication with ftp

 my $vsftpdLog = '/var/log/vsftpd.log';
 my $cnt;
 if (-e $vsftpdLog) {
  open FH, "<$vsftpdLog" or die "cannot open $vsftpdLog";
  $FTP_ReturnHash->{'DEBUG'}.="Open $vsftpdLog\n";  
  while(<FH>) {
 	 chomp;
 	 if (/(FAIL LOGIN)/i) {  #This is just a precheck to speed up things ...
 	  if (m/^([^ ]*) ([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  
 	 	 my $tmpEpoche=str2time("$2 $3 $4");
 	 	 my $tmpDate="$2 $3 $4";
 	 	 #print "$2 $3 $4 == $tmpEpoche\n";
 	 	 #print "xxxxxxxxxxxx  $_\ $LastKnownEpochTime $tmpEpoche\n";
     if ($LastKnownEpochTime < $tmpEpoche ){  #Filter the time 	 	
 	 	  #print "MATCH $2 $3 $4 == $tmpEpoche " . (time-$TimeBack) . "\n";
 	 	  #Tue Oct  8 19:44:37 2019 [pid 908] [ddd] FAIL LOGIN: Client "::ffff:192.168.178.44"
 	 	  #                                                             ^^^^^^^^^^^^^^^^^^^^^^
 	 	  #Tue Oct  8 19:44:37 2019 [pid 908] [ddxd] FAIL LOGIN: Client "2a01:4f8:c0c:270b::2"   
 	 	  #                                                              ^^^^^^^^^^^^^^^^^^^^^
 	 	  if (/FAIL LOGIN: Client \"([^\"]*)/){
 	 	  	$cnt++;
  	 	 	my $tmpIP=$1;
 	 	 	  $tmpIP =~ s/\:\:ffff\://g; #Prefix spaces 1.0.71
 	 	    my $tldate = strftime("%d-%m-%Y %H:%M:%S", localtime($tmpEpoche));
 	 	    my $tldatex = strftime("%d-%m-%Y %H:%M:%S", localtime($LastKnownEpochTime));
 	 	    #print "ADD $tmpIP $tldate $tldatex\n";
 	 	    #$ReturnHash->{'SYSLOG'}.="Bla\n";         
 	 	    $FTP_ReturnHash->{'DEBUG'}.="BlaBla $tmpIP\n\n";  
 	 	    $FTP_ReturnHash->{'IP_DENY'}->{$tmpIP}=$FTP_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
 	 	    #print "ADDxx $tmpIP $FTP_ReturnHash->{'IP_DENY'}->{$tmpIP}\n";
 	    } 
 	   }  #if ((time-$TimeBack) < $tmpEpoche )  #Filter the time 	 	
 	  }   #if (m/^([^ ]*) ([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/)
   }    #if (/(FAIL LOGIN)/i)   #This is just a precheck to speed up things ...
  }	   #while(<FH>) 
 }	     #if (-e $ftpLog)

  if ($cnt<1) {
   #print "====VSFTP SET DUMMY ==\n";	
   $FTP_ReturnHash->{'IP_DENY'}->{'-'}='-'; #Need a base init
   $FTP_ReturnHash->{'DEBUG'}='0'; #Need a base init
  } 


} #Sub



1;
   