# Fail2Nft - The script to block unwanted ssh/smtp/imap/ftp/grafana users - More infromation please see https://coolgeo.org/fail2nft
# *** Grafana Module ***
# The only function here is ->ReadGrafanaRecords<-
# Param:
# Epoch Time (time of last scan)
# Return:
# Hash of IP Address


# This program is distributed in the hope that it will be useful,
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE.    


#NOTE NOTE NOTE
#We are not covering the date/time complex given in the grafana log, no timezone conversation

package splunk;
require Exporter;
use strict;
use POSIX;
use HTTP::Date qw/str2time/;


sub ReadSplunkRecords {
 #Param:
 #LastKnownEpochTime = Epoch time of last run;
 #Return:
 #ReturnHash =  Hash of return values
 my $LastKnownEpochTime = shift;
 my ($Splunk_ReturnHash) = @_;
 $Splunk_ReturnHash->{'IP_ALLOW'}->{'-'}='-'; #Need a base init as we never deliver a successful authetication with grafana
 my $splunkLog = '/var/log/splunk/audit.log';
 
 
 
 
 
 $Splunk_ReturnHash->{'DEBUG'}.="Use $splunkLog\n";
 my $cnt;
 if (-e $splunkLog) {
  open FH, "<$splunkLog" or die "cannot open $splunkLog";
  #$Splunk_ReturnHash->{'DEBUG'}.="Open $splunkLog\n";
  while(<FH>) {
   chomp;
   if (/action=login attempt, info=failed/i) {  #This is just a precheck to speed up things ...
    if (/(\d{2})-(\d{2})-(\d{4}) (\d{2}):(\d{2}):(\d{2})/){  #TIME PATTERN
     #$Splunk_ReturnHash->{'DEBUG'}.="COMPLEX $3-$1-$2-$4-$5-$6\n";
     my $tmpEpoche=str2time("$3-$1-$2 $4:$5:$6");
     #$Splunk_ReturnHash->{'DEBUG'}.="EPOCH $tmpEpoche / $LastKnownEpochTime\n";
     if ($LastKnownEpochTime < $tmpEpoche ){  #Filter the time
      $Splunk_ReturnHash->{'DEBUG'}.="MATCH MATCH MATCH -- $LastKnownEpochTime\n";
      #04-17-2023 17:23:22.129 +0200 INFO  AuditLogger - Audit:[timestamp=04-17-2023 17:23:22.129, user=demo123, action=login attempt, info=failed, src=172.28.0.3 method=Splunk]
      #src=172.28.0.3
      #src=172.28.0.3 method=Splunk]
      if (/src=([^ ]*)/){  #IP PATTERN
       $cnt++;
       my $tmpIP=$1;
       $Splunk_ReturnHash->{'DEBUG'}.="BlaBla -$tmpIP-\n\n";
       $Splunk_ReturnHash->{'IP_DENY'}->{$tmpIP}=$Splunk_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
      }  #if (/remote_addr=([^ ]*)/)  #IP PATTERN
     }   #if ($LastKnownEpochTime < $tmpEpoche )
    }    #if (/t=(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})/)  #TIME PATTERN
   }     #if (/Invalid username or password/i) {
  }      #while(<FH>)
 }       #if (-e $splunkLog)
 if ($cnt<1) {
  #print "====VSFTP SET DUMMY ==\n";
  $Splunk_ReturnHash->{'IP_DENY'}->{'-'}='-'; #Need a base init
 }
} #Sub

1;
   