# Fail2Nft - The script to block unwanted ssh/smtp/imap/ftp users - For more information please see https://coolgeo.org/fail2nft
# *** MAIL Module ***
# The only function here is ->ReadMailRecords<-
# Param:
# Epoch Time (time of last scan)
# Return:
# Hash of IP Address


# This program is distributed in the hope that it will be useful,
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE.    

package mail;
require Exporter;
use strict;
use POSIX;
use HTTP::Date qw/str2time/;

sub ReadMailRecords {
 ##########################
 #MAIL MODULE
 #Parse: /var/log/mail.log
 ##########################
 
 my $LastKnownEpochTime = shift;
 my ($MAIL_ReturnHash) = @_;
 $MAIL_ReturnHash->{'IP_ALLOW'}->{'-'}='-'; #Need a base init as we never deliver a successful authentication with mail
 
 #$IP6Support = 1;
 my ($tmpIP,$tmpUser,$whiteIP,$sysIP);
 my ($tmpIP,$tmpUser);
 my $cnt=0;  
 if ( -e '/var/log/mail.log') { #1.0.8
  my $IP6Support=1;
  open FHL, "</var/log/mail.log" or die "mail.log does not exist";
  while (<FHL>){
   chomp;
   ######################################################################################################################################################### 
   #                                               SMTP attack
   #########################################################################################################################################################
   #1.0.6 / 1.2
   #Aug 27 17:50:52 vm-mta01 sm-mta[2038]: 17RHocbI002038: [103.133.106.210]: possible SMTP attack: command=AUTH, count=5
   if (/possible SMTP attack/i){   
    if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get Date
 	 my $tmpEpoche=str2time("$1 $2 $3");
 	 my $tmpDate="$1 $2 $3";
	 #print "DEB $1 $2 $3 -- $4 $5 $6 $tmpEpoche => $LastKnownEpochTime\n";
     #if ((time-$LastKnownEpochTime) < $tmpEpoche ){  #Filter the time
	 if ($LastKnownEpochTime < $tmpEpoche ){  #Filter the time
      if (/ \[(\d+)\.(\d+)\.(\d+)\.(\d+)\]/){  #IP
	   #print "DEB APPLY $tmpDate  $tmpEpoche  => $LastKnownEpochTime\n";
       $tmpIP="$1.$2.$3.$4";
       if ($tmpIP ne '127.0.0.1') {
  	    $cnt++;
  	    if (/count=(\d+)/){
		 $MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}=$MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}+$1;
		} else {
		 $MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}=$MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
		} 
	   }
	  } 
	 }
	}
   }   #if (/possible SMTP attack/i)
 

   ######################################################################################################################################################### 
   #                                               SASL LOGIN
   #########################################################################################################################################################
   #1.0.5
   #May 12 19:07:13 vm-xk01 sm-mta[23719]: t4CH7A5f023719: AUTH failure (LOGIN): authentication failure (-13) SASL(-13): authentication failure: checkpass failed, relay=abts-north-dynamic-140.197.163.122.airtelbroadband.in [122.163.197.140] (may be forged)
   #May 12 19:03:22 mail sm-mta[39557]: t4CH3EPn039557: AUTH failure (LOGIN): authentication failure (-13) SASL(-13): authentication failure: checkpass failed, relay=[105.109.83.155]
   #May 12 21:19:03 vm-xk01 sm-mta[28653]: t4CJJ2X4028653: AUTH failure (DIGEST-MD5): user not found (-20) SASL(-13): user not found: unable to canonify user and get auxprops, relay=p57B97D5C.dip0.t-ipconnect.de [87.185.125.92]
   #NOTE: Need sendmail loglevel 10!
   
   if (/AUTH failure/i){   #due to incorrect pwd - SASL
    if (/SASL/i){   #check if we're on sasl
     if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get Date
 	  my $tmpEpoche=str2time("$1 $2 $3");
 	  ##&syslog(" =DEB SASL TMP EPOC $tmpEpoche");  	 #1.0.4
 	  my $tmpDate="$1 $2 $3";
      if ($LastKnownEpochTime < $tmpEpoche ){  #Filter the time 	 	
       if (/relay\=.*\[(\d+)\.(\d+)\.(\d+)\.(\d+)\]/i) {   #due to incorrect pwd - SASL
        $tmpIP=$1.".".$2.".".$3.".".$4;
  	    if ($tmpIP ne '127.0.0.1') {
  	     $cnt++;
  	     $MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}=$MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
        }
       } 
   	   if ($IP6Support) {
   	    #Jun 17 20:47:50 localhost sm-mta[28408]: v5HIlnaD028408: AUTH failure (CRAM-MD5): user not found (-20) SASL(-13): user not found: user: joe@mailtower.de property: cmusaslsecretCRAM-MD5 not found in sasldb, relay=p200300C0A3F1D40054AD8F213B304B75.dip0.t-ipconnect.de [IPv6:2003:c0:a3f1:d400:54ad:8f21:3b30:4b75]
  	    if (/relay\=.*\[IPv6:((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\]\s*/) { #1.0.10
	     $tmpIP="$1";
  	     if ($tmpIP ne '127.0.0.1') {
  	      $cnt++;
  	      $MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}=$MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
  	     } 
   	    }	
   	   }      
      } 
     } 
    } 
   } 
  
   
   ################
   #  AUTH FAIL
   ################  
   #2017 - Dovecot v6 sample:
   #Jun 17 19:25:09 localhost dovecot: imap-login: Login: user=<matthias>, method=PLAIN, rip=2003:c0:a3f1:d400:b9fd:4d91:1e08:bf79, lip=2a01:4f8:d16:7146::2, mpid=25319, TLS, session=<3AYBLytSigAgAwDAo/HUALn9TZEeCL95>
   #Jun 17 19:25:09 localhost dovecot: imap-login: Login: user=<matthias>, method=PLAIN, rip=2003:c0:a3f1:d400:b9fd:4d91:1e08:bf79, lip=2a01:4f8:d16:7146::2, mpid=25320, TLS, session=<ERMBLytSiwAgAwDAo/HUALn9TZEeCL95>
   #2017 - Dovecot v6 FAIL SAMPLE via Thundebird:
   #Jun 17 19:50:16 localhost dovecot: imap-login: Disconnected (auth failed, 4 attempts in 131 secs): user=<joe>, method=PLAIN, rip=2003:c0:a3f1:d400:54ad:8f21:3b30:4b75, lip=2a01:4f8:d16:7146::2, TLS, session=<S6YPgStSjwAgAwDAo/HUAFStjyE7MEt1>
   #Check this, it happened using Thunderbird
   #Feb 21 23:24:35 vm-xk01 auth: pam_unix(dovecot:auth): authentication failure; logname= uid=0 euid=0 tty=dovecot ruser=joe rhost=93.207.66.254  user=joe
   #Oct 13 19:19:06 vm-mk01 dovecot: imap-login: Aborted login (auth failed, 1 attempts in 4 secs): user=<joe>, method=PLAIN, rip=127.0.0.1, lip=127.0.0.1, secured, session=<bwA+jKLo7QB/AAAB>
   #Dec 12 20:07:53 vm-mk01 dovecot: imap-login: Disconnected (auth failed, 1 attempts): user=<matthias>, method=PLAIN, rip=95.222.246.70, lip=78.47.152.76, TLS: Disconnected
   if (/auth failed/i){   #incorrect pwd
    if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get Date
	 	 my $tmpEpoche=str2time("$1 $2 $3");
	 	 my $tmpDate="$1 $2 $3";
   	 if ($LastKnownEpochTime < $tmpEpoche ){  #Filter the time 	 	
	    if (/imap-login/i){   #
	     ##&syslog(" =DEB IMAP LOGIN");  	#1.0.4
	  	 if (/user\=\<([^\>]*)/i){   
	  		$tmpUser=$1;
	  		##&syslog(" =DEB IMAP USER $tmpUser");  	#1.0.4
	  	  if (/rip\=(\d+)\.(\d+)\.(\d+)\.(\d+)/i){   
   	     $tmpIP=$1.".".$2.".".$3.".".$4;
	  	   #$MAIL_ReturnHash->{'DEBUG'}.="Tmp User: $tmpUser\n\n";  
  	 	   if ($tmpIP ne '127.0.0.1') {
  	 	    $cnt++;
  	 	    $MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}=$MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
 	 	     } 
   	    }  
   	    #Add imap v6 support
   	    #doesnt get covered?
   	    #Jun 17 20:17:10 localhost dovecot: imap-login: Disconnected (auth failed, 6 attempts in 147 secs): user=<joe>, method=PLAIN, rip=2003:c0:a3f1:d400:54ad:8f21:3b30:4b75, lip=2a01:4f8:d16:7146::2, TLS, session=<wD9J4CtSsQAgAwDAo/HUAFStjyE7MEt1>
   	    if ($IP6Support) { #1.0.10
  	   	 if (/rip\=((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?,\s*/) { #1.0.10, notice the comma at the end
	        #syslog("Add v6IP (imap): =>$1<= $_");
	        $tmpIP="$1";
   	 	    #$MAIL_ReturnHash->{'DEBUG'}.="Tmp User: $tmpUser\n\n";  
  	 	    if ($tmpIP ne '127.0.0.1') {
  	 	     $cnt++;
  	 	     $MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}=$MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
  	 	    } 
   	     }	
   	    }
   	   } 
      } 
     } 
    } 
   }
  
  
   ######################################################################################################################################################### 
   #                                               DOVECOT PLUGIN
   #########################################################################################################################################################
   #Note: v6 is covered by imap login #1.1.9 / 1.1.10
   if (/dovecot\:/i){   
    if (/Authentication failure/i){  
     if (/^([^ ]*) *([^ ]*) *([^ ]*)/){  
      my $tmpEpoche=str2time("$1 $2 $3");
	 	  my $tmpDate="$1 $2 $3";
      if ((time-$LastKnownEpochTime) < $tmpEpoche ){ 
    	 if (/pam\(([^,]*)\,([^)]*)/){
   	    $tmpIP=$2;
        $tmpUser=$1;
        #$MAIL_ReturnHash->{'DEBUG'}.="Tmp User: $tmpUser / $tmpIP\n\n";  
  	 	  if ($tmpIP ne '127.0.0.1') {
  	 	   $cnt++;
  	 	   $MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}=$MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
	      } 
   	   }     #if (/pam\(([^,]*)\,([^)]*)){
   	  }      #if ($LastKnownEpochTime < $tmpEpoche ){  #Filter the time 	 	
   	 }       #if (/^([^ ]*) *([^ ]*) *([^ ]*)/)  #Get Date
    }        #if (/Authentication failure/i)   #dovecot message 
   }	       #if (/dovecot\:/i) #dovecot message
  
  
  
   ######################################################################################################################################################### 
   #                                               QPOPPER PLUGIN
   #########################################################################################################################################################
  
   if (/in\.qpopper/){
    if (/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get Date
	 	 my $tmpEpoche=str2time("$1 $2 $3");
	 	 my $tmpDate="$1 $2 $3";
     if ((time-$LastKnownEpochTime) < $tmpEpoche ){  #Filter the time
      if (/incorrect/i){   #incorrect pwd
       if (/ \((\d+)\.(\d+)\.(\d+)\.(\d+)\)/){
      	$tmpIP="$1.$2.$3.$4";
     	  if ($tmpIP ne '127.0.0.1') {
  	 	   $cnt++;
  	 	   $MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}=$MAIL_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
  	 	  } 
     	 } 
      }    #incorrect pwd  
     }		 #Filter the time
    }      #Get Date
	 }       #if (/in\.qpopper/)
  }	       #while (<FHL>)
 }         #if (! -e '/var/log/mail.log') { #1.0.8
 if ($cnt<1) {
  #print "====MAIL SET DUMMY ==\n";	
  $MAIL_ReturnHash->{'IP_DENY'}->{'-'}='-'; #Need a base init
  $MAIL_ReturnHash->{'DEBUG'}='0'; #Need a base init
 } 
}         #SUB

1;
   