# Fail2Nft - The script to block unwanted ssh/smtp/imap/ftp/grafana users - More infromation please see https://coolgeo.org/fail2nft
# *** Grafana Module ***
# The only function here is ->ReadGrafanaRecords<-
# Param:
# Epoch Time (time of last scan)
# Return:
# Hash of IP Address


# This program is distributed in the hope that it will be useful,
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE.    


#NOTE NOTE NOTE
#We are not covering the date/time complex given in the grafana log, no timezone conversation

package grafana;
require Exporter;
use strict;
use POSIX;
use HTTP::Date qw/str2time/;


sub ReadGrafanaRecords {
 #Param:
 #LastKnownEpochTime = Epoch time of last run;
 #Return:
 #ReturnHash =  Hash of return values
 
 my $LastKnownEpochTime = shift;
 my ($Grafana_ReturnHash) = @_;

 $Grafana_ReturnHash->{'IP_ALLOW'}->{'-'}='-'; #Need a base init as we never deliver a successful authetication with grafana

 my $grafanaLog = '/var/log/grafana/grafana.log';
 $Grafana_ReturnHash->{'DEBUG'}.="Use $grafanaLog\n";  
 my $cnt;
 if (-e $grafanaLog) {
  open FH, "<$grafanaLog" or die "cannot open $grafanaLog";
  $Grafana_ReturnHash->{'DEBUG'}.="Open $grafanaLog\n";  
  #$Grafana_ReturnHash->{'IP_DENY'}->{'2.3.4.5'}=$Grafana_ReturnHash->{'IP_DENY'}->{'2.3.4.5'}+1;
  while(<FH>) {
   chomp;
   #logger=context userId=0 orgId=0 uname= t=2022-12-31T20:29:14.081948095+01:00 level=error msg="Invalid username or password" error="user not found" remote_addr=192.168.178.40 traceID=
   if (/Invalid username or password/i) {  #This is just a precheck to speed up things ...
 	$Grafana_ReturnHash->{'DEBUG'}.="Pattern found\n";  
	$Grafana_ReturnHash->{'DEBUG'}.="$_\n";  
	#if (/t=(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})\.\d+(\W{1})(\d{2})\:/){  #COMPLEX TIME PATTERN WITH TZ - ignoring
    if (/t=(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})/){  #TIME PATTERN
	 $Grafana_ReturnHash->{'DEBUG'}.="COMPLEX $1-$2-$3-$4-$5-$6\n";  
     my $tmpEpoche=str2time("$1-$2-$3 $4:$5:$6");
     $Grafana_ReturnHash->{'DEBUG'}.="EPOCH $tmpEpoche\n";  
     if ($LastKnownEpochTime < $tmpEpoche ){  #Filter the time 	 	
	  $Grafana_ReturnHash->{'DEBUG'}.="MATCH MATCH MATCH -- $LastKnownEpochTime\n";  
	  #remote_addr=192.168.178.40 traceID=
	  if (/remote_addr=([^ ]*)/){  #IP PATTERN 
	   $cnt++;
  	   my $tmpIP=$1;
 	   $Grafana_ReturnHash->{'DEBUG'}.="BlaBla -$tmpIP-\n\n";  
	   $Grafana_ReturnHash->{'IP_DENY'}->{$tmpIP}=$Grafana_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
	  }	 #if (/remote_addr=([^ ]*)/)  #IP PATTERN 
	 }   #if ($LastKnownEpochTime < $tmpEpoche )
    }    #if (/t=(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})/)  #TIME PATTERN
   }     #if (/Invalid username or password/i) {    
  }	     #while(<FH>) 
 }	     #if (-e $ftpLog)

  if ($cnt<1) {
   #print "====VSFTP SET DUMMY ==\n";	
   $Grafana_ReturnHash->{'IP_DENY'}->{'-'}='-'; #Need a base init
  } 


} #Sub



1;
   