# Fail2Nft - The script to block unwanted ssh/smtp/imap/ftp users - More infromation please see https://coolgeo.org/fail2nft
# *** Auth Module ***
# The only function here is ->ReadSyslogRecords<-
# Param:
# Epoch Time (time of last scan)
# Return:
# Hash of IP Address

#1.0.1 - add pattern for gcp 03May2021
#1.0.2 - add ubuntu22 and aws ssh pattern

package auth;
require Exporter;
use strict;
use POSIX;
use HTTP::Date qw/str2time/;
#use Net::Syslog;

sub ReadSyslogRecords {
 #Param:
 #LastKnownEpochTime = Epoch time of last run;
 #Return:
 #AUTH_ReturnHash =  Hash of return values

 my $LastKnownEpochTime = shift;
 my ($AUTH_ReturnHash) = @_;

 #################################################################
 my $authLog = '/var/log/auth.log';
 my $syslog_dateformat='%d-%m-%Y %H:%M:%S';  #Syslog format date
 #################################################################

 my ($cnt_allow,$cnt_deny);
 my ($host,$ReverseTime,$geoip,$sIP,$sASNN,$sASN,%hDatSucRecords,%hDatRecords,$CachedRecordWindow,$IgnoreSystemWhitelist);

 if (-e $authLog) {
  my %hTempDatRecords;
  my $formatdate;
  open FHL, "<$authLog" or die "Auth.log does not exist";
  my ($tmpEpoche,$tmpUser,$tmpIP,$tmpDate,$tmpAuth,$tmpPKUser,$tmpPKIP,$tmpPKEpoche,$tmpPKDate);
  my ($tmpIP6);  #1.0.9
  my $tmpProto="ssh";
   ############################################################################################################ ##########
  #Debug hack, we map my local IP's found in auth.log to external IP's for simulation purposes, set undef for production
  my $IPDebug=1;
  my %hIPMapping; #Debugging Purpose
  $hIPMapping{'192.168.178.19'} = '172.217.22.110';  #google
  $hIPMapping{'192.168.178.34'} = '98.138.219.231';  #yahoo
  $hIPMapping{'192.168.178.40'} = '205.251.242.103'; #amazon
  $hIPMapping{'192.168.178.27'} = '66.135.196.249';  #ebay
  #########################################################################################

  my $cntl;
  my $cnt=1;
  my ($tmpPID);
  while (<FHL>){
   $cntl++;
   chomp;
   $tmpUser=undef;
   $tmpIP=undef;
   $cnt++;


  #Nov  8 19:41:28 ip-172-31-29-66 sshd[3834]: Connection closed by authenticating user root 159.65.219.175 port 60306 [preauth]
 if ( /Connection closed by authenticating user/ ) {   #1.0.2
   if (m/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get the epoche date from the log record
    $tmpEpoche=str2time("$1 $2 $3");
    $tmpDate="$1 $2 $3";
    if ($5 =~ /\[(\d+)\]/) {
     $tmpPID=$1;
    }
   }
   if (/user \w+ (\d+)\.(\d+)\.(\d+)\.(\d+)/){  #Get IP
    $tmpIP="$1.$2.$3.$4";
   }

   #print "OK $tmpDate/$tmpEpoche/$tmpIP => $_ \n";
   $formatdate = strftime($syslog_dateformat, localtime($tmpEpoche));
   $AUTH_ReturnHash->{'SYSLOG'}.="$formatdate Failure SSH Login: SRV=$tmpIP M=S2F SUC=1 LOU=$1 TGE=$tmpDate PROTO=AUTH LCK=1 USR=$tmpUser\n";
   $AUTH_ReturnHash->{'IP_DENY'}->{$tmpIP}=$AUTH_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
  }


   #Samples to get:
   #Jun  3 18:40:28 myhost sshd[4490]: Failed password for invalid user admin from 91.197.232.107 port 46083 ssh2
    #un  3 19:04:30 myhost sshd[5829]: Accepted password for root from 192.168.2.126 port 55673 ssh2
    #IPv6 Add on
    #Jun  3 17:54:29 myhost sshd[1183]: Accepted password for root from 2604:a880:0:1010::809:c001 port 35015 ssh2
    #Jun  3 19:21:49 myhost sshd[6924]: pam_unix(sshd:auth): authentication failure; logname= uid=0 euid=0 tty=ssh ruser= rhost=2a01:4f8:d16:430f::2  user=root


#       if (/(invalid user|Authentication failure|Accepted|FAILED su|Successful su|session closed|Failed password)/i) {  #This is just a precheck to speed up things ...
        if (/(invalid user|Authentication failure|Accepted|FAILED su|Successful su|session closed|Failed password|Connection closed)/i) {  #This is just a precheck to speed up things ... Add Connection Closed 1.0.1

         if ((!/keyboard/) or /Accepted/){     #Disclaimer for "keyboard" - we do not want duplicate records due to ssh debug logging
          if ((/$tmpProto/) or (/su/)){        #Filter by protocol or su / superuser
                 #Nov 10 14:38:21 vm-mk01 sshd[24927]:
                 if (m/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/){  #Get the epoche date from the log record
                  $tmpEpoche=str2time("$1 $2 $3");
                  $tmpDate="$1 $2 $3";
                  if ($5 =~ /\[(\d+)\]/) {
                        $tmpPID=$1;
                  }
           }

       if ($LastKnownEpochTime < $tmpEpoche ){  #Filter the time
        if (/invalid user *([^ ]*)/){  #Get NON Existing User
                $tmpUser=$1;
        } else {
         if (/Failed password for *([^ ]*)/){     #Get Existing User - That covers the above "precheck" rule - DO NOT REMOVE
                $tmpUser=$1;
         } else {
                if (/Authentication failure for *([^ ]*)/){     #Get Existing User - Patched SSh Version
                 $tmpUser=$1;
          }
         }
        }


        if ((/FAILED su for *([^ ]*) by *([^ ]*)/)){
         $tmpUser=$1;
        }

        #if ((/Successful su for *([^ ]*) by *([^ ]*)/)){
        # if ("nobody" ne $1){
        #  #&Sendmail(4,$_);
        # }
        #}

        if (/from (\d+)\.(\d+)\.(\d+)\.(\d+)/){  #Get IP
         $tmpIP="$1.$2.$3.$4";
        }

        if (!$tmpIP) {  #1.0.9
         #Jun  3 17:54:29 myhost sshd[1183]: Accepted password for root from 2604:a880:0:1010::809:c001 port 35015 ssh2 #1.0.9
         #https://community.helpsystems.com/forums/intermapper/miscellaneous-topics/5acc4fcf-fa83-e511-80cf-0050568460e4 #1.0.9
         if (/from\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)? \s*/) { #1.0.9
              $tmpIP="$1";
         }
        }
		
		
		    if ($IPDebug) {
                if ($hIPMapping{$tmpIP}) {
                        $tmpIP=$hIPMapping{$tmpIP};
                }
        }

        if (/Failed password for/){
         $AUTH_ReturnHash->{'SYSLOG'}.="$formatdate Failure SSH Login: SRV=$tmpIP M=S2F SUC=1 LOU=$1 TGE=$tmpDate PROTO=AUTH LCK=1 USR=$tmpUser\n";
         $AUTH_ReturnHash->{'IP_DENY'}->{$tmpIP}=$AUTH_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
        }



       if ( /Connection closed by authenticating user *([^ ]*) (\d+)\.(\d+)\.(\d+)\.(\d+)/ ) {   #1.0.1
          #print  "OK $1 $2 $3 $4 $5";
          $AUTH_ReturnHash->{'SYSLOG'}.="$formatdate Failure SSH Login: SRV=$tmpIP M=S2F SUC=1 LOU=$1 TGE=$tmpDate PROTO=AUTH LCK=1 USR=$tmpUser\n";
          $AUTH_ReturnHash->{'IP_DENY'}->{$tmpIP}=$AUTH_ReturnHash->{'IP_DENY'}->{$tmpIP}+1;
        }



        if ((/Accepted password for *([^ ]*)/) or (/Accepted keyboard-interactive\/pam for *([^ ]*)/)){
         $formatdate = strftime($syslog_dateformat, localtime($tmpEpoche));
         $AUTH_ReturnHash->{'SYSLOG'}.="$formatdate Successful SSH Login: SRV=$host M=S2F SUC=1 LOU=$1 TGE=$tmpDate PROTO=AUTH LCK=0 USR=$tmpUser\n";
         $AUTH_ReturnHash->{'IP_ALLOW'}->{$tmpIP}=$AUTH_ReturnHash->{'IP_ALLOW'}->{$tmpIP}+1;
         $cnt_allow++;
        }   #if ((/Accepted password for *([^ ]*)/) or (/Accepted keyboard-interactive\/pam for *([^ ]*)/))




      if ( /Accepted publickey for *([^ ]*) from (\d+)\.(\d+)\.(\d+)\.(\d+)/ ) {   #1.0.1
        #print "OK $1 $2 $3 $4 $5";
        $formatdate = strftime($syslog_dateformat, localtime($tmpEpoche));
        $AUTH_ReturnHash->{'SYSLOG'}.="$formatdate Successful SSH Login: SRV=$host M=S2F SUC=1 LOU=$1 TGE=$tmpDate PROTO=AUTH LCK=0 USR=$tmpUser\n";
        $AUTH_ReturnHash->{'IP_ALLOW'}->{$tmpIP}=$AUTH_ReturnHash->{'IP_ALLOW'}->{$tmpIP}+1;
        $cnt_allow++;
      }



       }    #if ((time-$ReverseTime) < $tmpEpoche )
          }     #if ((/(authentication failure|Failed password)/)
         }      #if (!/keyboard/)
        }       #if (/fail/)
   }        #While ...
  } #if (-e $authLog)

  if ($cnt_deny<1) {
   $AUTH_ReturnHash->{'IP_DENY'}->{'-'}='-'; #Need a base init
   $AUTH_ReturnHash->{'DEBUG'}='-';          #Need a base init
  }
  if ($cnt_allow<1) {
   $AUTH_ReturnHash->{'IP_ALLOW'}->{'-'}='-'; #Need a base init
   $AUTH_ReturnHash->{'DEBUG'}='-';           #Need a base init
  }
 }  #Sub



1;

