#####################
#Eventlog to Firewall
#####################
# Perl scrip to obtain then Windows Event Log, if intruders are present then add them to the Firewall
# This program is distributed in the hope that it will be useful,
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE.  

#1.0.1 - Add Logon Type 3 to event code 4625 - 24Jun2019

#Splunk Fields!
#SRV=$host
#M=S2F
#LFR=$FWRule
#LOF=$tmpuser logoff
#WID=1 
#DIP=detected IP
#IDU=$tmpuser
#LOU Logon
#TGE=TimeGenerated

use strict;
use Win32::OLE('in');
use POSIX;
use HTTP::Date qw/str2time/;
use XML::Simple;      #=>Read my XML Config
use Net::Syslog;
use Time::Local;
use Data::Dumper;
use Sys::Hostname;
use Cwd;


my ($TimeBack,$BlockTimeDelta,$ExpireDelta,$MaxRequest,$WinFWRule,$gmt_offset_in_seconds,$UseGMT,@syslogip,@whitelistip,@resp,$Syslog,$gmt_offset_in_seconds,$startLastToken,$LogAge);

#################################################################################################
my $IgnoreSystemWhitelist=1; #Do this!!!, we will whitelist by default all internal ip addresses
my $Conffile="evt2fw.xml";
my @internalwhitelist= ('127.0.0.1','10.0','172.22','192.168');
my $host = hostname;
#################################################################################################

############
&ReadConfig;
############


#Open syslog dat filehandle
my $tldate = strftime("%Y%m%d", localtime(time));
my $evtflog="$tldate-evt2fw.log";
open (FHLog, ">>$evtflog") or die "no such file";
syslog("******************");
syslog("Reading event data");

my (%hDatRecords,%IPCnt,$fwCNT,$Expiredrecords,%hDatExpiredRecords);




my $GetLastStartDate=&getLastStartDate;

#Check for datechange
#############
&CheckLogAge;
#############

###############
&ReadTimeBack;
###############

################################
#Get results from local database
&ReadDatFile;
################################

#####################
#Get results from WMI
&ReadWMIrecords;
#####################


#Add to IP / Job Counter 

 #my $whiteIP=undef; #leave me here!
 for my $pntepoche ( sort keys %hDatRecords ){   
  if ($pntepoche > (time-$BlockTimeDelta)) {
   for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  #Get IPs and count them
    #if ($hDatRecords{$pntepoche}{$pntip} ne 1) {  #Do not count records which have been marked as firewalled  #NNNNEEEEIIIIINNNNNNNN
     $IPCnt{$pntip}++;  #==>> Job Counter	
    #} 
   } 
  }	
 }


 #rewrite DAT File and mark the firewalled records
 open (FHDAT, ">evt2fw.dat") or die "no such file";
 print FHDAT "#epoche;ip;firewalled\n"; #CSV Header
 for my $pntepoche ( sort keys %hDatRecords ){   
  for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  
   if (($pntepoche) and ($pntepoche)){
    if ($IPCnt{$pntip} >= $MaxRequest){
     print FHDAT "$pntepoche;$pntip;1\n";
    } else {
     print FHDAT "$pntepoche;$pntip;$hDatRecords{$pntepoche}{$pntip}\n";
    }
   } else {
   	#syslog("Empty record? $pntepoche/$pntip");
   } 
  }
 }

 #Add the firewall Rules here!!!
 my $CSVIP; 
 for my $pntcnt ( sort keys %IPCnt ){   
  syslog("Firewall candidate: $IPCnt{$pntcnt} $pntcnt");
  if ($IPCnt{$pntcnt} >= $MaxRequest){
 	 syslog("BLOCK $IPCnt{$pntcnt} = $pntcnt");
 	 $CSVIP.="$pntcnt,";
  }	
 } 
 $CSVIP=~s/\,$//g; #no comma at the end ...
 syslog ("CSVIP: $CSVIP");
 syslog ("ST IP: $startLastToken");
 
 $startLastToken=~s/\,$//g; #no comma at the end ...
 
 #Compare $CSVIP with last known stats, need to be different
 #if ($CSVIP ne $startLastToken){
 #	syslog ("DEBXX NETSH");
 # syslog ("DEBXZ1 $CSVIP");
 # syslog ("DEBXZ2 $startLastToken");
 # }
 # syslog ("DEBXY $CSVIP $startLastToken");
 
 
 my $csvtoken; #CSV List is empty yet ....
 #Apply Firewall Rule
 if ($CSVIP ne $startLastToken){
  if ($CSVIP) {
   $csvtoken=$CSVIP;  #Add me to compare later!!!
   my $FWRule="netsh advfirewall firewall set rule name=" . '"' . $WinFWRule . '"' . " new RemoteIP=$CSVIP enable=yes";
   SendToSyslog("Apply to local firewall rule. SRV=$host M=S2F LFR=$FWRule");
   syslog("Request: $FWRule");
   $csvtoken=$CSVIP;
   my @resp=`$FWRule`;
   my $resp;
   foreach (@resp){
 	  if (/ok/i){$resp=1}
   }
   if ($resp) {syslog("Response: OK");}
  } else {
 	 if ((!$fwCNT) and ($Expiredrecords)) {  #No generic counters
 	  syslog("No IP given -  disable firewall rule!"); #Disable firewall rule
 	  SendToSyslog("Disable local firewall rule - no intruders. SRV=$host M=S2F LFR=0");
    my $FWRule="netsh advfirewall firewall set rule name=". '"' . $WinFWRule . '"' . " new enable=no";
    syslog("Request: $FWRule");
    
    
    my @resp=`$FWRule`;
    my $resp;
    foreach (@resp){
 	   if (/ok/i){$resp=1}
    }
    if ($resp) {syslog("Response: OK");}
   } else {
    syslog("nothing to do");
   }  #if (!$fwCNT)
   
  }
 } else {               #if ($CSVIP ne $startLastToken)
 	syslog("no status change - nothing to do");
 	$csvtoken=$CSVIP;  #Set CSV token to get written into our status file
 	#syslog("XX1:$CSVIP");
 	#syslog("XX2:$startLastToken");
 	
 }

open (FHSTAT, ">evt2fw.sta") or die "no such file";
print FHSTAT (time);
if ($csvtoken){
	print FHSTAT ";$csvtoken";
}	
print FHSTAT "\n";
close FHSTAT;

sub ReadWMIrecords {
 use constant wbemFlagReturnImmediately => 0x10;
 use constant wbemFlagForwardOnly => 0x20;
 my $tmpLogon;
 #my @computers = ("localhost");
 #foreach my $computer (@computers) {
   my $objWMIService = Win32::OLE->GetObject("winmgmts:{impersonationLevel=impersonate,(Security)}!\\\\$host\\root\\CIMV2") or die "WMI connection failed.\n";
   #my $colItems = $objWMIService->ExecQuery("Select * from Win32_NTLogEvent Where Logfile = 'Security' ", "WQL",wbemFlagReturnImmediately | wbemFlagForwardOnly);
   my $colItems = $objWMIService->ExecQuery("Select * from Win32_NTLogEvent Where Logfile = 'Security' and (eventcode  = '4625' or eventcode  = '4624' or eventcode  = '4647')  and TimeGenerated > '" . &DateToWMIDate($TimeBack) . "' ", "WQL",wbemFlagReturnImmediately | wbemFlagForwardOnly);
   syslog("start WMI - $TimeBack - " . &DateToWMIDate($TimeBack));
   my $tmpuser;
   foreach my $objItem (in $colItems) {
      $tmpuser="";
      #syslog("Message: $objItem->{Message}");       #Debugging
      #Logon Type:			10
      if ($objItem->{Message} =~ m/Logon Type\:(\s+|\t+)(\d+)/){
      	$tmpLogon=$2;
      }
      	


      #################
      #EventCode: 4647 
      #################

      if ($objItem->{Message} =~ m/Account For Which Logon Failed:\r\s*Security ID:([^\$]*)\n\s*Account Name:\s*([^ ]*)\r/){  #4625 - LogonType 10 = Failed Logon
       $tmpuser=$2;
      } else {
      	if ($objItem->{Message} =~ m/New Logon:\r\s*Security ID:([^\$]*)\n\s*Account Name:\s*([^ ]*)\r/){	#4624 - LogonType 10 = Successful Logon
      		$tmpuser=$2;
       }
      }

      if ($objItem->{EventCode} eq 4647){ 
	     syslog("Logoff event");      
	     if ($objItem->{Message} =~ m/Account Name\:(\s+|\t+)(\w+)/){
	     	syslog("Logoff User=$2");      
	     	SendToSyslog("User initiated logoff. SRV=$host M=S2F LOF=$2 TGE=$objItem->{TimeGenerated}");
	     }
	    }	



      if (($tmpLogon eq 10) or ($tmpLogon eq 3)) { #1.0.1
       if ($objItem->{Message} =~ m/Source Network Address:\s+(\d+)\.(\d+)\.(\d+)\.(\d+)/){

      	my $whiteIP=undef; #leave me here!
      	my $currentIP="$1.$2.$3.$4"; #leave me here!
        

        #################
        #EventCode: 4625 
        #################
        if ($objItem->{EventCode} eq 4625){ 
      	 syslog("**************  GENERAL INTRUSION (WARNING) *************");
      	 SendToSyslog("Intrusion Detection. SRV=$host M=S2F WID=0 DIP=$currentIP IDU=$tmpuser TGE=$objItem->{TimeGenerated}");
      	 syslog("TimeGenerated: $objItem->{TimeGenerated} " . &WMIDateToEpoche($objItem->{TimeGenerated}));
      	 syslog("==>> IP: $currentIP");
      	 syslog("==>> User: $tmpuser");
      	 syslog("EventCode: $objItem->{EventCode}");
      	 syslog("LogonType: $tmpLogon");
      	
      	 #ignore whitelist of xml config
      	 foreach (@whitelistip){ #Checking whitelist before we block this ip
        	#syslog("Whitelist: $_ --> $currentIP");
	        if ($currentIP =~ /^$_/){
		       syslog("==>> $_ / Ignore because this is a IP of config whitelist: $currentIP   ");
		       SendToSyslog("Whitelisted Intrusion Detection. SRV=$host M=S2F WID=1 DIP=$currentIP IDU=$tmpuser LOU=0 TGE=$objItem->{TimeGenerated}");
		       $whiteIP=$_; #Set Whitelist!
		       last;
	        }
         }
        
         #Ignore system whitelist
         if ($IgnoreSystemWhitelist){  #Default is undef unless you switch this off in our configuration
          foreach (@internalwhitelist){ #Checking system whitelist before we block this ip
           if ($currentIP =~ /^$_/){
            syslog("Ignore because this is a IP of system whitelist: $_ --> $currentIP --  Ignore!");
            $whiteIP=$_; #Set Whitelist!
            last;
           } 
          }
         }
         if (!$whiteIP) {   ##Checking whitelist before we block this ip
          syslog("     =>****  REAL INTRUSION   ****");
          SendToSyslog("Intrusion Detection. SRV=$host M=S2F WID=0 DIP=$currentIP IDU=$tmpuser TGE=$objItem->{TimeGenerated}");
          $hDatRecords{&WMIDateToEpoche($objItem->{TimeGenerated})}{$currentIP}=0;      	
         } else {
          syslog(" ==> Info: whitlist address: / $whiteIP // $currentIP ");
         }
        }   #if ($objItem->{EventCode} eq 4625)
        
        
        
        
        #################
        #EventCode: 4624
        #################
        if ($objItem->{EventCode} eq 4624){ 
      	 syslog("*********** GENERAL LOGIN (INFO) *************");
      	 print "Successful Login - Expire IP Records\n";
      	 syslog("==>> IPPP: $currentIP");
      	 syslog("==>> User: $tmpuser");
      	 syslog("EventCode: $objItem->{EventCode}");
      	 syslog("LogonType: $tmpLogon");
      	 SendToSyslog("An account was successfully logged on. SRV=$host M=S2F LOU=$tmpuser DIP=$currentIP IDU=0 TGE=$objItem->{TimeGenerated}");
      	 
         for my $pntepoche ( sort keys %hDatRecords ){   #Delete the firewall rules if a successful login is given
          for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  
           #syslog (" Check in IP Database  ==>> User:  $pntip");
           if ($currentIP eq $pntip){
            syslog ("Found and delete: IP $pntip");
            delete $hDatRecords{$pntepoche}{$pntip};
            #exit;
           } 
          }
         }

        }
       
       }  
      }   
   }
 #}

} #Sub

sub DateToWMIDate {
 #$-[0] = age	in seconds
 my $dateFrom= (time - int($_[0]));
 syslog(strftime("%Y%m%d %H:%M:%S", localtime($dateFrom)));
 #20121011011915.000000-000
 return strftime("%Y%m%d%H%M%S.000000-000", localtime($dateFrom));
}

sub WMIDateToEpoche {
 #$-[0] = Epochedate
 if ( $_[0] =~ m/^(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})\./){
 	return str2time("$1-$2-$3 $4:$5:$6")
 } 
 
}


sub ReadDatFile {
 my $tmpfnd;
 open (FHDAT, "<evt2fw.dat") or syslog("No Dat File!");
 while (<FHDAT>) {
 	chomp;
 	s/#.*//;             #No Comments #
  s/'.*//;             #No Comments '
  s/^\s+//;            #No leading spaces
  s/\s+$//;            #No trailing spaces
 	my @hrecordToken = split(/;/,$_);
 	$hDatRecords{$hrecordToken[0]}{$hrecordToken[1]}=$hrecordToken[2];
 }
 
 ##Check and delete expired records
 for my $pntepoche ( sort keys %hDatRecords ){   
  for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  
 	 if (($pntepoche) and ($pntepoche<(time-$ExpireDelta))){
    syslog("Delete expired Record: $pntip " . (time-$ExpireDelta) . " =>$hDatRecords{$pntepoche}{$pntip}");
    if (!$hDatExpiredRecords{$pntip}){
     if ($hDatExpiredRecords{$pntip} ne 1){
      $hDatExpiredRecords{$pntip}=$hDatRecords{$pntepoche}{$pntip}; #copy record to build diff. later
     } 
    } 
    delete $hDatRecords{$pntepoche}{$pntip};  #Delete hash
   }
  }
 }

 for my $pntip ( sort keys %hDatExpiredRecords){   
  $tmpfnd=undef;  
  for my $pntepoche ( sort keys %hDatRecords ){   
   if ($hDatRecords{$pntepoche}{$pntip}){
    syslog("Exist $pntepoche / $pntip ");
    $tmpfnd=1;
    last;
   } 
  } 
  
  if ($hDatExpiredRecords{$pntip} eq 1){
   if (!$tmpfnd){  #send only to syslog if the record has fully gone
  	$Expiredrecords=1;  #Expired records are occuring, that means that we inventory all data new
  	SendToSyslog("ExpiredRecord M=S2F IEI=$pntip");
  	syslog("Firewall record has fully expired: $pntip ==> $hDatExpiredRecords{$pntip}");
   } else {
  	syslog("Firewall record has expired: $pntip ==> $hDatExpiredRecords{$pntip}");	
   } 
  } else {
   if (!$tmpfnd){ #send only to syslog if the record has fully gone
  	$Expiredrecords=1;  #Expired records are occuring, that means that we inventory all data new
  	SendToSyslog("A non firewalled record expired, M=S2F IDE=$pntip");
  	syslog("Record has fully expired: $pntip ==> $hDatExpiredRecords{$pntip}");
   } else {
  	syslog("NON Firewall Record has expired: $pntip ==> $hDatExpiredRecords{$pntip}");
   }
  }
 }

 #set inventory flag $fwCNT
 for my $pntepoche ( sort keys %hDatRecords ){   
  for my $pntip( sort keys %{$hDatRecords{$pntepoche}} ) {  
 	 if ($hDatRecords{$pntepoche}{$pntip} eq 1) {
    $fwCNT++;   #Generic FW counter, this will tell us that there are at least some records on the firewall
    #syslog ("Count=$fwCNT / collect: $Expiredrecords" );
   } 
  }
 }



}



sub syslog {

    my $tldate = strftime("%d-%m-%Y %H:%M:%S", localtime(time));
    print FHLog "$tldate $_[0]\n";
    print "$_[0]\n";

}  


sub SendToSyslog {
  if ($Syslog) {
   my $s;
   foreach (@syslogip){
    $s=new Net::Syslog(Facility=>'local4',Priority=>'debug',SyslogHost=>$_);
    $s->send($_[0],Priority=>'info');
   } 
  }  
}



sub ReadConfig {
 #######################################
 #Read My XML Config given in $Conffile
 #######################################
 #Getting arrays first ....
 my $data = eval {XMLin($Conffile,ForceArray => 1)};
 for( @{$data->{Syslog}}){
  syslog("Push: $_->{IP}");
  push(@syslogip,$_->{IP});
 } 
 for( @{$data->{Whitelist}}){
  syslog("Push: $_->{IP}");
  push(@whitelistip,$_->{IP});
 } 
 #Getting the setup (non array)
 my $xml = new XML::Simple (KeyAttr=>[]); 
 my $data = $xml->XMLin("$Conffile");
 
 $TimeBack=undef;
 #TimeBack Data
 #Set the time delta where you want me to check WMI for ip addresses in seconds
 #12h=43200
 #24h=86400
 #2h GMT+2
 #my $TimeBack=86400;
 $TimeBack=$data->{Setup}->{TimeBack};

 #Set the time delta where we check how many times a ip address had access our system
 $BlockTimeDelta=$data->{Setup}->{BlockTimeDelta};
 #Set the time delta where the existing DAT records expires
 $ExpireDelta=$data->{Setup}->{ExpireDelta};
 #Set the maximum amount of requests until we firewall the sender address
 $MaxRequest=$data->{Setup}->{MaxRequest};   
 #Firewall Rule Name
 $WinFWRule=$data->{Setup}->{FirewallRuleName};   
 #Use GMT Time for WMI
 $UseGMT=$data->{Setup}->{UseGMT};   
 #Write Syslog 
 $Syslog=$data->{Setup}->{Syslog};   
 #Logrotate
 $LogAge=$data->{Setup}->{Logage};   
 
 #Disable SystemWhitleist
 if ($data->{Setup}->{IgnoreSystemWhitelist} eq 1) {   
  $IgnoreSystemWhitelist=undef;
 } else {
 	$IgnoreSystemWhitelist=1;
 } 
 if ($UseGMT eq 1) {  #Add the GMT Offset to our local timezone if set in config.
  my @t = localtime(time);
  $gmt_offset_in_seconds = timegm(@t) - timelocal(@t);
 } 

}





sub getLastStartDate {
 $startLastToken=undef;	
 my $lastRecord;
 my @slastToken;
 open (FHSTAT, "<evt2fw.sta") or syslog("no status file?");
 while (<FHSTAT>){
	chomp;
  
  @slastToken  = split(/;/,$_);  #We first split semi colums to array IF apply ...
  
  #foreach (@slastToken){
  #	syslog("==>>>> $_");
  #}
  #for my $pntepoche ( sort keys %hDatRecords ){   
  # 	my @hrecordToken = split(/;/,$_);
 	#$hDatRecords{$hrecordToken[0]}{$hrecordToken[1]}=$hrecordToken[2];
  #}
  #syslog("==>>>> $slastToken[1]");
  
  
  if ($slastToken[0]){
   $lastRecord=$slastToken[0];  #Do this! Return a proper datetime of my last execution ...
   #syslog ("Geeeeeeeeet evt2fw.sta = " . $lastRecord);
  } 
   
  if ($slastToken[1]){
  	#syslog ("Geeeeeeeeet evt2fw.sta = " . $slastToken[1]);
  	$startLastToken=$slastToken[1];
  }	   
   
  $lastRecord=$_;
	syslog ("Get evt2fw.sta = " . $lastRecord);
	return $lastRecord;
 }
 return 2592000;  #Walk back for about 4 weeks if no file is given
}

sub CheckLogAge {
 my $curdir=getcwd;
 if (($LogAge) and ($LogAge ne 0)){
  my $lage=time-($LogAge*60*60*24);
  my $lday = strftime("%d", localtime($GetLastStartDate));
  my $cday = strftime("%d", localtime(time));
  if ($lday ne $cday) {
   syslog ("Daychange occured");	
   opendir(DIR, $curdir);
   my @logfiles = grep(/\.*$/,readdir(DIR));
   foreach (@logfiles){
 	  if (/log/i){
 	   open(FHVER, "$_");
     #print " -- " .((stat FHVER)[9]) . " --\n";
     if ( ((stat FHVER)[9]) lt $lage){
     	close FHVER;
     	syslog("delete $curdir/$_");
     	unlink "$curdir/$_";
     }
 	  } 
   }
  }
 } 
}



sub ReadTimeBack {
 if (!$TimeBack) {   #Get reverse time
  $TimeBack=(time-$GetLastStartDate)+60; #testing to see if we get better results trying 60 sec offset
  #$TimeBack=(time-$GetLastStartDate)+1; #testing to see if we get better results trying 60 sec offset
  $TimeBack+=$gmt_offset_in_seconds; #Add GMT Offset!!!!
 }
} 
