#!/usr/bin/perl
#Perl DDNS script to get update your A or AAAA DNS record at Cloudflare.

#1.1 - Added TTL 03Mar2022
#    - Changed default provider to ipconfig.io

#2.0 - Add more features and improvements 11July2023
#    - Use the host command (host -t A domain.com and/or host -t AAAA domain.com) instead of Cloudflare - save transactions and improve speed
#    - Switch to syslog
#    - FQDN Array, we check all domains
#    - IP support static to xml.coolgeo.org
#    - Add Telegram support
#    - Runs on Linux only

use strict;
use warnings;
use LWP;               #Used to talk to Cloudflare
use JSON qw( );        #Used to decrypt json
use POSIX;             #Used for time stuff
use File::Path;        #Used to mkdir the log path if verbose is given
use Data::Dumper;      #Used to dump json data
use Getopt::Long;      #Used to read command params
use XML::Simple;       #Used to read the configuration file
use Net::IP ':PROC';   #Used to get the IP version
use Net::Syslog;       #Install build-essential then cpan -i Net::Syslog

#vars
my ($cfZoneID,$cfAddrType,$cfDNSName,$cfAuthKey,$cfAuthMail,$flag_verbose,$opt_config,$configuration,$flag_help,$cfTTL,$cfProxied,$tgMessage);
my ($cfSetIP,$tldate,$url,$req,$res,$json,$data,$cfDNSID,$cfLastModified,$cfContent,$cfCurrentContent,$IPInfoURLv4,$currentIP4,$currentIP6,$IPInfoURLv6,$currentDNS4,$dnsID,%hCheckDomain,$changeStat,$currentDNS6);
my ($MessageEnabled,$MessageID,$MessageType,$MessageBotID,$MessageChatID);


#Init
my $UseSyslog=1;
my $syslog=new Net::Syslog(Facility=>'local4',Priority=>'debug',SyslogHost=>"127.0.0.1");
my $xml = new XML::Simple (KeyAttr=>[]); 
my $ua = LWP::UserAgent->new();
$ua->agent('CFDDNS-2.1');
$cfCurrentContent=0; #init with something

GetOptions  #parameters
(
 "v!" => \$flag_verbose,
 "c=s" => \$opt_config,
 "h!" => \$flag_help,
 );


if ($flag_help) {
 &print_help;
 exit;
}

if (!$opt_config) {
 $configuration="cfddns2.xml";
} else {
 $configuration="$opt_config";
}

&ReadConfig($configuration); # Getting my xml configuration

if ($flag_verbose) {
 syslog("*** Starting DDNS IP Address Check ***");
 syslog("Configuration File: $configuration");
}

if (!-e $configuration) {
 print "configuration file ($configuration) does not exist\n";
 exit 1;
}


############
#Get V4 Addr
############
syslog("Request my IPv4 Address from $IPInfoURLv4");
$req = HTTP::Request->new(GET=>$IPInfoURLv4);
$res = $ua->request($req);

#syslog("Received IPv4: " . $res->content);
if ($res->is_success) {
 $data = $xml->XMLin($res->content,ForceArray => 0);
 $currentIP4=$data->{IP};
 syslog("Received IPv4: $currentIP4 ");
} else {
 syslog($res->status_line);
 exit;
}

for my $pnt ( sort keys %hCheckDomain ) {
 ###################
 #Get HOST A Record
 ###################
 my $cmdret=`host -t A $pnt`;
 if ($cmdret =~ /has address (.*)$/) {
  $currentDNS4=$1;
 }

 if (!$currentDNS4) {
  syslog("Error while receiving v4 host record ($pnt) - abort ");
  exit 1;
 }

 if ($currentIP4 ne $currentDNS4) {
  syslog("Detect IP4 change for $pnt DNS: $currentDNS4 Current: $currentIP4 ");
  $dnsID=getCFZoneID("A",$pnt);
  syslog("Get DNS ID: $dnsID");
  if (setCFDNSIP("A",$dnsID,$pnt,$currentIP4)) {
   syslog("IP change successfuly completed: $pnt");
   syslog("VER=4 IPOLD=$currentDNS4 IPNEW=$currentIP4 FQDN=$pnt"); #Splunk key/val design
   $tgMessage.="================%0A"; #Telegram message details, used with IPv4 only
   $tgMessage.="FQDN=$pnt%0A";
   $tgMessage.="OldIP=$currentDNS4%0A";
   $tgMessage.="NewIP=$currentIP4%0A";
  } else {
   syslog("Error with IP change: $pnt");
  }
 } else {
  syslog("No change for Type A Record $pnt = $currentDNS4");
 }  #if ($currentIP4 ne $currentDNS4)
}   #for my $pnt ( sort keys %hCheckDomain ) {

############
#Get V6 Addr
############
if ($IPInfoURLv6) {
 syslog("Request my IPv6 Address from $IPInfoURLv6");
 $req = HTTP::Request->new(GET=>$IPInfoURLv6);
 $res = $ua->request($req);
 if ($res->is_success) {
  $data = $xml->XMLin($res->content,ForceArray => 0);
  $currentIP6=$data->{IP};
  syslog("Received IPv6: $currentIP6 ");
 } else {
  #syslog("Error while receiving ipv6 address - abort ");
  syslog($res->status_line);
  exit 1;
 }

 for my $pnt ( sort keys %hCheckDomain ) {
  ###################
  #Get HOST AAAA Record
  ###################
  my $cmdret=`host -t AAAA $pnt`;
  if ($cmdret =~ /has IPv6 address (.*)$/) {
   $currentDNS6=$1;
  } 

  if ($currentDNS6) {
   if ($currentIP6 ne $currentDNS6) {
    syslog("Detect IP6 change for $pnt DNS: $currentDNS4 Current: $currentIP4 ");
    $dnsID=getCFZoneID("AAAA",$pnt);
    syslog("Get DNS ID: $dnsID");
    if (setCFDNSIP("AAAA",$dnsID,$pnt,$currentIP6)) {
     syslog("IP change successfuly completed: $pnt");
     syslog("VER=6 IPOLD=$currentDNS6 IPNEW=$currentIP6 FQDN=$pnt"); #Splunk key/val design
    } else {
     syslog("Error with IP change: $pnt");
    }
   } else {  #if ($currentIP6 ne $currentDNS6) 
    syslog("No change for Type AAAA Record $pnt = $currentDNS6");
   }  #if ($currentIP6 ne $currentDNS6) {
  }   #if ($currentDNS6)
 }    #for my $pnt ( sort keys %hCheckDomain ) 
}     #if ($IPInfoURLv6)

###################
#Telegram Messaging
###################
if (($MessageEnabled) and ($tgMessage)) {
 syslog("Send Telegram alert");
 my $tldate = strftime("%Y-%m-%d", localtime(time));
 my $tltime = strftime("%H:%M:%S", localtime(time));
 my $message="<strong>IP Address Change</strong>%0A";
 $message.="Date: $tldate%0A";
 $message.="Time: $tltime%0A";
 $message.=$tgMessage;
 my $ua = LWP::UserAgent->new();
 $ua->agent('sh-mqtt');
 my $url="https://api.telegram.org/bot" . $MessageBotID . "/sendMessage?chat_id=" . $MessageChatID . "&parse_mode=HTML&text=" . $message;
 my $req = HTTP::Request->new(GET=>$url);
 my $res = $ua->request($req);
 if ($res->is_success) {
  syslog("Telegram message has been sent");
 } else {
  syslog($res->status_line);
 }
}   #if ($MessageEnabled)



#########
#FINISHED
#########

sub syslog {
 if ($flag_verbose) {
  $tldate = strftime("%Y-%m-%d %H:%M:%S", localtime(time));
  print "$tldate $_[0]\n";
  #print FHLOG "$tldate $_[0]\n";
 }
 if ($UseSyslog) {
  $syslog->send("M=CF " . $_[0],Priority=>'info');
 } 
}

sub ReadConfig {
 my $xml = new XML::Simple (KeyAttr=>[]);
 my $data = $xml->XMLin("$_[0]",ForceArray => 0);
 $cfAuthKey=$data->{Settings}->{AuthKey};
 $cfZoneID=$data->{Settings}->{ZoneID};
 $cfDNSName=$data->{Settings}->{FQDN};
 $cfAuthMail=$data->{Settings}->{AuthMail};
 $cfTTL=$data->{Settings}->{TTL};
 $cfProxied=$data->{Settings}->{PROXIED};
 $IPInfoURLv4=$data->{Settings}->{IPInfo4};
 $IPInfoURLv6=$data->{Settings}->{IPInfo6};

 $MessageEnabled=$data->{Telegram}->{Enabled};
 $MessageID=$data->{Telegram}->{ID};
 $MessageType=$data->{Telegram}->{Type};
 $MessageBotID=$data->{Telegram}->{BotID};
 $MessageChatID=$data->{Telegram}->{ChatID};


 $data = eval {XMLin("$_[0]",ForceArray => 1)};
 for( @{$data->{DOMAIN}}){
  if ($_->{Enable}) {
   $hCheckDomain{$_->{FQDN}}=1;
  }
 }

}  #sub


sub print_help {
 print "Usage: $0 -c (optional path to configuration)  -v (optional verbose)  -h (print help) \n";
}


sub getCFZoneID {
 #Get my Cloudflare DNS ID
 $cfAddrType=$_[0];
 $cfDNSName=$_[1];
 #syslog("DebType type=$cfAddrType name=$cfDNSName");
 $url = "https://api.cloudflare.com/client/v4/zones/$cfZoneID/dns_records?type=$cfAddrType&name=$cfDNSName";
 syslog("Get Request: $url");
 $req = HTTP::Request->new(GET=>$url);
 $req->header('Content-Type' => 'application/json');
 $req->header('X-Auth-Key' => $cfAuthKey);
 $req->header('X-Auth-Email' => $cfAuthMail);
 $res = $ua->request($req);
 if ($res->is_success) {
  $json = JSON->new;
  $data = $json->decode($res->content);
  #print Dumper($data);
  for my $v (@{$data->{'result'}}){
   $cfDNSID=$v->{'id'};
   #$cfDNSID=$data->{'result'}->{'id'};
   $cfLastModified=$v->{'modified_on'};
   $cfCurrentContent=$v->{'content'};
   syslog("Received DNS ID: $cfDNSID");
   syslog("Received DNS Last modified: $cfLastModified");
   syslog("Received DNS Current Content: $cfCurrentContent");
  }
  return $cfDNSID;
 } else {  #if ($res->is_success)
  syslog("HTTP get error msg :  $res->message");
  $json = JSON->new;
  $data = $json->decode($res->content);
  syslog("Data Dump:");
  syslog(Dumper($data));
  exit 1;
 } #if ($res->is_success)
}  #Sub getCFZoneID

sub setCFDNSIP {
 $cfAddrType=$_[0];
 $cfDNSID=$_[1];
 $cfDNSName=$_[2];
 $cfSetIP=$_[3];

 #syslog("DEBUG: $cfAddrType--$cfDNSName--$cfSetIP-$cfTTL--$cfProxied");
 $url = "https://api.cloudflare.com/client/v4/zones/$cfZoneID/dns_records/$cfDNSID";
 syslog("Change Request: $url");
 my $json = '{"type":"'.$cfAddrType.'","name":"'.$cfDNSName.'","content":"'.$cfSetIP.'","ttl":'.$cfTTL.',"proxied":'.$cfProxied.'}';
 #syslog("Send Json Data XX: $json");
 $req = HTTP::Request->new(PUT=>$url);
 $req->header('Content-Type' => 'application/json');
 $req->header('X-Auth-Key' => $cfAuthKey);
 $req->header('X-Auth-Email' => $cfAuthMail);
 $req->content($json);
 my $res = $ua->request($req);
 if ($res->is_success) {
  #print "received the message " . $res->message;
  $json = JSON->new;
  $data = $json->decode($res->content);
  #print Dumper($data);
  $cfContent=$data->{'result'}->{'content'};
  $cfLastModified=$data->{'result'}->{'modified_on'};
  syslog("Result: IP Change complete - Message: " . $res->message);
  syslog("Result: Last modified at $cfLastModified => $cfContent");
  return 1;
 } else {  #if ($res->is_success) 
  #use Data::Dump qw/ dd /; dd( $res->as_string ); 
  syslog("HTTP get error msg : ", $res->message);
  exit 1;
 }         #if ($res->is_success) {
} #sub setCFDNSIP
