#!/usr/bin/python3
#Python3 DDNS script to get update your A or AAAA DNS record at Cloudflare.

# importing the requests library for CFDDNS
import requests 
import datetime
import xml.etree.ElementTree as ET
import requests
import ipaddress
import sys
import json
import socket
import os
import argparse



#https://jsoneditoronline.org/#left=local.yujigi&right=local.mubaro

def cfReadXML ():
 root = ET.parse('cfddns.xml').getroot()
 for type_tag in root.findall('Settings'):
   subcfKey = type_tag.get('AuthKey')
   subcfMail = type_tag.get('AuthMail')
   subcfZondeID = type_tag.get('ZoneID')
   subcfFQDN = type_tag.get('FQDN')
   subIPInfo = type_tag.get('IPInfo')
   subTTL = type_tag.get('TTL')
   subProxied = type_tag.get('Proxied')
   return subcfKey, subcfMail, subcfZondeID, subcfFQDN, subIPInfo, subTTL, subProxied


def syslog (strTxt):
 mydate = datetime.datetime.now()
 myformatdatestamp=(mydate.strftime("%Y-%m-%d %H:%M:%S "))
 myformatfiledate=(mydate.strftime("%Y-%m-%d-cfddns.txt ")) 
 f = open(directory + myformatfiledate, "a")
 f.write(myformatdatestamp + strTxt + "\n")
 f.close()
 if (verbose == 1):
     print (myformatdatestamp + strTxt )
     


def cfGetEnvironment():
 #Request the current CFID and CFIP
 #Return: cfIP, cfID
 #print (cfURL)
 r = requests.get(url = cfURL,headers=cfHeaders) 
 data = r.json()
 #json_string = json.dumps(data)
 #print (json_string)
 #exit
 cfIP = data['result'][0]['content']
 cfID  = data['result'][0]['id']
 return cfIP, cfID



def _do_dns_lookup(hostname: str, port: int) -> str:
    #Nice idea: https://www.programcreek.com/python/example/531/socket.getaddrinfo
    tentative_ipV6_addr=""
    ipver1=""
    
    try:
        addr_infos = socket.getaddrinfo(hostname, port, socket.AF_UNSPEC, socket.IPPROTO_IP)
    except (socket.gaierror, IndexError, ConnectionError):
        raise ServerHostnameCouldNotBeResolved(f"Could not resolve {hostname}")

    family, socktype, proto, canonname, sockaddr = addr_infos[0]

    # By default use the first DNS entry, IPv4 or IPv6
    tentative_ip_addr = sockaddr[0]
    
    try:
      ip = ipaddress.ip_address(sockaddr[0])
      #syslog('%s is a correct IP%s address. (1)' % (ip, ip.version))
      ipver=('%s' % (ip.version))
      #syslog("xxxx " + ipver)
      if (ipver == "6"):
       tentative_ipV6_addr = sockaddr[0]
       #print ("Save " + tentative_ipV6_addr + " " + ipver )
    except:
      syslog("Invalid address(2)")

    # But try to use IPv4 if we have both IPv4 and IPv6 addresses, to work around buggy networks
    for family, socktype, proto, canonname, sockaddr in addr_infos:
        if family == socket.AF_INET:
            tentative_ip_addr = sockaddr[0]
            try:
              ip = ipaddress.ip_address(sockaddr[0])
              #syslog('%s is a correct IP%s address. (1)' % (ip, ip.version))
              ipver=('%s' % (ip.version))
              #syslog("xxxx " + ipver)
              if (ipver == "6"):
                tentative_ipV6_addr = sockaddr[0]
                #print ("Save " + tentative_ipV6_addr + " " + ipver )
            except:
              syslog("Invalid address(2)")

    
    if len(tentative_ipV6_addr) >= 1:
      #print (" Return V6")
      #V6 has priority
      return tentative_ipV6_addr, "6"

  
    #print (" Return V4")
    return tentative_ip_addr, "4"

######################
#        MAIN
######################



#Get the first ARG, check if v (verbose)
verbose = 0
if len(sys.argv) == 2:
 #print ("Arg")
 a=sys.argv[1]
 #print (a)
 if (a == "-v" or a == "-V"):
     verbose = 1



#Automatic create directory as log dir
directory = './log/'
if not os.path.exists(directory):
    os.makedirs(directory)

#Simulating    
#verbose = 1

syslog("Starting CFDDNS")

#Get settings from the xml configuration file
cfKey, cfMail, cfZondeID, cfFQDN, IPInfo, cfTTL,cfProxied=cfReadXML()


#DNS Lookup, we get the ip addresss of cfFQDN, this is an optional thing
myDNSIP,myDNSVer=(_do_dns_lookup( cfFQDN, 0) )
syslog("DNS Lookup to " + cfFQDN + " = "+ myDNSIP + " (v" + myDNSVer + ")")


#Get current IP address
syslog ("Get my current IP address from: " + IPInfo)
objReq = requests.get(IPInfo)
strIP=objReq.text
strIP = strIP.strip('\n')  #Remove CRLF
#strIP="8.8.8.7" #simulating

    
#Check if the adddress is valid
try:
    ip = ipaddress.ip_address(strIP)
    ipVer=('%s' % (ip.version))
    #syslog('%s is a correct IP%s address.' % (ip, ip.version))
    #ipver=ip.version
    #if (ipVer == "4"):
    #  print("Version 4"  )
    #else:
    # if (ipVer == "6"):
    #  print("Version 6"  )
except ValueError:
    syslog('address/netmask is invalid: %s' % strIP)
    sys.exit(-1)

syslog("My current IP address is: " + strIP + "  (v" + ipVer + ")")
if (ipVer == myDNSVer):
 syslog("Protocol is matching: " + myDNSVer)
else:
 syslog("Protocol mismatch: " + myDNSVer + "/" + ipVer)
 sys.exit(-1)


###myDNSIP = "a02:2e0:3f9:1::2"
if (myDNSIP == strIP):
 syslog ("Gethostbyname is matching your current IP ")
 syslog ("Status: No change")
 sys.exit(-1)
else:
 syslog ("Gethostbyname is NOT matching your current IP ")
 syslog ("Status: Get IP Data from CloudflareChange")

#Construct header and URL
cfHeaders = {'Content-type': 'application/json', 'X-Auth-Key':cfKey,'X-Auth-Email':cfMail}
if (ip.version == 6):
    CFZoneType="AAAA"
else:
    CFZoneType="A"

#Covering both IP types, A and AAAA
cfURL = "https://api.cloudflare.com/client/v4/zones/" + cfZondeID + "/dns_records?type=" + CFZoneType + "&name=" + cfFQDN
syslog("Get ID for " + strIP)

#Get current environment from cloudflare
syslog("Get environment by: " + cfURL)
cfIP, cfID=cfGetEnvironment()
syslog("Cloudflare ID " + cfID )
syslog("Cloudflare IP: " + cfIP)


boolStat=0
#if strIP != cfIP or myDNSIP != cfIP : #This would check the DNS IP as well
if strIP != cfIP :
    syslog ("Status: Change IP at Cloudlare")
    boolStat=1
else:
    syslog ("Status: No change required")




if boolStat == 1:
    syslog ("Starting change")
    payload = {
        "type": CFZoneType,
        "name": cfFQDN,
        "content": strIP
    }
    cfHeaders = {'Content-type': 'application/json','X-Auth-Key':cfKey,'X-Auth-Email':cfMail,'ttl':cfTTL,'proxied':cfProxied}
    cfChangeURL = "https://api.cloudflare.com/client/v4/zones/" + cfZondeID + "/dns_records/" + cfID
    r = requests.put(cfChangeURL, data=json.dumps(payload), headers=cfHeaders)
    print(r.content)
    data = json.loads(r.content)
    syslog("Success - modified on: " + data['result']['modified_on'])

