
#Powershell DDNS script to get update your A or AAAA DNS record at Cloudflare. - Mar2022


param (
    [switch]$v = $false  #-v verbose
)

function main {

 [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12  #Enforce tls12


 $LogName="cfddns.log"

 #You might need to modify this value
 #$SSLProtos="Tls11, Tls12"

 #$cfAddrType= 'AAAA'  #ip v6
 $cfAddrType="A"      #ip v4

 syslog "************"
 syslog "Apply CFDDNS"
 syslog "************"
 syslog ""
 syslog "Get configuration:`t`tcfddns.xml"

 $Config = "cfddns.xml"
 $XPath = "/CONFIG/Settings"
 Select-Xml -Path $Config -XPath $Xpath |  foreach {
  $cfAuthKey = $_.node.AuthKey
  $cfZoneID = $_.node.ZoneID
  $cfAuthMail = $_.node.AuthMail
  $cfDNSName = $_.node.FQDN
  $cfIPInfo = $_.node.IPInfo
  $cfTTL = $_.node.TTL
  $cfProxied = $_.node.Proxied
  $cfIPInfo = $_.node.IPInfo
 }


 if ($cfProxied -eq "false") {  #Format proxy settings
  $cfProxied=$false
 } else {
  $cfProxied=$true
 } 

 $headers = @{  #Set CF Auth Headers
    'X-Auth-Key' = $cfAuthKey
    'X-Auth-Email' = $cfAuthMail
 }


 
 $ipaddr = Invoke-RestMethod -Method 'Get' -uri  $cfIPInfo 
 #$ip = $($ipaddr.ip)  #If this is a object like json
 $ip = $ipaddr
 $ip = [string]::join("",($ip.Split("`n")))  #remove crlf
 syslog("My current IP is`t`t$ip")

 #Get my Cloudflare Zone ID, modified date and IP
 $url = "https://api.cloudflare.com/client/v4/zones/$cfZoneID/dns_records?type=$cfAddrType&name=$cfDNSName";
 $zone = Invoke-RestMethod -Uri $url -Method Get -Headers $headers 

 syslog "Received DNS ID`t`t`t$($zone.result.id)"
 syslog "Received last Modified:`t`t$($zone.result.modified_on)"
 syslog "Received last Content:`t`t$($zone.result.content)"

 if ($($zone.result.id)) {
  if ($($zone.result.content) -ne $ip) {
   #Nice idea https://github.com/fire1ce/DDNS-Cloudflare-PowerShell
   $url = "https://api.cloudflare.com/client/v4/zones/$cfZoneID/dns_records/$($zone.result.id)";
   $record = @{
	"type" = "A"
	"name" =  $cfDNSName
	"content" = $ip
	"ttl" = $cfTTL
	"proxied" = $cfProxied
    }
   $body = $record | ConvertTo-Json
   $request = Invoke-RestMethod -Uri $url -Method PUT -Headers $headers -Body $body -ContentType "application/json"  -SslProtocol $SSLProtos 
   syslog "Success - last Modified:`t$($request.result.modified_on)"
  } else {
   syslog "Nothing to do"
  } 
 } else {
  syslog "Error on response"
 } 
}  #func

function syslog ($strText) {
 if ($v) {
  $WorkingDir=get-location
  $LogDir = "$WorkingDir\log"
  If(!(test-path $LogDir)) {
      New-Item -ItemType Directory -Force -Path $LogDir | out-null
  }

  $Date=Get-Date
  $DateStr = $Date.ToString("yyyy-MM-dd HH:mm:ss")
  $LogStr = $Date.ToString("yyyyMMdd")
  $LogName = "$LogStr-cfddns.log"
  write-host "$strText"
  Out-File -FilePath "$LogDir\$LogName" -InputObject "$DateStr $strText"  -Encoding ASCII -Append
 } 
}	
 
main
exit 0