#!/usr/bin/perl
#Perl DDNS script to get update your A or AAAA DNS record at Cloudflare.

#1.1 - Added TTL 03Mar2022
#    - Changed default provider to ipconfig.io

use strict;
use warnings;
use LWP;               #Used to talk to Cloudflare
use JSON qw( );        #Used to decrypt json 
use POSIX;             #Used for time stuff
use File::Path;        #Used to mkdir the log path if verbose is given
use Data::Dumper;      #Used to dump json data 
use Getopt::Long;      #Used to read command params
use XML::Simple;       #Used to read the configuration file
use Net::IP ':PROC';   #Used to get the IP version


#vars
my ($cfZoneID,$cfAddrType,$cfDNSName,$cfAuthKey,$cfAuthMail,$flag_verbose,$opt_config,$configuration,$flag_help,$cfTTL,$cfProxied);
my ($cfSetIP,$tldate,$url,$req,$res,$json,$data,$cfDNSID,$cfLastModified,$cfContent,$cfCurrentContent,$IPInfoURL);
 

#Init
my $ua = LWP::UserAgent->new();
$ua->agent('CFDDNS-1.1');
$cfCurrentContent=0; #init with something

GetOptions  #parameters
	(
	 "v!" => \$flag_verbose, 
	 "c=s" => \$opt_config, 
	 "h!" => \$flag_help, 
 );


if ($flag_help) {
	&print_help;
	exit;
}

if (!$opt_config) {
	$configuration="cfddns.xml";
}	 else {
	$configuration="$opt_config";
}

&ReadConfig($configuration); # Getting my xml configuration

if ($flag_verbose) {
 mkpath('./log',0,1777); 
 my $tldate = strftime("%Y%m%d", localtime(time));              
 open (FHLOG, ">>./log/$tldate-cfddns.log") or die "no such file";
 syslog("*** Starting DDNS IP Address Check ***");
 syslog("Configuration File: $configuration");
} 

if (!-e $configuration) {
	print "configuration file ($configuration) does not exist\n";
}	

syslog("Request my IP Address from $IPInfoURL");
$req = HTTP::Request->new(GET=>$IPInfoURL);
$res = $ua->request($req);
syslog("Received: " . $res->content);
my $ip = (new Net::IP ($res->content) or die ('Invalid data received from '.$IPInfoURL));
my $ipver=$ip->version();


if ($ipver == 4) {
 $cfAddrType = 'A';
 $cfSetIP=$res->content;
 syslog("IP Address Type: v4");
}	
	
if ($ipver == 6) {
 $cfAddrType = 'AAAA';
 $cfSetIP=$res->content;
 syslog("IP Address Type: v6");
}	

$cfSetIP =~ s/\n//g;  #Remove CR
#$cfSetIP = '37.24.34.37';  #Simulate change

if ($cfSetIP) {
 syslog("Current IP Address: $cfSetIP");
} else {
 print "cannot get ip address"
} 
 


#Get my Cloudflare Zone ID
$url = "https://api.cloudflare.com/client/v4/zones/$cfZoneID/dns_records?type=$cfAddrType&name=$cfDNSName";
syslog("Sendrequest: $url");
$req = HTTP::Request->new(GET=>$url);
$req->header('Content-Type' => 'application/json');
$req->header('X-Auth-Key' => $cfAuthKey);
$req->header('X-Auth-Email' => $cfAuthMail);
$res = $ua->request($req);
if ($res->is_success) {
 $json = JSON->new;
 $data = $json->decode($res->content);
 #print Dumper($data);
 for my $v (@{$data->{'result'}}){
   $cfDNSID=$v->{'id'};
   #$cfDNSID=$data->{'result'}->{'id'};
   $cfLastModified=$v->{'modified_on'};
   $cfCurrentContent=$v->{'content'};
   syslog("Received DNS ID: $cfDNSID");
   syslog("Received DNS Last modified: $cfLastModified");
   syslog("Received DNS Current Content: $cfCurrentContent");
 }		
} else {
 print "HTTP get error msg : ", $res->message, "\n";
 $json = JSON->new;
 $data = $json->decode($res->content);
 print "Data Dump:\n";
 print Dumper($data);
 exit;
}	


if (($cfSetIP eq $cfCurrentContent) and ($cfCurrentContent)) {
	syslog("Result: IP $cfSetIP is already set, nothing to do - ABORT");
	exit;
}


if ($cfDNSID) { #Change A/AAAA Record if needed
 $url = "https://api.cloudflare.com/client/v4/zones/$cfZoneID/dns_records/$cfDNSID";
 syslog("Sendrequest: $url");
 my $json = '{"type":"'.$cfAddrType.'","name":"'.$cfDNSName.'","content":"'.$cfSetIP.'","ttl":'.$cfTTL.',"proxied":'.$cfProxied.'}';
 #syslog("Send Json Data XX: $json");
 $req = HTTP::Request->new(PUT=>$url);
 $req->header('Content-Type' => 'application/json');
 $req->header('X-Auth-Key' => $cfAuthKey);
 $req->header('X-Auth-Email' => $cfAuthMail);
 $req->content($json);
 my $res = $ua->request($req);
 if ($res->is_success) {
    #print "received the message " . $res->message;
    $json = JSON->new;
    $data = $json->decode($res->content);
    #print Dumper($data);
    $cfContent=$data->{'result'}->{'content'};
    $cfLastModified=$data->{'result'}->{'modified_on'};
    syslog("Result: IP Change complete - Message: " . $res->message);
    syslog("Result: Last modified at $cfLastModified => $cfContent");
 } else {
    #use Data::Dump qw/ dd /; dd( $res->as_string ); 
    print "HTTP get error msg : ", $res->message, "\n";
    exit;
 }
} else {
	syslog("No DNS ID received, check settings, check email");
}

sub syslog {
 if ($flag_verbose) {
	$tldate = strftime("%Y-%m-%d %H:%M:%S", localtime(time));              
	print "$tldate $_[0]\n";
	print FHLOG "$tldate $_[0]\n";
 }	
}

sub ReadConfig {
 my $xml = new XML::Simple (KeyAttr=>[]); 
 my $data = $xml->XMLin("$_[0]",ForceArray => 0);
 $cfAuthKey=$data->{Settings}->{AuthKey};
 $cfZoneID=$data->{Settings}->{ZoneID};
 $cfDNSName=$data->{Settings}->{FQDN};
 $cfAuthMail=$data->{Settings}->{AuthMail};
 $cfTTL=$data->{Settings}->{TTL};
 $cfProxied=$data->{Settings}->{PROXIED};
 $IPInfoURL=$data->{Settings}->{IPInfo};
}


sub print_help {
	print "Usage: $0 -c (optional path to configuration)  -v (optional verbose)  -h (print help) \n";
}