#!/usr/bin/perl 

#############
#Reboot Host
#############


#2.0.1.9 - Add Shutdown and Wake Up Modes, add parameter mode, 1=Reboot,2=Shut Down,3=Waku Up - May2011
#Add Fields
#ALTER TABLE `mylvs`.`tblResources` ADD COLUMN `cmd_shutdown_id` INTEGER(8) UNSIGNED AFTER `mac`,
# ADD COLUMN `cmd_wakeup_id` INT(8) UNSIGNED AFTER `cmd_shutdown_id`;

#ToDo: Need weightdown stat in automove function 28aug06

#ToDo: Add: SendEmergencyEMail

#####################################################################
#####################################################################

use warnings;
use strict;
use DBI;
use POSIX;


####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############
####################################################################
my $basepath=$ENV{DOCUMENT_ROOT};
my $server = $ENV{HTTP_HOST};
####################################################################
my $httproot="http://'.$server.'/";
my $retscriptname="mylvshst.pl";
#Remember this:   <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>

####################### CONFIGURATION #######################
my $version = "2.0.1.9";

#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};

my $granted = undef;  #user login flag - default off
#For static test purposes ...
#$tparam = "to=2";
#$tparam = "wu=1";
#$tparam = "wd=1";
#$tparam = "to=1";
#$tparam = "td=4";
#####################################################################
#####################################################################

#$httproot$retscriptname

my ($sqlAlias,$sqlIP,$GlobalAlias,$GlobalIP,$GlobalMAC,$GlobalTxt,$replstr,$weightdownstate);
my (%ResInvID,$ResWeight,$dbh,$mstring,$mxstring,$var,$value,$auto_ok,$slqEnabled,$slqMAC,$sEnabled);
my ($NodeService,$NodeVip,$sqlnoden,$sqlcur,$sqlInvID,$sqlInvTID,$sqlInvWeight,$sqlNodeID,$sqlLink,$sqlIPort,$sqlinv,$sqlalias,$sqlactive,$sqlmethod,$sqlweight,$sqlenabled,$sqlPoolID,$sqlWeightStat,$curstat,$sqlpool,$sqlPoolReource,$sqlAliasEnabled,$mdstring,$slqCmdreboot,$slqCmdwakeup,$slqCmdshutdown);
my ($resID,$invID,$rstID,$runcmd,$runcmdname);
my $showid;  #=1;  #Ste TestID !!!
my ($myIP,$myHost,$myCHost,$mode);

$granted=&chkuser($curuser);  #Check User
print &HTMLHeader;
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 

#if ($tparam =~ m/^resid=(\d*)&invid=(\d*)&rstid=(\d*)/){  

$mode=0; #2.0.1.9
if ($tparam =~ m/mode=(\d*)/){   #2.0.1.9
	$mode=$1;
}	


$GlobalAlias="Apply Command ";
$GlobalTxt="Server:";
print &HTMLStartOutsideTable;
print &HTMLStartInsideTable;


if ($tparam =~ m/^id=(\d*)/){  
	#$showid=$2;
  $sqlalias = $dbh->prepare("SELECT alias,realip,cmd_reboot_id,enabled,mac,cmd_shutdown_id,cmd_wakeup_id FROM tblResources where resID = '" . $1 . "';" ); 
  $sqlalias->execute ; #Get Inventory and ID's
  (($sqlAlias,$sqlIP,$slqCmdreboot,$slqEnabled,$slqMAC,$slqCmdshutdown,$slqCmdwakeup)=$sqlalias->fetchrow_array);
  $GlobalAlias=$sqlAlias;
  $GlobalIP=$sqlIP;
  $GlobalMAC=$slqMAC;
  
  
  #print "$GlobalMAC<BR>";
  $resID=$1;
  $sEnabled=$slqEnabled;
  #$invID=$2;
  #$rstID=$3;
  $retscriptname=$retscriptname."?edit=$resID";
  if ($mode eq 1){
   my $sqlcmd = $dbh->prepare("SELECT name,command FROM tblCommands where cmdID = '" . $slqCmdreboot . "';" ); 
   $sqlcmd->execute ; #Get Inventory and ID's
   (($runcmdname,$runcmd)=$sqlcmd->fetchrow_array);
   $runcmd=&GetChkCmd($runcmd,$GlobalIP);
   
   }	else {
  	if ($mode eq 2){
     my $sqlcmd = $dbh->prepare("SELECT name,command FROM tblCommands where cmdID = '" . $slqCmdshutdown . "';" ); 
     $sqlcmd->execute ; #Get Inventory and ID's
     (($runcmdname,$runcmd)=$sqlcmd->fetchrow_array);
     $runcmd=&GetChkCmd($runcmd,$GlobalIP);
     #$runcmd=&GetChkMac($runcmd,$GlobalMAC);
     #print "==== $runcmd $sqlcmd<BR>";
  	} else {	
  	 if ($mode eq 3){
      
      my $sqlcmd = $dbh->prepare("SELECT name,command FROM tblCommands where cmdID = '" . $slqCmdwakeup . "';" ); 
      $sqlcmd->execute ; #Get Inventory and ID's
      (($runcmdname,$runcmd)=$sqlcmd->fetchrow_array);
      $runcmd=&GetChkCmd($runcmd,$GlobalIP,$GlobalMAC);
  	 } else {	
  	  print "Invalid Mode\n";
      print &HTMLEndInsideTable;
      print &HTMLEndOutsideTable;
      print &HTMLEndHeader;
      exit;  	
     } 
    } 
   }
   #print "Apply:<BR>";
   #print "$runcmd<BR>";


  
  #$runcmdname=$slqCmdreboot;
}  


 
if ($granted) {

 if ($mode le 3){   #2.0.1.9
  #print "$resID-$invID-$rstID";
  if ($runcmd) {
   &lvslog(3,"Applied Reboot: $runcmd",$curuser);
   if ($sEnabled) {
  	print  "Please turn off all services first on this server<BR>";
   } else {               #if ($sEnabled)
  	
    if ($simulate eq "0") {
     print  "Apply: $runcmd<BR>";
	   `$runcmd`;   #Run command
	   print  "\nDone!<BR>";
	  } else {             #if ($simulate eq "0")
 	 	 print  "Simulation Mode !!<BR>";
     print  "Apply: $runcmd<BR>";
	   ###`$runcmd`;   #Run command
	   print  "\nDone!<BR>";
	  }                     #if ($simulate eq "0")
	 }                      #if ($sEnabled)
	} else {                #if ($runcmd)
   print  "Command Not Configured<BR>";
  }                       #if ($runcmd) 
 } else {
 	# print  "Mode Unknown<BR>";
 }


 




} else {
 print "No Permissions To Reboot This Server !";	
}            #if ($granted)  
print &HTMLEndInsideTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;



 
 
sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}


sub lvslog {
 #Logs into sql
 #$_[0] = Code (used for the image)
 #$_[1] = Message
 #$_[2] = User
 #my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','$_[1]');" );
 my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message,epoche) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','".$_[1]."','".time."');" );
 $sqlcur->execute;
}



sub HTMLHeader {
#<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
my $ret='Content-type: text/html; charset=iso-8859-1

<html>
<head>
<title>LVS</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.fontairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #979696;
}
.fontnormal {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #979696;
}
.ecke-top-hg-lft {
	background-image: url(images/ecke-top-hg-lft.gif);
	background-repeat: repeat-y;
	background-position: right;
}
.whitefield {
	background-color: #FFFFFF;
	border: 1px solid #cfcfcf;
}
-->
</style>
<style type="text/css">
<!--
.fontblacksmall {
	font-family: Verdana;
	font-size: 10px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
-->
</style>
</head>
';
	
return $ret;	
}



sub HTMLStartOutsideTable {
my $ret='
<body><br>
<!-- Aussentabelle -->
<table width="830" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">LVS Service Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$GlobalAlias.'<span class="fontnormal"> (</span><span class="fontnormal">'.$GlobalIP.'
          )</span></td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
';	
return $ret;		
}

sub HTMLStartInsideTable {
my $ret='
      <!-- Hier kommt innentabelle rein ! --><br>
      <br>
      <table width="549" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-lft.gif" width="19" height="11"></td>
          <td height="11" valign="bottom" background="/images/t2_top-hg.gif"></td>
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-rt.gif" width="19" height="11"></td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td bgcolor="f8f8f8" class="fontairname">'.$GlobalTxt.'</td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td class="whitefield"><br>
          <table width="90%" border="0" align="center" cellpadding="0" cellspacing="0">
           <tr>
           <td class="fontblacksmall">
 ';	                
 return $ret;		
}
                
                
                
sub HTMLEndInsideTable {
my $ret='
              </td>
              </tr>
            </table>
            <br>
          </td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-lft.gif" width="19" height="19"></td>
          <td height="19" background="/images/t2_bottom-hg.gif">&nbsp;</td>
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-rt.gif" width="19" height="19"></td>
        </tr>
        <tr> 
          <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
          <td width="19">&nbsp;</td>
        </tr>
      </table>
      <!-- Innere Tabelle -->
 ';	                
 return $ret;		
}

sub HTMLEndOutsideTable {
my $ret='
       <br>
        <!-- Innere Tabelle -->    
      </p>

      </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>

          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub GetChkCmd {
  $_=$_[0];  #Prepare string filter
  s/%HOST%/$_[1]/;
  s/%MAC%/$_[2]/;
  return $_;
}



sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT reboot FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	