#!/usr/bin/perl 

###########
#Show Nodes
###########

#2.0.5 - Add v6

#To Do: Fix missing display stats for v6

#####################################################################
#####################################################################

use warnings;
use strict;
use DBI;
use POSIX;
use Net::SNMP;  #Used for live http users

use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript);


####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############



$lvscmd=$lvscmd." -Ln";
my $retscriptname="mylvshst.pl";


####################### CONFIGURATION #######################
my $version = "2.0.5";

#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;  #user login flag - default off
#####################################################################
#####################################################################


my ($dbh,$hdeb,%NodeIDv6,%NodeIDv4);   #2.0.5
my $prtDeb=undef;  #2.0.5 - set to undef for non debug

my (%NodeID,%NodeAddress,%NodePort,%NodeScheduler,%NodePersistent,%NodePersistentTimeout,%NodeProto,%ResSNMPKey,%ResSNMPPass,%ResSNMPPort,%ResSNMPTO,%ResSNMPEnable);
my (%RSAddress,%RSPort,%RSRoute,%RSWeight,%RSActive,%RSInActive,$curmodeID,$curmodePropertyID,%ResIP,%ResKEY,%ResActiveSrvTot,%ResInActiveConTot,%ResWeightCur,%ResActiveConTot);
&GetLVSOutput;



$granted=&chkuser($curuser);  #Check User
#print &HTMLHeader;
print htmlmainheader;
print htmlmaintab(4,685,0);
print htmlmaincss;
print jscript;
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
print &HTMLStartOutsideTable;
#print &HTMLStartInsideTable;
 
#if ($granted) {
#} else {
#print "No Permissions To Reset This Service !";	
#}            #if ($granted)  


my ($img_status,$img_monitor,$txt_status,$txt_monitor,$txt_server,$txt_active,$txt_inactive,$txt_http,$class_server,$class_http,$active_class,$inactive_class);
my (%Servers,%SNMP_RESID,%SNMP_Node,$sqlresip,%SNMP_Server,$resources,$cnt_tot_http,$cnt_tot_active,$cnt_tot_inactive,%MON_STAT);
my ($sqlsnmpkey,$sqlsnmppass,$sqlsnmpport,$sqlsnmptimeout,$sqltsnmpID,$CurHTTPUsers);
my (%Ssnmpkey,%Ssnmppass,%Ssnmpport,%Ssqlsnmptimeout,%SsqltsnmpID,%SsqltsnmpKEY,%NodeUsers,%NodeActive,%NodeInActive,%NodeServers);
my ($SQLscheduler,$SQLservice,$SQLvip,$SQLpersistent,$var,$val,$tmpIP,$tmpPort) ;

my $sqnodes = $dbh->prepare("SELECT nodeid,enabled,name,monitor,scheduler,service,vip,persistent,vip6 FROM tblNodes" ); 
$sqnodes->execute ; #Get Resources
 while (my($SQLnodeid,$SQLenabled,$SQLname,$SQLmonitor,$SQLscheduler,$SQLservice,$SQLvip,$SQLpersistent,$SQLvip6)=$sqnodes->fetchrow_array) {
  $MON_STAT{$SQLnodeid}=1;
  my $sqinvq = $dbh->prepare("SELECT invid,resid,snmpid FROM tblNodesInventory where nodeid='".$SQLnodeid."' and active='1' and enabled='1' "); 
  $sqinvq->execute ; #Get Resources
  while (my($SQLinvid,$SQLresid,$SQLsnmpid)=$sqinvq->fetchrow_array) {
   $Servers{$SQLnodeid}++;
   #if ($SQLvip6) { #2.0.5
   #	$Servers{$SQLnodeid}++;
   #}
   
   
   #Check Monitors
   my $sqlmon = $dbh->prepare("SELECT status FROM tblMonitor where invID='".$SQLinvid."' and enabled='1'"); 
   $sqlmon->execute ; #Get Resources
   while (my($SQLMonstat)=$sqlmon->fetchrow_array) {
    if (($SQLMonstat eq "OK") and ($MON_STAT{$SQLnodeid})) {
   	$MON_STAT{$SQLnodeid}=1;
   	#print "DEBUG $SQLMonstat-$SQLinvid\n"; 
    } else {
   	$MON_STAT{$SQLnodeid}=undef;
   	#print "DEBUG $SQLMonstat-$SQLinvid\n"; 
     #last;     		
    } 
   }
   if ($MON_STAT{$SQLnodeid}) {
    #print "=DEBUG $SQLnodeid-$MON_STAT{$SQLnodeid}\n"; 
   } else {
    #print "=DEBUG $SQLnodeid-0\n"; 
   } 
   
   if  ($SQLsnmpid ne "0"){
    $SNMP_Server{$SQLinvid}=$SQLresid;
    $SNMP_RESID{$SQLinvid}=$SQLsnmpid;
    #$MON_STAT{$SQLinvid}=undef;
   } 
  }
  
  my $sqlsnmp = $dbh->prepare("SELECT snmpID,snmpkey,snmppass,snmpport,snmptimeout FROM tblSNMP;" ); 
  $sqlsnmp->execute ; 
  while (($sqltsnmpID,$sqlsnmpkey,$sqlsnmppass,$sqlsnmpport,$sqlsnmptimeout)=$sqlsnmp->fetchrow_array){
  	$Ssnmppass{$sqltsnmpID}=$sqlsnmppass;
  	$Ssnmpport{$sqltsnmpID}=$sqlsnmpport;
  	$Ssqlsnmptimeout{$sqltsnmpID}=$sqlsnmptimeout;
  	$SsqltsnmpID{$sqltsnmpID}=$sqltsnmpID;
  	$SsqltsnmpKEY{$sqltsnmpID}=$sqlsnmpkey;
  }

  for $resources (sort keys %SNMP_RESID ){  
   if ($SNMP_RESID{$resources} ne 0) {
    my $sqlqres = $dbh->prepare("SELECT realip FROM tblResources where resID = '" . $SNMP_Server{$resources} . "';" ); 
    $sqlqres->execute; 
    (($sqlresip)=$sqlqres->fetchrow_array);
    $CurHTTPUsers= &GetSnmpVal ($sqlresip,$SsqltsnmpKEY{$SNMP_RESID{$resources}},$Ssnmppass{$SNMP_RESID{$resources}},$Ssnmpport{$SNMP_RESID{$resources}},$Ssqlsnmptimeout{$SNMP_RESID{$resources}});
    $NodeUsers{$SQLnodeid}+=$CurHTTPUsers;
   }
  }



  
  if (uc($SQLservice) ne "FWM") {
   if ($SQLvip) {
    $hdeb.="xx $SQLservice - $SQLvip<br>";
    ($var,$val) = split(/:/,$SQLvip,2);     #Get IP:Port
    $tmpIP=$var;
    $tmpPort=$val;
    #print "$SQLscheduler-$SQLservice-$SQLvip-$SQLpersistent-$tmpIP-$tmpPort\n";
   } else {
    if ($SQLvip6) {
   	 $hdeb.="xx V6 $SQLservice - $SQLvip6 -- $tmpIP<br>";
   	 if ($SQLvip6 =~ /^(.*):(\d+)$/){
      $tmpIP=$1;
      $tmpPort=$2;
   	  $hdeb.="xx $SQLservice - $SQLvip6 -->>>s $tmpIP // $tmpPort<br>";
   	 } 
    }	
   } 
  } else {
   $tmpIP=$SQLvip;	
   #print "$SQLscheduler-$SQLservice-$SQLvip-$SQLpersistent\n";
  }

 




  for my $pntbase (sort keys %NodeID){  #Enum LVS Inventory and enum real nodes and services
   
   if ($SQLenabled eq "1") {
   	
    if ($NodeScheduler{$pntbase}	eq $SQLscheduler) {  #Thats a great misconfiguration point !!!!
  	 #print " \n";
  	 if (uc($NodeProto{$pntbase}) ne "FWM") {
  	 		
 		  if (uc($NodeProto{$pntbase}) eq uc($SQLservice)) {
 		  	#$hdeb.="blaxx $NodeAddress{$pntbase} - $tmpIP -- $tmpPort<br>"; 		   	
 		   if ($tmpIP eq $NodeAddress{$pntbase}) {
 		   	
 		    if ($tmpPort eq $NodePort{$pntbase}) {	
 		    	$hdeb.="bla $NodeAddress{$pntbase} - $tmpIP -- $tmpPort<br>"; 		   	
 		     #print "$NodeID{$pntbase} \n";
 		     #print "$NodeProto{$pntbase} \n";
 		     #print "$NodeAddress{$pntbase} \n";
 		     #print "$NodePort{$pntbase} \n";
         #print "$NodeScheduler{$pntbase} \n";
         #print "$NodePersistent{$pntbase} \n";
         #print "$NodePersistentTimeout{$pntbase} \n\n";
         for my $pntval (sort keys %{$RSAddress{$pntbase}} ){
         	#print "=>$SQLnodeid-$RSAddress{$pntbase}{$pntval} - $RSActive{$pntbase}{$pntval} - $RSInActive{$pntbase}{$pntval}\n";
         	$hdeb.=("=YYYXXXXX>$SQLnodeid-$RSAddress{$pntbase}{$pntval} - $RSActive{$pntbase}{$pntval} - $RSInActive{$pntbase}{$pntval} // $pntbase // $pntval<br>");
         	#%NodeActive,%NodeInActive
         	$NodeActive{$SQLnodeid}+=$RSActive{$pntbase}{$pntval};
         	$NodeInActive{$SQLnodeid}+=$RSInActive{$pntbase}{$pntval};
         	$hdeb.=("=FINAL  $NodeActive{$SQLnodeid} // NodeID $SQLnodeid	 // $pntbase // $pntval //--// $RSAddress{$pntbase}{$pntval}<br>");
         	if ($RSAddress{$pntbase}{$pntval} =~ /\./) {  #2.0.5 count only v4 as server
         	 $NodeServers{$SQLnodeid}++; 
         	 $NodeIDv4{$SQLnodeid}=1;
         	 $hdeb.=("=FINALv4  PLUS<br>");
         	} 
         	
         	if (!$NodeIDv4{$SQLnodeid}) {  #2.0.5
            #aloa
         		$NodeServers{$SQLnodeid}++;
         		$hdeb.=("=FINALv6  PLUS<br>"); 
         	}	
         	
         }	
        } 
       }
      }
   	 } 
   	 if (uc($NodeProto{$pntbase}) eq "FWM") {
   	 	#print "XXX====>>>> $SQLnodeid - $SQLservice - $NodeProto{$pntbase}- $SQLvip - $NodeAddress{$pntbase}\n";
   	  if (uc($NodeProto{$pntbase}) eq uc($SQLservice)) {
   	   #print "====>>>> $SQLnodeid - $SQLservice - $SQLvip - $NodeAddress{$pntbase}\n";
   	   if ($SQLvip eq $NodeAddress{$pntbase}) {
   	   #print "$NodeID{$pntbase} \n";
 		   for my $pntval (sort keys %{$RSAddress{$pntbase}} ){
      	 #print "=>$SQLnodeid-$RSAddress{$pntbase}{$pntval} - $RSActive{$pntbase}{$pntval} - $RSInActive{$pntbase}{$pntval}\n";
      	 $NodeActive{$SQLnodeid}+=$RSActive{$pntbase}{$pntval};
       	 $NodeInActive{$SQLnodeid}+=$RSInActive{$pntbase}{$pntval};
       	 $NodeServers{$SQLnodeid}++;
        } 
       }	
 		  }
   	 }
    } 	
   }	
  }
  #exit;


  
  for $resources (sort keys %SNMP_RESID ){  #Delete Temp. SNMP Hash
   delete $SNMP_RESID{$resources};
   delete $SNMP_Server{$resources};
  }

  #Pseudo defaults
  $class_server="fontblacksmall";
  $class_http="fontblacksmall";
  $active_class="fontblacksmall";
  $inactive_class="fontblacksmall";




  $img_monitor='/images/yellow.gif';
  $txt_monitor="OK2";
  #$txt_active=$NodeActive{$SQLnodeid};
  #$txt_inactive=$NodeInActive{$SQLnodeid};
  #$txt_inactive="3";


  if ($MON_STAT{$SQLnodeid}) {
   $img_monitor='/images/green.gif';
   $txt_monitor="OK";
  } else { 
   $img_monitor='/images/yellow.gif';
   $txt_monitor="Some monitors are showing errors";
  }

  if ($SQLenabled eq "1") {
   $img_status='/images/green.gif';
   $txt_status="OK";
  } else {
   $img_status='/images/blue.gif';
   $img_monitor='/images/blue.gif';
   $txt_status="OFF";
   $txt_monitor="OFF";
   $txt_active="-";
   $txt_inactive="-";
  }	 

  
  if ($NodeUsers{$SQLnodeid}) {
   $txt_http=$NodeUsers{$SQLnodeid};
   $cnt_tot_http+=$NodeUsers{$SQLnodeid};
  } else {
   $txt_http="-";
  }
  
  
  if ($NodeActive{$SQLnodeid}) {
   $txt_active=$NodeActive{$SQLnodeid};
   $cnt_tot_active+=$NodeActive{$SQLnodeid};
   $active_class="fontblacksmall";
  } else {
   $txt_active="-";
  }

  if ($NodeInActive{$SQLnodeid}) {
   $txt_inactive=$NodeInActive{$SQLnodeid};
   $cnt_tot_inactive+=$NodeInActive{$SQLnodeid};
  } else {
   $txt_inactive="-";
  }

 
  if ($Servers{$SQLnodeid}) {
   if ($Servers{$SQLnodeid} eq $NodeServers{$SQLnodeid}) {  #Set Col.
    $txt_server=$Servers{$SQLnodeid}."/".$NodeServers{$SQLnodeid};
    $class_server="fontblacksmall";
   } else {
    $txt_server=$Servers{$SQLnodeid}."/".$NodeServers{$SQLnodeid};
    $class_server="fontorangebold";
    $img_status='/images/yellow.gif';
    $txt_status="Check Servers";

  }
    
    
    
  } else {
   $txt_server=0;
  }
  

   
   #
  my $ret='
  <tr>
          <td width="11" height="29" align="right"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
          <td height="29" background="/images/t1_zeile-hg.gif" class="fontblacksmall">'.$SQLnodeid.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="139" height="29" align="left" background="/images/t1_zeile-hg.gif" class="blackLink"><a href="mylvs.pl?nodeid='.$SQLnodeid.'">'.$SQLname.'</td>
          <td width="8" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="57" height="29" align="center" background="/images/t1_zeile-hg.gif"><img src="'.$img_status.'" width="20" height="20" border="0" title="'.$txt_status.'"></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="57" height="29" align="center" background="/images/t1_zeile-hg.gif"><img src="'.$img_monitor.'" width="20" height="20" border="0" title="'.$txt_monitor.'"></td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="69" height="29" align="center" background="/images/t1_zeile-hg.gif"><span class="'.$class_server.'">'.$txt_server.'</span></td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="67" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$active_class.'">'.$txt_active.'</td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="67" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$inactive_class.'">'.$txt_inactive.'</td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="59" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$class_http.'">'.$txt_http.'</td>
          <td height="29" align="left"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
  </tr>
  ';
  print $ret;		
 }
 
#exit;

my $ret='
<tr>
          <td width="11" height="29" align="right"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
          <td height="29" background="/images/t1_zeile-hg.gif" class="fontblacksmallbold"></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="139" height="29" align="left" background="/images/t1_zeile-hg.gif" class="'.$class_http.'">Total</td>
          <td width="8" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="61" height="29" align="left" background="/images/t1_zeile-hg.gif" class="fontblacksmallbold"></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="57" height="29" align="center" background="/images/t1_zeile-hg.gif"></td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="69" height="29" align="center" background="/images/t1_zeile-hg.gif"><span class="fontblacksmallbold"></span></td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="67" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$class_http.'">'.$cnt_tot_active.'</td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="67" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$class_http.'">'.$cnt_tot_inactive.'</td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="59" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$class_http.'">'.$cnt_tot_http.'</td>
          <td height="29" align="left"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
  </tr>

';
print $ret;		





#print &HTMLEndInsideTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;



 
 
 sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}


sub lvslog {
 #Logs into sql
 #$_[0] = Code (used for the image)
 #$_[1] = Message
 #$_[2] = User
 my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','$_[1]');" );
 $sqlcur->execute;
}






sub HTMLStartOutsideTable {
#my $ret='

#<body><br>
#<!-- Aussentabelle -->
my $ret='
<table width="685" height="368" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="634" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" height="29"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33" height="15"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">Show Nodes <span class="fontnormal"></span></td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt innentabelle rein ! --><br>
	  
	  <table width="619" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_top-corner-lft.gif" width="11" height="8"></td>
          <td width="14" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>      
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>      
          <td width="139" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="8" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="61" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="57" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="69" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="67" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="67" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="59" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="17" height="8" align="left" valign="bottom"><img src="/images/t1_top-corner-rt.gif" width="11" height="8"></td>
  </tr>
  <tr>
          <td width="11" height="41" align="right"><img src="/images/t1_top-gray-lft.gif" width="11" height="41"></td>      
          <td height="41" background="/images/t1_top-gray-hg.gif" class="fontairname"><br>
            ID</td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="139" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Node</td>
          <td width="8" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="61" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Status</td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="57" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Monitor</td>
          <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="69" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Servers</td>
          <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="67" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Active</td>
          <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="67" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          InActive</td>
          <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="59" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          HTTP</td>
          <td height="41" align="left"><img src="/images/t1_top-gray-rt.gif" width="11" height="41"></td>
  </tr>
  
  
  
  
 ';	                
 return $ret;		
}
                
sub HTMLStartInsideTable {
my $ret='
  <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">Show Nodes <span class="fontnormal"></span></td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt innentabelle rein ! --><br>
	  
	  <table width="619" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_top-corner-lft.gif" width="11" height="8"></td>
          <td width="14" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>      
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>      
          <td width="139" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="8" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="61" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="57" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="69" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="67" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="67" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="59" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="17" height="8" align="left" valign="bottom"><img src="/images/t1_top-corner-rt.gif" width="11" height="8"></td>
  </tr>
  <tr>
          <td width="11" height="41" align="right"><img src="/images/t1_top-gray-lft.gif" width="11" height="41"></td>      
          <td height="41" background="/images/t1_top-gray-hg.gif" class="fontairname"><br>
            ID</td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="139" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Node</td>
          <td width="8" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="61" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Status</td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="57" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Monitor</td>
          <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="69" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Servers</td>
          <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="67" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Active</td>
          <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="67" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          InActive</td>
          <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="59" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          HTTP</td>
          <td height="41" align="left"><img src="/images/t1_top-gray-rt.gif" width="11" height="41"></td>
  </tr>
  
  

';	                
 return $ret;		
}
                 
                
sub HTMLEndInsideTable {
my $ret='
        <tr> 
          <td width="11" height="14" align="right" valign="top"><img src="/images/t1_bottom-lft.gif" width="11" height="14"></td>      
          <td height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="139" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="8" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="61" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="57" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="69" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="67" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="67" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="59" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td height="14" align="left" valign="top"><img src="/images/t1_bottom-rt.gif" width="11" height="14"></td>
  </tr>
</table>

<br>
      <!-- Innere Tabelle -->
 ';	                
 return $ret;		
#       <a href="lvs2.pl"><img src="/images/back-tab.gif" alt="status name" width="63" height="29" border="0"></a><br>

}

sub HTMLEndOutsideTable {
my $ret='
  
        <tr> 
          <td width="11" height="14" align="right" valign="top"><img src="/images/t1_bottom-lft.gif" width="11" height="14"></td>      
          <td height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="139" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="8" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="61" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="57" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="69" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="67" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="67" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="59" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td height="14" align="left" valign="top"><img src="/images/t1_bottom-rt.gif" width="11" height="14"></td>
  </tr>
</table>

      <a href="mylvs.pl"><img src="/images/back-tab.gif" alt="status name" width="63" height="29" border="0"></a><br>
<br>
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- HH-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'" width="176" height="76"></td>
        </tr>
      </table>
      <!-- End of HH-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 if ($prtDeb ) {
  return $hdeb.$ret;		
 } else {
	return $ret;		
 } 
}

sub GetChkCmd {
  $_=$_[0];  #Prepare string filter
  s/%HOST%/$_[1]/;
  return $_;

}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT reset FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	



sub GetSnmpVal {
  my $ssnmphost = $_[0];
  my $ssnmpkey = $_[1];
  my $ssnmpcommunity = $_[2];
  my $ssnmpport = $_[3];
  my $ssnmptimeout = $_[4];
  if ((length($ssnmpkey) gt 0 ) and ($ssnmpkey ne 0)){
   my ($session, $error) = Net::SNMP->session(
     -hostname  => $ssnmphost,
     -community => $ssnmpcommunity,
     -port      =>  $ssnmpport ,
     -timeout   =>  $ssnmptimeout
   );
   my $result = $session->get_request(
     -varbindlist => [$ssnmpkey]
   );
   
   if (!defined($result)) {
      my $restxt = $session->error;
      #&SysLog ($restxt);
      $session->close;
      return (-1);
   }
   
   return ("$result->{$ssnmpkey}");
  } else {
   return (0); 	
  } 
}

 
sub GetLVSOutput {
 #Parse LVS Command Output and save it to hash
 my @lvsret = `$lvscmd`;   #Get LVS Status
 for my $myret (@lvsret) {
 	chomp $myret;
  #Mask: "TCP  10.0.1.18:7000 wrr persistent 3600"
  #Mask: "UDP  10.0.1.22:7000 wrr persistent 3600"
 	$hdeb.="XXXXX  DEB1 => $myret<br>";
 	if ($myret!~/\s*\[/ ) {  #v6?  #2.0.5
 	 if ($myret =~ /^(\w{3})\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	  #print "XXXXX  DEB2 => $myret\n";
 	  $curmodeID++;
 	  $curmodePropertyID=0;
    $NodeID{$curmodeID}=$curmodeID;
    $NodeIDv4{$curmodeID}=$curmodeID;
    $NodeProto{$curmodeID}="$1";
 	  $NodeAddress{$curmodeID}="$2.$3.$4.$5";
 	  $NodePort{$curmodeID}="$6";
    $NodeScheduler{$curmodeID}="$7";		
    $NodePersistent{$curmodeID}="$8";		
    $NodePersistentTimeout{$curmodeID}="$9";		
 	 } else {
 	  if ($myret =~ /^(\w{3})\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w*)/) {
 	   #Mask: "TCP  10.0.1.18:7000 wrr"
     #Mask: "UDP  10.0.1.22:7000 wrr"
 	   #print "XYXYXY  DEB2a => $myret\n";
 	   $curmodeID++;
 	   $curmodePropertyID=0;
     $NodeID{$curmodeID}=$curmodeID;
     $NodeIDv4{$curmodeID}=$curmodeID;
     $NodeProto{$curmodeID}="$1";
 	   $NodeAddress{$curmodeID}="$2.$3.$4.$5";
 	   $NodePort{$curmodeID}="$6";
     $NodeScheduler{$curmodeID}="$7";		
     $NodePersistent{$curmodeID}="";		
     $NodePersistentTimeout{$curmodeID}="";		
 	  } else {
 	   if ($myret =~ /^FWM\s*(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	  	 #Mask: "FWM  1 wlc persistent 3600"
 	  	 #print "XXXXX  DEB3 => $myret\n";
 	 	 $curmodeID++;
 	 	 $curmodePropertyID=0;
 	 	 $NodeID{$curmodeID}=$curmodeID;
 	 	 $NodeIDv4{$curmodeID}=$curmodeID;
 	 	 $NodeProto{$curmodeID}="FWM";
 	 	 $NodeAddress{$curmodeID}="$1";
 	 	 $NodePort{$curmodeID}="0";
      $NodeScheduler{$curmodeID}="$2";		
      $NodePersistent{$curmodeID}="$3";		
      $NodePersistentTimeout{$curmodeID}="$4";		
 	   } else {
 	    if ($myret =~ /^FWM\s*(\d*)\s*(\w*)/) {
 	     #Mask: "FWM  1 wlc "
 	  	  #print "XXXXX  DEB3a => $myret\n";
 	 	  $curmodeID++;
 	 	  $curmodePropertyID=0;
 	 	  $NodeID{$curmodeID}=$curmodeID;
 	 	  $NodeIDv4{$curmodeID}=$curmodeID;
 	 	  $NodeProto{$curmodeID}="FWM";
 	 	  $NodeAddress{$curmodeID}="$1";
 	 	  $NodePort{$curmodeID}="0";
       $NodeScheduler{$curmodeID}="$2";		
       $NodePersistent{$curmodeID}="$3";		
       $NodePersistentTimeout{$curmodeID}="$4";		
 	    }
 	   }
 	  }
	 }	
  }   else {  #2.0.5 V6
   $hdeb.=" =oo> $myret<br>\n";
 	 if ($myret =~ /^(\w{3})\s*\[(.*)\]:(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	  $hdeb.=" yy=> $myret<br>\n";
 	  $curmodeID++;
 	  $curmodePropertyID=0;
    $NodeID{$curmodeID}=$curmodeID;
    $NodeIDv6{$curmodeID}=$curmodeID;
    $NodeProto{$curmodeID}="$1";
 	  $NodeAddress{$curmodeID}="$2";
 	  $NodePort{$curmodeID}="$3";
    $NodeScheduler{$curmodeID}="$4";		
    $NodePersistent{$curmodeID}="$5";		
    $NodePersistentTimeout{$curmodeID}="$6";		
   } else {
   	#TCP [fde2:8acd:e9d3::220]:7798 wlc
 	  if ($myret =~ /^(\w{3})\s*\[(.*)\]:(\d*)\s*(\w*)/) {
 	   $hdeb.=" =xxs> $myret<br>\n";	
 	  	#Mask: TCP [fde2:8acd:e9d3::220]:7798 wlc
 	   $curmodeID++;
 	   $curmodePropertyID=0;
     $NodeID{$curmodeID}=$curmodeID;
     $NodeIDv6{$curmodeID}=$curmodeID;
     $NodeProto{$curmodeID}="$1";
 	   $NodeAddress{$curmodeID}="$2";
 	   $NodePort{$curmodeID}="$3";
     $NodeScheduler{$curmodeID}="$4";		
     $NodePersistent{$curmodeID}="";		
     $NodePersistentTimeout{$curmodeID}="";		
 	 }
  }
 } 	
 	
 	
 	
 	#Get Node Values
 	#Mask: " -> 10.0.1.240:0                 Route   100    0          0         "
 	if ($myret!~/\s*->\s*\[/ ) {  #v6?  #2.0.5
 	 if ($myret =~ m/\s*->\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w+)\s*(\d*)\s*(\d*)\s*(\d*)/) {
 	  $curmodePropertyID++;
    $RSAddress{$curmodeID}{$curmodePropertyID}="$1.$2.$3.$4";
    $RSPort{$curmodeID}{$curmodePropertyID}="$5";
    $RSRoute{$curmodeID}{$curmodePropertyID}="$6";
    $RSWeight{$curmodeID}{$curmodePropertyID}="$7";
    $RSActive{$curmodeID}{$curmodePropertyID}="$8";
    $RSInActive{$curmodeID}{$curmodePropertyID}="$9";
 	 }
 	} else {  #v6
 		#if ($iptmp =~ /^\[(.*)\]:(\d+)$/) {
 		#$hdeb.="V6 --> $myret<br>\n";  #2.0.5
 		#  -> [fde2:8acd:e9d3::221]:7798   Route   100    0          0

 	  if ($myret =~ m/\s*->\s*\[(.*)\]:(\d*)\s*(\w+)\s*(\d*)\s*(\d*)\s*(\d*)/) {
 	   #$hdeb.="$1 $2 $3 -- Active=$5 InActive=$6<br>\n";  #2.0.5
 	   $curmodePropertyID++;
     $RSAddress{$curmodeID}{$curmodePropertyID}="$1";
     $RSPort{$curmodeID}{$curmodePropertyID}="$2";
     $RSRoute{$curmodeID}{$curmodePropertyID}="$3";
     $RSWeight{$curmodeID}{$curmodePropertyID}="$4";
     $RSActive{$curmodeID}{$curmodePropertyID}="$5";
     $RSInActive{$curmodeID}{$curmodePropertyID}="$6";
   
 	 } else {
 	  if ($myret =~ /^FWM\s*(\d*)\s*(\w*)/) {  #=> experimental - not tested yet
 	   #Mask: "FWM  1 wlc "
 	   #print "XXXXX  DEB3a => $myret\n";
 	 	 #$curmodeID++;
 	 	 $curmodePropertyID=0;
 	 	 $NodeID{$curmodeID}=$curmodeID;
 	 	 $NodeIDv6{$curmodeID}=$curmodeID;
 	 	 $NodeProto{$curmodeID}="FWM";
 	 	 $NodeAddress{$curmodeID}="$1";
 	 	 $NodePort{$curmodeID}="0";
     $NodeScheduler{$curmodeID}="$2";		
     $NodePersistent{$curmodeID}="$3";		
     $NodePersistentTimeout{$curmodeID}="$4";		
 	  }
 	 }
 	}
 }    #for my $myret (@lvsret)
}     #sub GetLVSOutput
	