#!/usr/bin/perl -w

#########
#Show Log
#########




use strict;
use DateTime;         #=> See: http://www.linux-magazin.de/Artikel/ausgabe/2006/02/perl/perl.html
use DBI;
use Time::localtime;


my $version="2.0.0.0";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############

$lvscmd=$lvscmd." -Ln";
#Debugging ...
#$lvscmd="/bin/cat /usr/local/dev/mysql/ipvsadm.txt";
####################### CONFIGURATION #######################

use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript);



#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};

my $granted = undef;   #user login flag - default off
#For static test purposes ...
#$tparam = "y=2006?m=8?d=10";

#####################################################################
#####################################################################
my ($RefDay,$RefMonth,$RefYear,$sdate,$CUday,$CUmonth,$CUyear,$CDday,$CDmonth,$CDyear,$dbh,%Code,$resp,$ret,$sqlTst,$Cusr);

 #BEGIN
 $granted=&chkuser($curuser);  #Check User
 $dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
 #print &HTMLHeader;
 print htmlmainheader;
 print htmlmaintab(3,1080,0);
 print htmlmaincss;
 print jscript;
 print &HTMLStartOutsideTable;
 if ($granted) {
  #Get Reference SQL Date 
  if ( $tparam =~ m/y=(\d{4})\?m=(\d{1,2})\?d=(\d{1,2})/) {
   #print "$1 $2 $3\n";
 	 $RefDay=$3;
   $RefMonth=$2;
   $RefYear=$1;        
  }	else {  #Load default: Today !
   my $tm = localtime;
   $RefDay=sprintf"%d",$tm->mday;
   $RefMonth=sprintf"%d",$tm->mon + 1;
   $RefYear=sprintf"%-d",$tm->year + 1900;
  }
 
  #Resolve Codes
  my $sqlindex = $dbh->prepare("SELECT code,image FROM tblLogCode ;" );
  $sqlindex->execute ;  #Get Nodes
  while(my($SQLcode,$SQLimage)=$sqlindex->fetchrow_array) {
 	 #print "$SQLcode -- $SQLimage\n";
 	 $Code{$SQLcode}=$SQLimage;
  }	
  my $now = DateTime->new(
   year   => $RefYear,
   month  => $RefMonth,
   day    => $RefDay
  );
           
  $sdate = $now->clone()->add(days => 1);
  $CUday=$sdate->day;
  $CUmonth=$sdate->month;
  $CUyear=$sdate->year;
  $sdate = $now->clone()->subtract(days => 1);
  $CDday=$sdate->day;
  $CDmonth=$sdate->month;
  $CDyear=$sdate->year;
  #print "$CUday - $CUmonth $CUyear\n";
  #print "$CDday - $CDmonth $CDyear\n";
  #exit;
  my $sqltst = $dbh->prepare("SELECT message FROM tblLogging where year='".$RefYear."' and month='".$RefMonth."' and day='".$RefDay."' order by logid desc;" ); 
  $sqltst->execute ; #Get Resources
  $resp=undef;
  (($sqlTst)=$sqltst->fetchrow_array);
  if ($sqlTst){$resp=1;}
 
  if ($resp){
   $ret='
   <table width="1000" border="2" rules="none" bordercolor="#CCCCCC"  align="center" cellspacing="0" >
   <TR>
    <TD align="left" bgcolor="#F2F2F2"></TD>
    <TD align="left" bgcolor="#F2F2F2">Date</TD>
    <TD align="left" bgcolor="#F2F2F2">User</TD>
    <TD align="left" bgcolor="#F2F2F2">Message</TD>
   </TR>
   ';	                
   print $ret;		
   #print "SELECT user,message FROM tblLogging where year='".$RefYear."' and month='".$RefMonth."' and day='".$RefDay."' order by logid desc" . "\n";
   #exit;
   my $sqlres = $dbh->prepare("SELECT code,user,message,hour,minute,second FROM tblLogging where year='".$RefYear."' and month='".$RefMonth."' and day='".$RefDay."' order by logid desc;" ); 
   $sqlres->execute ; #Get Resources
   while (my($sqlCode,$sqlUser,$sqlMessage,$sqhHour,$sqlMin,$sqlSec)=$sqlres->fetchrow_array) {
    #print "$sqlCode-$sqlUser - $sqlMessage\n";
    if ($sqlUser =~ /monitor/i){
    	$Cusr="fontorangebold";
    } else {
    	$Cusr="fontblack";
    }
    print "<TR><TD><IMG src='".$Code{$sqlCode}."' align=center border=0></TD>\n";
    print "<TD align=left class=fontblacksmall><b>$RefYear-$RefMonth-$RefDay $sqhHour:$sqlMin:$sqlSec</b></TD>\n";
    print "<TD align=left class=".$Cusr."><b>$sqlUser</b></TD>\n";
    print "<TD align=left class=fontblacksmall><b>$sqlMessage</b></TD></tr>\n";
   }            
   print "    </table>";
  } else {
   print '   <table border=0 align="center" cellspacing="0" ><TR>';
   print '   <TD align="left" class=fontblackbig>No Records Present !</TD></TR>';
   print "   </table>";
  }
 } else {
  print '   <table border=0 align="center" cellspacing="0" ><TR>';
  print '   <TD align="left" class=fontblackbig>No Permissions To View Log !</TD></TR>';
  print "   </table>";
 }     #if ($granted) 
 print &HTMLEndOutsideTable;
 print &HTMLEndHeader;

 #END SCRIPT
           


sub chkDate () {
	if (length($_[0]) eq 1 ) {
		return "0" . $_[0];
	} else {
    return $_[0];		
	}
}           


sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}





sub HTMLStartOutsideTable {
my $ret='
<!-- Aussentabelle -->
<table width="936" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>

    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td align="center" class="fontairname">Linux Virtual Server LogView ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>

  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <p>
        <!-- Log Table ! -->
        <br>	
';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Left Output -->
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td class="fontairname"><a href="mylvsshlog.pl?y='.$CDyear.'?m='.$CDmonth.'?d='.$CDday.'"><img src="/images/left.gif"  border="0" title="Back" style="margin-top:25px"></td>
        <td class="fontairname" border="0"><img src="/images/hh-clear.gif" width="45" height="76"></td>
		    <td class="fontairname" border="0"><a href="mylvsshlog.pl?y='.$CUyear.'?m='.$CUmonth.'?d='.$CUday.'"><img src="/images/right.gif" border="0" title="Next"  style="margin-top:25px"><td>
		    <td class="fontairname"><img src="/images/hh-clear.gif" width="176" height="76"></td>
		    <td class="fontairname"><img src="/images/hh-clear.gif" width="176" height="76"></td>
        <td class="fontairname"><img src="/images/hh-clear.gif" width="176" height="76"></td>
        <td class="fontairname"><img src="/images/hh-clear.gif" width="176" height="76"></td>
		    <td class="fontairname"><img src="'.$sitelogo.'" width="176" height="76"></td>
		   </tr>
      </table>
     <!-- End of Left Output -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of LogTable -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT logview FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	