#!/usr/bin/perl -w

######################
#Restore configuration
######################



use strict;
use DBI;
use Time::localtime;


my $version="2.0.1.2";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;


############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############

#Load LVS htmlhelper
use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript);
use htmlsetuphelper qw(&htmlsetuptab &htmlsetupcss &htmlmainsetupheader);
#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;   #user login flag - default off



#####################################################################
#####################################################################


my ($tblText,$list);


my @reqTokens = split(/&/,$tparam);
foreach (@reqTokens){ #
  if (/^list\=*([^ ]*)/){$list=$1;}	 
 } 
 if (!$list){$list=20};

$tblText="Restore Configuration";

#BEGIN
$granted=&chkuser($curuser);  #Check User

print htmlmainheader;
print htmlsetupcss;
print jscript;
print htmlmaintab(7,860,0);

print &HTMLStartOutsideTable; 	
print htmlsetuptab(5);
print &HTMLInnerTableStart;
print &HTMLInnerTableEntry;
print &HTMLInnerTableEnd;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;

#END SCRIPT
           




sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}



sub HTMLStartOutsideTable {


my $ret='
<table width="860" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="794" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$tblText.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  
  <tr> 
    <td width="33" height="10" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>

  <tr> 
    <td width="33" height="184" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt die innere Tabelle rein ! --><br>
      
';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT showcon FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	




sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);

    $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
}




sub HTMLInnerTableStart{

 #my $subpageadd=$pagelink."?mode=add";
 #my $subpage="lvs2restoredata?name=";
 my $ret='	
   
    <table align="center" border="0" cellpadding="0" cellspacing="0" width="769">
       <!-- Weisser Aussenrahmen -->
          <tbody><tr> 
            <td align="right" valign="bottom" width="11" height="8"><img src="/images/t1_top-corner-lft.gif" width="11" height="8"></td>
            <td width="174" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>

            <td background="/images/t1_top-hg.gif" valign="bottom" width="10"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="379"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="10"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="91"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="76"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td align="left" valign="bottom" width="11" height="8"><img src="/images/t1_top-corner-rt.gif" width="11" height="8"></td>
          </tr>
          <!-- Grau unterlegter Aussenrahmen Oben -->

          <tr class="UeberschrBorderBottom"> 
            <td align="right" valign="bottom"><img src="/images/t1_top-gray-lft.gif" height="32" width="11"></td>
            <td height="32" align="left" class="UeberschrBorderBottom">Backup Date</td>
            <td width="7" valign="bottom" class="UeberschrBorderBottom"><img src="/images/separator-gray_7x32.gif" width="7" height="32"></td>
            <td colspan="5" align="right" class="UeberschrBorderBottom"></td>
            <td width="11" height="32" align="left" valign="bottom"><img src="/images/t1_top-gray-rt.gif" height="32" width="11"></td>
          </tr>
          <!-- Grau unterlegter Aussenrahmen Oben -->
          <tbody>
';
 
 return $ret;		
}



sub HTMLInnerTableEnd{
 
  my $ret='	

             <!-- Zeile Grauverlauf Oben -->
            <!-- Grau unterlegter Aussenrahmen Unten -->
            <tr> 
              <td align="right" valign="top" width="11" height="14"><img src="/images/t1_bottom-lft.gif" width="11" height="14"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" height="14"><img src="/images/1x1_clear.gif" width="1" height="8"></td>

              <td background="/images/t1_bottom-hg1.gif" valign="top" width="10"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="379"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="10"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="91"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="76"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td align="left" valign="top" width="11" height="14"><img src="/images/t1_bottom-rt.gif" width="11" height="14"></td>
            </tr>
            <tr> 
            <tr> 
             <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
             <td width="19">&nbsp;</td>
            </tr>

          </tbody>

        </table>




      <!-- Innere Tabelle -->



';

 
 return $ret;		

}


sub HTMLInnerTableEntry{

 my $ret;
 my %rfile;
 my %filetot;
 my $tid;
 my $ttid;
 my $tcomplete;
 my $scomplete;
 my $sfile;
 my $tfile;
 my $ttext;
 opendir(DIR, $backuppath); #Get files
 my @files = grep(/\.*$/,readdir(DIR));
 closedir(DIR);

 foreach my $bfile (@files){
 	
 	if ($bfile !~ /^\./) {
 	 if ($bfile =~ /(\d{4})(\d{2})(\d{2})-(\d{2})(\d{2})(\d{2})/) {
 	  $tid="$1$2$3-$4$5$6";
    $tcomplete=undef;
 	  $scomplete=undef;
 	  $sfile="";
 	  $tfile="";
 	  foreach my $cfile (@files){
 	   if ($cfile =~ /(\d{4})(\d{2})(\d{2})-(\d{2})(\d{2})(\d{2})/) {
 	    $ttid="$1$2$3-$4$5$6";
 	    if ($ttid eq $tid){
 	     if (($cfile =~ /\.sql/i) and ($cfile !~ /\.txt/i)){
 	      $scomplete=1;
 	      $sfile=$cfile;
 	     }
 	     if ($cfile =~ /\.txt/i){
 	      $tcomplete=1;
 	      $tfile=$cfile;
 	     }
 	     if (($tcomplete) and ($scomplete)){last}
 	    }
 	   }
 	  }
 	  if (($tcomplete) and ($scomplete)){
 	   open (FH, "<$backuppath/$tfile") or die "no such file $backuppath/$tfile";
 	   while (<FH>){
 	  	chomp;
 	  	$ttext=$_;
 	  	last;
 	   }
 	   if ($sfile =~ /(\d{4})(\d{2})(\d{2})-(\d{2})(\d{2})(\d{2})\.sql/i) {
 	    $ttid="$1$2$3-$4$5$6";
 	    $rfile{$ttid}=substr($ttext,0,40);   	  #Only n chars
 	    $filetot{$ttid}=$ttid;   #used for sorting ....
 	    #print "$ttid - $rfile{$ttid}\n";
 	   }
 	  }
 	 } 
 	}
 }	

#exit;
 my $scnt;
 for my $bfile( sort { $filetot{$b} cmp $filetot{$a} } keys %rfile ) {
  #for my $val( sort { $ConStateFin{$a} cmp %ConStateFin{$b} } keys %ConTotal ) {
  #for my $bfile ( sort{$rfile->{$a}<=>$rfile->{$b}} keys %rfile ){
  #orig for my $bfile( sort { $rfile{$b} <=> $rfile{$a} } keys %rfile ) {
  #for my $bfile( sort { $rfile{$b} cmp $rfile{$a} } keys %rfile ) {
  #for my $bfile( sort keys %rfile ) {
  my $subpage="mylvsrestoredata.pl?name=$bfile.sql" ;
  my $subreload='<a href="javascript:confirmReload('."'$subpage')".'">';
  my $subdelpage="mylvsdeletebackup.pl?name=$bfile.sql" ;
  my $subdel='<a href="javascript:confirmDelete('."'$subdelpage')".'">';
	$scnt++;
 	if ($list >= $scnt) {
   $ret.='	
         <!-- Innere tabelle fuer nodes -->
            <tr> 
              <td align="right" background="/images/t1_zeile-hg.gif" valign="bottom" width="11" height="29"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
              <td align="left" background="/images/t1_zeile-hg.gif" height="29"><img src="/images/1x1_clear.gif" width="1" height="1">'.$bfile.'</td>
              <td background="/images/t1_zeile-hg.gif" width="10"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
              <td class="blackLinkMid" align="left" background="/images/t1_zeile-hg.gif" width="379">'.$rfile{$bfile}.'</td>
              <td background="/images/t1_zeile-hg.gif" width="10"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
              <td class="blackLinkMid" align="center" background="/images/t1_zeile-hg.gif" width="91"><img src="/images/1x1_clear.gif" width="1" height="1">'.$subreload.'<img src="/images/buttons/restore.gif" border="0"></a></td>
              <td background="/images/t1_zeile-hg.gif" width="7"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>

              <td class="blackLinkMid" align="center" background="/images/t1_zeile-hg.gif" width="76"><img src="/images/1x1_clear.gif" width="1" height="1">'.$subdel.'<img src="/images/buttons/delete.gif" border="0"></a></td>
              <td align="left" valign="bottom" width="11" height="29"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
            </tr>
 ';        
 }
}


#}        
 return $ret;		

}
