#!/usr/bin/perl 


#####################################
#MYLVS - NODE MANAGER - SQL WRITER
#####################################

#20090512 - 2.0.1.9 Fix Node deletion
#20100503 add new mode deleteassign
#20170517 add v6 - 2.0.5
#####################################################################
#####################################################################

use warnings;
use strict;
use DBI;
use POSIX;
use Net::IP ':PROC'; #2.0.5 -  #http://stackoverflow.com/questions/27398691/ip-database-from-ip2location-and-convert-ipv4-to-ipv6-in-perl -  apt-get install libnet-ip-perl
# apt-get install libnet-ip-perl


####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############
#my $httproot="http://test.maximegalon.intern/";

####################################################################
my $basepath=$ENV{DOCUMENT_ROOT};
my $server = $ENV{HTTP_HOST};
####################################################################


my $httproot="http://$server/";
my $retscriptname="mylvseditnode.pl";

#Remember this:   <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>

####################### CONFIGURATION #######################
my $version = "2.0.5";

#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;   #user login flag - default off
#For static test purposes ...
#$tparam = "to=2";
#$tparam = "wu=1";
#$tparam = "wd=1";
#$tparam = "to=1";
#$tparam = "td=4";
#####################################################################
#####################################################################

my ($sqlAlias,$sqlIP,$GlobalAlias,$GlobalIP,$GlobalTxt);
my ($dbh,$dbhn,$dbhhN,$var,$value);
#my ($sqlcur,$sqlInvID,$sqlInvTID,$sqlInvWeight,$sqlNodeID,$sqlLink,$sqlIPort,$sqlinv,$sqlalias,$sqlactive,$sqlmethod,$sqlweight,$sqlenabled,$sqlPoolID,$sqlWeightStat,$curstat,$sqlpool,$sqlPoolReource,$sqlAliasEnabled,$mdstring);
my $showid;  #=1;  #Ste TestID !!!
my ($myIP,$myHost,$myCHost);
$granted=&chkuser($curuser);  #Check User
print &HTMLHeader;
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$dbhn = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$tparam=URLDecode($tparam);
my ($nodename,$nodeid,$vip,$protocol,$schedule,$port,$persistance,$enabled,$monitor,$chktoken,$chkinvtoken,$id,$mode,$sqlstat,$sql,$sqlstatN,$sqlN,$dinc);
my ($ndlink,$ndweight,$ndmethod,$ndcommand,$ndport,$ndsnmp,$ndenabled,$ndpoolid,$ndid,$ndresid,$ndnodeid);
my ($vip6,$ipinvalid,$tmpvip,$tmpvip6); #2.0.5   


$GlobalTxt="Node Manager: Save Assignment";
print &HTMLStartOutsideTable;
print &HTMLStartInsideTable;



 if ($granted) {
  $chktoken=1;
  $chkinvtoken=1;
  
  
  
  my @reqTokens = split(/&/,$tparam);
  
  foreach (@reqTokens){ #Get Mode Fisrt !!!
 	 if (!/\'|\;|\(|\)|\"|\`|\*|where\s+|truncate\s+|\s+from\s+|\select\s+|delete\s+|\s+as\s+/){  #No SQL Injection
 	 	  if (/^mode\=*([^ ]*)/){$mode=$1;}	 
   }
  }

 	if ((lc($mode) eq "delete") or (lc($mode) eq "add") or (lc($mode) eq "edit") or (lc($mode) eq "deleteassign") ){  
   foreach (@reqTokens){
 	  if (!/\'|\;|\(|\)|\"|\`|\*|where\s+|truncate\s+|\s+from\s+|\select\s+|delete\s+|\s+as\s+/){  #No SQL Injection
	   if (/^nodename\=*([^ ]*)/i){$nodename=$1;}	 
	   if (/^ipv4\=*([^ ]*)/i){$vip=$1;}	  #2.0.5
	   if (/^ipv6\=*([^ ]*)/i){$vip6=$1;}	  #2.0.5
	   if (/^protocol\=*([^ ]*)/i){$protocol=$1;}	 
	   if (/^schedule\=*([^ ]*)/i){$schedule=$1;}	 
	   if (/^port\=*([^ ]*)/i){$port=$1;}	 
	   if (/^persistance\=*([^ ]*)/i){$persistance=$1;}	 
	   if (/^enabled\=*([^ ]*)/i){$enabled=$1;}	 
	   if (/^monitor\=*([^ ]*)/i){$monitor=$1;}	 
	   if (/^id\=*([^ ]*)/i){$id=$1;}	 
	   if ($enabled !~ /1/){$enabled=0;}
	   if (/^nodeid\=*([^ ]*)/i){$nodeid=$1;}	 
    }
   }   #foreach (@reqTokens)
   $retscriptname="mylvseditnode.pl";
   if ($enabled =! /on/i){
   	$enabled=1;
   } else {
   	$enabled=0;
   }	
   if ($monitor =! /on/i){
   	$monitor=1;
   } else {
   	$monitor=0;	
   }	

   #Check all tokens to be set
   #$port=undef;
   
   if ($protocol!~/fwm/i){
    if( ((!$nodename) or ((!$vip) and (!$vip6))  or (!$schedule) and (!$port) and (!$protocol) or ((!$id) and ($mode ne "add") )) and (lc($mode) ne "delete")  and (lc($mode) ne "deleteassign") ){
   	 print "Data Incomplete -$nodename-$vip-$protocol-$schedule-$port-$persistance-$enabled-$monitor-$id- !!<br>\n";
   	 $dinc=1;
    } else {
     print "Data Complete<BR>";	
    }
   } else { #fwmark
    if( ((!$nodename) or ((!$vip) and (!$vip6))  or (!$schedule) and (!$protocol) or ((!$id) and ($mode ne "add") )) and (lc($mode) ne "delete")  and (lc($mode) ne "deleteassign") ){
   	 print "Data Incomplete -$nodename-$vip-$protocol-$schedule-$port-$persistance-$enabled-$monitor-$id- !! <br>\n";
   	 $dinc=1;
    } else {
     print "Data Complete<BR>";	
    }
   } 
    
    
   if ((!checkIP($vip) and ($protocol!~/fwm/i)) and ($vip)){
   	print "Syntax error, check IPv4 address format<BR>";	
   	$dinc=1;
   }

   if ((!checkIP($vip6)) and ($protocol!~/fwm/i) and ($vip6) ){
   	print "Syntax error, check IPv6 address format<BR>";	
   	$dinc=1;
   }

  }

  if ((lc($mode) eq "nodeinvedit") or (lc($mode) eq "nodeinvadd") or (lc($mode) eq "nodeinvdel") ){  
   #print "Start NodeINVx $mode<BR>\n";
   foreach (@reqTokens){
    if (/^link\=*([^ ]*)/i){$ndlink=$1;}	 
    if (/^method\=*([^ ]*)/i){$ndmethod=$1;}	 
    if (/^weight\=*([^ ]*)/i){$ndweight=$1;}	 
    if (/^command\=*([^ ]*)/i){$ndcommand=$1;}	 
    if (/^port\=*([^ ]*)/i){$ndport=$1;}	 
    if (/^snmp\=*([^ ]*)/i){$ndsnmp=$1;}	 
    if (/^enabled=*([^ ]*)/i){$ndenabled=$1;}	 
    if (/^poolid\=*([^ ]*)/i){$ndpoolid=$1;}	 
    if (/^id\=*([^ ]*)/i){$ndid=$1;}	 
    if (/^resID\=*([^ ]*)/i){$ndresid=$1;}	 
    if (/^nodeid=(\d*)/i){$ndnodeid=$1} 
    if (/^nodename\=*([^ ]*)/i){$nodename=$1;}	 
   }
   #print "DEB: $ndenabled<BR>\n";
   $retscriptname="mylvsassignnode.pl?nodeid=$ndnodeid&node=$nodename";
   if ($ndenabled =~ /on/i){
   	$ndenabled=1;
   } else {
   	$ndenabled=0;
   }	
   #print "DEB1: $enabled<BR>\n";
   #if ($ndenabled !~ /1/){$ndenabled=0;}
   if (((!$ndlink)  or (!$ndmethod) or (length($ndweight) eq 0) or (length($ndcommand) eq 0 ) or (length($ndport) eq 0 ) or (!$ndid)) and ($mode != /nodeinvdel/i) ) {
   	print "Add Data Incomplete -$ndlink-$ndweight-$ndmethod-$ndcommand-$ndport-$ndsnmp-$ndenabled-$ndpoolid-$ndid- !!\n";
   	$dinc=1;
   } else {
    print "Data Complete<BR>";	
   }
  
   if ((!$dinc and (lc($mode) eq "nodeinvedit"))){
    $sqlstat = ("Update tblNodesInventory set Link = '".$ndlink."', method='".$ndmethod."', weight='".$ndweight."', cmd_reset_id='".$ndcommand."', port='".$ndport."', snmpID='".$ndsnmp."', enabled='".$ndenabled."', automovepoolid='".$ndpoolid."'  where invID ='".$ndid."';"); 
    #my $sql = $dbh->prepare($sqlstat);
    &PrintHTMLMessage("$sqlstat<BR>");
    if ($simulate ne 1){
     my $rv  = $dbh->do($sqlstat);
     if ($rv eq 1) {
     	print "Update Table OK<BR>\n";
     } else {
   	  print "Update Table Error<BR>\n";
     }	
    }
   }
 


   if ((!$dinc and (lc($mode) eq "nodeinvadd"))){
    &PrintHTMLMessage("Insert Table <BR>");
    $sqlstat = ("Insert into tblNodesInventory (invID,resID,nodeID,snmpID,enabled,active,maintenance,failstate,port,method,link,weight,automovepoolid,weightdown,cmd_reset_id,bid) values (");
    $sqlstat .= "'".$ndid."','";
    $sqlstat .= $ndresid."','";
    $sqlstat .= $ndnodeid."','"; 	   	 
    $sqlstat .= $ndsnmp."','";  
    $sqlstat .= $ndenabled."','";  
    $sqlstat .= "1"."','";  
    $sqlstat .= "0"."','";  
    $sqlstat .= "0"."','"; 
    $sqlstat .= $ndport."','";  
    $sqlstat .= $ndmethod."','";  
    $sqlstat .= $ndlink."','";  
    $sqlstat .= $ndweight."','";  
    $sqlstat .= $ndpoolid."','";  
    $sqlstat .= "0"."','"; 
    $sqlstat .= $ndcommand."','";  
    $sqlstat .= "1"."');"; 
    &PrintHTMLMessage("$sqlstat<BR>");
    if ($simulate ne 1){
     my $rv  = $dbh->do($sqlstat);
     if ($rv eq 1) {
      print "Insert Table OK<BR>\n";
     } else {
   	  print "Insert Table Error<BR>\n";
     } 	
    }
   }
  }
  if (!$monitor){$monitor=0;}
  if (!$persistance){$persistance=0;}
  
  if ($protocol!~/fwm/i){
   if ($vip) {
   	$tmpvip="', vip='".$vip.":".$port;
   }
   if ($vip6) {
   	$tmpvip6="', vip6='".$vip6.":".$port;
   } else {
   	$tmpvip6="', vip6='";
   }
  } else {
   if ($vip) {
   	$tmpvip="', vip='".$vip;
   }
     	
   if ($vip6) {
   	$tmpvip6="', vip6='".$vip6;
   } else {
   	 $tmpvip6="', vip6='";
   }
  	
  }


  #print "Extra debug: $tmpvip $tmpvip6<br>";

  if ((lc($mode) eq "nodeinvedit") and ($chkinvtoken) and ($id) and not (lc($mode) eq "add") and not (lc($mode) eq "delete")) {
    &PrintHTMLMessage("Update tblNodesInventory");
  }

  if (($chktoken) and ($id) and not (lc($mode) eq "delete") and not (lc($mode) eq "nodeinvedit") and not (lc($mode) eq "nodeinvadd") and not (lc($mode) eq "nodeinvdel") and not (lc($mode) eq "deleteassign") and not ($dinc) ){
   &PrintHTMLMessage("Update Table - $mode<BR>");       

   
   
   $sqlstat = ("Update tblNodes set Name = '".$nodename."', enabled='".$enabled."', service='".lc($protocol)."', scheduler='".lc($schedule).  $tmpvip .  "', persistent='".$persistance."', monitor='".$monitor.$tmpvip6."' where nodeid ='".$id."';"); 
   #my $sql = $dbh->prepare($sqlstat);
   &PrintHTMLMessage("$sqlstat<BR>");   
   if ($simulate ne 1){
    my $rv  = $dbh->do($sqlstat);
    if ($rv eq 1) {
     print "Update Table OK<BR>\n";
    } else {
   	 print "Update Table Error<BR>\n";
    }	
   }
  }

  if (($mode eq "add") and (!$id) and not (lc($mode) eq "nodeinvedit") and not (lc($mode) eq "nodeinvadd") and not (lc($mode) eq "nodeinvdel")  and not ($dinc) ){
   &PrintHTMLMessage("Insert Record<BR>");
   if ((!$nodename) or (!$schedule) or (!$protocol) or (!$vip)){
   	print "Error: Data not complete<BR>\n";
   } else {
   
   
  if ($protocol!~/fwm/i){
   if ($vip) {
   	$tmpvip="$vip:$port";
   }
   if ($vip6) {
   	$tmpvip6="$vip6:$port";
   } else {
   	$tmpvip6="";
   }
  } else {
   if ($vip) {
   	$tmpvip="$vip";
   }
     	
   if ($vip6) {
   	$tmpvip6="$vip6:$port";
   }
  	
  }

   
   
   
   
   
    #Get ID!
    $sqlstat = ("Select NodeID from tblNodes order by NodeID desc limit 1;"); 
    $sql = $dbh->prepare($sqlstat);
    $sql->execute;
    (my($sqlID)=$sql->fetchrow_array);
    $id=$sqlID+1;
    
    &PrintHTMLMessage("Get new ID = $id<BR>");
    #$vip6
    #$vip
    $sqlstat = ("Insert into tblNodes (nodeID,enabled,Name,scheduler,service,vip,persistent,monitor,vip6) values ('".$id."','".$enabled."','".$nodename."','".$schedule."','".$protocol."','".$tmpvip."','".$persistance."','".$monitor."','".$tmpvip6."');");
    &PrintHTMLMessage("$sqlstat<BR>");
    if ($simulate ne 1){
     my $rv  = $dbh->do($sqlstat);
     if ($rv eq 1) {
      print "Insert Table OK<BR>\n";
     } else {
   	  print "Insert Table Error<BR>\n";
     } 	
    }
   }
  }

  if (($mode eq "delete") and ($id) and not (lc($mode) eq "nodeinvedit") and not (lc($mode) eq "nodeinvadd") and not (lc($mode) eq "nodeinvdel")){
   &PrintHTMLMessage("Delete Record - Mode: $mode $id<BR>");   
   if ($simulate ne 1){
    #20090512   	
   	my $sqlin="Select invID from tblNodesInventory where nodeID ='".$id."';";
   	&PrintHTMLMessage("$sqlin<BR>");
    my $sqli = $dbhn->prepare($sqlin);
    $sqli->execute;
    while (my($sqlInvID)=$sqli->fetchrow_array){

     my $sqlmn="Delete from tblMonitor where invID ='".$sqlInvID."';";
     &PrintHTMLMessage("$sqlmn<BR>");
     my $sqln = $dbhn->prepare($sqlmn);
     $sqln->execute;
    }
   	
   	
    #Get ID!
    $sqlstat = ("Delete from tblNodesInventory where nodeID = '".$id."';"); 
    &PrintHTMLMessage("$sqlstat<BR>");
    $sql = $dbh->prepare($sqlstat);
    $sql->execute;
    #Dont do this ???  -  #20090512   	Do this
    $sqlstat = ("Delete from tblNodes where nodeID = '".$id."';"); 
    &PrintHTMLMessage("$sqlstat<BR>"); 
    $sql = $dbh->prepare($sqlstat);
    $sql->execute;
   
   }
  }



  
  #20100503 add new mode deleteassign
  if (($mode eq "deleteassign")) {# and ($id) and not (lc($mode) eq "nodeinvedit") and not (lc($mode) eq "nodeinvadd") and not (lc($mode) eq "nodeinvdel")){
   &PrintHTMLMessage("Delete Record - Mode: $mode $id<BR>"); 
   if ($simulate ne 1){
     my $sqlmn="Delete from tblMonitor where InvID ='".$id."';";
     &PrintHTMLMessage("$sqlmn<BR>");      
     my $sqln = $dbhn->prepare($sqlmn);
     $sqln->execute;
   	#aloa

     my $sqlmn = ("Delete from tblNodesInventory where InvID = '".$id."';"); 
     &PrintHTMLMessage("$sqlmn<BR>"); 
     my $sqln = $dbhn->prepare($sqlmn);
     $sqln->execute;
   }
  }



  print "Task Complete!<br>\n";

 } else {     #if ($granted) 
  print "No Permissions To Perform This Task !\n";
 }            #if ($granted)  

print &HTMLEndInsideTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;



 
 
 sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}


sub lvslog {
 #Logs into sql
 #$_[0] = Code (used for the image)
 #$_[1] = Message
 #$_[2] = User
 #my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','$_[1]');" );
 my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message,epoche) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','".$_[1]."','".time."');" );
 $sqlcur->execute;
}



sub HTMLHeader {
#<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
my $ret='Content-type: text/html; charset=iso-8859-1

<html>
<head>
<title>LVS</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.fontairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #979696;
}
.fontnormal {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #979696;
}
.ecke-top-hg-lft {
	background-image: url(images/ecke-top-hg-lft.gif);
	background-repeat: repeat-y;
	background-position: right;
}
.whitefield {
	background-color: #FFFFFF;
	border: 1px solid #cfcfcf;
}
-->
</style>
<style type="text/css">
<!--
.fontblacksmall {
	font-family: Verdana;
	font-size: 10px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
-->
</style>
</head>
';
	
return $ret;	
}



sub HTMLStartOutsideTable {
my $ret='
<body><br>
<!-- Aussentabelle -->
<table width="830" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">LVS Inventory Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$GlobalAlias.'<span class="fontnormal"> (</span><span class="fontnormal">'.$GlobalTxt.'
          )</span></td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
';	
return $ret;		
}

sub HTMLStartInsideTable {
my $ret='
      <!-- Hier kommt innentabelle rein ! --><br>
      <br>
      <table width="549" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-lft.gif" width="19" height="11"></td>
          <td height="11" valign="bottom" background="/images/t2_top-hg.gif"></td>
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-rt.gif" width="19" height="11"></td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td bgcolor="f8f8f8" class="fontairname"></td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td class="whitefield"><br>
          <table width="90%" border="0" align="center" cellpadding="0" cellspacing="0">
           <tr>
           <td class="fontblacksmall">
 ';	                
 return $ret;		
}
                
                
                
sub HTMLEndInsideTable {
my $ret='
              </td>
              </tr>
            </table>
            <br>
          </td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-lft.gif" width="19" height="19"></td>
          <td height="19" background="/images/t2_bottom-hg.gif">&nbsp;</td>
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-rt.gif" width="19" height="19"></td>
        </tr>
        <tr> 
          <td colspan="2" align="left" valign="top"><a href="'."$httproot$retscriptname".'"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
          <td width="19">&nbsp;</td>
        </tr>
      </table>
      <!-- Innere Tabelle -->
 ';	                
 return $ret;		
}

sub HTMLEndOutsideTable {
my $ret='
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT servermanager FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	


sub URLDecode {
    my $theURL = $_[0];
    $theURL =~ tr/+/ /;
    $theURL =~ s/%([a-fA-F0-9]{2,2})/chr(hex($1))/eg;
    $theURL =~ s/<!--(.|\n)*-->//g;
    return $theURL;
}


sub PrintHTMLMessage {
	if ($HTMLLVSView){
	 print "$_[0]\n";
	} 
}




sub checkIP {  #2.0.5
 #my $ipaddr='fde2:8acd:e9d3::22011';
 $ipinvalid=undef;
 #print "Check IP  $_[0] <BR>";	 
 my $ip = new Net::IP ($_[0]) or &errorprint(Net::IP::Error());

 #$ip_num=$ip->intip();
 #$ipaddr=$ip->ip();
 #$ipver=$ip->version();
 #$iptype=$ip->iptype();
 if (!$ipinvalid) {
 	#if ($opt_v) {
  # print ("$_[0] = IP Version: ".$ip->version()." (VALID)\n");
  # #print ("Size: ".$ip->size()."\n");
  # #print ("Len : ".$ip->prefixlen()."\n");
  # #print ("Type: ".$ip->iptype()."\n");
  #} 
  return 1;
 }
 return undef; 
}


sub errorprint {  #2.0.5
	#if ($opt_v) {
	# print "$_[0]\n";
	#} 
	$ipinvalid=1;
}
