#!/usr/bin/perl -w

#######################
#Show LVS2 Connections
#######################


#2.0.1.0  Start testing       18Oct2006
#2.0.1.1  Add Geo::IPFree
#2.0.1.2  Changed Geo info to a csv/sql solution
#2.0.1.3  Removed cgi-bin from path 20Aug2015

use strict;
use DBI;
use Time::localtime;
#use Geo::IPfree;  

my $version="2.0.1.3";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############
$lvscmd=$lvscmd." -Ln";

my $defaultcount=50;  #if no parameter is given, remeber that there is also a max value in the xml config

#Load LVS htmlhelper
use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript);
use htmlsetuphelper qw(&htmlsetuptab &htmlsetupcss &htmlmainsetupheader);



####################### CONFIGURATION #######################


#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
####################################################################
my $basepath=$ENV{DOCUMENT_ROOT};
my $server = $ENV{HTTP_HOST};
####################################################################


my $granted = undef;   #user login flag - default off


#####################################################################
#####################################################################
my ($dbh,$dbhh,$dbhhh,%Code,$resp,$ret,$FIN_WAIT,$NONE,$ESTABLISHED,$CLOSED,$SYN_RECV,$CONNECTIONS,$SENDER);
my (%tmpTotESTABLISHED,%tmpTotCLOSED,%tmpTotNONE,%tmpTotFIN_WAIT,%tmpTotSYN_RECV,$cnt,%TotLVSConnx,%tmpOrder,$reqcnt,$searchip,$tblText);
my ($tmpSource,$tmpTarget,$class_established,$class_closed,$class_tot,$class_none,$class_syn,$class_fin,$country,$country_name,$img_flag,$tmpipnum);
my $tmpESTABLISHED=undef;my $tmpCLOSED=undef;my $tmpNONE=undef;my $tmpFIN_WAIT=undef;my $tmpSYN_RECV=undef;
my ($nodeid,$nodename);

my($SQLnodeid,$SQLenabled,$SQLalias,$SQLip,$SQLcmdid,$SQLmrtg);

my $pagelink="lvs2addnode.pl";
my $pagedellink="lvs2servermgr.pl";




my @reqTokens = split(/&/,$tparam);
if ($reqTokens[0] =~ /^nodeid=/) {
  if ($reqTokens[0] =~ m/nodeid=(\d*)/){ 
   $nodeid=$1;
  }
 }

if ($reqTokens[1] =~ /^node=/) {
  if ($reqTokens[1] =~ m/node=([^ ]*)/){ 
   $nodename=$1;
  }
 }


$tblText="Monitor Manager";
#BEGIN
$granted=&chkuser($curuser);  #Check User
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$dbhh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$dbhhh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 


#print &HTMLHeader;
print htmlmainheader;
print htmlsetupcss;
print jscript;
print htmlmaintab(7,860,0);

print &HTMLStartOutsideTable; 	
print htmlsetuptab(6);
print &HTMLInnerTableStart;
print &HTMLInnerTableEntry;
print &HTMLInnerTableEnd;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;

#END SCRIPT
           


sub chkDate () {
	if (length($_[0]) eq 1 ) {
		return "0" . $_[0];
	} else {
    return $_[0];		
	}
}           


sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}




sub HTMLHeader {
#<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
my $ret='Content-type: text/html; charset=iso-8859-1

<html>
<head>
<title>LVS</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.fontairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #979696;
}

.fontblackairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #000000;
}

.fontnormal {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #979696;
}
.whitefield {
	background-color: #FFFFFF;
	border: 1px solid #cfcfcf;
}
.fontblacksmall {
	font-family: Verdana;
	font-size: 10px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
.fontblack {
	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
.fontblackbig {
	font-family: Verdana;
	font-size: 18px;
	font-style: normal;
	font-weight: bold;
	color: #000000;
}

.fontorangebold {
	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #fb9419;
}
.fontredbold {
	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #d70012;
}


.blackLink A:link {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLink A:visited {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLink A:active {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLink A:hover {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #979696;
 text-decoration: underline;
}





.blackLinkMid A:link {
 font-family: Verdana;
 font-size: 14px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLinkMid A:visited {
 font-family: Verdana;
 font-size: 14px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLinkMid A:active {
 font-family: Verdana;
 font-size: 14px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 


.redLink A:link {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #d70012;
 text-decoration: none;
}
 

.redLink A:visited {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #d70012;
 text-decoration: none;
}
 

.redLink A:active {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #d70012;
 text-decoration: none;
}
 

.redLink A:hover {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #d70012;
 text-decoration: underline;
}

.orangeLink A:link {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #fb9419;
 text-decoration: none;
}
 

.orangeLink A:visited {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #fb9419;
 text-decoration: none;
}
 

.orangeLink A:active {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #fb9419;
 text-decoration: none;
}
 
.fontblack1 {	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}


.orangeLink A:hover {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #fb9419;;
 text-decoration: underline;
}

.fontblackblold {
	font-family: Verdana;
	font-size: 12px;
	font-style: normal;
	font-weight: bold;
	color: #000000;
}


 
-->
</style>
</head>



';
	
return $ret;	
}


sub HTMLStartOutsideTable {
#my $ret='
#<body>
#<p class="fontblold"><br>
#  <!-- Aussentabelle -->
#</p>


#  <table width="812" border="0" align="center" cellpadding="0" cellspacing="0" >
#  <td width="96" height="25" align="center" background="/images/neutral-tab.gif" class="blackLink"><a href="lvs2shconx.pl?list=25">Connections</td>
#  <td width="96" height="25" align="center" background="/images/neutral-tab.gif" class="blackLink"><a href="lvs2search.pl">Search</td>
#  <td width="96" height="25" align="center" background="/images/neutral-tab.gif" class="blackLink"><a href="lvs2shlog.pl">Log</td>
#  <td width="96" height="25" align="center" background="/images/neutral-tab.gif" class="blackLink"><a href="lvs2shnodes.pl">Nodes</td>
#  <td width="96" height="25" align="center" background="/images/neutral-tab.gif" class="blackLink"><a href="lvs2.pl">Servers</td>
#  <td width="96" height="25" align="center" background="/images/neutral-tab.gif" class="blackLink"><a href="lvs2addnode.pl">Setup</td>
#  <td width="233" height="25" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="25"></td>
#</table>


my $ret='
<table width="860" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="794" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$tblText.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  
  <tr> 
    <td width="33" height="10" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>

  <tr> 
    <td width="33" height="184" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt die innere Tabelle rein ! --><br>
      
';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT showcon FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	




sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);

    $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
}




sub HTMLInnerTableStart{

 #my $subpageadd=$pagelink."?mode=add";
 my $subpageadd="lvs2addserver.pl?mode=add";
 
 
#    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="http://lvs.intern/lvs2mainsetup.pl">Add Node</a></td>
 #<td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="#">Add Server</a></td>
 #my $ret='	
#	  	  <table align="center" border="0" cellpadding="0" cellspacing="0" width="769">
#    <tbody><tr> 
#    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="http://lvs.intern/lvs2editnode.pl">Edit Node</a></td>
#    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="http://lvs.intern/lvs2manageserver.pl">Edit Server</a></td>
#    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="#">Apply Config</a></td>
#    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="#">Backup</a></td>
#    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="#">Restore</a></td>
#    <td class="blackLink" align="center" background="/images/1x1_clear.gif" height="25" width="104"></td>
#    <td class="blackLink" align="center" background="/images/1x1_clear.gif" height="25" width="104"></td>
#    <td background="/images/t1_zeile-hg-bl.gif" height="25" width="132"><img src="/images/1x1_clear.gif" height="25" width="1"></td>
#    </tr>
#    </tbody></table>
    
 
my $ret='	
         <table class="fontblack" align="center" border="0" cellpadding="0" cellspacing="0" width="769">
         <form action="lvs2shconx.pl" method="post/get"></form>
          
   
   <!-- Weisser Aussenrahmen -->
          <tbody><tr> 
            <td align="right" valign="bottom" width="11" height="8"><img src="/images/t1_top-corner-lft.gif" width="11" height="8"></td>
            <td width="248" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>

            <td background="/images/t1_top-hg.gif" valign="bottom" width="20"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="304"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="11"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="70"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="18"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="76"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
            <td align="left" valign="bottom" width="11" height="8"><img src="/images/t1_top-corner-rt.gif" width="11" height="8"></td>
          </tr>
          <!-- Grau unterlegter Aussenrahmen Oben -->

          <tr class="UeberschrBorderBottom"> 
            <td align="right" valign="bottom"><img src="/images/t1_top-gray-lft.gif" width="11" height="32"></td>
            <td class="UeberschrBorderBottom" align="left" height="32">Server</td>
            <td class="UeberschrBorderBottom" valign="bottom" width="20"><img src="/images/separator-gray_7x32.gif" width="7" height="32"></td>
            <td colspan="5" class="UeberschrBorderBottom" align="right"><a href="http://'.$server.'/mylvsassignmon.pl?mode=add"><img src="/images/buttons/add.gif" alt="Add new monitor" border="0"></a></td>
            <td align="left" valign="bottom" width="11" height="32"><img src="/images/t1_top-gray-rt.gif" width="11" height="32"></td>
          </tr>
          <!-- Grau unterlegter Aussenrahmen Oben -->
          </tbody><tbody>
	


';
 
 return $ret;		

 
# return $ret;		

}



sub HTMLInnerTableEnd{

	
 
 
  my $ret='	

              <!-- Zeile Grauverlauf Oben -->
            <!-- Grau unterlegter Aussenrahmen Unten -->
            <tr> 
              <td align="right" valign="top" width="11" height="14"><img src="/images/t1_bottom-lft.gif" width="11" height="14"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" height="14"><img src="/images/1x1_clear.gif" width="1" height="8"></td>

              <td background="/images/t1_bottom-hg1.gif" valign="top" width="20"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="304"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="11"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="70"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="18"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="76"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
              <td align="left" valign="top" width="11" height="14"><img src="/images/t1_bottom-rt.gif" width="11" height="14"></td>
            </tr>
            <tr> 
             <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" border="0" width="63" height="29"></a></td>
             <td width="20">&nbsp;</td>
            </tr>

          </tbody>

        </table>




      <!-- Innere Tabelle -->



';

 
 return $ret;		

}


sub HTMLInnerTableEntry{

my $ret;
my $imglink;
my $prtweight;
my $amode;

#To be checked:
my $SQLResAlias;
my $SQLResID;
my $subdelpagelink;
my($SQLnodeID);
my %monitor;
 
 my $sqlserver = $dbh->prepare("SELECT monID,invID FROM tblMonitor;" ); 
 $sqlserver->execute ; #Get Resources
 while (my($SQLmonID,$SQLinvID)=$sqlserver->fetchrow_array) {

  my $sqlnode = $dbhh->prepare("SELECT resid,nodeid from tblNodesInventory where invID='$SQLinvID';" ); 
  $sqlnode->execute ; #Get Resources
  (my($SQLresID,$SQLnodeID)=$sqlnode->fetchrow_array);
  	

  my $sqlnodename = $dbhh->prepare("SELECT name from tblNodes where nodeid='".$SQLnodeID."';" ); 
  $sqlnodename->execute ; #Get Resources
  (my($SQLnodeName)=$sqlnodename->fetchrow_array);

  my $sqlalias = $dbhh->prepare("SELECT alias from tblResources where resID='".$SQLresID."';" ); 
  $sqlalias->execute ; #Get Resources
  (my($SQLAlias)=$sqlalias->fetchrow_array);

   $monitor{$SQLAlias}{$SQLnodeName}=$SQLmonID;
}

for my $pntalias ( sort keys %monitor ) {
 for my $pntnode (sort keys %{$monitor{$pntalias}} ) {


 $ret.='	


<!-- Innere tabelle fuer nodes -->
            <tr> 
              <td align="right" background="/images/t1_zeile-hg.gif" valign="bottom" width="11" height="29"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
              <td align="left" background="/images/t1_zeile-hg.gif" height="29"><img src="/images/1x1_clear.gif" width="1" height="1">'.$pntalias.'</td>
              <td background="/images/t1_zeile-hg.gif" width="20"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
              <td class="blackLinkMid" align="left" background="/images/t1_zeile-hg.gif" width="304">'.$pntnode.'</td>
              <td background="/images/t1_zeile-hg.gif" width="11"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
              <td class="blackLinkMid" align="center" background="/images/t1_zeile-hg.gif" width="70"><img src="/images/1x1_clear.gif" width="1" height="1"><a href="http://'.$server.'/mylvsassignmon.pl?monid='.$monitor{$pntalias}{$pntnode}.'"><img src="/images/buttons/edit.gif" border="0"></a></td>
              <td background="/images/t1_zeile-hg.gif" width="18"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>

              <td class="blackLinkMid" align="center" background="/images/t1_zeile-hg.gif" width="76"><img src="/images/1x1_clear.gif" width="1" height="1"><a href="javascript:confirmDelete('."'".'http://'.$server.'/mylvsassignmgr.pl?mode=delete&amp;id='.$monitor{$pntalias}{$pntnode}."'".')"><img src="/images/buttons/delete.gif" border="0"></a></td>
              <td align="left" valign="bottom" width="11" height="29"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
            </tr>



';        

  
 #}   #if ($SQLRResID)  
#}        

}
}        

 
 return $ret;		

}
