#!/usr/bin/perl -w

#to do: add <td width="98" class="blackLink" align="center"><a href="lvs2reset.pl">Reset LVS </a></td>

#######################
#LVS2 Manage Nodes
#######################


use strict;
use DBI;
use Time::localtime;
#use Geo::IPfree;  

my $version="2.0.1.2";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############
$lvscmd=$lvscmd." -Ln";

my $defaultcount=50;  #if no parameter is given, remeber that there is also a max value in the xml config


#Load LVS htmlhelper
use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript );
use htmlsetuphelper qw(&htmlsetuptab &htmlsetupcss &htmlmainsetupheader);

####################### CONFIGURATION #######################


#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};

my $granted = undef;   #user login flag - default off


#####################################################################
#####################################################################
my ($dbh,%Code,$resp,$ret,$FIN_WAIT,$NONE,$ESTABLISHED,$CLOSED,$SYN_RECV,$CONNECTIONS,$SENDER);
my (%tmpTotESTABLISHED,%tmpTotCLOSED,%tmpTotNONE,%tmpTotFIN_WAIT,%tmpTotSYN_RECV,$cnt,%TotLVSConnx,%tmpOrder,$reqcnt,$searchip,$tblText);
my ($tmpSource,$tmpTarget,$class_established,$class_closed,$class_tot,$class_none,$class_syn,$class_fin,$country,$country_name,$img_flag,$tmpipnum);
my $tmpESTABLISHED=undef;my $tmpCLOSED=undef;my $tmpNONE=undef;my $tmpFIN_WAIT=undef;my $tmpSYN_RECV=undef;

my $pagelink="mylvsaddnode.pl";
my $pagedellink="mylvsnodemgr.pl";
my $pageassignlink="mylvsassignnode.pl";
my $pageacopy="mylvscopynode.pl";


$tblText="Node Manager";
#BEGIN
$granted=&chkuser($curuser);  #Check User
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 


print htmlmainheader;
print jscript;
print htmlsetupcss;




print htmlmaintab(7,860,0);
print &HTMLStartOutsideTable; 	

print htmlsetuptab(1);
print &HTMLInnerTableStart;
print &HTMLInnerTableEntry;
print &HTMLInnerTableEnd;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;

#END SCRIPT
           


sub chkDate () {
	if (length($_[0]) eq 1 ) {
		return "0" . $_[0];
	} else {
    return $_[0];		
	}
}           


sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}





sub HTMLStartOutsideTable {
my $ret='
<table width="860" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="794" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$tblText.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  
  <tr> 
    <td width="33" height="10" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>

  <tr> 
    <td width="33" height="184" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt die innere Tabelle rein ! --><br>
      
';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT showcon FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	




sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);

    $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
}




sub HTMLInnerTableStart{

 my $subpageadd=$pagelink."?mode=add";
 my $ret='	
         <table align="center" border="0" cellpadding="0" cellspacing="0" width="769" class="fontblack">
          <form action="lvs2shconx.pl" method="post/get">
          </form>
   
   <!-- Weisser Aussenrahmen -->
          <tr> 
            <td align="right" height="8" valign="bottom" width="11"><img src="/images/t1_top-corner-lft.gif" height="8" width="11"></td>
            <td background="/images/t1_top-hg.gif" height="8" valign="bottom"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7%"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7%"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7%"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td width="7%" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td align="left" height="8" valign="bottom" width="11"><img src="/images/t1_top-corner-rt.gif" height="8" width="11"></td>
          </tr>
          <!-- Grau unterlegter Aussenrahmen Oben -->

          <tr class="UeberschrBorderBottom"> 
            <td align="right" valign="bottom"><img src="/images/t1_top-gray-lft.gif" height="32" width="11"></td>
            <td height="32" align="left" class="UeberschrBorderBottom">Node</td>
            <td width="7" valign="bottom" class="UeberschrBorderBottom"><img src="/images/separator-gray_7x32.gif" width="7" height="32"></td>
            <td colspan="7" align="right" class="UeberschrBorderBottom"><a href="'.$subpageadd.'" target="_self"><img src="/images/buttons/add.gif" alt="Add new node" border="0"></a></td>
            <td width="11" height="32" align="left" valign="bottom"><img src="/images/t1_top-gray-rt.gif" height="32" width="11"></td>
          </tr>
          <!-- Grau unterlegter Aussenrahmen Oben -->
          <tbody>
';
 
 return $ret;		

}



sub HTMLInnerTableEnd{

	
 my $ret='	

             <!-- Zeile Grauverlauf Oben -->
            <!-- Grau unterlegter Aussenrahmen Unten -->
            <tr> 
              <td align="right" height="14" valign="top" width="11"><img src="/images/t1_bottom-lft.gif" height="14" width="11"></td>
              <td background="/images/t1_bottom-hg1.gif" height="14" valign="top"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7%"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7%"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7%"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td width="7%" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td width="11" height="14" align="left" valign="top"><img src="/images/t1_bottom-rt.gif" height="14" width="11"></td>
            </tr>
          </tbody>

        </table>




      <!-- Innere Tabelle -->



';
 
 return $ret;		

}


sub HTMLInnerTableEntry{

my $ret;
my $sqnodes = $dbh->prepare("SELECT nodeid,enabled,name,monitor,scheduler,service,vip,persistent FROM tblNodes" ); 
$sqnodes->execute ; #Get Resources
 while (my($SQLnodeid,$SQLenabled,$SQLname,$SQLmonitor,$SQLscheduler,$SQLservice,$SQLvip,$SQLpersistent)=$sqnodes->fetchrow_array) {
  #my $pagelink="lvs2addnode.pl?nodeid=$SQLnodeid";
  my $subpagelink=$pagelink."?nodeid=$SQLnodeid";
	my $tlink=$pagedellink."?id=$SQLnodeid&mode=delete";
	my $subdelpagelink='<a href="javascript:confirmDelete('."'$tlink')".'">';
	my $subassignpagelink=$pageassignlink."?nodeid=$SQLnodeid&node=$SQLname";
	my $subcopypagelink=$pageacopy."?nodeid=$SQLnodeid&node=$SQLname";
	
	
 $ret.='	

 

            <!-- Innere tabelle fuer nodes -->
            <tr> 
              <td align="right" background="/images/t1_zeile-hg.gif" height="29" valign="bottom" width="11"><img src="/images/t1_zeile-lft.gif" height="29" width="11"></td>
              <td align="left" background="/images/t1_zeile-hg.gif" height="29"><img src="/images/1x1_clear.gif" height="1" width="1">'.$SQLname.'</td>
              <td background="/images/t1_zeile-hg.gif" width="7"><img src="/images/t1_separator-zeile.gif" height="29" width="7"></td>
              <td class="blackLinkMid" align="center" background="/images/t1_zeile-hg.gif" width="7%"><a href="'.$subpagelink.'"><img src="/images/buttons/edit.gif"  border="0"></a></td>
              <td background="/images/t1_zeile-hg.gif" width="7"><img src="/images/t1_separator-zeile.gif" height="29" width="7"></td>
              <td class="blackLinkMid" align="center" background="/images/t1_zeile-hg.gif" width="7%"><img src="/images/1x1_clear.gif" height="1" width="1">'.$subdelpagelink.'<img src="/images/buttons/delete.gif" border="0"></a></td>
              <td background="/images/t1_zeile-hg.gif" width="7"><img src="/images/t1_separator-zeile.gif" height="29" width="7"></td>

              <td class="blackLinkMid" align="center" background="/images/t1_zeile-hg.gif" width="7%"><img src="/images/1x1_clear.gif" height="1" width="1"><a href="'.$subassignpagelink.'"><img src="/images/buttons/assign.gif" border="0"></a></td>
              <td background="/images/t1_zeile-hg.gif" width="7"><img src="/images/t1_separator-zeile.gif" height="29" width="7"></td>


              <td width="7%" align="center" background="/images/t1_zeile-hg.gif" class="blackLinkMid"><img src="/images/1x1_clear.gif" height="1" width="1"><a href="'.$subcopypagelink.'"><img src="/images/buttons/copy.gif" border="0"></a></td>
              <td align="left" height="29" valign="bottom" width="11"><img src="/images/t1_zeile-rt.gif" height="29" width="11"></td>
            </tr>
';        
}        

 
 return $ret;		

}
