#!/usr/bin/perl 

#2.0.3 - Add visible and mac adress options - may2011
#2.0.4 - Add Wakup and Shutdown-Jul2011
#2.0.5 - Add v6 - Mai2017

##################################
#Manage Server Add / Edit / Delete
#Parameter:
#lvs2manageserver.pl?add%enabled=x&ip=x.x.x.x&mrtg=text&command=x
#lvs2manageserver.pl?edit%id=x&enabled=x&ip=x.x.x.x&mrtg=text&command=x
#lvs2manageserver.pl?delete%id=x
##################################




use warnings;
use strict;
use DBI;
use POSIX;


####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
use Net::IP ':PROC'; #2.0.5 -  #http://stackoverflow.com/questions/27398691/ip-database-from-ip2location-and-convert-ipv4-to-ipv6-in-perl -  apt-get install libnet-ip-perl
# apt-get install libnet-ip-perl

############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############
#my $httproot="http://test.maximegalon.intern/";
####################################################################
my $basepath=$ENV{DOCUMENT_ROOT};
my $server = $ENV{HTTP_HOST};
####################################################################

my $httproot="http://$server/";
my $retscriptname="mylvsmgrsrv.pl";
#Remember this:   <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
#or this:         <td colspan="2" align="left" valign="top"><a href="'."$httproot$retscriptname".'"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
####################### CONFIGURATION #######################



my $version = "2.0.5";

#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;   #user login flag - default off
#####################################################################
#####################################################################

my ($sqlAlias,$sqlIP,$GlobalAlias,$GlobalIP,$GlobalTxt,$sqln,$sqlnn,$sqlnnn);
my ($dbh,$dbhn,$dbhnn,$dbhnnn,$var,$value);
my $showid;  #=1;  #Ste TestID !!!
my ($myIP,$myHost,$myCHost);

my ($ip6,$ipinvalid);  #2.0.5


$granted=&chkuser($curuser);  #Check User
print &HTMLHeader;
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$dbhn = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$dbhnn = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$dbhnnn = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$tparam=URLDecode($tparam);

    

my ($servername,$nodename,$ip4,$id,$cpnode,$cpmon,$newresID,$newinvID,$tmpAlias,$tmpSQLlink,$newmonID,$cpserver,$newnodeID,$port);
my ($chktoken,$id,$mode,$sqlstat,$sql);

my ($errmsg); #2.0.3
my $isUnique=1;

my @reqTokens = split(/&/,$tparam);
foreach (@reqTokens){  #Get nmode first
 if (!/\'|\;|\(|\)|\"|\`|\*|where\s+|truncate\s+|\s+from\s+|\select\s+|delete\s+|\s+as\s+/){  #No SQL Injection
  if (/^mode=*([^ ]*)/i){$mode=$1;}	 
 }
}

 $GlobalTxt="Server: Unknown";
 
 if ($mode eq "copyserver"){
  $GlobalTxt="Server: Copy";
 } 

 if ($mode eq "copynode"){
  $GlobalTxt="Node: Copy";
 } 

 print &HTMLStartOutsideTable;
 print &HTMLStartInsideTable;



 if ($granted) {
  $chktoken=1;
 	if (lc($mode) eq "copyserver"){  
   foreach (@reqTokens){
 	  if (!/\'|\;|\(|\)|\"|\`|\*|where\s+|truncate\s+|\s+from\s+|\select\s+|delete\s+|\s+as\s+/){  #No SQL Injection
	   if (/^servername=*([^ ]*)/i){$servername=$1;}	 
   	 if (/^ip4=*([^ ]*)/i){$ip4=$1;}	 
   	 if (/^ip6=*([^ ]*)/i){$ip6=$1;}	 
   	 if (/^id=*([^ ]*)/i){$id=$1;}	 
   	 if (/^cpnode=*([^ ]*)/i){$cpnode=$1;}	 
   	 if (/^cpmon=*([^ ]*)/i){$cpmon=$1;}	 
    }
   }   #foreach (@reqTokens)
   if ($cpnode =~ /on/i){
   	$cpnode=1;
   } else {
   	$cpnode=0;
   }	

   if ($cpmon =~ /on/i){
   	$cpmon=1;
   } else {
   	$cpmon=0;
   }	



#   if ((!checkIP($vip) and ($protocol!~/fwm/i)) and ($vip)){
#   	print "Syntax error, check IPv4 address format<BR>";	
#   	$dinc=1;
#   }

#   if ((!checkIP($vip6)) and ($protocol!~/fwm/i) and ($vip6) ){
#   	print "Syntax error, check IPv6 address format<BR>";	
#   	$dinc=1;
#   }



   &PrintHTMLMessage("************************************************<BR>");
   &PrintHTMLMessage("***  Copy Server and all associated nodes and monitors   ***<BR>");
   &PrintHTMLMessage("************************************************<BR>");
   &PrintHTMLMessage("New Servername: $servername <BR>");
   &PrintHTMLMessage("New IP(4): $ip4 <BR>");
   &PrintHTMLMessage("New IP(6): $ip6 <BR>");
   &PrintHTMLMessage("Source ResID: $id <BR>");
   $sqlstat = ("Select resID from tblResources order by resID desc limit 1;"); 
   $sql = $dbh->prepare($sqlstat);
   $sql->execute;
   (my($sqlID)=$sql->fetchrow_array);
   $newresID=$sqlID+1;
   #&PrintHTMLMessage("$sqlstat <BR>");
   &PrintHTMLMessage("New ResID: $newresID <BR>");
  
  
   $sqlstat = ("Select invID from tblNodesInventory order by invID desc limit 1;"); 
   $sql = $dbh->prepare($sqlstat);
   $sql->execute;
   (my($sqlID)=$sql->fetchrow_array);
   $newinvID=$sqlID+1;
   #&PrintHTMLMessage("$sqlstat <BR>");
   &PrintHTMLMessage("New InvID: $newresID <BR>");
  
   $sqlstat = ("Select monID from tblMonitor order by monID desc limit 1;"); 
   $sql = $dbh->prepare($sqlstat);
   $sql->execute;
   (my($sqlID)=$sql->fetchrow_array);
   $newmonID=$sqlID+1;
   #&PrintHTMLMessage("$sqlstat <BR>");
   &PrintHTMLMessage("New MonID: $newmonID <BR>");


   if ((!checkIP($ip4)) and ($ip4)){
   	$isUnique=undef;
   	&PrintHTMLMessage("Error: The IPv4 address is invalid <br>");
   }

   if ((!checkIP($ip6)) and ($ip6)){
   	$isUnique=undef;
   	&PrintHTMLMessage("Error: The IPv6 address is invalid <br>");
   }
   
   if ((!$ip4) and (!$ip6)) {   
   	&PrintHTMLMessage("Error: No ip address has been set, required is to set either v4 or v6 <br>");
   	$isUnique=undef;
   }	
   


  
   #Should not exist
   $sqlstat = ("Select alias from tblResources where alias='$servername';"); 
   $sql = $dbh->prepare($sqlstat);
   $sql->execute;
   (my($sqlAlias)=$sql->fetchrow_array);
   if ($sqlAlias) {
   	$isUnique=undef;
   	$errmsg.="Error! the alias does already exist: $sqlAlias <BR>";
   	&PrintHTMLMessage("Error! the alias does already exist: $sqlAlias  <BR>");
   }

   $sqlstat = ("Select realip from tblResources where realip='$ip4';"); 
   $sql = $dbh->prepare($sqlstat);
   $sql->execute;
   (my($sqlIP)=$sql->fetchrow_array);
   if ($sqlIP) {
   	$isUnique=undef;
   	$errmsg.="Error! the IP does already exist: $sqlIP  <BR>";
   	&PrintHTMLMessage("Error! the IP does already exist: $sqlIP  <BR>");
   }
   
   
   if (($cpnode eq 0) and ($cpmon eq 1))  {
   	$isUnique=undef;
   	$errmsg.="Error! monitoring can be copied only if the nodes are getting copied too!  <BR>";
   	&PrintHTMLMessage("Error! monitoring can be copied only if the nodes are getting copied too! <BR>");
   }

   
   
   if ($isUnique){  #switch me on
    $sqlstat = ("Select enabled,alias,realip,cmd_reboot_id,mrtg_link,visible,mac,cmd_shutdown_id,cmd_wakeup_id from tblResources where resID='$id' limit 1;"); 
    $sql = $dbh->prepare($sqlstat);
    $sql->execute;
    #$sqlRes
    (my($SQLenabled,$SQLalias,$SQLrealip,$SQLcmd_reboot_id,$SQLmrtg_link,$SQLvisible,$SQLmac,$SQLcmd_shutdown_id,$SQLcmd_wakeup_id)=$sql->fetchrow_array);
    my $tmpAlias=$SQLalias;
    
    #&PrintHTMLMessage("$id - $SQLenabled,$SQLalias,$SQLrealip,$SQLcmd_reboot_id,$SQLmrtg_link,$SQLvisible,$SQLmac,$SQLcmd_shutdown_id,$SQLcmd_wakeup_id<br>");
   
    #################
    #Insert new host!   
    #################
    $sqlstat = ("insert into tblResources (resID,enabled,alias,realip,cmd_reboot_id,mrtg_link,visible,mac,cmd_shutdown_id,cmd_wakeup_id,realip6) values ('$newresID','0','$servername','$ip4','$SQLcmd_reboot_id','$SQLmrtg_link','$SQLvisible','$SQLmac','$SQLcmd_shutdown_id','$SQLcmd_wakeup_id','$ip6')"); 
    #&PrintHTMLMessage("$sqlstat<br>");
    $sql  = $dbhn->do($sqlstat);
    if ($sql eq 1) {
     &PrintHTMLMessage(" -> OK: SQL Host Insert - NewResID:$newresID - Source:$id <br>");
    } else {
   	 &PrintHTMLMessage(" -> ERROR: SQL Host Insert - NewResID:$newresID - Source:$id <br>");
    }


    if ($cpnode eq 1) {
     #################
     #Insert new node!     
     #################
     $sqlstat = ("select invID,resID,nodeID,snmpID,enabled,active,maintenance,failstate,port,method,link,weight,automovepoolid,weightdown,cmd_reset_id,bid from tblNodesInventory where resID='$id' order by invID;"); 
     $sql = $dbh->prepare($sqlstat);
     $sql->execute;
     while (my($SQLinvID,$SQLresID,$SQLnodeID,$SQLsnmpID,$SQLenabled,$SQLactive,$SQLmaintenance,$SQLfailstate,$SQLport,$SQLmethod,$SQLlink,$SQLweight,$SQLautomovepoolid,$SQLweightdown,$SQLcmd_reset_id,$SQLbid)=$sql->fetchrow_array) {
      #&PrintHTMLMessage(" - $SQLinvID,$SQLresID,$SQLnodeID,$SQLsnmpID,$SQLenabled,$SQLactive,$SQLmaintenance,$SQLfailstate,$SQLport,$SQLmethod,$SQLlink,$SQLweight,$SQLautomovepoolid,$SQLweightdown,$SQLcmd_reset_id,$SQLbid<br>");
      #$tmpSQLlink = $SQLlink;
      #$tmpSQLlink =~ s/$tmpAlias/$servername/g; #!Replace alias with the new servername
      #Insert new node!     
      $tmpSQLlink=$servername.":".$SQLport; #2.0.5 - Use static link mapping

      $sqlstat = ("insert into tblNodesInventory (invID,resID,nodeID,snmpID,enabled,active,maintenance,failstate,port,method,link,weight,automovepoolid,weightdown,cmd_reset_id,bid) values ('$newinvID','$newresID','$SQLnodeID','$SQLsnmpID','0','$SQLactive','$SQLmaintenance','$SQLfailstate','$SQLport','$SQLmethod','$tmpSQLlink','$SQLweight','$SQLautomovepoolid','$SQLweightdown','$SQLcmd_reset_id','$SQLbid') ");
      &PrintHTMLMessage(" - $sqlstat<br>");
      $sqln  = $dbhn->do($sqlstat);
      if ($sqln eq 1) {
       &PrintHTMLMessage(" -> OK: SQL NodeInventory Insert - NewInvID:$newinvID - Source:$SQLinvID   <br>");
      } else {
     	 &PrintHTMLMessage(" -> ERROR: SQL NodeInventory Insert - NewInvID:$newinvID - Source:$SQLinvID <br>");
      }
      $newinvID++;
     }  #While
    } else { #$cpnode 
     &PrintHTMLMessage("Skip adding nodes<br>");
    } #$cpnode 
    

    if ($cpmon eq 1) {
     ############################
     #Insert new monitor session!     
     ############################
     #&PrintHTMLMessage(" MONCHECK OldID: $id<br>");
     $sqlstat = ("SELECT nodeID,invID FROM tblNodesInventory where resid='$id'");
     $sql = $dbh->prepare($sqlstat);
     $sql->execute;
     while (my($SQLnodeID,$SQLinvID)=$sql->fetchrow_array) {  #1st node check
      #&PrintHTMLMessage(" DBLCHK $SQLnodeID,$SQLinvID<br>");
      $sqlstat = ("SELECT nodeID,invID FROM tblNodesInventory where resid='$newresID' and nodeID='$SQLnodeID'");
      #&PrintHTMLMessage(" XXX $sqlstat <br>");
      $sqln = $dbhn->prepare($sqlstat);
      $sqln->execute;
      while (my($SQLXnodeID,$SQLXinvID)=$sqln->fetchrow_array) {  #2nd node check
       #&PrintHTMLMessage(" MON CHECK: DBLCHK XX $SQLnodeID,$SQLinvID - replace with $SQLXnodeID,$SQLXinvID<br>");
       ################################  
       #Check and copy monitor settings  
       ################################
       
      
       
       $sqlstat = ("select enabled,invID,recTaskID,timeout,checkalive,checkinterval,failcheckinterval,rechecks,recheckwait,notificationclock,messageid,checkinventory,immediaterecoverid,commandid,lastcheck,status
       from tblMonitor
       where invID='$SQLinvID'"); 
       $sqlnn = $dbhnn->prepare($sqlstat);
       $sqlnn->execute;
       (my($SQLenabled,$SQLinvID,$SQLrecTaskID,$SQLtimeout,$SQLcheckalive,$SQLcheckinterval,$SQLfailcheckinterval,$SQLrechecks,$SQLrecheckwait,$SQLnotificationclock,$SQLmessageid,$SQLcheckinventory,$SQLimmediaterecoverid,$SQLcommandid,$SQLlastcheck,$SQLstatus)=$sqlnn->fetchrow_array);
      
      if ($SQLinvID){
       #&PrintHTMLMessage(" MON CHECKXXX: $SQLinvID eq $SQLXinvID<br>");
       #&PrintHTMLMessage(" COPY MON $SQLinvID<br>");
       $sqlstat = ("insert into tblMonitor (monID,enabled,invID,recTaskID,timeout,checkalive,checkinterval,failcheckinterval,rechecks,recheckwait,notificationclock,messageid,checkinventory,immediaterecoverid,commandid,lastcheck,status) values
        ('$newmonID','$SQLenabled','$SQLXinvID','$SQLrecTaskID','$SQLtimeout','$SQLcheckalive','$SQLcheckinterval','$SQLfailcheckinterval','$SQLrechecks','$SQLrecheckwait','$SQLnotificationclock','$SQLmessageid','$SQLcheckinventory','$SQLimmediaterecoverid','$SQLcommandid','$SQLlastcheck','$SQLstatus') 
        ");
       #&PrintHTMLMessage(" SQL: $sqlstat<br>");
       $sqlnnn  = $dbhnnn->do($sqlstat);
       if ($sqlnnn eq 1) {
        &PrintHTMLMessage(" -> OK: SQL Monitor Insert - MonID:$newmonID InvID:$SQLXinvID<br>");
       } else {
      	 &PrintHTMLMessage(" -> ERROR: SQL Monitor Insert - MonID:$newmonID InvID:$SQLXinvID<br>");
       }
       $newmonID++;
      } else {
      	 &PrintHTMLMessage(" -> Info: No Monitor Config: InvID:$SQLXinvID<br>");
      }
      
      } #2nd node check
     }  ##1st node check
    }   #if ($cpmon eq 1)     
    
    
   }    #if ($isUnique)
   &PrintHTMLMessage("FINISHED!<BR>");
   
   
   
   print "Task Complete!<br>\n";
  }     #if (lc($mode) eq "copyserver")
  
  ##################################################################################################  
  ##################################################################################################
  ##################################################################################################
  
  if (lc($mode) eq "copynode") {
   &PrintHTMLMessage("************************************************<BR>");
   &PrintHTMLMessage("***  Copy Nodes and all associated server and monitors   ***<BR>");
   &PrintHTMLMessage("************************************************<BR>");

   foreach (@reqTokens){
 	  if (!/\'|\;|\(|\)|\"|\`|\*|where\s+|truncate\s+|\s+from\s+|\select\s+|delete\s+|\s+as\s+/){  #No SQL Injection
	   if (/^nodename=*([^ ]*)/i){$nodename=$1;}	 
   	 if (/^id=*([^ ]*)/i){$id=$1;}	 
   	 if (/^ip4=*([^ ]*)/i){$ip4=$1;}	 
   	 if (/^ip6=*([^ ]*)/i){$ip6=$1;}	 
   	 if (/^port=*([^ ]*)/i){$port=$1;}	 
   	 if (/^cpserver=*([^ ]*)/i){$cpserver=$1;}	 
    }
   }   #foreach (@reqTokens)
   if ($cpserver =~ /on/i){
   	$cpserver=1;
   } else {
   	$cpserver=0;
   }	

   &PrintHTMLMessage("New Nodename: $nodename <BR>");
   &PrintHTMLMessage("New Node IPv4: $ip4 <BR>");
   &PrintHTMLMessage("New Node IPv6: $ip6 <BR>");
   &PrintHTMLMessage("Source NodeID: $id <BR>");


   $sqlstat = ("Select nodeID from tblNodes order by nodeID desc limit 1;"); 
   $sql = $dbh->prepare($sqlstat);
   $sql->execute;
   (my($sqlID)=$sql->fetchrow_array);
   $newnodeID=$sqlID+1;

   &PrintHTMLMessage("New NodeID: $newnodeID <BR>");
   $isUnique=1;
   
   
   #if ($ip4 !~ /(\d+).(\d+).(\d+).(\d+)/){ #2.0.5 disabled
   # $isUnique=undef;
   # $errmsg.="Error: The IP address is invalid <BR>";
   # &PrintHTMLMessage("Error: The IP address is invalid <br>");
   #}
   
   if ((!checkIP($ip4)) and ($ip4)){
   	$isUnique=undef;
   	&PrintHTMLMessage("Error: The IPv4 address is invalid <br>");
   }

   if ((!checkIP($ip6)) and ($ip6)){
   	$isUnique=undef;
   	&PrintHTMLMessage("Error: The IPv6 address is invalid <br>");
   }
   
   if ((!$ip4) and (!$ip6)) {   
   	&PrintHTMLMessage("Error: No ip address has been set, required is to set either v4 or v6 <br>");
   	$isUnique=undef;
   }	
   
   if (!$nodename) {
   	&PrintHTMLMessage("Error: No nodename has been set<br>");
   	$isUnique=undef;
   }


   if (!$port) {
   	&PrintHTMLMessage("Error: No port has been set<br>");
   	$isUnique=undef;
   }

   
   

   ################### 
   #Check node IP/Port
   ###################
   $sqlstat = ("Select enabled,Name,scheduler,service,vip,persistent,monitor from tblNodes where vip = '$ip4:$port' or vip6='$ip6:$port'");
   $sql = $dbh->prepare($sqlstat);
   $sql->execute;
   (my($SQLenabled,$SQLName,$SQLscheduler,$SQLservice,$SQLvip,$SQLpersistent,$SQLmonitor)=$sql->fetchrow_array);
   if ($SQLvip){
   	$isUnique=undef;
   	$errmsg.="Error: IP does already exist <BR>";
    &PrintHTMLMessage("Error: IP does already exist<br>");
   }
   
   ################### 
   #Check node name
   ###################
   $sqlstat = ("Select enabled,Name,scheduler,service,vip,persistent,monitor from tblNodes where Name = '$nodename'");
   #&PrintHTMLMessage("Error: Nodename does already exist<br>");
   $sql = $dbh->prepare($sqlstat);
   $sql->execute;
   (my($SQLenabled,$SQLName,$SQLscheduler,$SQLservice,$SQLvip,$SQLpersistent,$SQLmonitor)=$sql->fetchrow_array);
   if ($SQLvip){
   	$isUnique=undef;
   	$errmsg.="Error: Nodename does already exist: $nodename <BR>";
    &PrintHTMLMessage("Error: Nodename does already exist: $nodename<br>");
   }


   ######### 
   #Get node
   #########
   $sqlstat = ("Select enabled,Name,scheduler,service,vip,persistent,monitor from tblNodes where nodeID='$id'");
   $sql = $dbh->prepare($sqlstat);
   $sql->execute;
   (my($SQLenabled,$SQLName,$SQLscheduler,$SQLservice,$SQLvip,$SQLpersistent,$SQLmonitor)=$sql->fetchrow_array);
   #&PrintHTMLMessage("$SQLenabled,$SQLName,$SQLscheduler,$SQLservice,$SQLvip,$SQLpersistent,$SQLmonitor <br>");

  
   if ($isUnique) {
    ############# 
    #Insert node
    ############
   	$sqlstat = ("insert into tblNodes (nodeID,enabled,Name,scheduler,service,vip,persistent,monitor,vip6) values ('$newnodeID','$SQLenabled','$nodename','$SQLscheduler','$SQLservice','$ip4:$port','$SQLpersistent','$SQLmonitor','$ip6:$port') ");
    $sql  = $dbhn->do($sqlstat);
    if ($sql eq 1) {
     &PrintHTMLMessage(" -> OK: SQL Node Insert - New NodeID:$newnodeID <br>");
    } else {
   	 &PrintHTMLMessage(" -> ERROR: SQL Node Insert - New NodeID:$newnodeID  <br>");
    }
   

     ###########
     #Get server
     ###########
    if ($cpserver eq 1) {
     $sqlstat = ("Select invID from tblNodesInventory order by invID desc limit 1");
     $sql = $dbh->prepare($sqlstat);
     $sql->execute;
     (my($SQLinvID)=$sql->fetchrow_array);
     $newinvID=$SQLinvID+1;
     
     &PrintHTMLMessage(" -> Copy Server, new invID=$newinvID  <br>");
     $sqlstat = ("Select invID,resID,nodeID,snmpID,enabled,active,maintenance,failstate,port,method,link,weight,automovepoolid,weightdown,cmd_reset_id,bid FROM tblNodesInventory where nodeID = '$id'");
     $sql = $dbh->prepare($sqlstat);
     $sql->execute;
     while (my($SQLinvID,$SQLresID,$SQLnodeID,$SQLsnmpID,$SQLenabled,$SQLactive,$SQLmaintenance,$SQLfailstate,$SQLport,$SQLmethod,$SQLlink,$SQLweight,$SQLautomovepoolid,$SQLweightdown,$SQLcmd_reset_id,$SQLbid)=$sql->fetchrow_array){
      #&PrintHTMLMessage(" -> $SQLinvID,$SQLresID,$SQLnodeID,$SQLsnmpID,$SQLenabled,$SQLactive,$SQLmaintenance,$SQLfailstate,$SQLport,$SQLmethod,$SQLlink,$SQLweight,$SQLautomovepoolid,$SQLweightdown,$SQLcmd_reset_id,$SQLbid  <br>");	
      $sqlstat = ("insert into tblNodesInventory (invID,resID,nodeID,snmpID,enabled,active,maintenance,failstate,port,method,link,weight,automovepoolid,weightdown,cmd_reset_id,bid) values ('$newinvID','$SQLresID','$newnodeID','$SQLsnmpID','$SQLenabled','$SQLactive','$SQLmaintenance','$SQLfailstate','$SQLport','$SQLmethod','$ip4:$port','$SQLweight','$SQLautomovepoolid','$SQLweightdown','$SQLcmd_reset_id','$SQLbid')");
      #&PrintHTMLMessage(" -> $sqlstat  <br>");
      $sqln  = $dbhn->do($sqlstat);
      if ($sqln eq 1) {
       &PrintHTMLMessage(" -> OK: SQL Server Insert - New InvID:$newinvID <br>");
      } else {
   	   &PrintHTMLMessage(" -> ERROR: SQL Server Insert - New InvID:$newinvID  <br>");
   	   #&PrintHTMLMessage(" -> $sqlstat  <br>");
      }
      $newinvID++;
     }   #While
    }    #if ($cpserver eq 1) 
   }	  #if ($isUnique)
   &PrintHTMLMessage("FINISHED!<BR>");
   if ($errmsg) {
  	print "==xx==" . $errmsg;
   }	

   print "Task Complete!<br>\n";
   $retscriptname="mylvseditnode.pl";  
  }     #if (lc($mode) eq "copynode")
 }      #if ($granted) 

 print &HTMLEndInsideTable;
 print &HTMLEndOutsideTable;
 print &HTMLEndHeader;



 
 
sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}


sub lvslog {
 #Logs into sql
 #$_[0] = Code (used for the image)
 #$_[1] = Message
 #$_[2] = User
 #my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','$_[1]');" );
 my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message,epoche) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','".$_[1]."','".time."');" );
 $sqlcur->execute;
}



sub HTMLHeader {
#<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
my $ret='Content-type: text/html; charset=iso-8859-1

<html>
<head>
<title>LVS</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.fontairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #979696;
}
.fontnormal {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #979696;
}
.ecke-top-hg-lft {
	background-image: url(images/ecke-top-hg-lft.gif);
	background-repeat: repeat-y;
	background-position: right;
}
.whitefield {
	background-color: #FFFFFF;
	border: 1px solid #cfcfcf;
}
-->
</style>
<style type="text/css">
<!--
.fontblacksmall {
	font-family: Verdana;
	font-size: 10px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
-->
</style>
</head>
';
	
return $ret;	
}



sub HTMLStartOutsideTable {
my $ret='
<body><br>
<!-- Aussentabelle -->
<table width="830" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">LVS Copy  Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$GlobalAlias.'<span class="fontnormal"> (</span><span class="fontnormal">'.$GlobalTxt.'
          )</span></td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
';	
return $ret;		
}

sub HTMLStartInsideTable {
my $ret='
      <!-- Hier kommt innentabelle rein ! --><br>
      <br>
      <table width="549" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-lft.gif" width="19" height="11"></td>
          <td height="11" valign="bottom" background="/images/t2_top-hg.gif"></td>
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-rt.gif" width="19" height="11"></td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td bgcolor="f8f8f8" class="fontairname"></td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td class="whitefield"><br>
          <table width="90%" border="0" align="center" cellpadding="0" cellspacing="0">
           <tr>
           <td class="fontblacksmall">
 ';	                
 return $ret;		
}
                
                
                
sub HTMLEndInsideTable {
my $ret='
              </td>
              </tr>
            </table>
            <br>
          </td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-lft.gif" width="19" height="19"></td>
          <td height="19" background="/images/t2_bottom-hg.gif">&nbsp;</td>
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-rt.gif" width="19" height="19"></td>
        </tr>
        <tr> 
          <td colspan="2" align="left" valign="top"><a href="'."$httproot$retscriptname".'"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
          <td width="19">&nbsp;</td>
        </tr>
      </table>
      <!-- Innere Tabelle -->
 ';	                
 return $ret;		
}

sub HTMLEndOutsideTable {
my $ret='
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT servermanager FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	


sub URLDecode {
    my $theURL = $_[0];
    $theURL =~ tr/+/ /;
    $theURL =~ s/%([a-fA-F0-9]{2,2})/chr(hex($1))/eg;
    $theURL =~ s/<!--(.|\n)*-->//g;
    return $theURL;
}

sub PrintHTMLMessage {
	if ($HTMLLVSView){
	 print "$_[0]\n";
	} 
}



sub checkIP {  #2.0.5
 #my $ipaddr='fde2:8acd:e9d3::22011';
 $ipinvalid=undef;
 #print "Check IP  $_[0] <BR>";	 
 my $ip = new Net::IP ($_[0]) or &errorprint(Net::IP::Error());

 #$ip_num=$ip->intip();
 #$ipaddr=$ip->ip();
 #$ipver=$ip->version();
 #$iptype=$ip->iptype();
 if (!$ipinvalid) {
 	#if ($opt_v) {
  # print ("$_[0] = IP Version: ".$ip->version()." (VALID)\n");
  # #print ("Size: ".$ip->size()."\n");
  # #print ("Len : ".$ip->prefixlen()."\n");
  # #print ("Type: ".$ip->iptype()."\n");
  #} 
  return 1;
 }
 return undef; 
}


sub errorprint {  #2.0.5
	#if ($opt_v) {
	# print "$_[0]\n";
	#} 
	$ipinvalid=1;
}
