#!/usr/bin/perl -w

################################
#Show LVS2 Add/Edit Server Mask
################################

use strict;
use DBI;
use Time::localtime;
#use Geo::IPfree;  

#2.0.3 - Add Visible mode - May 2011
#2.0.4 - Add Wakup and Shutdown-Jul2011
#2.0.5 - Add v6 support 

my $version="2.0.5";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############
####################### CONFIGURATION #######################


#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;   #user login flag - default off

#Load LVS htmlhelper
use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript);
use htmlsetuphelper qw(&htmlsetuptab &htmlsetupcss &htmlmainsetupheader);

#########################################################################################
my ($ServerName,$NodeIP,$Protocol,$Schedule,$Port,$Persistance,$tresid,$ResID,$ttt,$IP,$SQLCName,$SQLCID,$SQLcmd_reset_id,$RebootID,$MRTG,$ShutID,$WakeID);
my ($Visible,$MAC);  #2.0.3
my ($selmonval,$selen,$selenval,$txtProto,$tblText);
my ($IP6);  #2.0.5
my $EditMode=undef;
my ($dbh,$dbhn,$ret);
#########################################################################################
#BEGIN
$granted=&chkuser($curuser);  #Check User
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$dbhn = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 

if ($tparam =~ /^serverid=/) {
 $EditMode=1;
 if ($tparam =~ m/serverid=(\d*)/){ 
  $tresid=$1;
  my $sql = $dbh->prepare("SELECT enabled,alias,realip,realip6,cmd_reboot_id,mrtg_link,resID,visible,mac,cmd_shutdown_id,cmd_wakeup_id FROM tblResources where resID='".$1."' ;" );  	
  $ttt=("SELECT enabled,alias,realip,realip6,cmd_reboot_id,mrtg_link,resID,visible,mac,cmd_shutdown_id,cmd_wakeup_id FROM tblResources where resID='".$1."' ;" );  	
  $sql->execute ; 
  (my($enabled,$alias,$realip,$realip6,$cmd_reboot_id,$mrtg_link,$resID,$visible,$mac,$Shutcmd,$Wakecmd)=$sql->fetchrow_array);
  $txtProto="IP Address";
  $IP=$realip;
  $IP6=$realip6;  #2.0.5
  $ServerName=$alias;
  $ResID=$resID;
  $RebootID=$cmd_reboot_id;
  $ShutID=$Shutcmd;
  $WakeID=$Wakecmd;
  $MRTG=$mrtg_link;
  $MAC=$mac;
  
  
  #$Visible=$visible;
  if ($visible eq 1){
   $Visible="checked";
  } else {
  	$Visible="";
  }	

  
  if ($enabled eq 1){
   $selenval="checked";
   #$selen=1;
  }
  if ($enabled eq 2){
   $selenval="";
   #$selen=0;
  }
 }	
}	

if ($ServerName){
 $tblText="Server Manager:&nbsp;Edit: $ServerName - ResID: $ResID";
} else {
 $tblText="Server Manager:&nbsp;Add";
} 

print htmlmainheader;
print htmlsetupcss;
print jscript;
print htmlmaintab(7,860,0);


#print &HTMLHeader;
print &HTMLStartOutsideTable; 	
print htmlsetuptab(2);
print &HTMLInnerTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;

#END SCRIPT
           


sub chkDate () {
	if (length($_[0]) eq 1 ) {
		return "0" . $_[0];
	} else {
    return $_[0];		
	}
}           


sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}






sub HTMLStartOutsideTable {
my $ret='
<table width="860" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="794" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$tblText.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  
  <tr> 
    <td width="33" height="10" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>

  <tr> 
    <td width="33" height="184" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt die innere Tabelle rein ! --><br>
      
';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT showcon FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	




sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);

    $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
}


sub HTMLInnerTable{
my $ret='	
	  <table width="769" border="0" align="center" cellpadding="0" cellspacing="0"><form action="mylvsservermgr.pl" method="post/get">
	  
        <!-- Weisser Aussenrahmen -->
         <tr> 
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_top-corner-lft.gif" width="11" height="8"></td>
         <td width="95" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="291" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="100" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="258" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="14" height="8" align="right" valign="bottom"><img src="/images/t1_top-corner-rt.gif" width="14" height="8"></td>
        </tr>
        <!-- Grau unterlegter Aussenrahmen Oben -->
         <tr> 
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_top-gray-lft.gif" width="11" height="8"></td>
         <td width="95" height="8" background="/images/t1_top-gray-hg.gif"></td>
         <td width="291" height="8" background="/images/t1_top-gray-hg.gif"></td>
         <td width="100" height="8" background="/images/t1_top-gray-hg.gif"></td>
         <td width="258" height="8" background="/images/t1_top-gray-hg.gif"></td>
         <td width="14" height="8" align="right" valign="bottom"><img src="/images/t1_top-gray-rt.gif" width="14" height="8"></td>
        </tr>
        <!-- Grau unterlegter Aussenrahmen Oben -->
        <tr> 
         <td width="11" height="14" align="right" valign="bottom"><img src="/images/t1_zeile-lft-cl.gif" width="11" height="14"></td>
         <td width="95" height="14" background="/images/t1_zeile-hg-bl.gif"></td>
         <td width="291" height="14" background="/images/t1_zeile-hg-bl.gif"></td>
         <td width="100" height="14" background="/images/t1_zeile-hg-bl.gif"></td>
         <td width="258" height="14" background="/images/t1_zeile-hg-bl.gif"></td>
         <td width="14" height="14" align="right" valign="bottom"><img src="/images/t1_zeile-rt-cl.gif" width="14" height="14"></td>
        </tr>
        <!-- Menu -->
        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">Name</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">
   	     <input name="servername" size="30" maxlength="30" class="fontblack" type="text" value="'.$ServerName.'">
   	     </td><td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1"></td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
  		    
	    	 </td>
         <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
        </tr>


        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">IP (v4)</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">
   	     <input name="ipv4" size="30" maxlength="30" class="fontblack" type="text" value="'.$IP.'">
   	     </td><td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1">IP (v6)</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
  		    <input name="ipv6" size="30" maxlength="30" class="fontblack" type="text" value="'.$IP6.'">
	    	 </td>
         <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
        </tr>


        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">MRTG Link</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">
   	     <input name="mrtg" size="30" maxlength="60" class="fontblack" type="text" value="'.$MRTG.'">
   	     </td>
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1">CmdLink</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
         ';  

         my $sql = $dbh->prepare("SELECT name,cmdID FROM tblCommands where type = '2' order by cmdID ;" );  	
         
         $sql->execute ; 
         $ret.=   '<select name="command">';

         if ($SQLcmd_reset_id ne "0"){
          $ret.=   '<option value="0">NA</option>';
         } else {
          #$ret.=   '<option value="0" selected>NA</option>';
          $ret.=   '<option value="0" selected>NA</option>';
         } 
          
          while (($SQLCName,$SQLCID)=$sql->fetchrow_array) {
           if ($SQLCID eq	$RebootID){
            $ret.=   '<option value="'.$SQLCID.'" selected>'.$SQLCName.'</option>';
           } else { 
            $ret.=   '<option value="'.$SQLCID.'">'.$SQLCName.'</option>';
           }
          }
         $ret.=   '</select>';
         $ret.=   '</td>
        <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
        </tr>

        <!-- #2.0.4 !-->
        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">ShutDown</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">';

         my $sql = $dbh->prepare("SELECT name,cmdID FROM tblCommands where type = '2' order by cmdID ;" );  	
         $sql->execute ; 
         $ret.=   '<select name="shutid">';

         if ($SQLcmd_reset_id ne "0"){
          $ret.=   '<option value="0">NA</option>';
         } else {
          #$ret.=   '<option value="0" selected>NA</option>';
          $ret.=   '<option value="0" selected>NA</option>';
         } 
          
          while (($SQLCName,$SQLCID)=$sql->fetchrow_array) {
           if ($SQLCID eq	$ShutID){
            $ret.=   '<option value="'.$SQLCID.'" selected>'.$SQLCName.'</option>';
           } else { 
            $ret.=   '<option value="'.$SQLCID.'">'.$SQLCName.'</option>';
           }
          }
         $ret.=   '</select>';
   	     $ret.='
   	     </td>
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1">WakeUPLink</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
         ';  

         my $sql = $dbh->prepare("SELECT name,cmdID FROM tblCommands where type = '2' order by cmdID ;" );  	
         $sql->execute ; 
         $ret.=   '<select name="wakeid">';

         if ($SQLcmd_reset_id ne "0"){
          $ret.=   '<option value="0">NA</option>';
         } else {
          #$ret.=   '<option value="0" selected>NA</option>';
          $ret.=   '<option value="0" selected>NA</option>';
         } 
          
          while (($SQLCName,$SQLCID)=$sql->fetchrow_array) {
           if ($SQLCID eq	$WakeID){
            $ret.=   '<option value="'.$SQLCID.'" selected>'.$SQLCName.'</option>';
           } else { 
            $ret.=   '<option value="'.$SQLCID.'">'.$SQLCName.'</option>';
           }
          }
         $ret.=   '</select>';
         $ret.=   '</td>
        <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
        </tr>



        <!-- #2.0.3 !-->
        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">MAC Addr</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">
         <input name="macadr" size="30" maxlength="60" class="fontblack" type="text" value="'.$MAC.'">
   	     </td>';
         if($EditMode){  #Show Info about Node Member
          $ret.='
          <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1">Info Node</td>  
          <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
          ';  
          my $sqlna = $dbh->prepare("SELECT invid,nodeID FROM tblNodesInventory where resID='".$tresid."' ;" );  	
          $sqlna->execute ; 
          $ret.=   '<select name="nodeinf">';
          while (my($SQLCResID,$SQLCNodeID)=$sqlna->fetchrow_array) {
          	my $sqlnb = $dbhn->prepare("SELECT name FROM tblNodes where nodeID='".$SQLCNodeID."' ;" );  	
          	$sqlnb->execute ; 
          	(my($SQLNname)=$sqlnb->fetchrow_array);
            $ret.=   '<option value="'.$SQLCResID.'">'.$SQLNname.' - '.$SQLCResID.'</option>';
          }
          $ret.=   '</select>';
          $ret.=   '&nbsp;</td>';
         } else { 
          $ret.='
          <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1"></td>  
          <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
          ';  
        }  
       $ret.='
    	 </td>
         <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
        </tr>




        <!-- End Test -->








        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">Enabled</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">
 		     <input name="enabled" type="checkbox" '.$selenval.'>	 
   	     </td>
          <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1">Visible</td>  
          <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
          <input name="visible" type="checkbox" '.$Visible.'>&nbsp;</td>
    	   </td>
         <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
         </tr>
         <tr> 
         <td width="11" height="30" align="right" valign="bottom"><img src="/images/t1_zeile-lft-cl.gif" width="11" height="30"></td>';
   	     #Add submit button
   	     if ($EditMode){
   	      $ret.='<td width="95" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1"><input type="submit" value="OK" class="fontblack"></td>';
         } else {
         	$ret.='<td width="95" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1"><input type="submit" value="Add" class="fontblack"></td>';
         }
         
         $ret.='
         <td width="291" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1">
   	     <td width="100" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1">';
   	     
   	     if ($EditMode){
   	      $ret.='<input name="mode" type="hidden" value="edit">';	 
   	     } else {
   	      $ret.='<input name="mode" type="hidden" value="add">';
   	     } 
   	     $ret.='
   	     </td>  
         <td width="258" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1">
         <input name="id" type="hidden" value="'.$tresid.'">	 

  	   	 </td>
         <td width="14" height="30" align="right" valign="bottom"><img src="/images/t1_zeile-rt-cl.gif" width="14" height="30"></td>
        </tr>
















        <!-- Zeile Blank - Abschluss Unten -->
         <tr> 
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-lft-bl.gif" width="11" height="29"></td>
         <td width="95" height="8" background="/images/t1_zeile-hg-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="291" height="8" background="/images/t1_zeile-hg-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="100" height="8" background="/images/t1_zeile-hg-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="258" height="8" background="/images/t1_zeile-hg-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="14" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-rt-bl.gif" width="14" height="29"></td>
        </tr>
        <!-- Zeile Grauverlauf Oben -->
        <!--         
         <tr> 
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
         <td width="747" height="8" background="/images/t1_zeile-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
        </tr>
        -->   
        <!-- Grau unterlegter Aussenrahmen Unten -->
        <tr> 
   		    <td width="11" height="14" align="right" valign="top"><img src="/images/t1_bottom-lft.gif" width="11" height="14"></td>  
          <td width="95"  height="8" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td width="291"  height="8" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td width="100"  height="8" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td width="258"  height="8" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td height="14" align="left" valign="top"><img src="/images/t1_bottom-rt.gif" width="14" height="14"></td>
        </tr>
        <tr> 
         <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
         <td width="19">&nbsp;</td>
        </tr>

     </table>


';
 
 return $ret;		

}