#!/usr/bin/perl 
#=> LVS Logo Page: http://mirror.etf.bg.ac.yu/lvs/logo/logo.html

#2.0.3	Add filed visible and mac in table tblResources
#				Dont show server if enabled = 0 and visible = 0


use warnings;
use strict;
use CGI::Carp qw(fatalsToBrowser);
use DBI;
use POSIX;
use Sys::Hostname;

#Too many problems for now using snmp ... MK 2015
#use Net::SNMP;  #Used for live http users


#####################################################################
my $scriptname = 'mylvs.pl';
my $version="2.0.5";
my $host = hostname;
#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;  #user login flag - default off


####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;


use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript);


############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############



$lvscmd=$lvscmd." -Ln";
#Debugging ...
#$lvscmd="/bin/cat /usr/local/dev/mysql/lvsstat.txt";
####################### CONFIGURATION #######################
my $MonTimeout = 1800;
my $DateFormat="%d.%m.%Y %H:%M:%S";
#####################################################################
my $ColEnmum=undef;
my ($ccol,$col_curservice,$col_curactive,$col_curweight,$col_active,$col_inactive,@ResHost,$dbh,$prthtml,$curmodeID,$curmodePropertyID,%ResSNMPID);
my (%NodeID,%NodeAddress,%NodePort,%NodeScheduler,%NodePersistent,%NodePersistentTimeout,%NodeProto,%ResSNMPKey,%ResSNMPPass,%ResSNMPPort,%ResSNMPTO,%ResSNMPEnable);
my (%RSAddress,%RSPort,%RSRoute,%RSWeight,%RSActive,%RSInActive,$sqlsnmpkey,$sqlsnmppass,$sqlsnmpport,$sqlsnmptimeout,$CurHTTPUsers,$col_curhttp,$curhttpusrlink);
my ($sqlInvID,$sqlInvEnabled,$sqlInvWeight,$sqlInvActive,$sqlSNMP,$mrtglink,%ResMrtgID,$sqlNodeID,$curnodeid,$tmpcurnodeid,$GlobalTxt,$mid,$uppen,$dslpen);
my (%ResAlias,%ResIP,%ResKEY,%ResEnabled,%ResWeight,%ResInvID,%ResMonStat,%ResMonLastCheck,$tmonstat,$img_monstat,$img_monstat_title,%ResServiceTot,%ResServices,$txt_curservice,$txt_curactive,%ResActiveSrvTot,%ResActiveConTot,%ResInActiveConTot,$tmpActive,$tmpInActive,%ResWeightTot,%ResWeightCur,$txt_curweight,$tmpstr4,$link_weight,$img_weight,$img_weight_title,$link_mgr,$img_enable,$img_enable_title,$img_enabled,$img_enabled_text);
my (%ResVisible); #2.0.3
my (%ResIP6,$hdeb,%NodeIDv4,%NodeIDv6); #2.0.5
my $prtDeb=undef;  #2.0.5 - set to undef for non debug
my $date=localtime(); 
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
&GetLVSOutput;

$curnodeid=undef;
$GlobalTxt="List all available Servers";
#$tparam = "nodeid=9";
if ($tparam =~ /^nodeid=/) {
 if ($tparam =~ m/nodeid=(\d*)/){
 	$curnodeid="$1";
  my $sqln = $dbh->prepare("SELECT name FROM tblNodes where nodeID = '" . $curnodeid . "';" ); 
  $sqln->execute ; 
  #while (($sqlInvID,$sqlInvEnabled,$sqlInvWeight,$sqlInvActive,$sqlSNMP,$sqlNodeID)=$sqlinv->fetchrow_array) {
  (my($tmpName)=$sqln->fetchrow_array);
  $GlobalTxt="List Server and Node: $tmpName  ID: $curnodeid ";
 } 
}

print htmlmainheader;
print htmlmaintab(5,860,0);
print htmlmaincss;
print jscript;
print &HTMLStartOutsideTable;
print &HTMLStartInsideTable;

 my $sqlres = $dbh->prepare("SELECT resID,alias,realip,enabled,mrtg_link,visible,realip6 FROM tblResources" ); 
 $sqlres->execute ; #Get Resources
 while (my($sqlResID,$sqlResAlias,$sqlResIP,$sqlResEnabled,$mrtglink,$sqlvisible,$sqlResIP6)=$sqlres->fetchrow_array) {
  $ResAlias{$sqlResID}=$sqlResAlias;
  $ResIP{$sqlResID}=$sqlResIP;
  $ResIP6{$sqlResID}=$sqlResIP6;
  $ResEnabled{$sqlResID}=$sqlResEnabled;
  $ResKEY{$sqlResAlias}=$sqlResID;
  $ResMrtgID{$sqlResID}=$mrtglink;
  $ResVisible{$sqlResID}=$sqlvisible;  #2.0.3
  
  
  #@ResHost[$sqlResID]=$sqlResAlias;
  my $sqlinv = $dbh->prepare("SELECT invID,enabled,weight,active,snmpid,nodeid FROM tblNodesInventory where resID = '" . $sqlResID . "';" ); 
  $sqlinv->execute ; #Get Inventory and ID's
  while (($sqlInvID,$sqlInvEnabled,$sqlInvWeight,$sqlInvActive,$sqlSNMP,$sqlNodeID)=$sqlinv->fetchrow_array) {
   #print "=>$sqlInvID\n";
   $ResInvID{$sqlResID}{$sqlInvID}=$sqlInvID;
   $ResWeight{$sqlResID}+=$sqlInvWeight;
   
   if (($ResIP6{$sqlResID})) { #2.0.5 ! Let v6 shown up in the weight stats
    $ResWeight{$sqlResID}+=$sqlInvWeight;
    #$hdeb.="DEBW $ResIP6{$sqlResID} -- $ResIP{$sqlResID} -- $ResWeight{$sqlResID}<br>";
   }
   
   if ($sqlSNMP ne 0) {
    $ResSNMPID{$sqlResID}{$sqlSNMP}=$sqlSNMP;
    my $sqlsnmp = $dbh->prepare("SELECT snmpkey,snmppass,snmpport,snmptimeout FROM tblSNMP where snmpID = '" . $sqlSNMP . "';" ); 
    $sqlsnmp->execute ; #Get Inventory and ID's
    (($sqlsnmpkey,$sqlsnmppass,$sqlsnmpport,$sqlsnmptimeout)=$sqlsnmp->fetchrow_array);
    $ResSNMPEnable{$sqlResID}=1;
    $ResSNMPKey{$sqlResID}=$sqlsnmpkey;
    $ResSNMPPass{$sqlResID}=$sqlsnmppass;
    $ResSNMPPort{$sqlResID}=$sqlsnmpport;
    $ResSNMPTO{$sqlResID} =$sqlsnmptimeout;
   }
   if (($sqlInvEnabled eq 1) and ($sqlInvActive eq 1)) {
    $ResServiceTot{$sqlResID}++;
    $ResServices{$sqlResID}++;

    if (($ResIP6{$sqlResID}) and ($ResIP{$sqlResID})) { #2.0.5 ! Let v6 shown up in the weight stats
     $ResServiceTot{$sqlResID}++;
     $ResServices{$sqlResID}++;
    }
    
    
    
   } else {
   	$ResServiceTot{$sqlResID}++;
   }
   my $sqlmon = $dbh->prepare("SELECT monID,status,lastcheck FROM tblMonitor where invID = '" . $sqlInvID . "' and enabled=1;" ); 
   $sqlmon->execute ; #Get Monitor Datas
   while (my($sqlMonID,$sqlMonStat,$sqlMonLastCheck)=$sqlmon->fetchrow_array) {
    if ($sqlMonStat eq "OK"){
    	$tmonstat=1;
    	$ResMonStat{$sqlResID}{$sqlMonID}=1;
    	$ResMonLastCheck{$sqlResID}{$sqlMonID}=$sqlMonLastCheck;
    } else {
     if (($sqlMonStat eq "UNKNOWN") or ($sqlMonStat eq 0)){
    	$ResMonStat{$sqlResID}{$sqlMonID}=2;
    	$ResMonLastCheck{$sqlResID}{$sqlMonID}=$sqlMonLastCheck;
     } else {
     	$ResMonStat{$sqlResID}{$sqlMonID}=undef;
    	$ResMonLastCheck{$sqlResID}{$sqlMonID}=$sqlMonLastCheck;
     }		
    }
   }
  }
 } 
 #######  Get Total Services vs Enabled Services  ########
 for my $resources (sort values %ResAlias ){  #Use ResAlias for alphabetic sort and as hash for $ResKEY
  $tmpcurnodeid=undef;
  my $sqlt = $dbh->prepare("SELECT invID FROM tblNodesInventory where nodeID = '" . $curnodeid . "' and resID = '".$ResKEY{$resources}."';" ); 
  $sqlt->execute ; 
  (my($tmpcurnodeid)=$sqlt->fetchrow_array);
  if ((!$curnodeid) or ($tmpcurnodeid)){   #Filter Nodes  	
   $txt_curservice="0/0";
   $col_curservice="fontorangebold";
   $tmpActive=0;
   $tmpInActive=0;
   if (!$ResServiceTot{$ResKEY{$resources}}){$ResServiceTot{$ResKEY{$resources}}=0;}
   if ($ResServiceTot{$ResKEY{$resources}} ne $ResServices{$ResKEY{$resources}}) { 
    $col_curservice="fontorangebold";
    $txt_curservice="$ResServices{$ResKEY{$resources}}/$ResServiceTot{$ResKEY{$resources}}";
   } else { 
    $col_curservice="fontblack";
    $txt_curservice="$ResServices{$ResKEY{$resources}}/$ResServiceTot{$ResKEY{$resources}}";
   } 
   ####### DONE:  Get Total Services vs Enabled Services  ########
 
   #######  Get Live Services and Weigth vs Enabled Services  ########
   for my $pntbase (sort keys %NodeID){  #Enum LVS Inventory
    for my $pntval (sort keys %{$RSAddress{$pntbase}} ){
    	
     #$hdeb.="$RSAddress{$pntbase}{$pntval}<br>";
    	
    	
     #if ( ($RSAddress{$pntbase}{$pntval} eq $ResIP{$ResKEY{$resources}})  or ($RSAddress{$pntbase}{$pntval} eq $ResIP6{$ResKEY{$resources}}) ) {
     if ( ($RSAddress{$pntbase}{$pntval} eq $ResIP{$ResKEY{$resources}})  	 ) {
      $ResActiveSrvTot{$ResKEY{$resources}}++;
      $ResActiveConTot{$ResKEY{$resources}}+=$RSActive{$pntbase}{$pntval};
      $ResInActiveConTot{$ResKEY{$resources}}+=$RSInActive{$pntbase}{$pntval};
      $ResWeightCur{$ResKEY{$resources}}+=$RSWeight{$pntbase}{$pntval};
      $hdeb.="V4====$RSAddress{$pntbase}{$pntval} --- $ResActiveSrvTot{$ResKEY{$resources}}<br>";
      $NodeIDv4{$curmodeID}=1; #2.0.5 - Display Fix
     }
     

     if ( ($RSAddress{$pntbase}{$pntval} eq $ResIP6{$ResKEY{$resources}})  	 ) {
      #NodeIDv6{$curmodeID}=$curmodeID;
      #if (!$NodeIDv4{$curmodeID}) {  #let them count ..!
       $ResActiveSrvTot{$ResKEY{$resources}}++;  #2.0.5 Count v6 if v4 is not present
       $ResWeightCur{$ResKEY{$resources}}+=$RSWeight{$pntbase}{$pntval}; #2.0.5 Count v6 if v4 is not present
       $hdeb.="V6====$RSAddress{$pntbase}{$pntval} --- $ResActiveSrvTot{$ResKEY{$resources}} <br>";
      #} 
      $ResActiveConTot{$ResKEY{$resources}}+=$RSActive{$pntbase}{$pntval};
      $ResInActiveConTot{$ResKEY{$resources}}+=$RSInActive{$pntbase}{$pntval};
      
     }
    }
   }
  
   if ($ResActiveSrvTot{$ResKEY{$resources}} ne $ResServices{$ResKEY{$resources}}) {   
    if (!$ResActiveSrvTot{$ResKEY{$resources}}) {
    	$ResActiveSrvTot{$ResKEY{$resources}}="0";
 	  }
    $txt_curactive="$ResActiveSrvTot{$ResKEY{$resources}}/$ResServices{$ResKEY{$resources}}";
    $col_curactive="fontorangebold";
   } else {
 	  $txt_curactive="$ResActiveSrvTot{$ResKEY{$resources}}/$ResServices{$ResKEY{$resources}}";
 	  $col_curactive="fontblack";
   }
   if (!$ResWeightCur{$ResKEY{$resources}}){$ResWeightCur{$ResKEY{$resources}}=0;}
   if ($ResWeight{$ResKEY{$resources}} ne $ResWeightCur{$ResKEY{$resources}}){
    $txt_curweight="$ResWeightCur{$ResKEY{$resources}}/$ResWeight{$ResKEY{$resources}}";
    $col_curweight="fontblack";
    $col_curweight="fontorangebold";
   } else {
    $txt_curweight="$ResWeightCur{$ResKEY{$resources}}/$ResWeight{$ResKEY{$resources}}";
    $col_curweight="fontblack";
   }
   if ($ResWeightCur{$ResKEY{$resources}} eq 0) {
    $img_weight="/images/down.gif";
    $img_weight_title="Drain Up";
    
    my $sqlm = $dbh->prepare("SELECT mid FROM tblMaintenance where ip = '" . $ResIP{$ResKEY{$resources}} . "' and (updatepending='1' or DSLMaintenance='1');" );   
    $sqlm->execute ; 
    ($mid)=$sqlm->fetchrow_array;
    $link_weight="mylvsmgr.pl?wu=$ResKEY{$resources}";
    if ($mid) {
     $img_weight="/images/down1.gif";
     $img_weight_title="Maintenance pending";
     $link_weight="";	
    } 
   } else {
    $img_weight="/images/up.gif";
    $img_weight_title="Drain Down";
    $link_weight="mylvsmgr.pl?wd=$ResKEY{$resources}";
    my $sqlm = $dbh->prepare("SELECT mid FROM tblMaintenance where ip = '" . $ResIP{$ResKEY{$resources}} . "' and DSLMaintenance='1';" );   
    $sqlm->execute ; 
    ($mid)=$sqlm->fetchrow_array;
    $link_weight="mylvsmgr.pl?wd=$ResKEY{$resources}";
    if ($mid) {
     $img_weight="/images/down1.gif";
     $img_weight_title="DSL Maintenance pending";
     $link_weight="";	
    } 
   }
   $tmpActive=$ResActiveConTot{$ResKEY{$resources}};
   $tmpInActive=$ResInActiveConTot{$ResKEY{$resources}};
   if (!$tmpActive) {$tmpActive=0}
   if (!$tmpInActive) {$tmpInActive=0}
   if ($tmpActive >= $ActiveWarning) {
  	 $col_active="fontorangebold";   	
   } else {
    $col_active="fontblack";   	
   }
   if ($tmpInActive >= $InActiveWarning) {
  	 $col_inactive="fontorangebold";   	
   } else {
    $col_inactive="fontblack";   	
   }
   #######  Get Monitor Status  ########
   $img_monstat="/images/blue.gif";
   $img_monstat_title="Off";
   for my $value (sort keys %{$ResMonStat{$ResKEY{$resources}}} ){
    if ($ResMonStat{$ResKEY{$resources}}{$value}){
    	if ($ResMonStat{$ResKEY{$resources}}{$value} eq 2 ){
      $img_monstat="/images/gray.gif";
      $img_monstat_title="Unknown";
     } else {
    	 $img_monstat="/images/green.gif";
    	 $img_monstat_title="OK";
    	 if ((time-$ResMonLastCheck{$ResKEY{$resources}}{$value}) > $MonTimeout) {
       $img_monstat="/images/yellow.gif";
  	   $img_monstat_title="Check Time - $value - $ResKEY{$resources} - $ResMonStat{$ResKEY{$resources}}{$value}";
      }
     }
    } else {	
     $img_monstat="/images/red.gif";
     $img_monstat_title="Failure - $value - $ResKEY{$resources} - $ResMonStat{$ResKEY{$resources}}{$value}";
     last;
    }	
   }
   ####### DONE:  Get Monitor Status  ########
  
   if ($ResEnabled{$ResKEY{$resources}} eq 0 ) {
  	$col_curservice="fontblack";
    $img_monstat="/images/blue.gif";
    $img_monstat_title="Off";
    $txt_curservice="OFF";
    $col_curservice="fontorangebold";
    #Overwrite Service Display
    $txt_curactive="OFF";
    $col_curactive="fontorangebold";
    $img_enable="/images/kreuz_red.gif";
    $img_enable_title="Turn On";
    $link_mgr="mylvsmgr.pl?tu=$ResKEY{$resources}";
    $img_enabled="/images/kreuz_red.gif";
    $img_enabled_text="Disabled";
    
    
    my $sqlm = $dbh->prepare("SELECT mid,updatepending,DSLMaintenance FROM tblMaintenance where ip = '" . $ResIP{$ResKEY{$resources}} . "' and (updatepending='1' or DSLMaintenance='1') ;" );   
    
    $sqlm->execute ; 
    ($mid,$uppen,$dslpen)=$sqlm->fetchrow_array;
    if ($mid) {
     if ($dslpen){
      $img_enable_title="DSL - Maintenance pending";
      $link_mgr="";
     } else {
      $img_enable_title="Maintenance pending";
      $link_mgr="";
     } 
    } 
   
   } else {	

    #my $sqlm = $dbh->prepare("SELECT mid FROM tblMaintenance where ip = '" . $ResIP{$ResKEY{$resources}} . "' and  DSLMaintenance='1' ;" );   
    #$sqlm->execute ; 
    #($mid)=$sqlm->fetchrow_array;
    #if ($mid) {
    # $img_enable_title="Maintenance pending";
    # $img_enable="/images/kreuz_red.gif";
    # $link_mgr="";
    #} else {
     $img_enable="/images/gruener_haken2.gif";
     $img_enable_title="Turn Off";
     $link_mgr="mylvsmgr.pl?td=$ResKEY{$resources}";
     $img_enabled="/images/haken_green.gif";
     $img_enabled_text="Enabled";
    #}
   
   
   
   }	
 
   #Get HTTP Users 
   $CurHTTPUsers="-";  
 	 $col_curhttp="blackLink";
 	 $curhttpusrlink="#";
   if (($txt_curservice !~ /OFF/i) and ($txt_curactive !~ /OFF/i) and ($img_weight_title !~ /Drain Up/i)) {
    if ($ResSNMPEnable{$ResKEY{$resources}}) {
     $CurHTTPUsers= &GetSnmpVal ($ResIP{$ResKEY{$resources}},$ResSNMPKey{$ResKEY{$resources}},$ResSNMPPass{$ResKEY{$resources}},$ResSNMPPort{$ResKEY{$resources}},$ResSNMPTO{$ResKEY{$resources}});
     if ($CurHTTPUsers >= $HTTP_ERR) {
     	$col_curhttp="redLink";
    	$curhttpusrlink=$ResMrtgID{$ResKEY{$resources}};
     } else {
    	 if ($CurHTTPUsers >= $HTTP_WARN) {
     	  $col_curhttp="orangeLink";
    	  $curhttpusrlink=$ResMrtgID{$ResKEY{$resources}};
      } else {
       $col_curhttp="blackLink";
       $curhttpusrlink=$ResMrtgID{$ResKEY{$resources}};
      }
     }
    }   
   } else {
    $CurHTTPUsers="NA";  
    $curhttpusrlink="#";
    $col_curhttp="blackLink";
   }
   
   #If visible = 0 and enabled = 0 then DO NOT DISPLAY #2.0.3
   #If visible = 0 and enabled = 1 then DISPLAY  #2.0.3
   #If visible = 1 and enabled = 0 then DISPLAY  #2.0.3
   #If visible = 1 and enabled = 1 then DISPLAY  #2.0.3
   
   
   if (($ResVisible{$ResKEY{$resources}} ne 0 )  or ($ResEnabled{$ResKEY{$resources}} ne 0)) { #2.0.3
   $prthtml .= '
    <tr>
          <td width="11" height="29" align="right"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
          <td height="29" background="/images/t1_zeile-hg.gif" class="blackLink"><A HREF="mylvshst.pl?edit='.$ResKEY{$resources}.'">'.$resources.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="50" height="29" align="center" background="/images/t1_zeile-hg.gif"><a href="'.$link_mgr.'"><img src="'.$img_enable.'" width="20" height="20" border="0" title="'.$img_enable_title.'"></a></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="50" height="29" align="center" background="/images/t1_zeile-hg.gif"><a href="'.$link_weight.'"><img src="'.$img_weight.'" width="8" height="10" border="0" title="'.$img_weight_title.'"></a></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="50" height="29" align="center" background="/images/t1_zeile-hg.gif"><img src="'.$img_enabled.'" width="20" height="20" border="0" title="'.$img_enabled_text.'"></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="50" height="29" align="center" background="/images/t1_zeile-hg.gif"><img src="'.$img_monstat.'" width="19" height="17" title="'.$img_monstat_title.'"></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="50" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$col_curservice.'">'.$txt_curservice.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="50" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$col_curactive.'">'.$txt_curactive.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="90" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$col_curweight.'">'.$txt_curweight.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="40" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$col_active.'">'.$tmpActive.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="40" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$col_inactive.'">'.$tmpInActive.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="40" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$col_curhttp.'"><a href="'.$curhttpusrlink.'">'.$CurHTTPUsers.'</td>
          <td width="11" height="29" align="left"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
     </tr>
   ';
   }      #(($ResVisible{$ResKEY{$resources}} ne 0 )  or ($ResEnabled{$ResKEY{$resources}} ne 0))  #2.0.3
  }       #if (($curnodeid) and ($curnodeid eq $sqlNodeID)   #Filter Nodes 
 }        # for my $resources (sort values %ResAlias )
 
print $prthtml;
print &HTMLEndInsideTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;


#########  END SCRIPT  ######## 
 
 
 
sub GetLVSOutput {
 #Parse LVS Command Output and save it to hash
 my @lvsret = `$lvscmd`;   #Get LVS Status
 for my $myret (@lvsret) {
 	chomp $myret;
  #Mask: "TCP  10.0.1.18:7000 wrr persistent 3600"
  #Mask: "UDP  10.0.1.22:7000 wrr persistent 3600"
 	$hdeb.="XXXXX  DEB1 => $myret<br>";
 	if ($myret!~/\s*\[/ ) {  #v6?  #2.0.5
 	 if ($myret =~ /^(\w{3})\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	  #print "XXXXX  DEB2 => $myret\n";
 	  $curmodeID++;
 	  $curmodePropertyID=0;
    $NodeID{$curmodeID}=$curmodeID;
    $NodeIDv4{$curmodeID}=$curmodeID;
    $NodeProto{$curmodeID}="$1";
 	  $NodeAddress{$curmodeID}="$2.$3.$4.$5";
 	  $NodePort{$curmodeID}="$6";
    $NodeScheduler{$curmodeID}="$7";		
    $NodePersistent{$curmodeID}="$8";		
    $NodePersistentTimeout{$curmodeID}="$9";		
 	 } else {
 	  if ($myret =~ /^(\w{3})\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w*)/) {
 	   #Mask: "TCP  10.0.1.18:7000 wrr"
     #Mask: "UDP  10.0.1.22:7000 wrr"
 	   #print "XYXYXY  DEB2a => $myret\n";
 	   $curmodeID++;
 	   $curmodePropertyID=0;
     $NodeID{$curmodeID}=$curmodeID;
     $NodeIDv4{$curmodeID}=$curmodeID;
     $NodeProto{$curmodeID}="$1";
 	   $NodeAddress{$curmodeID}="$2.$3.$4.$5";
 	   $NodePort{$curmodeID}="$6";
     $NodeScheduler{$curmodeID}="$7";		
     $NodePersistent{$curmodeID}="";		
     $NodePersistentTimeout{$curmodeID}="";		
 	  } else {
 	   if ($myret =~ /^FWM\s*(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	  	 #Mask: "FWM  1 wlc persistent 3600"
 	  	 #print "XXXXX  DEB3 => $myret\n";
 	 	 $curmodeID++;
 	 	 $curmodePropertyID=0;
 	 	 $NodeID{$curmodeID}=$curmodeID;
 	 	 $NodeIDv4{$curmodeID}=$curmodeID;
 	 	 $NodeProto{$curmodeID}="FWM";
 	 	 $NodeAddress{$curmodeID}="$1";
 	 	 $NodePort{$curmodeID}="0";
      $NodeScheduler{$curmodeID}="$2";		
      $NodePersistent{$curmodeID}="$3";		
      $NodePersistentTimeout{$curmodeID}="$4";		
 	   } else {
 	    if ($myret =~ /^FWM\s*(\d*)\s*(\w*)/) {
 	     #Mask: "FWM  1 wlc "
 	  	  #print "XXXXX  DEB3a => $myret\n";
 	 	  $curmodeID++;
 	 	  $curmodePropertyID=0;
 	 	  $NodeID{$curmodeID}=$curmodeID;
 	 	  $NodeIDv4{$curmodeID}=$curmodeID;
 	 	  $NodeProto{$curmodeID}="FWM";
 	 	  $NodeAddress{$curmodeID}="$1";
 	 	  $NodePort{$curmodeID}="0";
       $NodeScheduler{$curmodeID}="$2";		
       $NodePersistent{$curmodeID}="$3";		
       $NodePersistentTimeout{$curmodeID}="$4";		
 	    }
 	   }
 	  }
	 }	
  }   else {  #2.0.5 V6
   $hdeb.=" =oo> $myret<br>\n";
 	 if ($myret =~ /^(\w{3})\s*\[(.*)\]:(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	  $hdeb.=" yy=> $myret<br>\n";
 	  $curmodeID++;
 	  $curmodePropertyID=0;
    $NodeID{$curmodeID}=$curmodeID;
    $NodeIDv6{$curmodeID}=$curmodeID;
    $NodeProto{$curmodeID}="$1";
 	  $NodeAddress{$curmodeID}="$2";
 	  $NodePort{$curmodeID}="$3";
    $NodeScheduler{$curmodeID}="$4";		
    $NodePersistent{$curmodeID}="$5";		
    $NodePersistentTimeout{$curmodeID}="$6";		
   } else {
   	#TCP [fde2:8acd:e9d3::220]:7798 wlc
 	  if ($myret =~ /^(\w{3})\s*\[(.*)\]:(\d*)\s*(\w*)/) {
 	   $hdeb.=" =xxs> $myret<br>\n";	
 	  	#Mask: TCP [fde2:8acd:e9d3::220]:7798 wlc
 	   $curmodeID++;
 	   $curmodePropertyID=0;
     $NodeID{$curmodeID}=$curmodeID;
     $NodeIDv6{$curmodeID}=$curmodeID;
     $NodeProto{$curmodeID}="$1";
 	   $NodeAddress{$curmodeID}="$2";
 	   $NodePort{$curmodeID}="$3";
     $NodeScheduler{$curmodeID}="$4";		
     $NodePersistent{$curmodeID}="";		
     $NodePersistentTimeout{$curmodeID}="";		
 	 }
  }
 } 	
 	
 	
 	
 	#Get Node Values
 	#Mask: " -> 10.0.1.240:0                 Route   100    0          0         "
 	if ($myret!~/\s*->\s*\[/ ) {  #v6?  #2.0.5
 	 if ($myret =~ m/\s*->\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w+)\s*(\d*)\s*(\d*)\s*(\d*)/) {
 	  $curmodePropertyID++;
    $RSAddress{$curmodeID}{$curmodePropertyID}="$1.$2.$3.$4";
    $RSPort{$curmodeID}{$curmodePropertyID}="$5";
    $RSRoute{$curmodeID}{$curmodePropertyID}="$6";
    $RSWeight{$curmodeID}{$curmodePropertyID}="$7";
    $RSActive{$curmodeID}{$curmodePropertyID}="$8";
    $RSInActive{$curmodeID}{$curmodePropertyID}="$9";
 	 }
 	} else {  #v6
 		#if ($iptmp =~ /^\[(.*)\]:(\d+)$/) {
 		#$hdeb.="V6 --> $myret<br>\n";  #2.0.5
 		#  -> [fde2:8acd:e9d3::221]:7798   Route   100    0          0

 	  if ($myret =~ m/\s*->\s*\[(.*)\]:(\d*)\s*(\w+)\s*(\d*)\s*(\d*)\s*(\d*)/) {
 	   #$hdeb.="$1 $2 $3 -- Active=$5 InActive=$6<br>\n";  #2.0.5
 	   $curmodePropertyID++;
     $RSAddress{$curmodeID}{$curmodePropertyID}="$1";
     $RSPort{$curmodeID}{$curmodePropertyID}="$2";
     $RSRoute{$curmodeID}{$curmodePropertyID}="$3";
     $RSWeight{$curmodeID}{$curmodePropertyID}="$4";
     $RSActive{$curmodeID}{$curmodePropertyID}="$5";
     $RSInActive{$curmodeID}{$curmodePropertyID}="$6";
   
 	 } else {
 	  if ($myret =~ /^FWM\s*(\d*)\s*(\w*)/) {  #=> experimental - not tested yet
 	   #Mask: "FWM  1 wlc "
 	   #print "XXXXX  DEB3a => $myret\n";
 	 	 #$curmodeID++;
 	 	 $curmodePropertyID=0;
 	 	 $NodeID{$curmodeID}=$curmodeID;
 	 	 $NodeIDv6{$curmodeID}=$curmodeID;
 	 	 $NodeProto{$curmodeID}="FWM";
 	 	 $NodeAddress{$curmodeID}="$1";
 	 	 $NodePort{$curmodeID}="0";
     $NodeScheduler{$curmodeID}="$2";		
     $NodePersistent{$curmodeID}="$3";		
     $NodePersistentTimeout{$curmodeID}="$4";		
 	  }
 	 }
 	}
 }    #for my $myret (@lvsret)
}     #sub GetLVSOutput



sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}





sub HTMLStartOutsideTable  {
my $ret='
<!-- Aussentabelle -->
<table width="830" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version - Hostname: $host".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$GlobalTxt.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
';
return $ret;	
}




sub HTMLStartInsideTable {
my $ret='
      <!-- Hier kommt innentabelle rein ! --><br>
	  
	  <table width="719" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_top-corner-lft.gif" width="11" height="8"></td>
          <td height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>      
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>      
          <td width="50" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="90" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="40" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="40" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="40" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="11" height="8" align="left" valign="bottom"><img src="/images/t1_top-corner-rt.gif" width="11" height="8"></td>
  </tr>
  <tr>
          <td width="11" height="41" align="right"><img src="/images/t1_top-gray-lft.gif" width="11" height="41"></td>      
          <td height="41" background="/images/t1_top-gray-hg.gif" class="fontairname"><br>
            Server name</td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="50" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            Mode </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="50" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            Weight </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="50" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            Enabled </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="50" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            Monitor </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>	
          <td width="50" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            Nodes </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="50" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            NodeStat </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="90" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            WeightStat(A/C) </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="40" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            Active </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="40" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            InAct </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="40" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
            HTTP </td>
          <td width="11" height="41" align="left"><img src="/images/t1_top-gray-rt.gif" width="11" height="41"></td>
  </tr>
	
';
return $ret;		
}


sub HTMLEndInsideTable {
my $ret='
        <tr> 
          <td width="11" height="14" align="right" valign="top"><img src="/images/t1_bottom-lft.gif" width="11" height="14"></td>      
          <td height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="50" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="90" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="40" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="40" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="40" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="11" height="14" align="left" valign="top"><img src="/images/t1_bottom-rt.gif" width="11" height="14"></td>
  </tr>
</table>
<br>
<br>
      <!-- Innere Tabelle -->
      
';
return $ret;		
}
      
sub HTMLEndOutsideTable  {
	#<td class="fontairname"><img src="/images/lvs-50.png" ></td>
my $ret='
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'" ></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->

';
return $ret;		
}

sub HTMLEndHeader {
my $ret='
</body>
</html>
';
if ($prtDeb) {  #2.0.5
 return $hdeb.$ret;		
} else { 
 return $ret;		
} 
}

sub GetSnmpVal {
  my $ssnmphost = $_[0];
  my $ssnmpkey = $_[1];
  my $ssnmpcommunity = $_[2];
  my $ssnmpport = $_[3];
  my $ssnmptimeout = $_[4];
  if ((length($ssnmpkey) gt 0 ) and ($ssnmpkey ne 0)){
   my ($session, $error) = Net::SNMP->session(
     -hostname  => $ssnmphost,
     -community => $ssnmpcommunity,
     -port      =>  $ssnmpport ,
     -timeout   =>  $ssnmptimeout
   );
   my $result = $session->get_request(
     -varbindlist => [$ssnmpkey]
   );
   
   if (!defined($result)) {
      my $restxt = $session->error;
      #&SysLog ($restxt);
      $session->close;
      return (-1);
   }
   
   return ("$result->{$ssnmpkey}");
  } else {
   return (0); 	
  } 
}

