#!/usr/bin/perl
#Script to load and apply ipvsadm out of the mylvs database.
#See this too: http://mylvs.com

#1.0.0 - Initial release 2014

#1.0.1 - Start the v6 project - Mai2017
#      - Add verbose (-v) parameter
#      - check if the v4 or v6 address is valid before applying it to ipvsadm
#      - Requires the following db update:
#        ALTER TABLE `mylvs`.`tblResources` ADD COLUMN `realip6` VARCHAR(45) AFTER `realip`;
#        ALTER TABLE `mylvs`.`tblNodes` ADD COLUMN `vip6` VARCHAR(51) AFTER `vip`;


#FW Mark samples:
#Apply FWMark on http
#iptables -A PREROUTING -t mangle -i eth0 -d 192.168.2.220 -p TCP --dport 80 -j MARK --set-mark 1
#ip6tables -A PREROUTING -t mangle -i eth0 -d fde2:8acd:e9d3::220 -p TCP --dport 80 -j MARK --set-mark 2
#and here is the corresponding ipvsadm command
#/usr/bin/sudo /sbin/ipvsadm -A -f 1
#/usr/bin/sudo /sbin/ipvsadm -a -f 1 -r 192.168.2.221:80 -g -w 100 
#/usr/bin/sudo /sbin/ipvsadm -a -f 1 -r 192.168.2.222:80 -g -w 100 
#/usr/bin/sudo /sbin/ipvsadm -A -f 2 -6
#/usr/bin/sudo /sbin/ipvsadm -a -f 2 -6 -r [fde2:8acd:e9d3::221]:80 -g -w 100 
#/usr/bin/sudo /sbin/ipvsadm -a -f 2 -6 -r [fde2:8acd:e9d3::222]:80 -g -w 100 
#see also: http://kb.linuxvirtualserver.org/wiki/IPv6_load_balancing	



use strict;
use DBI;
use POSIX;
use Getopt::Long; #1.0.1
use Net::IP ':PROC'; #1.0.1 -  #http://stackoverflow.com/questions/27398691/ip-database-from-ip2location-and-convert-ipv4-to-ipv6-in-perl -  apt-get install libnet-ip-perl
# apt-get install libnet-ip-perl

####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$opt_a);
&getconfig;
####################### CONFIGURATION #######################

my ($NodeID,$NodeName,$NodeScheduler,$NodeService,$NodeVIP,$NodePersistent,$ResAlias,$ResRealIP,$ResEnabled);
my ($InvID,$InvResID,$InvMethod,$invLink,$InvWeight,$InvAutomovePoolID,$InvPort,$InvFailstate);
my ($scheduler,$persistent);
my ($NodeVIP6,$ResRealIP6,$scheduler6,$opt_a,$opt_v,$opt_h,$ipinvalid,$applyv4,$applyv6,$applyNv4,$applyNv6); #1.0.1


#Read parameter:
Getopt::Long::Configure('bundling');
GetOptions
	("v"   => \$opt_v,
	 "a" => \$opt_a,
	 "h" => \$opt_h,
 );


######
#BEGIN
######

 if ($opt_h){
	print "usage: $0 -a (apply lvs commands) -v (verbose output, this disables -a) -h (help)\n";
	exit;
 }

 if ($opt_v){
	$opt_a=undef;
 }	
 
 if ($opt_a) {
  print "Apply: $lvscmd -C \n";
	`$lvscmd -C`;
 } else {
  print "$lvscmd -C \n";
 }

#Get Inventory from mySQL 
 my $dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword);
 my $sqlnode = $dbh->prepare("SELECT nodeID,Name,scheduler,service,vip,persistent,vip6 FROM tblNodes" );
 $sqlnode->execute ;  #Get Nodes
 while(($NodeID,$NodeName,$NodeScheduler,$NodeService,$NodeVIP,$NodePersistent,$NodeVIP6)=$sqlnode->fetchrow_array) {
  $scheduler=undef;
  $scheduler6=undef;
  $applyNv4=undef;
  $applyNv6=undef;
  if ($NodeVIP =~ /(.*):\d+$/) { #1.0.1 Check v4 Addr
  	$applyNv4=checkIP($1);
  }
  if ($NodeVIP6 =~ /(.*):\d+$/) { #1.0.1 Check v4 Addr
  	$applyNv6=checkIP($1);
  }
  
  if ($NodeService =~ /fwm/i) {
   $applyNv4=$NodeVIP; #Overwrite with fwmark
   $applyNv6=$NodeVIP6; #Overwrite with fwmark
   #print "DEB: $applyNv4 - $applyNv6\n";
  }

  
   if ($applyNv4){
    print "#Create Node: $NodeName\n";
    if ($NodeService =~ /udp/i) {
     $scheduler = "-u $NodeVIP";
    }
    if ($NodeService =~ /fwm/i) {
     $scheduler = "-f $NodeVIP";
     
    }
    if ($NodeService =~ /tcp/i) {
     $scheduler = "-t $NodeVIP";
    }
   }


   if ($applyNv6){
   	print "#Create Node: $NodeName\n";
    if ($NodeService =~ /udp/i) {
     if ($NodeVIP6 =~ /^(.*):(\d+)$/) {
      $scheduler6 = "-u [$1]:$2";

     } 
    }
    if ($NodeService =~ /fwm/i) {
     $scheduler6 = "-f $NodeVIP6 -6";	 #watch the -6 option with fwmark!
    }
    if ($NodeService =~ /tcp/i) {
     if ($NodeVIP6 =~ /^(.*):(\d+)$/) {
      $scheduler6 = "-t [$1]:$2";
     } 
    }
   }

  
  
  
   if ($NodePersistent ne "0"){
    $persistent = "-p $NodePersistent";
   } else {
    $persistent="";
   }	 
  #@}   #if (($applyv4) or ($applyv6))
  
  if ($opt_a)  {
   if ($applyNv4) {
    print "Apply (v4): $lvscmd -A $scheduler -s $NodeScheduler $persistent\n";
 	  `$lvscmd -A $scheduler -s $NodeScheduler $persistent`;
 	 } 
   if ($applyNv6) {
    print "Apply (v6): $lvscmd -A $scheduler6 -s $NodeScheduler $persistent \n";
 	  `$lvscmd -A $scheduler6 -s $NodeScheduler $persistent `;
   }
  } else {
   if ($applyNv4) {
    print "$lvscmd -A $scheduler -s $NodeScheduler $persistent\n";
   } 
   if ($applyNv6) {
    print "$lvscmd -A $scheduler6 -s $NodeScheduler $persistent \n";
   } 
  }	

  my $sqlnodeinv = $dbh->prepare("SELECT invID,resID,Method,Link,Weight,AutomovePoolID,Port,Failstate FROM tblNodesInventory where active='1' and nodeID='" . $NodeID ."';" );
  $sqlnodeinv->execute ;  #Get NodesInentory
  print "#Create Realserver: \n";
  while(($InvID,$InvResID,$InvMethod,$invLink,$InvWeight,$InvAutomovePoolID,$InvPort,$InvFailstate)=$sqlnodeinv->fetchrow_array) {
   #my $sqlnoderes = $dbh->prepare("SELECT alias,realip FROM tblResources where resID='" . $InvResID ."';" );
   #$sqlnoderes->execute ; #Get Resources
   my $sqlresource = $dbh->prepare("SELECT alias,realip,enabled,realip6 FROM tblResources where resID='" . $InvResID ."';" );
   $sqlresource->execute;
   (($ResAlias,$ResRealIP,$ResEnabled,$ResRealIP6)=$sqlresource->fetchrow_array)   ;
   if ($ResEnabled) {
    #1.0.1 - add $InvPort into the command string
  	$applyv4=checkIP($ResRealIP); #1.0.1
  	$applyv6=checkIP($ResRealIP6); #1.0.1
    if ($opt_a) {
    	if (($applyv4) and ($applyNv4)){
       print "Apply (v4): $lvscmd -a $scheduler -r $ResRealIP:$InvPort -$InvMethod -w $InvWeight #$NodeID-$InvID\n";
    	 `$lvscmd -a $scheduler -r $ResRealIP:$InvPort -$InvMethod -w $InvWeight`;
      } else {
       if ((!$applyNv4) and ($opt_v)){
      	print "SKIP Apply (v4): $lvscmd -a $scheduler -r $ResRealIP:$InvPort -$InvMethod -w $InvWeight #$NodeID-$InvID\n";	
       }
      }
      if (($applyv6) and ($applyNv6)) {
       print "Apply (v6): $lvscmd -a $scheduler6 -6 -r [$ResRealIP6]:$InvPort -$InvMethod -w $InvWeight #$NodeID-$InvID\n";
    	 `$lvscmd -a $scheduler6 -r [$ResRealIP6]:$InvPort -$InvMethod -w $InvWeight`;
    	} else {
    	 if ((!$applyNv6)  and ($opt_v)){
    	  print "SKIP Apply (v6): $lvscmd -a $scheduler6 -r [$ResRealIP6]:$InvPort -$InvMethod -w $InvWeight #$NodeID-$InvID\n";
    	 } 
    	 
    	}
    } else {
     if (($applyv4) and ($applyNv4)) {
      print "$lvscmd -a $scheduler -r $ResRealIP:$InvPort -$InvMethod -w $InvWeight #$NodeID-$InvID (v4) \n";
     } else {
   	  if ((!$applyNv4)  and ($opt_v)){
    	  print "SKIP $lvscmd -a $scheduler -r $ResRealIP:$InvPort -$InvMethod -w $InvWeight #$NodeID-$InvID (v4) \n";
    	} 
     }
     if (($applyv6) and ($applyNv6)){   
      print "$lvscmd -a $scheduler6 -r [$ResRealIP6]:$InvPort -$InvMethod -w $InvWeight #$NodeID-$InvID (v6)\n";
     } else {
   	  if ((!$applyNv6)  and ($opt_v) ){
    	  print "SKIP Apply (v6): $lvscmd -a $scheduler6 -r [$ResRealIP6]:$InvPort -$InvMethod -w $InvWeight #$NodeID-$InvID\n";
    	} 
	
      
     } 
    }	
   } 
  }
 } 
 
 ############
 #END SCRIPT
 ############
 
 sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
}





sub checkIP {

 #my $ipaddr='fde2:8acd:e9d3::22011';
 $ipinvalid=undef;
 my $ip = new Net::IP ($_[0]) or &errorprint(Net::IP::Error());

 #$ip_num=$ip->intip();
 #$ipaddr=$ip->ip();
 #$ipver=$ip->version();
 #$iptype=$ip->iptype();
 if (!$ipinvalid) {
 	if ($opt_v) {
   print ("$_[0] = IP Version: ".$ip->version()." (VALID)\n");
   #print ("Size: ".$ip->size()."\n");
   #print ("Len : ".$ip->prefixlen()."\n");
   #print ("Type: ".$ip->iptype()."\n");
  } 
  return 1;
 }
 return undef; 
}


sub errorprint {  #1.0.1
	if ($opt_v) {
	 print "$_[0]\n";
	} 
	$ipinvalid=1;
}
