#!/usr/bin/perl -w
#2009 05 09 look for exit

#######################
#Show MYLVS Connections
#######################


#2.0.1.0  Start testing       18Oct2006
#2.0.1.1  Add Geo::IPFree
#2.0.1.2  Changed Geo info to a csv/sql solution
#2.0.1.3  -housekeeping of geo functions - 20090509
#         -add new var = $SuppressedAddress for filtering internal ip addresses, 
#          we do not want to see them in the main view
#					-add $SuppressedAddress support within lvs.config.xml
#         -add new regex for searchargs - if ($tparam =~ m/search=(.*)/){ 
#         -flag improvemend $SYN_RECV / $FIN_WAIT
#         -Add new table - tblCustomFlags - resolve flags and links for customer ip address 	
#2.0.1.4  -Filter by username, exclude customer flags when special users are used - 20090528

use strict;
use DBI;
use Time::localtime;
#use Geo::IPfree;  




my $version="2.0.1.3";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############



use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript );


$lvscmd=$lvscmd." -Ln";
#Debugging ...
##$lvscmd="/bin/cat /usr/local/dev/mysql/ipvsadm.txt";
#$lvscmd="/bin/cat /usr/local/dev/mysql/lvsstat.txt";

#*************  LIST CONNECTIONS  ***************
##my $cmdcon = "/usr/bin/sudo /sbin/ipvsadm -L -n -c";    
my $cmdcon = $lvscmd." -c";
#my $cmdcon = "/bin/cat /usr/local/dev/mysql/lvsconx.txt";
my @cmdretcon = `$cmdcon`;
#*************  Finished LIST CONNECTIONS  ***************

my $defaultcount=50;  #if no parameter is given, remeber that there is also a max value in the xml config





####################### CONFIGURATION #######################


#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};

my $granted = undef;   #user login flag - default off
#For static test purposes ...
#$tparam = "y=2006?m=8?d=10";
#$tparam= "list=70";
#$tparam= "search=230.244.142.180";
#$tparam= "search=11.12.13.14";


#$curuser="hhiker";
#####################################################################
#####################################################################
my ($dbh,%Code,$resp,$ret,$sqlTst,$Cusr,$tmpcon,$var,$value,$FIN_WAIT,$NONE,$ESTABLISHED,$CLOSED,$SYN_RECV,$CONNECTIONS,$SENDER);
my (%tmpTotESTABLISHED,%tmpTotCLOSED,%tmpTotNONE,%tmpTotFIN_WAIT,%tmpTotSYN_RECV,$cnt,%TotLVSConnx,%tmpOrder,$reqcnt,$searchip,$tblText);
my ($tmpSource,$tmpTarget,$class_established,$class_closed,$class_tot,$class_none,$class_syn,$class_fin,$country,$country_name,$img_flag,$tmpipnum);
my $tmpESTABLISHED=undef;my $tmpCLOSED=undef;my $tmpNONE=undef;my $tmpFIN_WAIT=undef;my $tmpSYN_RECV=undef;

$reqcnt=10; #HotFixDefault - Nov2010

#Manage given paramteres if apply .... else use the conx default
if ($tparam =~ /^list=/) {
 if ($tparam =~ m/list=(\d*)/){ 
 	$reqcnt="$1"; 	
 	$tblText="List all connections";
  if ($SuppressedAddress){  #no search parameter given - exclude internal address
 	  $tblText.=" except $SuppressedAddress";
 	} 
 }
}	else {
 if ($tparam =~ /^search=/) {
  #if ($tparam =~ m/search=(\d*).(\d*).(\d*).(\d*)/){ 
  if ($tparam =~ m/search=(.*)/){ 
   #$searchip	= "$1.$2.$3.$4";                 
   $searchip	= "$1";                 
   $tblText='Search for SenderIP:&nbsp&nbsp<span class="fontblackairname">'.$searchip.'</span>';
   #$tblText="Search for SenderIP:  $searchip";
  } else {
   $reqcnt=$defaultcount;
   $tblText="List all connections";
   $searchip=undef;
   if (!$reqcnt){$reqcnt="$defaultcount"; }
  } 	
 } else {
 	$reqcnt=$defaultcount;
 	$tblText="List all connections";
 	$searchip=undef;
 	if (!$reqcnt){$reqcnt="$defaultcount"; }
 }	
}


#BEGIN
$granted=&chkuser($curuser);  #Check User
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 


####################################
#2.0.1.2 New Table !!!
my %ipinfo;
my (%ipInfoFrom,%ipInfoTo,%imgInfoDescription,%imgInfoFlagPath);

if ($curuser!~/hhiker/i){  #2.0.1.4
 my $sqlipmap = $dbh->prepare("SELECT cID,ipFrom,ipTo,imgDescription,imgFlagPath FROM tblCustomFlags;" );
 $sqlipmap->execute ; 
 while (my($cid,$ipFrom,$ipTo,$imgDescription,$imgFlagPath)=$sqlipmap->fetchrow_array) {
 	
 	#$tmpipnum=ip_to_numbe("$var"); 	#Konvert to ip to numeric
 	$ipInfoFrom{$cid}=ip_to_number("$ipFrom");
 	$ipInfoTo{$cid}=ip_to_number("$ipTo");
 	
 	$imgInfoDescription{$cid}=$imgDescription;
 	$imgInfoFlagPath{$cid}=$imgFlagPath;
 	
 	
 #	print "$cid,$ipInfoFrom{$cid}--$ipInfoTo{$cid}--,$imgInfoDescription{$cid},$imgInfoFlagPath{$cid}\n";
 }
} 
 #exit;

#$tmpipnum=ip_to_numbe("$var"); 	#Konvert to ip to numeric
###################################


print htmlmainheader;
print htmlmaintab(1,860,0);
print htmlmaincss;
print jscript;

if ($granted) {
 #my $GeoIP = Geo::IPfree::new();
 &GetConnections; 	
 print &HTMLStartOutsideTable; 	
 %tmpOrder=%TotLVSConnx;
   
 for my $source( sort { $tmpOrder{$b} <=> $tmpOrder{$a} } keys %tmpOrder ) {    	
 #for my $source( sort keys %TotLVSConnx  ) {
 ($var,$value) = split(/-/,$source,2);    
  
  if (($var !~ /$SuppressedAddress/) and (!$searchip)){ #2.0.1.3
   $cnt++;
  }
  

  #$tblText="List all connections";
  if ($searchip){ #2.0.1.3
   $cnt++;
  }

  
  if ((($cnt > $maxcount) or ($cnt > $reqcnt)) and (!$searchip))  { 
   last; 	
  };
 	
 		
 	
  
  if ((($searchip) and	($var =~ /$searchip/)) or (!$searchip)) {
 	
 	if ($TotLVSConnx{$source} > $ActiveWarning){
 		$class_tot="fontorangebold";
 	}	else {
 		$class_tot="fontblacksmall";
 	}
 	
 	
 	if ($tmpTotESTABLISHED{$source} > $ActiveWarning){
 		$class_established="fontorangebold";
 	}	else {
 		$class_established="fontblacksmall";
 	}
 		
 	if ($tmpTotCLOSED{$source} > $InActiveWarning){
 		$class_closed="fontorangebold";
 	}	else {
 		$class_closed="fontblacksmall";
 	}
 	
 	if ($tmpTotNONE{$source} > $InActiveWarning){
 		$class_none="fontorangebold";
 	}	else {
 		$class_none="fontblacksmall";
 	}

 	if ($tmpTotSYN_RECV{$source} > $InActiveWarning){
 		$class_syn="fontorangebold";
 	}	else {
 		$class_syn="fontblacksmall";
 	}

 	if ($tmpTotFIN_WAIT{$source} > $InActiveWarning){
 		$class_fin="fontorangebold";
 	}	else {
 		$class_fin="fontblacksmall";
 	}

 	
 	if (!$tmpTotESTABLISHED{$source}){$tmpTotESTABLISHED{$source}="0";} 
 	if (!$tmpTotCLOSED{$source}){$tmpTotCLOSED{$source}="0";} 
 	if (!$tmpTotNONE{$source}){$tmpTotNONE{$source}="0";} 
 	if (!$tmpTotFIN_WAIT{$source}){$tmpTotFIN_WAIT{$source}="0";} 
 	if (!$tmpTotSYN_RECV{$source}){$tmpTotSYN_RECV{$source}="0";} 
 	
 	

	my ($dbh,$Hostname);
	$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlname = $dbh->prepare("SELECT alias FROM tblResources where realip like '%".$value."%' ;" );
  $sqlname->execute ; 
  (($Hostname)=$sqlname->fetchrow_array);
  
  if (!$Hostname) {
  	$Hostname=$value;
  }
 	
  $tmpipnum=ip_to_number("$var"); 	#Konvert to ip to numeric
  $country=undef;
  $country_name=undef;
  $img_flag=undef;
  
  
  for my $pntip (sort keys %ipInfoFrom){  #
   #print "$cid,$ipInfoFrom{$cid}--$ipInfoTo{$cid}--,$imgInfoDescription{$cid},$imgInfoFlagPath{$cid}\n";
   if (($ipInfoFrom{$pntip}<=$tmpipnum) and ($ipInfoTo{$pntip}>=$tmpipnum)) {
   	$img_flag=$imgInfoFlagPath{$pntip};
  	$country_name=$imgInfoDescription{$pntip};
  		#print "$cid,$ipInfoFrom{$cid}--$ipInfoTo{$cid}--,$imgInfoDescription{$cid},$imgInfoFlagPath{$cid}\n";
   }	
  }
  
  
  
  
  if (!$country_name){
   my $sqlip = $dbh->prepare("SELECT ctry,country FROM tblIP2Country where ipfrom <='$tmpipnum' and ipto >='$tmpipnum' order by id;" );
   $sqlip->execute ; 
   (($country,$country_name)=$sqlip->fetchrow_array);
   if ($country) {
    #($country,$country_name) = $GeoIP->LookUp("$var") ; #Old fashion way ...
    $img_flag='"/flags/'.lc($country).'".png';
    $img_flag='"/flags/' . lc($country). '.png" alt="status name" width="17" height="14" border="0" ';
   } else {
    $img_flag='"/flags/ip.png" alt="status name" width="15" height="13" border="0" ';
    $country_name="Unknown $tmpipnum";
   }
  }   #if (!$country_name){


 	#<td width="113" height="29" align="center" background="/images/t1_zeile-hg.gif"><span class="fontblacksmall">'.$var.'</span></td>
 	#<td height="29" background="/images/t1_zeile-hg.gif" class="fontblacksmall"><img src="'.$img_flag.'" alt="status name" width="19" height="17" border="0" title="Sender from: '.$country_name.'"></td>
  if (($var !~ /$SuppressedAddress/) or ($searchip)){ 
   $ret='	 	
              <tr>
                <td width="11" height="29" align="right"><img src="/images/t1_zeile-lft.gif" alt="1" width="11" height="29"></td>
                <td height="29" background="/images/t1_zeile-hg.gif" class="fontblacksmall"><img src='. $img_flag .' title="Sender from: '.$country_name.'"></td>
                <td width="8" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                
                
                
                <td width="113" height="29" align="center" background="/images/t1_zeile-hg.gif"><span class="fontblacksmall">'.$var.'</span></td>
                <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                <td width="49" height="29" align="center" background="/images/t1_zeile-hg.gif"><span class="'.$class_tot.'">'.$TotLVSConnx{$source}.'</span></td>
                <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                <td width="48" height="29" align="center" background="/images/t1_zeile-hg.gif"><span class="'.$class_none.'">'.$tmpTotNONE{$source}.'</span></td>
                <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                
                <td width="56" height="29" align="center" background="/images/t1_zeile-hg.gif"><span class="'.$class_established.'">'.$tmpTotESTABLISHED{$source}.'</span></td>
                
                <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                <td width="48" height="29" align="center" background="/images/t1_zeile-hg.gif" class="fontorangebold"><span class="'.$class_syn.'">'.$tmpTotSYN_RECV{$source}.'</span></td>
                <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                <td width="52" height="29" align="center" background="/images/t1_zeile-hg.gif" class="fontorangebold"><span class="'.$class_fin.'">'.$tmpTotFIN_WAIT{$source}.'</span></td>
                <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                <td width="49" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$class_closed.'">'.$tmpTotCLOSED{$source}.'</td>
                <td width="10" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                <td width="40" height="29" align="center" background="/images/t1_zeile-hg.gif" class="fontblacksmall"><a href="mylvswhois.pl?show='.$var.'"><img src="/images/detail.gif" alt="status name" width="19" height="17" border="0" title="Get Info for: '.$var.'"></a></td>
                <td width="10" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                <td width="32" height="29" align="center" background="/images/t1_zeile-hg.gif" class="fontblacksmall"><a href="mylvsscan.pl?show='.$var.'"><img src="/images/trends.gif" alt="status name" width="19" height="17" border="0" title="Scan Host: '.$var.'"></a></td>
                <td width="10" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" alt="1" width="7" height="29"></td>
                <td width="106" height="29" align="center" background="/images/t1_zeile-hg.gif" class="fontblacksmall">'.$Hostname.' </td>
                 <td width="11" height="29" align="left"><img src="/images/t1_zeile-rt.gif" alt="status name" width="11" height="29"></td>
              </tr>
          ';	                
   print $ret;		
  } 
 }
}
}else {  # if ($granted) 
 print '   <table border=0 align="center" cellspacing="0" ><TR>';
 print '   <TD align="left" class=fontblackbig>No Permissions To View Connections !</TD></TR>';
 print "   </table>";
}        # if ($granted) 
print &HTMLEndOutsideTable;
print &HTMLEndHeader;

#END SCRIPT
           


sub chkDate () {
	if (length($_[0]) eq 1 ) {
		return "0" . $_[0];
	} else {
    return $_[0];		
	}
}           

sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}





sub HTMLStartOutsideTable {
#my $ret='
#<body>
#<p class="fontblold">
#  <!-- Aussentabelle -->
#</p>

#2.0.1.3
if (!$FIN_WAIT){$FIN_WAIT="0";} 
if (!$SYN_RECV){$SYN_RECV="0";} 
if (!$CLOSED){$CLOSED="0";}
if (!$CONNECTIONS){$CONNECTIONS="0";} 
if (!$SENDER){$SENDER="0";} 
if (!$ESTABLISHED){$ESTABLISHED="0";} 
 	
if (!$NONE){$NONE=0}
if (!$ESTABLISHED){$ESTABLISHED=0}	
if (!$CLOSED){$CLOSED=0}	
if (!$SYN_RECV){$SYN_RECV=0}		
if (!$CONNECTIONS){$CONNECTIONS=0}
if (!$SENDER){$SENDER=0}



	
my $ret='
<table width="860" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="794" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$tblText.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" height="484" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt innentabelle rein ! --><br>
      <table width="795" height="255" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-lft.gif" width="19" height="11"></td>
          <td width="757" height="11" valign="bottom" background="/images/t2_top-hg.gif"></td>
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-rt.gif" width="19" height="11"></td>
        </tr>
        <tr> 
          <td width="19" height="86" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td align="left" valign="top" bgcolor="f8f8f8" class="fontairname"><table width="685" height="146" border="0" align="center">
            <tr>
              <td width="679" height="142"><table width="635" border="0" align="center">
                  <tbody>
                    <tr>
                      <td width="145" class="fontblackblold" allign="left" vallign="center">Total Protocol State</td>
                      <td width="108" allign="left" vallign="center"><span class="fontblackblold">Amount</span></td>
                      <td width="58" allign="left" vallign="center">&nbsp;</td>
                      <td width="109" allign="left" vallign="center">&nbsp;</td>
                      <td width="105" class="fontblackblold" allign="left" vallign="center">Total Stats </td>
                      <td width="84" class="fontblackblold" allign="left" vallign="center">Anount</td>
                    </tr>
                    <tr>
                      <td class="fontblack" allign="left" vallign="center">FIN_WAIT</td>
                      <td class="fontblack" allign="left" vallign="center">'.$FIN_WAIT.'</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">Connections</td>
                      <td class="fontblack" allign="left" vallign="center">'.$CONNECTIONS.'</td>
                    </tr>
                    <tr>
                      <td class="fontblack" allign="left" vallign="center">NONE</td>
                      <td class="fontblack" allign="left" vallign="center">'.$NONE.'</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">Sender</td>
                      <td class="fontblack" allign="left" vallign="center">'.$SENDER.'</td>
                    </tr>
                    <tr>
                      <td class="fontblack" allign="left" vallign="center">ESTABLISHED</td>
                      <td class="fontblack" allign="left" vallign="center">'.$ESTABLISHED.'</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                    </tr>
                    <tr>
                      <td class="fontblack" allign="left" vallign="center">CLOSE</td>
                      <td class="fontblack" allign="left" vallign="center">'.$CLOSED.'</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                    </tr>
                    <tr>
                      <td class="fontblack" allign="left" vallign="center">SYN_RECV</td>
                      <td class="fontblack" allign="left" vallign="center">'.$SYN_RECV.'</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                      <td class="fontblack" allign="left" vallign="center">&nbsp;</td>
                    </tr>
                  </tbody>
              </table></td>
              </tr>
          </table></td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td class="whitefield"><p>&nbsp;</p>
            <table width="722" border="0" align="center" cellpadding="0" cellspacing="0">
              <tr>
                <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_top-corner-lft.gif" alt="1" width="11" height="8"></td>
                <td width="23" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="status name" width="1" height="1"></td>
                <td width="8" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a41" width="1" height="1"></td>
                <td width="113" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a41" width="1" height="1"></td>
                <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a40" width="1" height="1"></td>
                <td width="49" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a39" width="1" height="1"></td>
                <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a38" width="1" height="1"></td>
                <td width="48" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a37" width="1" height="1"></td>
                <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a36" width="1" height="1"></td>
                <td width="56" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a35" width="1" height="1"></td>
                <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a34" width="1" height="1"></td>
                <td width="48" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a33" width="1" height="1"></td>
                <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a32" width="1" height="1"></td>
                <td width="52" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a31" width="1" height="1"></td>
                <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a30" width="1" height="1"></td>
                <td width="49" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a29" width="1" height="1"></td>
                <td width="10" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a28" width="1" height="1"></td>
                <td width="40" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a27" width="1" height="1"></td>
                <td width="10" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a26" width="1" height="1"></td>
                <td width="32" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a25" width="1" height="1"></td>
                <td width="10" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a24" width="1" height="1"></td>
                <td width="106" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="a23" width="1" height="1"></td>
                <td width="11" height="8" align="left" valign="bottom"><img src="/images/t1_top-corner-rt.gif" alt="1" width="11" height="8"></td>
              </tr>
              <tr>
                <td width="11" height="41" align="right"><img src="/images/t1_top-gray-lft.gif" alt="1" width="11" height="41"></td>
                <td height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                From</td>
                <td width="8" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="1" width="7" height="41"></td>
                <td width="113" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                Sender IP </td>
                <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="1" width="7" height="41"></td>
                <td width="49" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                Total </td>
                <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="1" width="7" height="41"></td>
                <td width="48" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                None </td>
                <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="1" width="7" height="41"></td>
                <td width="56" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                Establ. </td>
                <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="1" width="7" height="41"></td>
                <td width="48" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                Syn </td>
                <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="1" width="7" height="41"></td>
                <td width="52" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                Fin </td>
                <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="1" width="7" height="41"></td>
                <td width="49" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                Closed </td>
                <td width="10" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="1" width="7" height="41"></td>
                <td width="40" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                Whois </td>
                <td width="10" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="b5" width="7" height="41"></td>
                <td width="32" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                Scan </td>
                <td width="10" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" alt="b4" width="7" height="41"></td>
                <td width="106" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
                Target </td>
                <td width="11" height="41" align="left"><img src="/images/t1_top-gray-rt.gif" alt="1" width="11" height="41"></td>
              </tr>

';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
              <tr>
                <td width="11" height="14" align="right" valign="top"><img src="/images/t1_bottom-lft.gif" alt="b2" width="11" height="14"></td>
                <td height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a22" width="1" height="1"></td>
                <td width="8" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a21" width="1" height="1"></td>
                <td width="113" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a20" width="1" height="1"></td>
                <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a19" width="1" height="1"></td>
                <td width="49" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a18" width="1" height="1"></td>
                <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a17" width="1" height="1"></td>
                <td width="48" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a16" width="1" height="1"></td>
                <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a15" width="1" height="1"></td>
                <td width="56" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a14" width="1" height="1"></td>
                <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a13" width="1" height="1"></td>
                <td width="48" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a12" width="1" height="1"></td>
                <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a11" width="1" height="1"></td>
                <td width="52" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a10" width="1" height="1"></td>
                <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a9" width="1" height="1"></td>
                <td width="49" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a8" width="1" height="1"></td>
                <td width="10" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a7" width="1" height="1"></td>
                <td width="40" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a5" width="1" height="1"></td>
                <td width="10" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a5" width="1" height="1"></td>
                <td width="32" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a4" width="1" height="1"></td>
                <td width="10" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a3" width="1" height="1"></td>
                <td width="106" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="a2" width="1" height="1"></td>
                <td width="11" height="14" align="left" valign="top"><img src="/images/t1_bottom-rt.gif" alt="b3" width="11" height="14"></td>
              </tr>
            </table>
            <p>&nbsp;</p>
            <p>&nbsp;</p>
          </td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-lft.gif" width="19" height="19"></td>
          <td height="19" background="/images/t2_bottom-hg.gif">&nbsp;</td>
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-rt.gif" width="19" height="19"></td>
        </tr>
        <tr> 
          <td height="54" colspan="2" align="left" valign="top"><a href="mylvs.pl"><img src="/images/back-tab.gif" alt="status name" width="63" height="29" border="0"></a></td>
          <td width="19">&nbsp;</td>
        </tr>
      </table>
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT showcon FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	


sub GetConnections {
 my ($var,$value);	
 for (@cmdretcon) {
 	chomp;
 	#print "==> $_\n";
  s/^([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*) *([^ ]*)/$1 $2 $3 $4 $5 $6/;  #Get Tokens !
  if (( ! /source/ ) and ( ! /destination/)) {   #Taken over from LVS-1 (??)
   if (($1 eq "TCP") or ($1 eq "IP") or ($1 eq "UDP") ){
    $tmpSource=undef;
    $tmpTarget=undef;
    if ($4) {  #Source Token Set ?
     ($var,$value) = split(/:/,$4,2);    
     $tmpSource=$var;
    } 
    if ($6) {  #Target Token Set ?
   	($var,$value) = split(/:/,$6,2);    
     $tmpTarget=$var;
    }
    if (($tmpSource) and ($tmpTarget)) {   #Source and Target IP present ?
     $CONNECTIONS++;
     $TotLVSConnx{"$tmpSource-$tmpTarget"}++;
     
     #Get State
     if ($3) {  #State Token Set ?
      if ($3 eq "ESTABLISHED"){$tmpTotESTABLISHED{"$tmpSource-$tmpTarget"}++;} 
      if ($3 eq "CLOSE") {$tmpTotCLOSED{"$tmpSource-$tmpTarget"}++;}
      if ($3 eq "NONE") {$tmpTotNONE{"$tmpSource-$tmpTarget"}++;}
      if ($3 eq "FIN_WAIT") {$tmpTotFIN_WAIT{"$tmpSource-$tmpTarget"}++;}
      if ($3 eq "SYN_RECV") {$tmpTotSYN_RECV{"$tmpSource-$tmpTarget"}++;}
     }     #if ($3) {  #State Token Set
    }      #if (($tmpSource) and ($tmpTarget))
   }       #if (($1 eq "TCP") or ($1 eq "IP") or ($1 eq "UDP") )
  }        #if (( ! /source/ ) and ( ! /destination/))    #Taken over from LVS-1 (??) 
  #exit;
 }         #for (@cmdretcon) 
 
 
 %tmpOrder=%TotLVSConnx;  #Sort mechanism has been taken over from LVS1, you might redisgn it to sort all vals
 for my $source( sort { $tmpOrder{$b} <=> $tmpOrder{$a} } keys %tmpOrder ) {    	
  #for my $source( sort keys %TotLVSConnx  ) {
  $SENDER++;
 	if ($tmpTotESTABLISHED{$source}){$ESTABLISHED+=$tmpTotESTABLISHED{$source};} 
 	if ($tmpTotCLOSED{$source}){$CLOSED+=$tmpTotCLOSED{$source};} 
 	if ($tmpTotNONE{$source}){$NONE+=$tmpTotNONE{$source};} 
 	if ($tmpTotFIN_WAIT{$source}){$FIN_WAIT+=$tmpTotFIN_WAIT{$source};} 
 	if ($tmpTotSYN_RECV{$source}){$SYN_RECV+=$tmpTotSYN_RECV{$source};} 
 }	


}



sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);

    $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
}



