#!/usr/bin/perl 


##################################
#Manage Server Add / Edit / Delete
#Parameter:
#lvs2manageserver.pl?add%enabled=x&ip=x.x.x.x&mrtg=text&command=x
#lvs2manageserver.pl?edit%id=x&enabled=x&ip=x.x.x.x&mrtg=text&command=x
#lvs2manageserver.pl?delete%id=x
##################################


use warnings;
use strict;
use DBI;
use POSIX;


####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############
#my $httproot="http://test.maximegalon.intern/";
####################################################################
my $basepath=$ENV{DOCUMENT_ROOT};
my $server = $ENV{HTTP_HOST};
####################################################################

my $httproot="http://$server/";
my $retscriptname="mylvsmgrsrv.pl";
#Remember this:   <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
#or this:         <td colspan="2" align="left" valign="top"><a href="'."$httproot$retscriptname".'"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
####################### CONFIGURATION #######################


#2.0.3 - Add visible and mac adress options - may2011
#2.0.4 - Add Wakup and Shutdown-Jul2011

my $version = "2.0.4";

#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;   #user login flag - default off
#####################################################################
#####################################################################

my ($sqlAlias,$sqlIP,$GlobalAlias,$GlobalIP,$GlobalTxt);
my ($dbh,$dbhn,$dbhhN,$var,$value);
my $showid;  #=1;  #Ste TestID !!!
my ($myIP,$myHost,$myCHost);
$granted=&chkuser($curuser);  #Check User
print &HTMLHeader;
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$dbhn = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$tparam=URLDecode($tparam);
my ($ndid,$ndresid,$ndnodeid,$chktoken,$id,$mode,$sqlstat,$sql);
my ($ndenabled,$ndalias,$ndip,$ndmrtg,$ndcmd);
my ($ndvisible,$ndmac,$errmsg); #2.0.3
my ($ndshut,$ndwake);           #2.0.4
my @reqTokens = split(/&/,$tparam);
  foreach (@reqTokens){ #Get Mode Fisrt !!!
 	 if (!/\'|\;|\(|\)|\"|\`|\*|where\s+|truncate\s+|\s+from\s+|\select\s+|delete\s+|\s+as\s+/){  #No SQL Injection
 	 	  if (/^mode\=*([^ ]*)/){$mode=$1;}	 
   }
  }


#if (($mode eq "add") and (!$ndid) and not (lc($mode) eq "edit") and not (lc($mode) eq "delete") ){
if ($mode eq "add"){
 $GlobalTxt="Server: Add";
} 


if ($mode eq "edit"){
 $GlobalTxt="Server: Edit";
} 


if ($mode eq "delete"){
 $GlobalTxt="Server: Delete";
} 

print &HTMLStartOutsideTable;
print &HTMLStartInsideTable;



 if ($granted) {
  $chktoken=1;
 	if ((lc($mode) eq "delete") or (lc($mode) eq "add") or (lc($mode) eq "edit") ){  
   foreach (@reqTokens){
 	  if (!/\'|\;|\(|\)|\"|\`|\*|where\s+|truncate\s+|\s+from\s+|\select\s+|delete\s+|\s+as\s+/){  #No SQL Injection
	   if (/^enabled=*([^ ]*)/i){$ndenabled=$1;}	 
   	 if (/^visible=*([^ ]*)/i){$ndvisible=$1;}	 
   	 if (/^macadr=*([^ ]*)/i){$ndmac=$1;}	 
   	 if (/^shutid=*([^ ]*)/i){$ndshut=$1;}	 
   	 if (/^wakeid=*([^ ]*)/i){$ndwake=$1;}	 
   	 if (/^servername\=*([^ ]*)/i){$ndalias=$1;}	 
   	 if (/^ip\=*([^ ]*)/i){$ndip=$1;}	 
   	 if (/^mrtg\=*([^ ]*)/i){$ndmrtg=$1;}	 
   	 if (/^command\=*([^ ]*)/i){$ndcmd=$1;}	 
   	 #if (/^command\=(\d*)/i){$ndcmd=$1;}	 
   	 if (/^id\=*([^ ]*)/i){$ndid=$1;}	 
    }
   }   #foreach (@reqTokens)
   if ($ndenabled =~ /on/i){
   	$ndenabled=1;
   } else {
   	$ndenabled=0;
   }	

   if ($ndvisible =~ /on/i){
   	$ndvisible=1;
   } else {
   	$ndvisible=0;
   }	


  }

  #lvs2servermanager !
  if (($mode eq "add") and (!$ndid) and not (lc($mode) eq "edit") and not (lc($mode) eq "delete") ){
   &PrintHTMLMessage("Insert Record (Add Server)<BR>");
   if (((!$ndenabled) and ($ndenabled ne 0)) or (!$ndalias) or (!$ndip) or (!$ndmrtg) or ((!$ndcmd) and ($ndcmd ne 0))){
   	&PrintHTMLMessage("Error: Data not complete<BR>");
   } else {
    #Get ID!
    $sqlstat = ("Select resID from tblResources order by resID desc limit 1;"); 
    $sql = $dbh->prepare($sqlstat);
    $sql->execute;
    (my($sqlID)=$sql->fetchrow_array);
    $id=$sqlID+1;
    &PrintHTMLMessage("Get new ID = $id<BR>");
    $sqlstat = ("Insert into tblResources (resID,enabled,alias,realip,cmd_reboot_id,mrtg_link,visible,mac) values ('".$id."','".$ndenabled."','".$ndalias."','".$ndip."','".$ndcmd."','".$ndmrtg."','1','".$ndmrtg."');");
    &PrintHTMLMessage("$sqlstat<BR>");
    if ($simulate ne 1){
     my $rv  = $dbh->do($sqlstat);
     if ($rv eq 1) {
   	  &PrintHTMLMessage("Insert Table Entry OK<BR>");
     } else {
   	  &PrintHTMLMessage("Insert Table Entry ERROR<BR>");
   	  $errmsg.="Insert Table Entry ERROR<BR> <BR><BR>";
     } 	
    }
   }
  }

#aloa
  #2.0.3
  #lvs2servermanager - edit !
  if (($mode eq "edit") and ($ndid) and not (lc($mode) eq "add") and not (lc($mode) eq "delete") ){
   &PrintHTMLMessage("Update Record (Edit Mode) <BR>");
   if (((!$ndenabled) and ($ndenabled ne 0)) or (!$ndalias) or (!$ndip) or (!$ndmrtg) or ((!$ndcmd) and ($ndcmd ne 0))){
   	&PrintHTMLMessage("Error: Data not complete<BR>");
   } else {
    
    if (($ndenabled eq 1) and ($ndvisible ne 1) ) {
     &PrintHTMLMessage("Error: The checkbox 'Visible' must be set if checkbox 'Enable' is set <BR>");
     $errmsg.="==>> Error: The checkbox 'Visible' must be SET if checkbox 'Enable' is set <<==<BR><BR>";
    } else {
    
     
     if ( ($ndvisible ne 1) ) { 
      my $sqls = $dbh->prepare ("select invID from tblNodesInventory where resID='".$ndid."' and enabled=1 and weightdown=0;"); 
   	  &PrintHTMLMessage("select invID from tblNodesInventory where resID='".$ndid."' and enabled=1 and weightdown=0;<BR>"); 
      $sqls->execute ; 
      (my($SInvID)=$sqls->fetchrow_array);
      if ($SInvID){
     	 $errmsg.="==>> Error: Services are found on this server, please switch them off first <<==<BR><BR>";
      } else {
       $sqlstat = ("Update tblResources set enabled='".$ndenabled."', alias='".$ndalias."', realip='".$ndip."', cmd_reboot_id='".$ndcmd."', mrtg_link='".$ndmrtg."', visible = '".$ndvisible."', mac = '". $ndmac . "', cmd_shutdown_id = '". $ndshut . "', cmd_wakeup_id = '". $ndwake . "' where resID='".$ndid."';"); 
       
       
       
       
       &PrintHTMLMessage("$sqlstat<BR>");
      }
     } else {    
      
      $sqlstat = ("Update tblResources set enabled='".$ndenabled."', alias='".$ndalias."', realip='".$ndip."', cmd_reboot_id='".$ndcmd."', mrtg_link='".$ndmrtg."', visible = '".$ndvisible."', mac = '". $ndmac . "', cmd_shutdown_id = '". $ndshut . "', cmd_wakeup_id = '". $ndwake . "' where resID='".$ndid."';"); 
      &PrintHTMLMessage("$sqlstat<BR>");
     }
      
       if ($simulate ne 1){
        my $rv  = $dbh->do($sqlstat);
        if ($rv eq 1) {
         &PrintHTMLMessage("Update Table Entry OK<BR>");
        } else {
   	     &PrintHTMLMessage("Update Table Entry ERROR<BR>");
   	     $errmsg.="Insert Table Entry ERROR<BR> <BR><BR>";
        } 	
       }
    
    }
   }
  }


  #lvs2servermanager - delete !
  if (($mode eq "delete") and not (lc($mode) eq "add") and not (lc($mode) eq "edit") ){
   &PrintHTMLMessage("Delete Record<BR>");
   if (!$ndid){
   	&PrintHTMLMessage("-$ndid<BR>");
   	&PrintHTMLMessage("Error: Data not complete<BR>");
   } else {
    #Delete Montor Records
    my $sqls = $dbh->prepare ("select invID from tblNodesInventory where resID='".$ndid."';"); 
   	&PrintHTMLMessage("select invID from tblNodesInventory where resID='".$ndid."';<BR>"); 
    $sqls->execute ; 
    while (my($SInvID)=$sqls->fetchrow_array){
     #print "==>> $SInvID<BR>\n";
 	   $sqlstat = ("delete from tblMonitor where invID='".$SInvID."';"); 
     &PrintHTMLMessage("$sqlstat<BR>");
     if ($simulate ne 1){
      my $rv  = $dbhn->do($sqlstat);
      if ($rv eq 1) {
       &PrintHTMLMessage("Delete Table Entry OK<BR>");
      } else {
   	   &PrintHTMLMessage("Delete Table Entry Error<BR>");
   	   #There wil be errors occuring if the monitor table has no id set with: invID 
   	   #$errmsg.="Insert Table Entry ERROR  -- $sqlstat<BR> <BR><BR>";
      } 	
     }
    }

    #Delete NodesInventory Records
    $sqlstat = ("delete from tblNodesInventory where resID='".$ndid."';"); 
    &PrintHTMLMessage("$sqlstat<BR>");
    if ($simulate ne 1){
     my $rv  = $dbh->do($sqlstat);
     if ($rv eq 1) {
      &PrintHTMLMessage("Delete Table Entry OK<BR>");
     } else {
   	  &PrintHTMLMessage("Delete Table Entry Error<BR>");
   	  #There wil be errors occuring if the monitor table has no id set with: invID #
   	  #$errmsg.="Insert Table Entry ERROR<BR> <BR><BR>";
     } 	
    }
    
    #Delete Resource
    $sqlstat = ("delete from tblResources where resID='".$ndid."';"); 
    &PrintHTMLMessage("$sqlstat<BR>");
    if ($simulate ne 1){
     my $rv  = $dbh->do($sqlstat);
     if ($rv eq 1) {
      &PrintHTMLMessage("Delete Table Entry OK<BR>");
     } else {
   	  &PrintHTMLMessage("Delete Table Entry Error<BR>");
   	  $errmsg.="Insert Table Entry ERROR<BR> <BR><BR>";
     } 	
    }
   }
  }
  if ($errmsg) {
  	print $errmsg;
  }	
  print "Task Complete!<BR>\n";
 } else {     #if ($granted) 
  print "No Permissions To Perform This Task !\n";
 }            #if ($granted)  

print &HTMLEndInsideTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;



 
 
sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}


sub lvslog {
 #Logs into sql
 #$_[0] = Code (used for the image)
 #$_[1] = Message
 #$_[2] = User
 #my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','$_[1]');" );
 my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message,epoche) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','".$_[1]."','".time."');" );
 $sqlcur->execute;
}



sub HTMLHeader {
#<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
my $ret='Content-type: text/html; charset=iso-8859-1

<html>
<head>
<title>LVS</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.fontairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #979696;
}
.fontnormal {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #979696;
}
.ecke-top-hg-lft {
	background-image: url(images/ecke-top-hg-lft.gif);
	background-repeat: repeat-y;
	background-position: right;
}
.whitefield {
	background-color: #FFFFFF;
	border: 1px solid #cfcfcf;
}
-->
</style>
<style type="text/css">
<!--
.fontblacksmall {
	font-family: Verdana;
	font-size: 10px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
-->
</style>
</head>
';
	
return $ret;	
}



sub HTMLStartOutsideTable {
my $ret='
<body><br>
<!-- Aussentabelle -->
<table width="830" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">LVS Inventory Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$GlobalAlias.'<span class="fontnormal"> (</span><span class="fontnormal">'.$GlobalTxt.'
          )</span></td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
';	
return $ret;		
}

sub HTMLStartInsideTable {
my $ret='
      <!-- Hier kommt innentabelle rein ! --><br>
      <br>
      <table width="549" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-lft.gif" width="19" height="11"></td>
          <td height="11" valign="bottom" background="/images/t2_top-hg.gif"></td>
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-rt.gif" width="19" height="11"></td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td bgcolor="f8f8f8" class="fontairname"></td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td class="whitefield"><br>
          <table width="90%" border="0" align="center" cellpadding="0" cellspacing="0">
           <tr>
           <td class="fontblacksmall">
 ';	                
 return $ret;		
}
                
                
                
sub HTMLEndInsideTable {
my $ret='
              </td>
              </tr>
            </table>
            <br>
          </td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-lft.gif" width="19" height="19"></td>
          <td height="19" background="/images/t2_bottom-hg.gif">&nbsp;</td>
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-rt.gif" width="19" height="19"></td>
        </tr>
        <tr> 
          <td colspan="2" align="left" valign="top"><a href="'."$httproot$retscriptname".'"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
          <td width="19">&nbsp;</td>
        </tr>
      </table>
      <!-- Innere Tabelle -->
 ';	                
 return $ret;		
}

sub HTMLEndOutsideTable {
my $ret='
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT servermanager FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	


sub URLDecode {
    my $theURL = $_[0];
    $theURL =~ tr/+/ /;
    $theURL =~ s/%([a-fA-F0-9]{2,2})/chr(hex($1))/eg;
    $theURL =~ s/<!--(.|\n)*-->//g;
    return $theURL;
}

sub PrintHTMLMessage {
	if ($HTMLLVSView){
	 print "$_[0]\n";
	} 
}