#!/usr/bin/perl -w

################################
#Show LVS2 Add/Edit Server Mask
################################

use strict;
use DBI;
use Time::localtime;
#use Geo::IPfree;  

my $version="2.0.1.2";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############
####################### CONFIGURATION #######################


#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;   #user login flag - default off


#Load LVS htmlhelper
use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript);
use htmlsetuphelper qw(&htmlsetuptab &htmlsetupcss &htmlmainsetupheader);
#########################################################################################
my ($ServerName,$NodeIP,$Protocol,$Schedule,$Port,$Persistance,$tresid,$ResID,$ttt,$IP,$SQLCName,$SQLCID,$SQLcmd_reset_id,$RebootID,$MRTG);
my $tblText;
my ($dbh,$ret);
#########################################################################################
#BEGIN
$granted=&chkuser($curuser);  #Check User
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 



$tblText="Apply Configuration";

print htmlmainheader;
print htmlsetupcss;
print jscript;
print htmlmaintab(7,860,0);


#print &HTMLHeader;
print &HTMLStartOutsideTable; 	
print htmlsetuptab(3);


print &HTMLInnerTableStart;



my ($persisten,$NodePersistent,$mstring,$scheduler,$NodeVIP,$NodeScheduler,$NodeService,$NodeName,$NodeID,$persistent,$simulate);
my ($ResAlias,$ResRealIP,$ResEnabled,$InvMethod,$InvID,$STRactive,$invLink,$InvAutomovePoolID,$InvPort,$InvFailstate,$InvResID,$InvWeight);


if ($granted) {
 #&lvslog(3,"Applied LVS Reset",$curuser);
 if ($simulate eq "1") {
   	print  "Simulation Mode !!<BR>";
 }  	
 print "#=>ATTENTION: Clear Config<br>";
 $mstring="$lvscmd -C";
 print "$mstring <br>";
 if ($simulate eq "0") {
 `$mstring`;
 }
#
#Get Inventory from mySQL 
 my $dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword);
 my $sqlnode = $dbh->prepare("SELECT nodeID,Name,scheduler,service,vip,persistent FROM tblNodes" );
 $sqlnode->execute ;  #Get Nodes
  while(($NodeID,$NodeName,$NodeScheduler,$NodeService,$NodeVIP,$NodePersistent)=$sqlnode->fetchrow_array) {
   print "#=>Create Node: $NodeName ID=$NodeID VIP=$NodeVIP Scheduler=$NodeScheduler Service=$NodeService Per.=$NodePersistent<br>";
   if ($NodeService !~ /fwm/i) {
    $scheduler = "-t $NodeVIP";
   } else {
    $scheduler = "-f $NodeVIP";	
   }	
  
   if ($NodePersistent ne "0"){
    $persistent = "-p $NodePersistent";
   } else {
    $persistent="";
   }	 
   $mstring="$lvscmd -A $scheduler -s $NodeScheduler $persistent";
   print "$mstring<br>";
   if ($simulate eq "0") {
    `$mstring`;
   }

  
   my $sqlnodeinv = $dbh->prepare("SELECT invID,resID,Method,Link,Weight,AutomovePoolID,Port,Failstate FROM tblNodesInventory where active='1' and nodeID='" . $NodeID ."' $STRactive;" );
   $sqlnodeinv->execute ;  #Get NodesInentory
   print "#=>Create Realserver For Node: $NodeName<br>";
   while(($InvID,$InvResID,$InvMethod,$invLink,$InvWeight,$InvAutomovePoolID,$InvPort,$InvFailstate)=$sqlnodeinv->fetchrow_array) {
    #my $sqlnoderes = $dbh->prepare("SELECT alias,realip FROM tblResources where resID='" . $InvResID ."';" );
    #$sqlnoderes->execute ; #Get Resources
    my $sqlresource = $dbh->prepare("SELECT alias,realip,enabled FROM tblResources where resID='" . $InvResID ."';" );
    $sqlresource->execute;
    (($ResAlias,$ResRealIP,$ResEnabled)=$sqlresource->fetchrow_array)   ;
    if ($ResEnabled) {
     $mstring="$lvscmd -a $scheduler -r $ResRealIP -$InvMethod -w $InvWeight";
     print "$mstring #Alias=$ResAlias NodeID=$NodeID InvID=$InvID<br>";
     if ($simulate eq "0") {
     `$mstring`;
     }

   
    } 
   }
  
 
  print "<br>";
 
 }

 print "<br>#Process Finished !<br>";


} else {
 print "No Permissions To Perform This Task !\n";	
	
	
}



















print &HTMLInnerTableEnd;



print &HTMLEndOutsideTable;
print &HTMLEndHeader;

#END SCRIPT
           


sub chkDate () {
	if (length($_[0]) eq 1 ) {
		return "0" . $_[0];
	} else {
    return $_[0];		
	}
}           


sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}




sub HTMLStartOutsideTable {
my $ret='
<table width="860" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="794" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$tblText.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  
  <tr> 
    <td width="33" height="10" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>

  <tr> 
    <td width="33" height="184" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt die innere Tabelle rein ! --><br>
      
';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- MyLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of MyLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT operations FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	




sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);

    $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
}


sub HTMLInnerTableStart {
my $ret='	

   <!-- Hier kommt innentabelle rein ! --><br>
   <br>
      <table width="765" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-lft.gif" width="19" height="11"></td>
          <td height="11" valign="bottom" background="/images/t2_top-hg.gif"></td>
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-rt.gif" width="19" height="11"></td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td bgcolor="f8f8f8" class="fontairname">Please do not abort this process, wait until this process shows finsihed</td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
       <td class="whitefield"><br>
       <table width="97%" border="0" align="center" cellpadding="0" cellspacing="0">
       <tr>
       <td class="fontblacksmall">
';	
	return $ret;
}
 


sub HTMLInnerTableEnd {
my $ret='	
 
       </td>
      </tr>
     </table>
    <br>
   </td>
   <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
   </tr>
   <tr> 
    <td width="19" height="19"><img src="/images/t2_ecke-bottom-lft.gif" width="19" height="19"></td>
    <td height="19" background="/images/t2_bottom-hg.gif">&nbsp;</td>
    <td width="19" height="19"><img src="/images/t2_ecke-bottom-rt.gif" width="19" height="19"></td>
   </tr>
   <tr> 
    <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
    <td width="19">&nbsp;</td>
   </tr>
  </table>
 <!-- Innere Tabelle -->


';	
	return $ret;
}




