#!/usr/bin/perl 

#############
#Show Info
#############

#Quick debug info page
#####################################################################
#####################################################################

use warnings;
use strict;
use DBI;
use POSIX;
use Text::ParseWords;   

####################### CONFIGURATION #######################

use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############

####################################################################
my $basepath=$ENV{DOCUMENT_ROOT};
my $server = $ENV{HTTP_HOST};
####################################################################

my $httproot="http://$server/";
my $retscriptname="mylvshst.pl";
#Remember this:   <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>

####################### CONFIGURATION #######################
my $version = "2.0.1.8";
my $DateFormat="%d.%m.%Y %H:%M:%S";
#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;  #user login flag - default off
#For static test purposes ...
#$tparam = "show=84.189.53.227";
#####################################################################
#####################################################################


my (%NodeID,%NodeAddress,%NodePort,%NodeScheduler,%NodePersistent,%NodePersistentTimeout,%NodeProto,%ResSNMPKey,%ResSNMPPass,%ResSNMPPort,%ResSNMPTO,%ResSNMPEnable,$curmodeID,$curmodePropertyID,);
my (%RSAddress,%RSPort,%RSRoute,%RSWeight,%RSActive,%RSInActive,$sqlsnmpkey,$sqlsnmppass,$sqlsnmpport,$sqlsnmptimeout,$CurHTTPUsers,$col_curhttp,$curhttpusrlink);
my ($sqlInvID,$sqlInvEnabled,$sqlInvWeight,$sqlInvActive,$sqlSNMP,$mrtglink,%ResMrtgID,$sqlNodeID,$curnodeid,$tmpcurnodeid,$GlobalTxt);
my (%ResAlias,%ResIP,%ResKEY,%ResEnabled,%ResWeight,%ResInvID,%ResMonStat,%ResMonLastCheck,$tmonstat,$img_monstat,$img_monstat_title,%ResServiceTot,%ResServices,$txt_curservice,$txt_curactive,%ResActiveSrvTot,%ResActiveConTot,%ResInActiveConTot,$tmpActive,$tmpInActive,%ResWeightTot,%ResWeightCur,$txt_curweight,$tmpstr4,$link_weight,$img_weight,$img_weight_title,$link_mgr,$img_enable,$img_enable_title,$img_enabled,$img_enabled_text);

$lvscmd=$lvscmd." -Ln";
&GetLVSOutput;
 #my @lvsret = `$lvscmd`;   #Get LVS Status


my ($shinfid,$dbh);


$granted=&chkuser($curuser);  #Check User
print &HTMLHeader;
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 


 if ($tparam =~ /id=/) {
  if ($tparam =~ m/id=(\d*)/){
   $shinfid="$1";
  } 
 }

print &HTMLStartOutsideTable;
print &HTMLStartInsideTable;

 
if ($granted) {
 #&lvslog(3,"Applied Scan: $shinfid",$curuser);
 
 if ($simulate eq "1") {
   	print  "Simulation Mode !!<BR>";
 }  	

 
 print "Show ID:$shinfid <BR>";
 print "SQL Server: $database:$servername <BR>";
 print "<BR>";
 print "****************<BR>";
 print "=>Inventory Info<BR>";
 print "****************<BR>";
 print "SELECT resID,nodeID,enabled,active,automovepoolid,cmd_reset_id FROM tblNodesInventory where invID='".$shinfid."' ;" . " <BR>";
 
 my $sqlitem = $dbh->prepare("SELECT resID,nodeID,enabled,active,automovepoolid,cmd_reset_id FROM tblNodesInventory where invID='".$shinfid."' ;" );
 $sqlitem->execute ; 
 (my ($SQLresID,$SQLnodeID,$SQLenabled,$SQLactive,$SQLautomovepoolid,$SQLcmd_reset_id)=$sqlitem->fetchrow_array);
 
 
 print "ResID: $SQLresID <BR>";
 print "NodeID: $SQLnodeID <BR>";
 print "Enabled: $SQLenabled <BR>";
 print "Active: $SQLactive <BR>";
 print "AutoMovePoolID: $SQLautomovepoolid <BR>";
 print "ResetID: $SQLcmd_reset_id <BR>";



 print "<BR>";
 print "*****************************<BR>";
 print "=>AutomovePool Member Info<BR>";
 print "*****************************<BR>";
 if ($SQLautomovepoolid gt 0) {
  print "SELECT resid FROM tblPoolResources where poolID='".$SQLautomovepoolid."' ;" . "<BR>";
  my $sqlp = $dbh->prepare("SELECT resid FROM tblPoolResources where poolID='".$SQLautomovepoolid."' ;" );
  $sqlp->execute ; 
  while (my ($poolresid)=$sqlp->fetchrow_array){
  	print "Pool / ResID: $poolresid<BR>";
  }
 } else {
 	print "No AutomovePool configured<BR>";
 } 





 print "<BR>";
 print "*********************<BR>";
 print "=>Reset Command Info<BR>";
 print "*********************<BR>";
 print "SELECT enabled,name,command FROM tblCommands where cmdID='".$SQLcmd_reset_id."' ;" . "<BR>";
 my $sqlcmd = $dbh->prepare("SELECT enabled,name,command FROM tblCommands where cmdID='".$SQLcmd_reset_id."' ;" );
 $sqlcmd->execute ; 
 (my ($SCLCenabled,$SCLCname,$SCLCcommand)=$sqlcmd->fetchrow_array);
 print "Enabled $SCLCenabled<BR>";
 print "Name $SCLCname<BR>";
 print "Command: $SCLCcommand<BR>";



 print "<BR>";
 print "*********************<BR>";
 print "=>Resource Info<BR>";
 print "*********************<BR>";
 print "SELECT enabled,alias,realip,cmd_reboot_id FROM tblResources where resID='".$SQLresID."' ;" . " <BR>";
 my $sqlres = $dbh->prepare("SELECT enabled,alias,realip,cmd_reboot_id FROM tblResources where resID='".$SQLresID."' ;" );
 $sqlres->execute ; 
 (my ($SQLRenabled,$SQLRalias,$SQLRrealip,$SQLRcmd_reboot_id)=$sqlres->fetchrow_array);

 print "Enabled: $SQLRenabled <BR>";
 print "Alias: $SQLRalias <BR>";
 print "IP: $SQLRrealip <BR>";
 print "RebootCMDID:$SQLRcmd_reboot_id <BR>";

 print "<BR>";
 print "*********************<BR>";
 print "=>Reboot Command Info<BR>";
 print "*********************<BR>";
 print "SELECT enabled,name,command FROM tblCommands where cmdID='".$SQLRcmd_reboot_id."' ;" . "<BR>";
 my $sqlrcmd = $dbh->prepare("SELECT enabled,name,command FROM tblCommands where cmdID='".$SQLRcmd_reboot_id."' ;" );
 $sqlrcmd->execute ; 
 (my ($SCLACenabled,$SCLACname,$SCLACcommand)=$sqlrcmd->fetchrow_array);
 print "Enabled $SCLACenabled<BR>";
 print "Name $SCLACname<BR>";
 print "Command: $SCLACcommand<BR>";


 print "<BR>";
 print "************<BR>";
 print "=>Node Info<BR>";
 print "************<BR>";
 print "SELECT enabled,name,monitor FROM tblNodes where nodeID='".$SQLnodeID."' ;" . "<BR>";
 my $sqlnode = $dbh->prepare("SELECT enabled,name,monitor FROM tblNodes where nodeID='".$SQLnodeID."' ;" );
 $sqlnode->execute ; 
 (my ($SQLNenabled,$SQLNname,$SQLNmonitor)=$sqlnode->fetchrow_array);
 print "Enabled: $SQLNenabled <BR>";
 print "Name: $SQLNname <BR>";
 print "Monitor: $SQLNmonitor <BR>";



 print "<BR>";
 print "**************<BR>";
 print "=>Monitor Info<BR>";
 print "**************<BR>";

 print "SELECT monid,enabled,recTaskID,timeout,checkalive,checkinterval,failcheckinterval,rechecks,recheckwait,notificationclock,messageid,checkinventory,immediaterecoverid,commandid,lastcheck,status FROM tblMonitor where invID='".$shinfid."' ;" . "<BR>";
 my $sqlmon = $dbh->prepare("SELECT monid,enabled,recTaskID,timeout,checkalive,checkinterval,failcheckinterval,rechecks,recheckwait,notificationclock,messageid,checkinventory,immediaterecoverid,commandid,lastcheck,status FROM tblMonitor where invID='".$shinfid."' ;");
 $sqlmon->execute ; 
 (my ($SQLMmonid,$SQLMenabled,$SQLMrecTaskID,$SQLMtimeout,$SQLMcheckalive,$SQLMcheckinterval,$SQLMfailcheckinterval,$SQLMrechecks,$SQLMrecheckwait,$SQLMnotificationclock,$SQLMmessageid,$SQLMcheckinventory,$SQLMimmediaterecoverid,$SQLMcommandid,$SQLMlastcheck,$SQLMstatus)=$sqlmon->fetchrow_array);
 if ($SQLMmonid gt 0) {


 print "ID: $SQLMmonid<BR>";
 print "Enabled: $SQLMenabled <BR>";
 print "RecTaskID: $SQLMrecTaskID <BR>";
 print "MonTimeout: $SQLMtimeout <BR>";
 print "CheckAlive: $SQLMcheckalive <BR>";
 print "CheckInterval: $SQLMcheckinterval <BR>";
 print "FailCheckInterval :$SQLMfailcheckinterval <BR>";
 print "Rechecks: $SQLMrechecks <BR>";
 print "RecheckWait: $SQLMrecheckwait <BR>";
 print "NotificationClock: $SQLMnotificationclock <BR>";
 print "MessageID: $SQLMmessageid <BR>";
 print "CheckInventory $SQLMcheckinventory <BR>";
 print "ImmediateRecoverID: $SQLMimmediaterecoverid <BR>";
 print "CommandID: $SQLMcommandid <BR>";
 my $lastcheck_date=strftime($DateFormat, localtime($SQLMlastcheck));   	   	
 print "LastCheck: $SQLMlastcheck ($lastcheck_date)<BR>";
 print "Status: $SQLMstatus <BR>";
 print " <BR>";



 print "<BR>";
 print "************************<BR>";
 print "=>Monitor Check Command<BR>";
 print "************************<BR>";
 #$SQLMcommandid
 if ($SQLMcommandid gt 0 ) {
  print "SELECT enabled,name,command FROM tblCommands where cmdID='".$SQLMcommandid."' ;" . "<BR>";
  my $sqlcmdm = $dbh->prepare("SELECT enabled,name,command FROM tblCommands where cmdID='".$SQLMcommandid."' ;" );
  $sqlcmdm->execute ; 
  (my ($SCLIenabled,$SCLICname,$SCLICcommand)=$sqlcmdm->fetchrow_array);
  print "Enabled $SCLIenabled<BR>";
  print "Name $SCLICname<BR>";
  print "Command: $SCLICcommand<BR>";
 } else {
	print "No monitor check configured<BR>";
 }
	
	



 print "<BR>";
 print "********************************<BR>";
 print "=>Monitor Immediate Recover Info<BR>";
 print "********************************<BR>";
 if ($SQLMimmediaterecoverid gt 0 ) {
  print "SELECT enabled,name,command FROM tblRecover where recID='".$SQLMimmediaterecoverid."' ;" . "<BR>";
  my $sqlcmdrec = $dbh->prepare("SELECT enabled,name,command FROM tblRecover where recID='".$SQLMimmediaterecoverid."' ;" );
  $sqlcmdrec->execute ; 
  (my ($SCLRCenabled,$SCLRCname,$SCLRCcommand)=$sqlcmdrec->fetchrow_array);
  print "Enabled $SCLRCenabled<BR>";
  print "Name $SCLRCname<BR>";
  print "Command: $SCLRCcommand<BR>";
 } else {
 	print "No Immediate Recover configured<BR>";
 }


 print "<BR>";
 print "************************<BR>";
 print "=>Monitor Recovery Info<BR>";
 print "************************<BR>";
 if ($SQLMrecTaskID gt 0 ) {

 print "SELECT recid,recclock FROM tblRecoverTasks where rectaskID='".$SQLMrecTaskID."' ;" . "<BR>";
 my $sqlrectsk = $dbh->prepare("SELECT recid,recclock FROM tblRecoverTasks where rectaskID='".$SQLMrecTaskID."' ;");
 $sqlrectsk->execute ; 
 while  (my ($SCLRrecid,$SCLRrecclock)=$sqlrectsk->fetchrow_array){
	
	print "==>> RecoverID: $SCLRrecid Interval: $SCLRrecclock<BR>";
	print " SELECT enabled,name,command FROM tblRecover where recID='".$SCLRrecid."' ;" . "<BR>";
  my $sqlrecc = $dbh->prepare("SELECT enabled,name,command FROM tblRecover where recID='".$SCLRrecid."' ;");
  $sqlrecc->execute ; 
	(my ($SCLRCenabled,$SCLRCname,$SCLRCcommand)=$sqlrecc->fetchrow_array);
	
	#print "$SCLRCenabled,$SCLRCname,$SCLRCcommand"  . "<BR>";
	print "==>> Enabled: $SCLRCenabled<BR>";
	print "==>> Name: $SCLRCname<BR>";
	print "==>> Command: $SCLRCcommand<BR><BR>";
 }

 } else {
	print "No Recover configured<BR>";
 }




 print "<BR><BR><BR>";
 print "************************<BR>";
 print "=>Monitor Messaging Info<BR>";
 print "************************<BR>";
 if ($SQLMmessageid gt 0 ) {
  print "SELECT type,mailfrom,server,mailto,mailcc,mailbcc FROM tblMessaging where mID='".$SQLMmessageid."' ;" . "<BR>";
  my $sqlmsg = $dbh->prepare("SELECT type,mailfrom,server,mailto,mailcc,mailbcc FROM tblMessaging where mID='".$SQLMmessageid."' ;" );
  $sqlmsg->execute ; 
  (my ($sqltype,$sqlmailfrom,$sqlserver,$sqlmailto,$sqlmailcc,$sqlmailbcc)=$sqlmsg->fetchrow_array);
  print "Type: $sqltype<BR>";
  print "Mailfrom: $sqlmailfrom<BR>";
  print "Mailserver: $sqlserver<BR>";
  print "MailTo: $sqlmailto<BR>";
  print "MailCC: $sqlmailcc<BR>";
  print "MailBCC: $sqlmailbcc<BR>";
 
 #$cmdsend=&GetChkCmd($LvsRec{$LvsRecTaskID{$cmdid}},$monhost);
 } else {
	print "No Messaging configured<BR>";
 }

} else {
	print "No Monitoring configured<BR>";
}  #MonID =0    -  $SQLMmonid


#print "SELECT enabled,name,command FROM tblCommands where cmdID='".$SQLMimmediaterecoverid."' ;" . "<BR>";
#my $sqlcmd = $dbh->prepare("SELECT enabled,name,command FROM tblCommands where cmdID='".$SQLcmd_reset_id."' ;" );
#$sqlcmd->execute ; 
#(my ($SCLCenabled,$SCLCname,$SCLCcommand)=$sqlcmd->fetchrow_array);
#print "Enabled $SCLCenabled<BR>";
#print "Name $SCLCname<BR>";
#print "Command: $SCLCcommand<BR>";

#print " <BR>";


 print " <BR><BR><BR>LVS Inventory:<BR>";
 for my $pntbase (sort keys %NodeID){  #Enum LVS Inventory
  for my $pntval (sort keys %{$RSAddress{$pntbase}} ){
   #print "DEB: $RSAddress{$pntbase}{$pntval}<BR>";
   if ($RSAddress{$pntbase}{$pntval} eq $SQLRrealip)  {
    print "NodeID: $pntbase Proto: $NodeProto{$pntbase} Address: $pntval  RealAddress:$SQLRrealip Weight: $RSWeight{$pntbase}{$pntval} Active: $RSActive{$pntbase}{$pntval} InActive: $RSInActive{$pntbase}{$pntval}<BR>";
   }
  }
 }

   #for my $pntbase (sort keys %NodeID){  #Enum LVS Inventory
   # for my $pntval (sort keys %{$RSAddress{$pntbase}} ){
   #  if ($RSAddress{$pntbase}{$pntval} eq $SQLRrealip)  {
   #  	#print "DEB=: $NodeProto{$pntbase} == $sqlService\n"; 	
   #  	if ($NodeProto{$pntbase} =~ /$sqlService/i ) {
   #    if (($NodeProto{$pntbase} eq "FWM" ) and ($NodeAddress{$pntbase} eq $sqlVip)) {
   #    	
   #    	#$NodePort{$curmodeID}="$0";
   #    	#print "FWM DEB: $RSAddress{$pntbase}{$pntval} == $NodeAddress{$pntbase} == $sqlVip ==> $RSActive{$pntbase}{$pntval} ==> $RSInActive{$pntbase}{$pntval} ==> $RSWeight{$pntbase}{$pntval}\n";
   #  	  $tmpActive=$RSActive{$pntbase}{$pntval};
   #  	  $tmpWeight=$RSWeight{$pntbase}{$pntval};
   #  	  $tmpInActive=$RSInActive{$pntbase}{$pntval};
   #     $RSFound{$pntbase}{$pntval}=1;
   #     $RSFoundAddress{$pntbase}{$pntval}=$RSAddress{$pntbase}{$pntval};
   #    } 
   #  	 if ((($NodeProto{$pntbase} eq "TCP" ) or ($NodeProto{$pntbase} eq "UDP")) 
   # 		 and ("$NodeAddress{$pntbase}:$RSPort{$pntbase}{$pntval}" eq $sqlVip)
   # 		 and ($sqlIP eq $RSAddress{$pntbase}{$pntval}))  {
   #  	  #print "DEB>: $sqlIP $RSAddress{$pntbase}{$pntval} $NodeAddress{$pntbase}:$RSPort{$pntbase}{$pntval} $sqlVip ==> $RSActive{$pntbase}{$pntval} ==> $RSInActive{$pntbase}{$pntval}  ==> $RSWeight{$pntbase}{$pntval}\n";
   #  	  $tmpWeight=$RSWeight{$pntbase}{$pntval};
   #  	  $tmpActive=$RSActive{$pntbase}{$pntval};
   #  	  $tmpInActive=$RSInActive{$pntbase}{$pntval};
   #  	  $RSFound{$pntbase}{$pntval}=1;
   #  	  #$RSFoundAddress{$pntbase}{$pntval}=$RSAddress{$pntbase}{$pntval};
   #  	 } 
   #   } 
   #  }
   # }
   #}
   














 
} else {
print "No permissions to get host informations !";	
}            #if ($granted)  
print &HTMLEndInsideTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;



 
 
 sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}

sub lvslog {
 #Logs into sql
 #$_[0] = Code (used for the image)
 #$_[1] = Message
 #$_[2] = User
 my $sqlcur = $dbh->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','$_[1]');" );
 $sqlcur->execute;
}



sub HTMLHeader {
#<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
my $ret='Content-type: text/html; charset=iso-8859-1

<html>
<head>
<title>LVS</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.fontairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #979696;
}
.fontnormal {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #979696;
}
.ecke-top-hg-lft {
	background-image: url(images/ecke-top-hg-lft.gif);
	background-repeat: repeat-y;
	background-position: right;
}
.whitefield {
	background-color: #FFFFFF;
	border: 1px solid #cfcfcf;
}
-->
</style>
<style type="text/css">
<!--
.fontblacksmall {
	font-family: Verdana;
	font-size: 10px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
-->
</style>
</head>
';
	
return $ret;	
}



sub HTMLStartOutsideTable {
my $ret='
<body><br>
<!-- Aussentabelle -->
<table width="968" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager <span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">Information</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
';	
return $ret;		
}

sub HTMLStartInsideTable {
my $ret='
      <!-- Hier kommt innentabelle rein ! --><br>
<br>
      <table width="840" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-lft.gif" width="19" height="11"></td>
          <td height="11" valign="bottom" background="/images/t2_top-hg.gif"></td>
          <td width="19" height="11" valign="bottom"><img src="/images/t2_ecke-top-rt.gif" width="19" height="11"></td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td bgcolor="f8f8f8" class="fontairname">Information</td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" background="/images/t2_hg-lft.gif">&nbsp;</td>
          <td class="whitefield"><br>
<table width="97%" border="0" align="center" cellpadding="0" cellspacing="0">
              <tr>
                <td class="fontblacksmall">
 ';	                
 return $ret;		
}
                
                
                
sub HTMLEndInsideTable {
my $ret='
                </td>
              </tr>
            </table>
            <br>
          </td>
          <td width="19" background="/images/t2_hg-rt.gif">&nbsp;</td>
        </tr>
        <tr> 
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-lft.gif" width="19" height="19"></td>
          <td height="19" background="/images/t2_bottom-hg.gif">&nbsp;</td>
          <td width="19" height="19"><img src="/images/t2_ecke-bottom-rt.gif" width="19" height="19"></td>
        </tr>
        <tr> 
          <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
          <td width="19">&nbsp;</td>
        </tr>
      </table>
      <!-- Innere Tabelle -->
 ';	                
 return $ret;		
}

sub HTMLEndOutsideTable {
my $ret='
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub GetChkCmd {
  $_=$_[0];  #Prepare string filter
  s/%HOST%/$_[1]/;
  return $_;

}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT reset FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	


sub GetLVSOutput {
 #Parse LVS Command Output and save it to hash
 my @lvsret = `$lvscmd`;   #Get LVS Status
 for my $myret (@lvsret) {
 	chomp $myret;
  #Mask: "TCP  10.0.1.18:7000 wrr persistent 3600"
  #Mask: "UDP  10.0.1.22:7000 wrr persistent 3600"
 	#print "XXXXX  DEB1 => $myret\n";
 	if ($myret =~ /^(\w{3})\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	 #print "XXXXX  DEB2 => $myret\n";
 	 $curmodeID++;
 	 $curmodePropertyID=0;
   $NodeID{$curmodeID}=$curmodeID;
   $NodeProto{$curmodeID}="$1";
 	 $NodeAddress{$curmodeID}="$2.$3.$4.$5";
 	 $NodePort{$curmodeID}="$6";
   $NodeScheduler{$curmodeID}="$7";		
   $NodePersistent{$curmodeID}="$8";		
   $NodePersistentTimeout{$curmodeID}="$9";		
 	} else {
 	 if ($myret =~ /^(\w{3})\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w*)/) {
 	 	#Mask: "TCP  10.0.1.18:7000 wrr"
    #Mask: "UDP  10.0.1.22:7000 wrr"
 	 	#print "XXXXX  DEB2a => $myret\n";
 	  $curmodeID++;
 	  $curmodePropertyID=0;
    $NodeID{$curmodeID}=$curmodeID;
    $NodeProto{$curmodeID}="$1";
 	  $NodeAddress{$curmodeID}="$2.$3.$4.$5";
 	  $NodePort{$curmodeID}="$6";
    $NodeScheduler{$curmodeID}="$7";		
    $NodePersistent{$curmodeID}="";		
    $NodePersistentTimeout{$curmodeID}="";		
 	 } else {
 	  if ($myret =~ /^FWM\s*(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	 	 #Mask: "FWM  1 wlc persistent 3600"
 	 	 #print "XXXXX  DEB3 => $myret\n";
 		 $curmodeID++;
 		 $curmodePropertyID=0;
 		 $NodeID{$curmodeID}=$curmodeID;
 		 $NodeProto{$curmodeID}="FWM";
 		 $NodeAddress{$curmodeID}="$1";
 		 $NodePort{$curmodeID}="0";
     $NodeScheduler{$curmodeID}="$2";		
     $NodePersistent{$curmodeID}="$3";		
     $NodePersistentTimeout{$curmodeID}="$4";		
 	  } else {
 	   if ($myret =~ /^FWM\s*(\d*)\s*(\w*)/) {
 	    #Mask: "FWM  1 wlc "
 	 	  #print "XXXXX  DEB3a => $myret\n";
 		  $curmodeID++;
 		  $curmodePropertyID=0;
 		  $NodeID{$curmodeID}=$curmodeID;
 		  $NodeProto{$curmodeID}="FWM";
 		  $NodeAddress{$curmodeID}="$1";
 		  $NodePort{$curmodeID}="0";
      $NodeScheduler{$curmodeID}="$2";		
      $NodePersistent{$curmodeID}="$3";		
      $NodePersistentTimeout{$curmodeID}="$4";		
 	   }
 	  }
 	 }
	}	
 	#Get Node Values
 	#Mask: " -> 10.0.1.240:0                 Route   100    0          0         "
 	if ($myret =~ m/\s*->\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w+)\s*(\d*)\s*(\d*)\s*(\d*)/) {
 	 $curmodePropertyID++;
   $RSAddress{$curmodeID}{$curmodePropertyID}="$1.$2.$3.$4";
   $RSPort{$curmodeID}{$curmodePropertyID}="$5";
   $RSRoute{$curmodeID}{$curmodePropertyID}="$6";
   $RSWeight{$curmodeID}{$curmodePropertyID}="$7";
   $RSActive{$curmodeID}{$curmodePropertyID}="$8";
   $RSInActive{$curmodeID}{$curmodePropertyID}="$9";
 	}
 }    #for my $myret (@lvsret)
}     #sub GetLVSOutput
