#!/usr/bin/perl 

#Changes 20090509 - Replaced $timeout with $checkinterval to avoid false color in view
#                 - Add new description text in $cursrvimgdescr - add real command name               

#May2011 - Add Wakup Up and ShutDown option


#####################
#Show Host Properties
#####################
use warnings;
use strict;
use DBI;
use POSIX;
use XML::Simple;
use Data::Dumper;
#####################################################################
#####################################################################


####################### CONFIGURATION #######################
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############


$lvscmd=$lvscmd." -Ln";

#Debugging ...
#$lvscmd="/bin/cat /usr/local/dev/mysql/lvsstat.txt";
####################################################################
my $basepath=$ENV{DOCUMENT_ROOT};
my $server = $ENV{HTTP_HOST};
####################################################################
my $retscriptname="mylvs.pl";
#Remember this:   <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
#my $ActiveWarning=50;
####################### CONFIGURATION #######################


my ($sqlNodeName,$sqlNodeEnabled,$sqlScheduler,$sqlService,$sqlVip);
my ($sqlInvID,$sqlInvWeight,$sqlNodeID,$sqlLink,$sqlCmdResetID,$sqlInvActive,$sqlInvEnabled); 
#####################################################################
#####################################################################
my (%NodeID,%NodeAddress,%NodePort,%NodeScheduler,%NodePersistent,%NodePersistentTimeout,%NodeProto,$prthtml,$sqlAlias,$cmdrebootid,$cmdrebootname,$sqlIP,$sqlEnabled);
my (%RSRoute,%RSPort,%RSAddress,%RSInActive,%RSActive,%RSWeight,%RSFoundAddress,$curmodeID,$curmodePropertyID,%RSFound,$MonStat);
&GetLVSOutput;

 ###   Fetch Environ   ####
 #####################################
 my $tparam=$ENV{QUERY_STRING};
 #####################################
 
 
 my $curuser=$ENV{REMOTE_USER};
 my $curip=$ENV{REMOTE_ADDR};
 my $showid=undef;
 
 my $DateFormat="%d.%m.%Y %H:%M:%S";

 my $ColDefRow="#909080"; 
 my $ColIDefRow="#C0C0C0";
 my $ColError="red";
 my $ColWarn="FF9933";
 my $ColOK="#00FF33";
 my ($myIP,$errorfnd);
 my (%sqlCmdName);

 my ($tmpActive,%ResActiveConTot,$tmpInActive,%ResInActiveConTot,$tmpWeight);
 my ($img_weight,$weight_stat,$img_monstat,$date_lastcheck,$font_image,$font_acitve,$lastcheck_date,$cursrvimg,$cursrvimgdescr,$cursrvcmd);
 if ($tparam =~ /edit=/) {
  if ($tparam =~ m/edit=(\d*)/){
   $showid="$1";
  } 
 }
 print &HTMLHeader;
 my (%ResInvID,$ResWeight,$dbh,%ResRstID);
 $dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
 if ($showid) {
  #Show Edit, Link, Service,Service Enable/Disable,Monitor Enable/Disable,Set Weight (Button),Set Weight (Amount)
  #Get ResID by IP
  #Get Services 
  my $sqlgalias = $dbh->prepare("SELECT alias,realip,enabled,cmd_reboot_id FROM tblResources where resID = '" . $showid . "';" ); 
  $sqlgalias->execute ; #Get Inventory and ID's
  (($sqlAlias,$sqlIP,$sqlEnabled,$cmdrebootid)=$sqlgalias->fetchrow_array);
  $myIP=$sqlIP;
  
  
  my $sqlcmdid = $dbh->prepare("SELECT name FROM tblCommands where cmdID = '" . $cmdrebootid . "';" ); 
  $sqlcmdid->execute ; #Get Inventory and ID's
  ($cmdrebootname)=$sqlcmdid->fetchrow_array;
  
  #print "<br> $sqlAlias - IP: $sqlIP - ResourceID: $showid\n"; 
  print &HTMLStartOutsideTable;
  print &HTMLStartInsideTable;
  my $sqlinv = $dbh->prepare("SELECT invID,weight,nodeID,link,cmd_reset_id,active,enabled FROM tblNodesInventory where resID = '" . $showid . "';" ); 
  $sqlinv->execute ; #Get Inventory and ID's
  while (($sqlInvID,$sqlInvWeight,$sqlNodeID,$sqlLink,$sqlCmdResetID,$sqlInvActive,$sqlInvEnabled)=$sqlinv->fetchrow_array) {

   my $sqlcmdid = $dbh->prepare("SELECT name FROM tblCommands where cmdID = '" . $sqlCmdResetID . "';" ); 
   $sqlcmdid->execute ; #Get Inventory and ID's
   (($sqlCmdName{$sqlCmdResetID})=$sqlcmdid->fetchrow_array);
   
   
   
   #Get Command Name
   #$sqlCmdResetID
   
   #print "=>$sqlInvID\n";
   $ResInvID{$sqlInvID}=$sqlInvID;
   $ResWeight=$sqlInvWeight;
   $ResRstID{$sqlInvID}=$sqlCmdResetID;
   my $sqlinvname = $dbh->prepare("SELECT name,enabled,scheduler,service,vip FROM tblNodes where nodeID = '" . $sqlNodeID . "';" ); 
   $sqlinvname->execute ; #Get Inventory and ID's
   (($sqlNodeName,$sqlNodeEnabled,$sqlScheduler,$sqlService,$sqlVip)=$sqlinvname->fetchrow_array);

   my $sqlmon = $dbh->prepare("SELECT enabled,monID,status,lastcheck,checkinterval,timeout FROM tblMonitor where invID = '" . $sqlInvID . "';" ); 
   #print "SELECT monid,status FROM tblMonitor where invID = '" . $sqlInvID . "' and enabled=1;\n"; 	
   $sqlmon->execute ; #Get Monitor Datas
   (my($sqlmonenabled,$sqlMonID,$sqlMonStat,$sqlMonLastCheck,$checkinterval,$timeout)=$sqlmon->fetchrow_array) ;
    if ($sqlmonenabled) {
   	 if ($sqlMonStat eq "OK") {
   	  $img_monstat="/images/green.gif";   	
   	  $MonStat="OK-$img_monstat";
   	 } else {
   	 	if ($sqlMonStat eq "UNKNOWN") {
   	 	 $img_monstat="/images/gray.gif";   	
   	 	 $MonStat="Unknown";
   	 	} else {
   	 	 $img_monstat="/images/red.gif";   	
   	 	 $MonStat="FAIL";
   	 	} 
   	 } 
   	 $lastcheck_date=strftime($DateFormat, localtime($sqlMonLastCheck));   	   	
   	 if ((time-$sqlMonLastCheck) > ($checkinterval + $timeout)) {
      $date_lastcheck="fontorangebold";   	
     } else {
    	$date_lastcheck="fontblack";   	
     }
    } else {
    	$MonStat="Disabled";
    	$img_monstat="/images/blue.gif";   	
    	$date_lastcheck="fontblack";   	
    	$lastcheck_date="/";
    }
    
  	if ($sqlEnabled ne 1) { #Overwrite values if needed
  	 if ($sqlmonenabled) {
  		$img_monstat="/images/grey.gif";   	
   		$MonStat="Unknown";
   		$lastcheck_date="/";
   		$date_lastcheck="fontblack";   
   	 }	else { 	
    	$MonStat="Disabled";
    	$img_monstat="/images/blue.gif";   	
    	$date_lastcheck="fontblack";   	
    	$lastcheck_date="/";
     }	
   	}

   
   #######  Get Live Services and Weigth vs Enabled Services  ########
	  $tmpActive=0;
    $tmpWeight=0;
    $tmpInActive=0;

   for my $pntbase (sort keys %NodeID){  #Enum LVS Inventory
    for my $pntval (sort keys %{$RSAddress{$pntbase}} ){
     if ($RSAddress{$pntbase}{$pntval} eq $sqlIP)  {
     	#print "DEB=: $NodeProto{$pntbase} == $sqlService\n"; 	
     	if ($NodeProto{$pntbase} =~ /$sqlService/i ) {
       if (($NodeProto{$pntbase} eq "FWM" ) and ($NodeAddress{$pntbase} eq $sqlVip)) {
       	
       	#$NodePort{$curmodeID}="$0";
       	#print "FWM DEB: $RSAddress{$pntbase}{$pntval} == $NodeAddress{$pntbase} == $sqlVip ==> $RSActive{$pntbase}{$pntval} ==> $RSInActive{$pntbase}{$pntval} ==> $RSWeight{$pntbase}{$pntval}\n";
     	  $tmpActive=$RSActive{$pntbase}{$pntval};
     	  $tmpWeight=$RSWeight{$pntbase}{$pntval};
     	  $tmpInActive=$RSInActive{$pntbase}{$pntval};
        $RSFound{$pntbase}{$pntval}=1;
        $RSFoundAddress{$pntbase}{$pntval}=$RSAddress{$pntbase}{$pntval};
       } 
     	 if ((($NodeProto{$pntbase} eq "TCP" ) or ($NodeProto{$pntbase} eq "UDP")) 
    		 and ("$NodeAddress{$pntbase}:$RSPort{$pntbase}{$pntval}" eq $sqlVip)
    		 and ($sqlIP eq $RSAddress{$pntbase}{$pntval}))  {
     	  #print "DEB>: $sqlIP $RSAddress{$pntbase}{$pntval} $NodeAddress{$pntbase}:$RSPort{$pntbase}{$pntval} $sqlVip ==> $RSActive{$pntbase}{$pntval} ==> $RSInActive{$pntbase}{$pntval}  ==> $RSWeight{$pntbase}{$pntval}\n";
     	  $tmpWeight=$RSWeight{$pntbase}{$pntval};
     	  $tmpActive=$RSActive{$pntbase}{$pntval};
     	  $tmpInActive=$RSInActive{$pntbase}{$pntval};
     	  $RSFound{$pntbase}{$pntval}=1;
     	  #$RSFoundAddress{$pntbase}{$pntval}=$RSAddress{$pntbase}{$pntval};
     	 } 
      } 
     }
    }
   }
   
   
   if ($sqlInvEnabled eq 1) {
    if ($sqlInvWeight ne $tmpWeight) {
     $img_weight="/images/yellow.gif";
     $weight_stat="Not Active";
    } else {
   	 $img_weight="/images/green.gif";
   	 $weight_stat="Online";
   	 if ($sqlInvActive eq 0) {
   	  $img_weight="/images/yellow.gif";
   	  $weight_stat="Check Config";
   	  $sqlInvWeight=0;
   	 }	
    } 
   } else {
     $img_weight="/images/red.gif";
     $weight_stat="Offline";
     $sqlInvWeight=0;
   }
   
   if ($sqlCmdResetID ne 0 ) {
   	#my $sqlcmd = $dbh->prepare("SELECT Name FROM tblCommands wheere cmdid ='".$sqlCmdResetID."';" );
    #$sqlcmd->execute ;  #Get Nodes
    #(my($SQLCMDName)=$sqlcmd->fetchrow_array) ;
   	
    $cursrvimg="/images/restart.gif";
    $cursrvimgdescr="$sqlCmdName{$sqlCmdResetID}";
    $cursrvcmd="mylvsrst.pl?resid=$showid&invid=$sqlInvID&rstid=$sqlCmdResetID";
   } else {  
    $cursrvimg="/images/kreuz_gray.gif";
    $cursrvimgdescr="Disabled";
    $cursrvcmd="#";
   }
   
   
   if (($sqlInvWeight eq $tmpWeight) and (($sqlInvEnabled eq 1))) {
    $font_image="fontblack";   	
   } else {
   	$font_image="fontorangebold";   	
   }   
   
   
   if (($tmpActive >= $ActiveWarning) or ($tmpInActive >= $ActiveWarning)) {
   	$font_acitve="fontredbold";   	
   } else {
    $font_acitve="fontblack";   	
   }
   


if (!$tmpWeight) { $tmpWeight = "0"}
#<td width="45" height="29" align="center" background="/images/t1_zeile-hg.gif"<img src="'.$img_monstat.'" title="'.$MonStat.'" width="19" height="17"></td>
$prthtml = '
  <tr>
          <td width="11" height="29" align="right"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
          <td height="29" background="/images/t1_zeile-hg.gif" class="blackLink"><A HREF="mylvsinfo.pl?id='.$sqlInvID.'">'.$sqlInvID.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="112" height="29" align="left" background="/images/t1_zeile-hg.gif" class="fontblack">'.$sqlNodeName.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="150" height="29" align="left" background="/images/t1_zeile-hg.gif" class="blackLink"><A HREF="'.$sqlLink.'">'.$sqlLink.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="36" height="29" align="center" background="/images/t1_zeile-hg.gif"><a href="'.$cursrvcmd.'"><img src="'.$cursrvimg.'"  title="'.$cursrvimgdescr.'" width="20" height="20" border="0"></a></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="35" height="29" align="center" background="/images/t1_zeile-hg.gif"><img src="'.$img_weight.'" title="'.$weight_stat.'" width="19" height="17"></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="35" height="29" align="center" background="/images/t1_zeile-hg.gif"><img src="'.$img_monstat.'" title="'.$MonStat.'" width="19" height="17"></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="137" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$date_lastcheck.'">'.$lastcheck_date.'</td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="80" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$font_image.'">'.$tmpWeight."/".$sqlInvWeight.'</td>
          <td width="10" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="93" align="center" background="/images/t1_zeile-hg.gif" class="'.$font_acitve.'">'.$tmpActive."/".$tmpInActive.'</td>
          <td height="29" align="left"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
  </tr>
  ';
  print $prthtml;  
 }   #while (my($sqlInvID,$sqlInvWeight,$sqlNodeID,$sqlLink)=$sqlinv->fetchrow_array) 
  
  
  ### DETECT INVALID SERVICES ON THIS HOST - DUE TO CONFIG ... AND PRINT IT TO CGI
  for my $pntbase (sort keys %NodeID){  #Enum LVS Inventory
   for my $pntval (sort keys %{$RSAddress{$pntbase}} ){
    if ((!$RSFound{$pntbase}{$pntval}) and ($RSAddress{$pntbase}{$pntval} eq $myIP)) {
     $prthtml = '
     <tr>
          <td width="11" height="29" align="right"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
          <td height="29" background="/images/t1_zeile-hg.gif" class="fontredbold">/</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="112" height="29" align="left" background="/images/t1_zeile-hg.gif" class="fontredbold">'.$sqlNodeName.'</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="150" height="29" align="left" background="/images/t1_zeile-hg.gif" class="fontredbold">/</td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="36" height="29" align="center" background="/images/t1_zeile-hg.gif"><img src="/images/grey.gif"  title="Invalid" width="20" height="20" border="0"></a></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="35" height="29" align="center" background="/images/t1_zeile-hg.gif"><img src="/images/grey.gif" title="Invalid" width="19" height="17"></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="45" height="29" align="center" background="/images/t1_zeile-hg.gif"<img src="/images/grey.gif" title="Invalid" width="19" height="17"></td>
          <td width="7" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="137" height="29" align="center" background="/images/t1_zeile-hg.gif" class="fontredbold">/</td>
          <td width="9" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="80" height="29" align="center" background="/images/t1_zeile-hg.gif" class="'.$font_image.'">'.$tmpWeight."/".$sqlInvWeight.'</td>
          <td width="10" height="29" background="/images/t1_zeile-hg.gif"><img src="/images/t1_separator-zeile.gif" width="7" height="29"></td>
          <td width="93" align="center" background="/images/t1_zeile-hg.gif" class="'.$font_acitve.'">'.$tmpActive."/".$tmpInActive.'</td>
          <td height="29" align="left"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
     </tr>
     ';
     print $prthtml;  
   }	
  }
 } 

print &HTMLEndInsideTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;
 
 
 }   #if ($showid) 


 
 sub GetLVSOutput {
 #Parse LVS Command Output and save it to hash
 my @lvsret = `$lvscmd`;   #Get LVS Status
 for my $myret (@lvsret) {
 	chomp $myret;
  #Mask: "TCP  10.0.1.18:7000 wrr persistent 3600"
  #Mask: "UDP  10.0.1.22:7000 wrr persistent 3600"
 	#print "XXXXX  DEB1 => $myret\n";
 	if ($myret =~ /^(\w{3})\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	 #print "XXXXX  DEB2 => $myret\n";
 	 $curmodeID++;
 	 $curmodePropertyID=0;
   $NodeID{$curmodeID}=$curmodeID;
   $NodeProto{$curmodeID}="$1";
 	 $NodeAddress{$curmodeID}="$2.$3.$4.$5";
 	 $NodePort{$curmodeID}="$6";
   $NodeScheduler{$curmodeID}="$7";		
   $NodePersistent{$curmodeID}="$8";		
   $NodePersistentTimeout{$curmodeID}="$9";		
 	} else {
 	 if ($myret =~ /^(\w{3})\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w*)/) {
 	 	#Mask: "TCP  10.0.1.18:7000 wrr"
    #Mask: "UDP  10.0.1.22:7000 wrr"
 	 	#print "XXXXX  DEB2a => $myret\n";
 	  $curmodeID++;
 	  $curmodePropertyID=0;
    $NodeID{$curmodeID}=$curmodeID;
    $NodeProto{$curmodeID}="$1";
 	  $NodeAddress{$curmodeID}="$2.$3.$4.$5";
 	  $NodePort{$curmodeID}="$6";
    $NodeScheduler{$curmodeID}="$7";		
    $NodePersistent{$curmodeID}="";		
    $NodePersistentTimeout{$curmodeID}="";		
 	 } else {
 	  if ($myret =~ /^FWM\s*(\d*)\s*(\w*)\s*(\w*)\s*(\d*)/) {
 	 	 #Mask: "FWM  1 wlc persistent 3600"
 	 	 #print "XXXXX  DEB3 => $myret\n";
 		 $curmodeID++;
 		 $curmodePropertyID=0;
 		 $NodeID{$curmodeID}=$curmodeID;
 		 $NodeProto{$curmodeID}="FWM";
 		 $NodeAddress{$curmodeID}="$1";
 		 $NodePort{$curmodeID}="0";
     $NodeScheduler{$curmodeID}="$2";		
     $NodePersistent{$curmodeID}="$3";		
     $NodePersistentTimeout{$curmodeID}="$4";		
 	  } else {
 	   if ($myret =~ /^FWM\s*(\d*)\s*(\w*)/) {
 	    #Mask: "FWM  1 wlc "
 	 	  #print "XXXXX  DEB3a => $myret\n";
 		  $curmodeID++;
 		  $curmodePropertyID=0;
 		  $NodeID{$curmodeID}=$curmodeID;
 		  $NodeProto{$curmodeID}="FWM";
 		  $NodeAddress{$curmodeID}="$1";
 		  $NodePort{$curmodeID}="0";
      $NodeScheduler{$curmodeID}="$2";		
      $NodePersistent{$curmodeID}="$3";		
      $NodePersistentTimeout{$curmodeID}="$4";		
 	   }
 	  }
 	 }
	}	
 	#Get Node Values
 	#Mask: " -> 10.0.1.240:0                 Route   100    0          0         "
 	if ($myret =~ m/\s*->\s*(\d*).(\d*).(\d*).(\d*):(\d*)\s*(\w+)\s*(\d*)\s*(\d*)\s*(\d*)/) {
 	 $curmodePropertyID++;
   $RSAddress{$curmodeID}{$curmodePropertyID}="$1.$2.$3.$4";
   $RSPort{$curmodeID}{$curmodePropertyID}="$5";
   $RSRoute{$curmodeID}{$curmodePropertyID}="$6";
   $RSWeight{$curmodeID}{$curmodePropertyID}="$7";
   $RSActive{$curmodeID}{$curmodePropertyID}="$8";
   $RSInActive{$curmodeID}{$curmodePropertyID}="$9";
 	}
 }    #for my $myret (@lvsret)
}     #sub GetLVSOutput

sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}



sub HTMLHeader {
#<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
my $ret='Content-type: text/html; charset=iso-8859-1

<html>
<head>
<title>LVS</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.fontairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #979696;
}
.fontnormal {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #979696;
}
.whitefield {
	background-color: #FFFFFF;
	border: 1px solid #cfcfcf;
}
.fontblacksmall {
	font-family: Verdana;
	font-size: 10px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
.fontblack {
	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
.fontorangebold {
	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #fb9419;
}
.fontredbold {
	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #d70012;
}


.blackLink A:link {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLink A:visited {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLink A:active {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLink A:hover {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #979696;
  text-decoration: underline;
}
 
-->
</style>
</head>
';
	
return $ret;	
}





#<td class="fontairname">Linux Virtual Server Manager - Alias: '.$sqlAlias.' - IP: '.$sqlIP.' - '.ResourceID: '.$showid.'<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip".')</span></td>


sub HTMLStartOutsideTable {
my $ret='	
<body><br>
<!-- Aussentabelle -->
<table width="837" height="369" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="771" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" height="29"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager <span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33" height="16"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">List Services on Server <span class="fontnormal"> ( </span>'."Alias: $sqlAlias - IP: $sqlIP - ResourceID: $showid".')</span></td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 

';
return $ret;		
}







sub HTMLStartInsideTable {
my $ret='

      <!-- Hier kommt innentabelle rein ! --><br>
	  <table width="785" border="0" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_top-corner-lft.gif" width="11" height="8"></td>
          <td width="14" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>      
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>      
          <td width="112" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="150" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="36" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="35" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="45" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="137" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="80" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="10" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="93" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" alt="14" width="1" height="1"></td>
          <td width="11" height="8" align="left" valign="bottom"><img src="/images/t1_top-corner-rt.gif" width="11" height="8"></td>
  </tr>
  <tr>
          <td width="11" height="41" align="right"><img src="/images/t1_top-gray-lft.gif" width="11" height="41"></td>      
          <td height="41" background="/images/t1_top-gray-hg.gif" class="fontairname"><br>
            ID</td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="112" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Memeber of Node</td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="150" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Link</td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="36" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Reset </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="35" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Status</td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="45" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Monitor </td>
          <td width="7" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="137" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Last Check</td>
          <td width="9" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="8" height="41"></td>
          <td width="80" height="41" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Weight</td>
          <td width="10" height="41" background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" width="7" height="41"></td>
          <td width="93" background="/images/t1_top-gray-hg.gif" class="fontblacksmall"><br>
          Active </td>
          <td height="41" align="left"><img src="/images/t1_top-gray-rt.gif" width="11" height="41"></td>
  </tr>


';
return $ret;	
}	




sub HTMLEndInsideTable {
my $ret='
        <tr> 
          <td width="11" height="14" align="right" valign="top"><img src="/images/t1_bottom-lft.gif" width="11" height="14"></td>      
          <td height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="112" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="150" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="36" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="35" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="45" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="7" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="137" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="9" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="80" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="10" height="14" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
          <td width="93" valign="top" background="/images/t1_bottom-hg.gif"><img src="/images/1x1_clear.gif" alt="13" width="1" height="1"></td>
          <td height="14" align="left" valign="top"><img src="/images/t1_bottom-rt.gif" width="11" height="14"></td>
  </tr>
</table>

      <a href="mylvs.pl"><img src="/images/back-tab.gif" alt="status name" width="63" height="29" border="0"></a><br>
<br>
      <!-- Innere Tabelle -->

';
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- HH-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
        <td class="fontairname"><a href="mylvssrvcommand.pl?id='.$showid.'&mode=1"><img src="/images/serviceevent.gif"  border="0" title="'."Reboot Server - $sqlAlias - ".$sqlIP.' " style="margin-top:25px"></td>
        <td class="fontairname"><a href="mylvssrvcommand.pl?id='.$showid.'&mode=2"><img src="/images/stop.gif"  border="0" title="'."Shut Down Server - $sqlAlias - ".$sqlIP.' " style="margin-top:25px"></td>
        <td class="fontairname"><a href="mylvssrvcommand.pl?id='.$showid.'&mode=3"><img src="/images/start.gif"  border="0" title="'."Wake Up Server - $sqlAlias - ".$sqlIP.' " style="margin-top:25px"></td>
        <td class="fontairname" border="0"><img src="/images/hh-clear.gif" width="5" height="76"></td>
        <td class="fontairname"><img src="/images/hh-clear.gif" width="540" height="76"></td>
		    <td class="fontairname"><img src="'.$sitelogo.'" width="176" height="76"></td>
        </tr>
      </table>
      <!-- End of HH-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';
return $ret;	

}

sub HTMLEndHeader {
my $ret='
</body>
</html>
';
return $ret;	
}
