#!/usr/bin/perl -w

################################
#Show LVS2 Add/Edit Server Mask
################################

use strict;
use DBI;
use POSIX;
#use Time::localtime;
#use Geo::IPfree;  


my $tldate = strftime("%Y%m%d-%H%M%S", localtime(time));


my $version="2.0.1.2";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############
####################### CONFIGURATION #######################


#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
my $granted = undef;   #user login flag - default off

#Load LVS htmlhelper
use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript);
use htmlsetuphelper qw(&htmlsetuptab &htmlsetupcss &htmlmainsetupheader);

#########################################################################################
my ($ServerName,$NodeIP,$Protocol,$Schedule,$Port,$Persistance,$tresid,$ResID,$ttt,$IP,$SQLCName,$SQLCID,$SQLcmd_reset_id,$RebootID,$MRTG);
my $tblText;
my ($dbh,$ret);
#########################################################################################
#BEGIN
$granted=&chkuser($curuser);  #Check User
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 



$tblText="Backup Manager";

print htmlmainheader;
print htmlsetupcss;
print jscript;
print htmlmaintab(7,860,0);


#print &HTMLHeader;
print &HTMLStartOutsideTable; 	
print htmlsetuptab(4);
print &HTMLInnerTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;

#END SCRIPT
           


sub chkDate () {
	if (length($_[0]) eq 1 ) {
		return "0" . $_[0];
	} else {
    return $_[0];		
	}
}           


sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}






sub HTMLStartOutsideTable {
my $ret='
<table width="860" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="794" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$tblText.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  
  <tr> 
    <td width="33" height="10" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>

  <tr> 
    <td width="33" height="184" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt die innere Tabelle rein ! --><br>
      
';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT showcon FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	




sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);

    $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
}


sub HTMLInnerTable{
my $ret='	
	  <table width="769" border="0" align="center" cellpadding="0" cellspacing="0"><form action="mylvsmkbackup.pl" method="post/get">
	  
        <!-- Weisser Aussenrahmen -->
         <tbody><tr> 
         <td align="right" valign="bottom" width="11" height="8"><img src="/images/t1_top-corner-lft.gif" width="11" height="8"></td>
         <td background="/images/t1_top-hg.gif" valign="bottom" width="125" height="8"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td background="/images/t1_top-hg.gif" valign="bottom" width="537" height="8"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td background="/images/t1_top-hg.gif" valign="bottom" width="39" height="8"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td background="/images/t1_top-hg.gif" valign="bottom" width="43" height="8"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td align="right" valign="bottom" width="14" height="8"><img src="/images/t1_top-corner-rt.gif" width="14" height="8"></td>
        </tr>
        <!-- Grau unterlegter Aussenrahmen Oben -->
         <tr> 
         <td align="right" valign="bottom" width="11" height="8"><img src="/images/t1_top-gray-lft.gif" width="11" height="8"></td>
         <td background="/images/t1_top-gray-hg.gif" width="125" height="8"></td>
         <td background="/images/t1_top-gray-hg.gif" width="537" height="8"></td>
         <td background="/images/t1_top-gray-hg.gif" width="39" height="8"></td>
         <td background="/images/t1_top-gray-hg.gif" width="43" height="8"></td>
         <td align="right" valign="bottom" width="14" height="8"><img src="/images/t1_top-gray-rt.gif" width="14" height="8"></td>
        </tr>
        <!-- Grau unterlegter Aussenrahmen Oben -->
        <tr> 
         <td align="right" valign="bottom" width="11" height="14"><img src="/images/t1_zeile-lft-cl.gif" width="11" height="14"></td>
         <td background="/images/t1_zeile-hg-bl.gif" width="125" height="14"></td>
         <td background="/images/t1_zeile-hg-bl.gif" width="537" height="14"></td>
         <td background="/images/t1_zeile-hg-bl.gif" width="39" height="14"></td>
         <td background="/images/t1_zeile-hg-bl.gif" width="43" height="14"></td>
         <td align="right" valign="bottom" width="14" height="14"><img src="/images/t1_zeile-rt-cl.gif" width="14" height="14"></td>
        </tr>
        <!-- Menu -->
 
        
        <tr> 
         <td align="right" valign="bottom" width="11" height="30"><img src="/images/t1_zeile-lft-cl.gif" width="11" height="30"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="125" height="30"><img src="/images/1x1_clear.gif" width="1" height="1">Backup Name </td>  
         <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="537" height="30"><img src="/images/1x1_clear.gif" width="1" height="1">'.$tldate.'</td>
         <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="39" height="30"><img src="/images/1x1_clear.gif" width="1" height="1"></td>  
         <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="43" height="30"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td align="right" valign="bottom" width="14" height="30"><img src="/images/t1_zeile-rt-cl.gif" width="14" height="30"></td>
        </tr>
        <tr> 
         <td align="right" valign="bottom" width="11" height="30"><img src="/images/t1_zeile-lft-cl.gif" width="11" height="30"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="125" height="30"><img src="/images/1x1_clear.gif" width="1" height="1">Comment</td>  
         <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="537" height="30"><img src="/images/1x1_clear.gif" width="1" height="1">
   	     <input name="comment" size="80" maxlength="80" class="fontblack" value="backup comment" type="text">   	     </td>
         <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="39" height="30">&nbsp;</td>  
         <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="43" height="30"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
        <td align="right" valign="bottom" width="14" height="30"><img src="/images/t1_zeile-rt-cl.gif" width="14" height="30"></td>
        </tr>
     
        <tr> 
         <td align="right" valign="bottom" width="11" height="30"><img src="/images/t1_zeile-lft-cl.gif" width="11" height="30"></td><td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="125" height="30"><img src="/images/1x1_clear.gif" width="1" height="1"><input value="OK" class="fontblack" type="submit"></td>
         <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="537" height="30"><img src="/images/1x1_clear.gif" width="1" height="1">   	     </td><td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="39" height="30"><img src="/images/1x1_clear.gif" width="1" height="1"><input name="name" value="'.$tldate.'.sql'.'" type="hidden">
   	     </td>  
         <td background="/images/t1_zeile-hg-bl.gif" valign="bottom" width="43" height="30"><img src="/images/1x1_clear.gif" width="1" height="1">
         <td align="right" valign="bottom" width="14" height="30"><img src="/images/t1_zeile-rt-cl.gif" width="14" height="30"></td>
        </tr>







        <!-- Zeile Blank - Abschluss Unten -->
         <tr> 
         <td align="right" valign="bottom" width="11" height="8"><img src="/images/t1_zeile-lft-bl.gif" width="11" height="29"></td>
         <td background="/images/t1_zeile-hg-hg.gif" width="125" height="8"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td background="/images/t1_zeile-hg-hg.gif" width="537" height="8"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td background="/images/t1_zeile-hg-hg.gif" width="39" height="8"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td background="/images/t1_zeile-hg-hg.gif" width="43" height="8"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td align="right" valign="bottom" width="14" height="8"><img src="/images/t1_zeile-rt-bl.gif" width="14" height="29"></td>
        </tr>
        <!-- Zeile Grauverlauf Oben -->
        <!--         
         <tr> 
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
         <td width="747" height="8" background="/images/t1_zeile-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
        </tr>
        -->   
        <!-- Grau unterlegter Aussenrahmen Unten -->
        <tr> 
   		    <td align="right" valign="top" width="11" height="14"><img src="/images/t1_bottom-lft.gif" width="11" height="14"></td>  
          <td background="/images/t1_bottom-hg1.gif" valign="top" width="125" height="8"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td background="/images/t1_bottom-hg1.gif" valign="top" width="537" height="8"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td background="/images/t1_bottom-hg1.gif" valign="top" width="39" height="8"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td background="/images/t1_bottom-hg1.gif" valign="top" width="43" height="8"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td align="left" valign="top" height="14"><img src="/images/t1_bottom-rt.gif" width="14" height="14"></td>
        </tr>
                            <tr> 
             <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" border="0" width="63" height="29"></a></td>
             <td width="537">&nbsp;</td>
            </tr>
     </tbody></table>



';
 
 return $ret;		

}