#!/usr/bin/perl -w


use strict;
use DBI;
use Time::localtime;
#use Geo::IPfree;  

my $version="2.0.1.2";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
my $conffile="/etc/lvs/lvs.conf.xml";


############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############


$lvscmd=$lvscmd." -Ln";

my $defaultcount=50;  #if no parameter is given, remeber that there is also a max value in the xml config


#Load LVS htmlhelper
use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss &jscript);
use htmlsetuphelper qw(&htmlsetuptab &htmlsetupcss &htmlmainsetupheader);


####################### CONFIGURATION #######################


#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};
####################################################################
my $basepath=$ENV{DOCUMENT_ROOT};
my $server = $ENV{HTTP_HOST};
####################################################################


my $granted = undef;   #user login flag - default off


#####################################################################
#####################################################################
my ($dbh,$dbhh,%Code,$resp,$ret,$FIN_WAIT,$NONE,$ESTABLISHED,$CLOSED,$SYN_RECV,$CONNECTIONS,$SENDER);
my (%tmpTotESTABLISHED,%tmpTotCLOSED,%tmpTotNONE,%tmpTotFIN_WAIT,%tmpTotSYN_RECV,$cnt,%TotLVSConnx,%tmpOrder,$reqcnt,$searchip,$tblText);
my ($tmpSource,$tmpTarget,$class_established,$class_closed,$class_tot,$class_none,$class_syn,$class_fin,$country,$country_name,$img_flag,$tmpipnum);
my $tmpESTABLISHED=undef;my $tmpCLOSED=undef;my $tmpNONE=undef;my $tmpFIN_WAIT=undef;my $tmpSYN_RECV=undef;
my ($nodeid,$nodename);

my($SQLnodeid,$SQLenabled,$SQLalias,$SQLip,$SQLcmdid,$SQLmrtg);

#my $pagelink="mylvsaddnode.pl";
my $pagelink="mylvsassignserver.pl";
my $pagedellink="mylvsnodemgr.pl";
my $pageassignlink="mylvsassignnode.pl";



my @reqTokens = split(/&/,$tparam);
if ($reqTokens[0] =~ /^nodeid=/) {
  if ($reqTokens[0] =~ m/nodeid=(\d*)/){ 
   $nodeid=$1;
  }
 }

if ($reqTokens[1] =~ /^node=/) {
  if ($reqTokens[1] =~ m/node=([^ ]*)/){ 
   $nodename=$1;
  }
 }


$tblText="Node Manager: Assign Server To No: $nodename - NodeID $nodeid"; #BEGIN
$granted=&chkuser($curuser);        #Check      User       
$dbh=DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
$dbhh =DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 



#print &HTMLHeader;
print htmlmainheader;
print htmlsetupcss;
print jscript;
print htmlmaintab(7,860,0);

print &HTMLStartOutsideTable; 	
print htmlsetuptab(1);
print &HTMLInnerTableStart;
print &HTMLInnerTableEntry;
print &HTMLInnerTableEnd;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;

#END SCRIPT
           


sub chkDate () {
	if (length($_[0]) eq 1 ) {
		return "0" . $_[0];
	} else {
    return $_[0];		
	}
}           


sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}



sub HTMLHeader {
#<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
my $ret='Content-type: text/html; charset=iso-8859-1

<html>
<head>
<title>LVS</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.fontairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #979696;
}

.fontblackairname {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #000000;
}

.fontnormal {
	font-family: Tahoma;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #979696;
}
.whitefield {
	background-color: #FFFFFF;
	border: 1px solid #cfcfcf;
}
.fontblacksmall {
	font-family: Verdana;
	font-size: 10px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
.fontblack {
	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}
.fontblackbig {
	font-family: Verdana;
	font-size: 18px;
	font-style: normal;
	font-weight: bold;
	color: #000000;
}

.fontorangebold {
	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #fb9419;
}
.fontredbold {
	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: bold;
	color: #d70012;
}


.blackLink A:link {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLink A:visited {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLink A:active {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLink A:hover {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #979696;
 text-decoration: underline;
}





.blackLinkMid A:link {
 font-family: Verdana;
 font-size: 14px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLinkMid A:visited {
 font-family: Verdana;
 font-size: 14px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 

.blackLinkMid A:active {
 font-family: Verdana;
 font-size: 14px;
 font-style: normal;
 font-weight: normal;
 color: #000000;
 text-decoration: none;
}
 


.redLink A:link {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #d70012;
 text-decoration: none;
}
 

.redLink A:visited {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #d70012;
 text-decoration: none;
}
 

.redLink A:active {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #d70012;
 text-decoration: none;
}
 

.redLink A:hover {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #d70012;
 text-decoration: underline;
}

.orangeLink A:link {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #fb9419;
 text-decoration: none;
}
 

.orangeLink A:visited {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #fb9419;
 text-decoration: none;
}
 

.orangeLink A:active {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #fb9419;
 text-decoration: none;
}
 
.fontblack1 {	font-family: Verdana;
	font-size: 11px;
	font-style: normal;
	font-weight: normal;
	color: #000000;
}


.orangeLink A:hover {
 font-family: Verdana;
 font-size: 10px;
 font-style: normal;
 font-weight: normal;
 color: #fb9419;;
 text-decoration: underline;
}

.fontblackblold {
	font-family: Verdana;
	font-size: 12px;
	font-style: normal;
	font-weight: bold;
	color: #000000;
}


 
-->
</style>
</head>



';
	
return $ret;	
}


sub HTMLStartOutsideTable {
my $ret='
<table width="860" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="794" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$tblText.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  
  <tr> 
    <td width="33" height="10" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>

  <tr> 
    <td width="33" height="184" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt die innere Tabelle rein ! --><br>
      
';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT showcon FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	




sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);

    $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
}




sub HTMLInnerTableStart{


 my $subpageadd=$pagelink."?addserver?nodeid=$nodeid";
 my $ret='	
	  	  <table align="center" border="0" cellpadding="0" cellspacing="0" width="769">
    <tbody><tr> 
    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="http://'.$server.'/mylvseditnode.pl">Edit Node</a></td>
    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="#">Edit Server</a></td>
    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="#">Apply Config</a></td>
    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="#">Backup</a></td>
    <td class="blackLink" align="center" background="/images/neutral-tab.gif" height="25" width="104"><a href="#">Restore</a></td>
    <td class="blackLink" align="center" background="/images/1x1_clear.gif" height="25" width="104"></td>
    <td class="blackLink" align="center" background="/images/1x1_clear.gif" height="25" width="104"></td>
    <td background="/images/t1_zeile-hg-bl.gif" height="25" width="132"><img src="/images/1x1_clear.gif" height="25" width="1"></td>
    </tr>
    </tbody></table>
    <table align="center" border="0" cellpadding="0" cellspacing="0" width="769"><form action="mylvsshconx.pl" method="post/get"></form>
    <!-- Weisser Aussenrahmen -->
    <tbody><tr> 
    <td align="right" height="8" valign="bottom" width="11"><img src="/images/t1_top-corner-lft.gif" height="8" width="11"></td>
    <td background="/images/t1_top-hg.gif" height="8" valign="bottom" width="59"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
    <td background="/images/t1_top-hg.gif" height="8" valign="bottom" width="12"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
    <td background="/images/t1_top-hg.gif" height="8" valign="bottom" width="60"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
    <td background="/images/t1_top-hg.gif" height="8" valign="bottom" width="14"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
    <td background="/images/t1_top-hg.gif" height="8" valign="bottom" width="65"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
    <td background="/images/t1_top-hg.gif" height="8" valign="bottom" width="12"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
    <td background="/images/t1_top-hg.gif" height="8" valign="bottom" width="522"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
    <td align="right" height="8" valign="bottom" width="14"><img src="/images/t1_top-corner-rt.gif" height="8" width="14"></td>
    </tr>
    <!-- Grau unterlegter Aussenrahmen Oben -->
    <tr> 
    <td align="right" valign="bottom"><img src="/images/t1_top-gray-lft.gif" height="32" width="11"></td>
    
    <td class="blackLinkMid" align="center" background="/images/t1_top-gray-hg.gif" height="32" width="48"><a href="http://'.$server.'/mylvsassignserver.pl?addserver&nodeid='.$nodeid.'">Assign</td>
    
    
    
    <td background="/images/t1_top-gray-hg.gif"><img src="/images/t1_top-gray-hg.gif" height="32" width="11"></td>
    <td background="/images/t1_top-gray-hg.gif"><img src="/images/t1_top-gray-hg.gif" height="32" width="58"></td>
    <td background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" height="32" width="12"></td>
	  <td align="left" background="/images/t1_top-gray-hg.gif" height="32" width="65">Weight</td>
    <td background="/images/t1_top-gray-hg.gif"><img src="/images/t1_separator-gray.gif" height="32" width="10"></td>
    <td align="left" background="/images/t1_top-gray-hg.gif" height="32" width="522">Server</td>
    <td align="right" height="32" valign="bottom" width="14"><img src="/images/t1_top-gray-rt.gif" height="32" width="14"></td>
    </tr>
    <!-- Grau unterlegter Aussenrahmen Oben -->



';
 
 my $ret='	
         <table align="center" border="0" cellpadding="0" cellspacing="0" width="769" class="fontblack">
          <form action="mylvsshconx.pl" method="post/get">
          </form>
   
   <!-- Weisser Aussenrahmen -->
          <tr> 
            <td align="right" height="8" valign="bottom" width="11"><img src="/images/t1_top-corner-lft.gif" height="8" width="11"></td>
            <td background="/images/t1_top-hg.gif" height="8" valign="bottom"><img src="/images/1x1_clear.gif" height="1" width="1"></td>

            <td background="/images/t1_top-hg.gif" valign="bottom" width="7"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7%"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7%"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td background="/images/t1_top-hg.gif" valign="bottom" width="7"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td width="7%" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" height="1" width="1"></td>
            <td align="left" height="8" valign="bottom" width="11"><img src="/images/t1_top-corner-rt.gif" height="8" width="11"></td>
          </tr>
          <!-- Grau unterlegter Aussenrahmen Oben -->

          <tr class="UeberschrBorderBottom"> 
            <td align="right" valign="bottom"><img src="/images/t1_top-gray-lft.gif" height="32" width="11"></td>
            <td height="32" align="left" class="UeberschrBorderBottom">Server within Node:&nbsp;'.$nodename.'</td>
            <td width="7" valign="bottom" class="UeberschrBorderBottom"><img src="/images/separator-gray_7x32.gif" width="7" height="32"></td>
            <td colspan="5" align="right" class="UeberschrBorderBottom"><a href="'.$subpageadd.'" target="_self"><img src="/images/buttons/add.gif" alt="Add new node" border="0"></a></td>
            <td width="11" height="32" align="left" valign="bottom"><img src="/images/t1_top-gray-rt.gif" height="32" width="11"></td>
          </tr>
          <!-- Grau unterlegter Aussenrahmen Oben -->
          <tbody>
';
 
 return $ret;		

}



sub HTMLInnerTableEnd{

	
 my $ret='	

             <!-- Zeile Grauverlauf Oben -->
            <!-- Grau unterlegter Aussenrahmen Unten -->
            <tr> 
              <td align="right" height="14" valign="top" width="11"><img src="/images/t1_bottom-lft.gif" height="14" width="11"></td>
              <td background="/images/t1_bottom-hg1.gif" height="14" valign="top"><img src="/images/1x1_clear.gif" height="8" width="1"></td>

              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7%"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7%"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td background="/images/t1_bottom-hg1.gif" valign="top" width="7"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td width="7%" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" height="8" width="1"></td>
              <td width="11" height="14" align="left" valign="top"><img src="/images/t1_bottom-rt.gif" height="14" width="11"></td>
            </tr>
            <tr> 
             <td colspan="2" align="left" valign="top"><a href="mylvseditnode.pl"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
             <td width="19">&nbsp;</td>
            </tr>

          </tbody>

        </table>




      <!-- Innere Tabelle -->



';
 
 
 
 
 
 
 
 return $ret;		


}


sub HTMLInnerTableEntry{

my $ret;
my $imglink;
my $prtweight;
my $amode;



 my $sqlserver = $dbh->prepare("SELECT resID,enabled,alias,realip,cmd_reboot_id,mrtg_link FROM tblResources order by alias;" ); 
 $sqlserver->execute ; #Get Resources
 while (my($SQLResID,$SQLResEnabled,$SQLResAlias,$SQLResIP,$SQLResCmdID,$SQLResMRTG)=$sqlserver->fetchrow_array) {



my $sqlinv = $dbh->prepare("SELECT invID,resid,weight FROM tblNodesInventory where nodeID='".$nodeid."' and resID='".$SQLResID."';"  ); 
$sqlinv->execute ; #Get Resources
(my($SQLInvID,$SQLRResID,$SQLweight)=$sqlinv->fetchrow_array) ;
if ($SQLRResID) {
	$imglink="/images/green.gif";
	$prtweight=$SQLweight;
	$amode="Edit";
#} else {	
#	$imglink="/images/red.gif";
#	$prtweight="-";
#	$amode="Assign";



  my $subpagelink=$pagelink."?nodeid=$SQLnodeid";
	#my $subdelpagelink=$pagedellink."?id=$SQLnodeid&mode=delete";
	
  my $tlink=$pagedellink."?id=$SQLInvID&nodeid=$nodeid&nodename=$nodename&mode=deleteassign";
	my $subdelpagelink='<a href="javascript:confirmDelete('."'$tlink')".'">';

	
	my $subassignpagelink=$pageassignlink."?id=$SQLnodeid";
  
 $ret.='	

 

            <!-- Innere tabelle fuer nodes -->
            <tr> 
              <td align="right" background="/images/t1_zeile-hg.gif" height="29" valign="bottom" width="11"><img src="/images/t1_zeile-lft.gif" height="29" width="11"></td>
              <td align="left" background="/images/t1_zeile-hg.gif" height="29"><img src="/images/1x1_clear.gif" height="1" width="1">'.$SQLResAlias.'</td>
              <td background="/images/t1_zeile-hg.gif" width="7"><img src="/images/t1_separator-zeile.gif" height="29" width="7"></td>
              <td class="blackLinkMid" align="center" background="/images/t1_zeile-hg.gif" width="7%">'.$prtweight.'</td>
              <td background="/images/t1_zeile-hg.gif" width="7"><img src="/images/t1_separator-zeile.gif" height="29" width="7"></td>
              <td class="blackLinkMid" align="center" background="/images/t1_zeile-hg.gif" width="7%"><img src="/images/1x1_clear.gif" height="1" width="1"><a href="http://'.$server.'/mylvsassignserver.pl?nodeinvid='.$SQLInvID.'"><img src="/images/buttons/edit.gif" border="0"></a></td>
              <td background="/images/t1_zeile-hg.gif" width="7"><img src="/images/t1_separator-zeile.gif" height="29" width="7"></td>

              <td width="7%" align="center" background="/images/t1_zeile-hg.gif" class="blackLinkMid"><img src="/images/1x1_clear.gif" height="1" width="1">'.$subdelpagelink.'<img src="/images/buttons/delete.gif" border="0"></a></td>
              <td align="left" height="29" valign="bottom" width="11"><img src="/images/t1_zeile-rt.gif" height="29" width="11"></td>
            </tr>
';        

  
 }   #if ($SQLRResID)  
}        

 
 return $ret;		

}
