#!/usr/bin/perl -w

######################
#LVS2 Node Edit / Add
######################


#To Do: Check Vars: $netmask,$method, are they required incl. the fields ?

use strict;
use DBI;
use Time::localtime;
#use Geo::IPfree;  

my $version="2.0.1.2";
####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
############
#Config Vars
############
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$ActiveWarning,$InActiveWarning,$HTTP_ERR,$HTTP_WARN,$simulate,$maxcount,$backuppath,$restoreapp,$backupapp,$SuppressedAddress,$HTMLLVSView,$bkupreplcommand,$sitelogo);
&getconfig;
############

#Load LVS htmlhelper
use lib "../modules/";
use htmlhelper qw(&htmlmaintab &htmlmainheader &htmlmaincss );
use htmlsetuphelper qw(&htmlsetuptab &htmlsetupcss &htmlmainsetupheader);
####################### CONFIGURATION #######################


#Get Apache Environs
my $tparam=$ENV{QUERY_STRING};
my $curuser=$ENV{REMOTE_USER};
my $curip=$ENV{REMOTE_ADDR};

my $granted = undef;   #user login flag - default off




#########################################################################################
my ($dbh,$ret);
#DropDown Preselection
my ($self,$selt,$selu,$selxl);
#$self="selected";

my ($seldr,$selma);
#$seltu="selected";

my ($selrr,$selwr,$sellc,$selwlc,$sellblc,$sellblcr,$seldh,$selsh,$selsed,$selnq);
#$selnq="selected";
my ($NodeName,$NodeIP,$Protocol,$Schedule,$Port,$Persistance,$nodeid);
my ($selmonval);
my ($selen,$selenval);
my $txtProto;
my $tblText;
my $EditMode=undef;
#########################################################################################

#BEGIN
$granted=&chkuser($curuser);  #Check User
$dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 

if ($tparam =~ /^nodeid=/) {
	$EditMode=1;
  if ($tparam =~ m/nodeid=(\d*)/){ 
   $nodeid=$1;
   my $sql = $dbh->prepare("SELECT enabled,name,scheduler,service,vip,persistent,monitor FROM tblNodes where nodeid='".$1."' ;" );  	
   
   $sql->execute ; 
   (my($enabled,$name,$scheduler,$service,$vip,$persistent,$monitor)=$sql->fetchrow_array);
   
   $txtProto="IP Address";
   
   if ($service =~ /tcp/i){
    $selt="selected";
   } 
   
   if ($service =~ /udp/i){
    $txtProto="IP Address";
    $selu="selected";
   }
   
   if ($service =~ /fwm/i){
    $self="selected";
    $txtProto="FWMark";
   } 
   
   $NodeName=$name;
   
   if ($vip =~ m/(\d+).(\d+).(\d+).(\d+):(\d+)/){
    $NodeIP="$1.$2.$3.$4";
    $Port="$5";
   } else {
    $NodeIP="";
    $Port="-";
    if ($vip =~ m/(\d+)/){
    	$NodeIP="$1";
    }	
   }
  
   #Not build in yet
   #$Netmask=$netmask;
   
   $Persistance=$persistent;
   if (!$Persistance){$Persistance="0"};
   
   #$selmon=$monitor;
   if ($monitor eq 1){
    $selmonval="checked";
   }
   
   if ($monitor eq 0){
    $selmonval="";
   }
   
   
   if ($enabled eq 1){
    $selenval="checked";
    #$selen=1;
   }
   
   if ($enabled eq 2){
    $selenval="";
    #$selen=0;
   }
    
   if ($scheduler =~ /rr/){$seldr="selected";}
   if ($scheduler =~ /wrr/){$selwr="selected";}
   if ($scheduler =~ /lc/){$sellc="selected";}
   if ($scheduler =~ /wlc/){$selwlc="selected";}
   if ($scheduler =~ /lblc/){$sellblc="selected";}
   if ($scheduler =~ /lblcr/){$sellblcr="selected";}
   if ($scheduler =~ /dh/){$seldh="selected";}
   if ($scheduler =~ /sh/){$selsh="selected";}
   if ($scheduler =~ /sed/){$selsed="selected";}
   if ($scheduler =~ /nq/){$selnq="selected";}
   #$tblText="SELECT enabled,name,scheduler,service,vip,persistent,monitor FROM tblNodes where nodeid='".$1."' ; $name $database:$servername";
   #if ($method =~ /dr/){$seldr="selected";}
   #if ($method =~ /tu/){$seltu="selected";}
   #if ($method =~ /masq/){$selma="selected";}
  }	
}	

if ($EditMode){
 $tblText="Node Manager - Edit Node: $NodeName - ID: $nodeid  ";
} else {
 $tblText="Node Manager - Add Node";
} 

print htmlmainheader;
print htmlmaintab(7,860,0);
print htmlmaincss;
print jscript;
print &HTMLStartOutsideTable; 	
print htmlsetuptab(1);
print &HTMLInnerTable;
print &HTMLEndOutsideTable;
print &HTMLEndHeader;
#END SCRIPT
           
sub chkDate () {
	if (length($_[0]) eq 1 ) {
		return "0" . $_[0];
	} else {
    return $_[0];		
	}
}           


sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $ActiveWarning=$data->{ShowAmount}->{ActiveWarning};
 $InActiveWarning=$data->{ShowAmount}->{InActiveWarning};
 $HTTP_ERR=$data->{ShowAmount}->{HTTP_ERR};
 $HTTP_WARN=$data->{ShowAmount}->{HTTP_WARN};
 $simulate=$data->{Operation}->{WebSimulate};
 $maxcount=$data->{ShowAmount}->{MaxConCount};
 $backuppath=$data->{SQLConfigBackup}->{Path};
 $restoreapp=$data->{SQLConfigBackup}->{RestoreApp};
 $backupapp=$data->{SQLConfigBackup}->{BackupApp};
 $SuppressedAddress=$data->{StatusView}->{SupressedAddress};
 $HTMLLVSView=$data->{View}->{HTMLLVSOutput};
 $sitelogo=$data->{Logo}->{Path};
}





sub HTMLStartOutsideTable {

my $ret='
<table width="860" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr> 
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-lft.gif" width="33" height="12"></td>
    <td width="794" height="12" background="/images/hg-top.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12" valign="bottom"><img src="/images/ecke-top-rt.gif" width="33" height="12"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top2-lft.gif" width="33" height="29"></td>
    <td class="fontairname">Linux Virtual Server Manager<span class="fontnormal"> ( </span>'."User: $curuser from IP: $curip - Version: $version ".')</span></td>
    <td width="33"><img src="/images/ecke-top2-rt.gif" width="33" height="29"></td>
  </tr>
  <tr> 
    <td width="33"><img src="/images/ecke-top3-lft.gif" width="33" height="15"></td>
    <td background="/images/hg-top3.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33"><img src="/images/ecke-top3-rt.gif" width="33" height="15"></td>
  </tr>
  <tr> 
    <td width="33" background="/images/ecke-top-hg-lft.gif">&nbsp;</td>
    <td bgcolor="#f8f8f8"><!-- Supported WebFare Tabelle --><table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td width="45"><img src="/images/pc-icon.gif" width="25" height="26"></td>
          <td class="fontairname">'.$tblText.'</td>
        </tr>
      </table><!-- End of Supported WebFare Tabelle --></td>
    <td width="33" background="/images/ecke-top-hg-rt.gif">&nbsp;</td>
  </tr>
  <tr> 
    <td width="33" height="12"><img src="/images/ecke-top4-lft.gif" width="33" height="12"></td>
    <td height="12" background="/images/hg-top4.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
    <td width="33" height="12"><img src="/images/ecke-top4-rt.gif" width="33" height="12"></td>
  </tr>
  
  <tr> 
    <td width="33" height="10" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>

  <tr> 
    <td width="33" height="184" background="/images/border-hg-lft.gif">&nbsp;</td>
    <td align="left" valign="top"> 
      <!-- Hier kommt die innere Tabelle rein ! --><br>
      
';
	
return $ret;	
	
}



sub HTMLEndOutsideTable {
my $ret='
      <!-- Innere Tabelle -->
    </td>
    <td width="33" background="/images/border-hg-rt.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
  </tr>
  <tr> 
    <td width="33" height="76"><img src="/images/ecke-bottom-lft.gif" width="33" height="76"></td>
    <td height="76" align="right" valign="top" background="/images/border-hg-bottom.gif">
      <!-- myLVS-Logo Tabelle -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="fontairname"><img src="'.$sitelogo.'"></td>
        </tr>
      </table>
      <!-- End of myLVS-Logo Tabelle -->
    </td>
    <td width="33" height="76"><img src="/images/ecke-bottom-rt.gif" width="33" height="76"></td>
  </tr>
</table>
<!-- End of Aussentabelle -->
';	                
 return $ret;		
}


sub HTMLEndHeader {
my $ret='
</body>
</html>
';	                
 return $ret;		
}

sub chkuser {
	
	my ($dbhf,$fnd);
	$dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword); 
  my $sqlusr = $dbhf->prepare("SELECT showcon FROM tblUsers where name='".$_[0]."' ;" );
  $sqlusr->execute ; 
  (($fnd)=$sqlusr->fetchrow_array);

  if ($fnd eq 1) {
	 #print "=> $_[0]-$fnd OK\n";
	 return "1";
	} else {
	 #print "=> $_[0] FAIL\n";
	 return undef;
	}
	
}	




sub ip_to_number($){ # IP => Number
my $ip = shift;
my (@octets, $ip_num);

    $ip =~ s/\n//g;
	@octets = split /\./, $ip;
	$ip_num = 0;
	foreach (@octets) {
	    $ip_num <<= 8;
	    $ip_num |= $_;
	}
return $ip_num;
}


sub HTMLInnerTable{

$selt="selected";		
my $ret='	
	  <table width="769" border="0" align="center" cellpadding="0" cellspacing="0"><form action="mylvsnodemgr.pl" method="post/get">
	  
        <!-- Weisser Aussenrahmen -->
         <tr> 
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_top-corner-lft.gif" width="11" height="8"></td>
         <td width="95" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="291" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="100" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="258" height="8" valign="bottom" background="/images/t1_top-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="14" height="8" align="right" valign="bottom"><img src="/images/t1_top-corner-rt.gif" width="14" height="8"></td>
        </tr>
        <!-- Grau unterlegter Aussenrahmen Oben -->
         <tr> 
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_top-gray-lft.gif" width="11" height="8"></td>
         <td width="95" height="8" background="/images/t1_top-gray-hg.gif"></td>
         <td width="291" height="8" background="/images/t1_top-gray-hg.gif"></td>
         <td width="100" height="8" background="/images/t1_top-gray-hg.gif"></td>
         <td width="258" height="8" background="/images/t1_top-gray-hg.gif"></td>
         <td width="14" height="8" align="right" valign="bottom"><img src="/images/t1_top-gray-rt.gif" width="14" height="8"></td>
        </tr>
        <!-- Grau unterlegter Aussenrahmen Oben -->
        <tr> 
         <td width="11" height="14" align="right" valign="bottom"><img src="/images/t1_zeile-lft-cl.gif" width="11" height="14"></td>
         <td width="95" height="14" background="/images/t1_zeile-hg-bl.gif"></td>
         <td width="291" height="14" background="/images/t1_zeile-hg-bl.gif"></td>
         <td width="100" height="14" background="/images/t1_zeile-hg-bl.gif"></td>
         <td width="258" height="14" background="/images/t1_zeile-hg-bl.gif"></td>
         <td width="14" height="14" align="right" valign="bottom"><img src="/images/t1_zeile-rt-cl.gif" width="14" height="14"></td>
        </tr>
        <!-- Menu -->
        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">Name</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">
   	     <input name="nodename" size="30" maxlength="30" class="fontblack" type="text" value="'.$NodeName.'">
   	     </td><td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1">'.$txtProto.'</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
  		    <input name="ip" size="30" maxlength="30" class="fontblack" type="text" value="'.$NodeIP.'">
	    	 </td>
         <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
        </tr>
        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">Port</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">
   	     <input name="port" size="30" maxlength="30" class="fontblack" type="text" value="'.$Port.'">
   	     </td>
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1">Protocol</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
         <select name="protocol">
         <option value="tcp"'.$selt.'>TCP</option>
         <option value="udp" '.$selu.'>UDP</option>
         <option value="fwm" '.$self.'>FWMARK </option>
         </select>
         </td>
         <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
        </tr>
        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">Persistence</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">
  		    <input name="persistance" size="30" maxlength="30" class="fontblack" type="text" value="'.$Persistance.'">
   	     </td>
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98">Schedule</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
         <select name="schedule">
         <option value="rr" '.$seldr.'>Round Robin</option>
         <option value="wrr" '.$selwr.'>Weighted Round Robin</option>
         <option value="lc" '.$sellc.'>Least-Connection</option>
         <option value="wlc" '.$selwlc.'>Weighted Least-Connection</option>
         <option value="lblc" '.$sellblc.'>Locality-Based Least-Connection</option>
         <option value="lblcr" '.$sellblcr.'>Locality-Based Least-Connection/Repl.</option>
         <option value="dh" '.$seldh.'>Destination Hashing</option>
         <option value="sh" '.$selsh.'>Source Hashing</option>
         <option value="sed" '.$selsed.'>Shortest Expected Delay</option>
         <option value="nq" '.$selnq.'>Never Queue</option>
         </select>
      	 </td>
         <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
        </tr>



        <tr> 
         <td align="right" height="30" valign="bottom" width="11"><img src="/images/t1_zeile-lft-cl.gif" height="30" width="11"></td>
   	     <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="95"><img src="/images/1x1_clear.gif" height="1" width="1">Enabled</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="263"><img src="/images/1x1_clear.gif" height="1" width="1">
 		     <input name="enabled" type="checkbox" '.$selenval.'>	 
   	     </td><td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="98"><img src="/images/1x1_clear.gif" height="1" width="1">Monitor</td>  
         <td background="/images/t1_zeile-hg-bl.gif" height="30" valign="bottom" width="288"><img src="/images/1x1_clear.gif" height="1" width="1">
         <input name="monitor" type="checkbox" '.$selmonval.'>	 
    	 </td>
         <td align="right" height="30" valign="bottom" width="14"><img src="/images/t1_zeile-rt-cl.gif" height="30" width="14"></td>
        </tr>



        <tr> 
         <td width="11" height="30" align="right" valign="bottom"><img src="/images/t1_zeile-lft-cl.gif" width="11" height="30"></td>';
   	     #Add submit button
   	     if ($EditMode){
   	      $ret.='<td width="95" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1"><input type="submit" value="OK" class="fontblack"></td>';
         } else {
         	$ret.='<td width="95" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1"><input type="submit" value="Add" class="fontblack"></td>';
         }
         
         $ret.='
         <td width="291" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1">
   	     <td width="100" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1">';
   	     
   	     if ($EditMode){
   	      $ret.='<input name="mode" type="hidden" value="edit">';	 
   	     } else {
   	      $ret.='<input name="mode" type="hidden" value="add">';
   	     } 
   	     $ret.='
   	     </td>  
         <td width="258" height="30" valign="bottom" background="/images/t1_zeile-hg-bl.gif"><img src="/images/1x1_clear.gif" width="1" height="1">
         <input name="id" type="hidden" value="'.$nodeid.'">	 

  	   	 </td>
         <td width="14" height="30" align="right" valign="bottom"><img src="/images/t1_zeile-rt-cl.gif" width="14" height="30"></td>
        </tr>







        <!-- Zeile Blank - Abschluss Unten -->
         <tr> 
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-lft-bl.gif" width="11" height="29"></td>
         <td width="95" height="8" background="/images/t1_zeile-hg-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="291" height="8" background="/images/t1_zeile-hg-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="100" height="8" background="/images/t1_zeile-hg-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="258" height="8" background="/images/t1_zeile-hg-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="14" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-rt-bl.gif" width="14" height="29"></td>
        </tr>
        <!-- Zeile Grauverlauf Oben -->
        <!--         
         <tr> 
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-lft.gif" width="11" height="29"></td>
         <td width="747" height="8" background="/images/t1_zeile-hg.gif"><img src="/images/1x1_clear.gif" width="1" height="1"></td>
         <td width="11" height="8" align="right" valign="bottom"><img src="/images/t1_zeile-rt.gif" width="11" height="29"></td>
        </tr>
        -->   
        <!-- Grau unterlegter Aussenrahmen Unten -->
        <tr> 
   		    <td width="11" height="14" align="right" valign="top"><img src="/images/t1_bottom-lft.gif" width="11" height="14"></td>  
          <td width="95"  height="8" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td width="291"  height="8" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td width="100"  height="8" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td width="258"  height="8" valign="top" background="/images/t1_bottom-hg1.gif"><img src="/images/1x1_clear.gif" width="1" height="8"></td>
          <td height="14" align="left" valign="top"><img src="/images/t1_bottom-rt.gif" width="14" height="14"></td>
        </tr>
        <tr> 
          <td colspan="2" align="left" valign="top"><a href="javascript:history.back()"><img src="/images/back-tab.gif" alt="previous page" width="63" height="29" border="0"></a></td>
          <td width="19">&nbsp;</td>
        </tr>

     </table>


';
 
 return $ret;		

}