use strict;
use POSIX;
use XML::Simple;      #=>Read my XML Config
use Data::Dumper;     #=>Debugging
use DBI;              ##=>used for mySQL

#300 WeightDown in progress, please stand by
#301 TurnOff in progress, please stand by
#302 Another maintenance service is already running, please come back later


#Codes:
#     200: Request accepted, go ahead

#New with this project:
#     303: Host is disabled for maintenance
#     304: Host has already maintenance running, please come back later
#     305: Host has already ip renew set, please come back later
#     306: Host has already ip renewed a few minutes ago, please come back later
#     307: Host not found in inventory
#New with this project:
#     407 ip renew is not set on: $TmpLVSHost
#     408 Function not supported



#     500: Access denied
#     501: Update failed, contact IT-Admin



my $wdTime = 60;         #'weight down time - sec~clock
my $toTime = 60;         #'turn off time - sec~clock

my ($Server,$Database,$Username,$Password);

my $Conffile = '/etc/mylvs/mylvs-ws.xml';


my ($LVSServer,$LVSUser,$LVSPass,$UnlimitedAccess,$LVSDB,%AccessHost,$tAccess,$sql,$TmpLVSHost,$StormProtection,$AllowReset);



 
package lvs;

# Based on the idea from:
# -- SOAP::Lite -- guide.soaplite.com -- Copyright (C) 2001 Paul Kulchenko --



sub WHATISMYIP {                     
  use CGI ':standard';
  my $RemoteAddr=$ENV{REMOTE_ADDR};
  if ($RemoteAddr){
   return "200 $RemoteAddr";     
  } else {
   return "501 Contact IT-Admin";     
  } 
}

sub REQUESTNEWDSLIP {                     
  &GetConfig;
  if (&GetPermission){  #Access granted, go and proceed!!!
   my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });
   $sql = $dbh->prepare("SELECT mID,DSLMaintenance,DSLRenewRequest,DSLDate,Enabled,DSLEpoche FROM tblMaintenance where ip = '".$TmpLVSHost."';" );  
   $sql->execute;
   (my ($SQLmID,$SQLDSLMaintenance,$SQLDSLRenewRequest,$SQLDSLDate,$SQLEnabled,$DSLEpoche)=$sql->fetchrow_array);
   if ($SQLmID){
   	
   	if (!$SQLEnabled){return "303 Host is disabled for maintenance";}
   	if ($SQLDSLMaintenance){return "304 Host has already maintenance running, please come back later";}
   	if ($SQLDSLRenewRequest){return "305 Host has already ip renew set, please come back later";}
    if ($StormProtection-(time - $DSLEpoche) > 0 ) {
   	 return "306: Host has already ip renewed a few minutes ago, please come back later in " . ($StormProtection-(time - $DSLEpoche)) . " seconds";
    }

    $sql = ("update tblMaintenance set DSLRenewRequest=1 where mID = '".$SQLmID."';" );  
    my $sqlret  = $dbh->do($sql);

    if ($sqlret){
     return "200 ip renew has been set for $TmpLVSHost";      	
    } else {  #if ($sqlret)
     return "501: Update failed, contact IT-Admin";
    }         #if ($sqlret)
   } else {   #if ($SQLmID)  
 	  return "406 Reqeust refused, Host does not exist in my inventory: $TmpLVSHost";      	
   }          #if ($SQLmID)
  } else {    #if ($tAccess)  #Access granted, go and proceed!!!
   return "500 Access Denied ";     
  }           #if ($tAccess)  #Access granted, go and proceed!!!
}             #Sub




sub RELEASETNEWDSLIP {                     
  &GetConfig;
  if (&GetPermission){  #Access granted, go and proceed!!!
   
   if ($AllowReset) {
   
    my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
    });
    $sql = $dbh->prepare("SELECT mID,DSLMaintenance,DSLRenewRequest,DSLDate,Enabled,DSLEpoche FROM tblMaintenance where ip = '".$TmpLVSHost."';" );  
    $sql->execute;
    (my ($SQLmID,$SQLDSLMaintenance,$SQLDSLRenewRequest,$SQLDSLDate,$SQLEnabled,$DSLEpoche)=$sql->fetchrow_array);
    if ($SQLDSLRenewRequest){
     $sql = ("update tblMaintenance set DSLRenewRequest=0 where ip = '".$TmpLVSHost."';" );  
     my $sqlret  = $dbh->do($sql);
     if ($sqlret){
      return "200 ip renew has been released for $TmpLVSHost";      	
     } else {  #if ($sqlret)
      return "501: Update failed, contact IT-Admin";
     }         #if ($sqlret)
    } else {   #if ($SQLDSLMaintenance)  
 	   return "407 ip renew is not set on: $TmpLVSHost";      	
    }          #if ($SQLmID)
  } else {    #if ($tAccess)  #Access granted, go and proceed!!!
   return "408 Function not supported";     
  }           #if ($tAccess)  #Access granted, go and proceed!!!
 } else {    #if ($tAccess)  #Access granted, go and proceed!!!
  return "500 Access Denied ";     
 }           #if ($tAccess)  #Access granted, go and proceed!!!

}             #Sub


sub WHATISMYDSLIP {                     
  #Return the dsl ip from the field DSLIP from the table tblMaintenance
  &GetConfig;
  if (&GetPermission){  #Access granted, go and proceed!!!
   my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });
   $sql = $dbh->prepare("SELECT DSLIP FROM tblMaintenance where ip = '".$TmpLVSHost."';" );  
   $sql->execute;
   (my ($SQLDSLIP)=$sql->fetchrow_array);
   if ($SQLDSLIP){
     return "200: $SQLDSLIP";
   } else {   #if ($SQLmID)  
 	  return "307 Reqeust refused, Host does not exist in my inventory: $TmpLVSHost";      	
   }          #if ($SQLmID)
  } else {    #if ($tAccess)  #Access granted, go and proceed!!!
   return "500 Access Denied ";     
  }           #if ($tAccess)  #Access granted, go and proceed!!!

}             #Sub







sub WHATISMYDSLDATE {                     
  #Return the dsl date from the field DSLIP from the table tblMaintenance
  &GetConfig;
  if (&GetPermission){  #Access granted, go and proceed!!!
   my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });
   $sql = $dbh->prepare("SELECT DSLDate FROM tblMaintenance where ip = '".$TmpLVSHost."';" );  
   $sql->execute;
   (my ($SQLDSLDate)=$sql->fetchrow_array);
   if ($SQLDSLDate){
     return "200: $SQLDSLDate";
   } else {   #if ($SQLmID)  
 	  return "307 Reqeust refused, Host does not exist in my inventory: $TmpLVSHost";      	
   }          #if ($SQLmID)
  } else {    #if ($tAccess)  #Access granted, go and proceed!!!
   return "500 Access Denied ";     
  }           #if ($tAccess)  #Access granted, go and proceed!!!

}             #Sub



sub WHATISMYDSLEPOCHE {                     
  #Return the dsl epoche date from the field DSLIP from the table tblMaintenance
  &GetConfig;
  if (&GetPermission){  #Access granted, go and proceed!!!
   my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });
   $sql = $dbh->prepare("SELECT DSLEpoche FROM tblMaintenance where ip = '".$TmpLVSHost."';" );  
   $sql->execute;
   (my ($SQLDSLDate)=$sql->fetchrow_array);
   if ($SQLDSLDate){
     return "200: $SQLDSLDate";
   } else {   #if ($SQLmID)  
 	  return "406 Reqeust refused, Host does not exist in my inventory: $TmpLVSHost";      	
   }          #if ($SQLmID)
  } else {    #if ($tAccess)  #Access granted, go and proceed!!!
   return "500 Access Denied ";     
  }           #if ($tAccess)  #Access granted, go and proceed!!!

}             #Sub


sub WHATISMYDSLSTATUS {                     
  #Return the dsl date from the field DSLIP from the table tblMaintenance
  &GetConfig;
  if (&GetPermission){  #Access granted, go and proceed!!!
   my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });
   my $sqlstr = "SELECT tblNodesInventory.invid,tblMaintenance.mid,tblNodes.vip,tblResources.resID
   FROM $LVSDB.tblNodesInventory,$LVSDB.tblResources,$LVSDB.tblMaintenance,tblNodes
   where
   tblNodesInventory.enabled=1
   and tblResources.enabled=1
   and tblMaintenance.enabled=1
   and tblNodesInventory.enabled=1
   and tblMaintenance.updatepending=0
   and tblMaintenance.requestUP=0
   and tblMaintenance.requestDown=0
   and tblResources.resID = tblNodesInventory.resID
   and tblResources.realip = '".$TmpLVSHost."'
   and tblMaintenance.ip = '".$TmpLVSHost."'
   and tblNodesInventory.active=1
   and tblNodesInventory.maintenance=0
   and tblNodesInventory.nodeid = tblNodes.nodeid
   and tblMaintenance.DSLMaintenance = 0;";
   $sql = $dbh->prepare($sqlstr);  
   $sql->execute;
   (my ($SQLDSLDate)=$sql->fetchrow_array);
   if ($SQLDSLDate){
     return "200: Host active: $TmpLVSHost";
   } else {   #if ($SQLmID)  
 	  return "303: Host is disabled for maintenance: $TmpLVSHost";      	
   }          #if ($SQLmID)
  } else {    #if ($tAccess)  #Access granted, go and proceed!!!
   return "500 Access Denied ";     
  }           #if ($tAccess)  #Access granted, go and proceed!!!

}             #Sub



sub REQUESTWEIGHTDOWN {

 ###############################################################
 #Webservice/SOAP Function to remove a host using the maintenance table (used by mylvsmon)
 #Return: 200=OK or 500=Failed (Error description)
 ###############################################################
 
 use DBI;
 use DBD::mysql;


  &GetConfig;
  if (&GetPermission){  #Access granted, go and proceed!!!
   my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });

   my $dbhn = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });
  
   my ($WARNTxt,$sql,$sqln);
   #my ($class, $c) = @_;   #use $c for the passed var
   #Check tblMaintenace first
   $sql = $dbh->prepare("SELECT enabled,requestUP,requestDOWN,updatepending,DSLMaintenance,response,message FROM tblMaintenance where ip = '".$TmpLVSHost."' and enabled=1;" );  
   $sql->execute;
   (my ($SQLenabled,$SQLrequestUP,$SQLrequestDOWN,$SQLupdatepending,$SQLDSLMaintenance,$SQLresponse,$SQLmessage)=$sql->fetchrow_array);
   if (($SQLrequestUP eq 1) or ($SQLrequestDOWN eq 1) or ($SQLupdatepending eq 1) or ($SQLDSLMaintenance eq 1) or ($SQLenabled ne 1) or ($SQLresponse =~ /401/)){
   	$dbh->disconnect;
   	$dbhn->disconnect;
  	if ($SQLenabled ne 1){
  		return "500: Host is disabled on $TmpLVSHost";
  	}
  	if ($SQLrequestUP){
  		return "500: REQUESTWEIGHTUP is already set on $TmpLVSHost";
  	}
  	if ($SQLrequestDOWN){
  		return "500: REQUESTWEIGHTDOWN is already set on $TmpLVSHost";
  	}
  	if ($SQLupdatepending){
  		return "500: REQUESTWEIGHTDOWN (Updatepending) is already set on $TmpLVSHost";
  	}
  	if ($SQLDSLMaintenance){
  		return "301: DSL Maintenance pending, please come back again later - on $TmpLVSHost";
  	}
  	
  	if ($SQLresponse =~ /401/){
  		return "$SQLresponse: $SQLmessage - on $TmpLVSHost";
  	}
   }         #   if (($SQLrequestUP eq 1) or ($SQLrequestDOWN eq 1) or ($SQLupdatepending eq 1) or ($SQLDSLMaintenance eq 1) or ($SQLenabled ne 1))



   
   my $xstr = "SELECT tblNodesInventory.invid,tblResources.enabled,tblResources.alias FROM $LVSDB.tblNodesInventory,$LVSDB.tblResources,$LVSDB.tblMaintenance,$LVSDB.tblNodes where tblResources.realip = '".$TmpLVSHost."' and tblResources.resID = tblNodesInventory.resID and tblNodesInventory.nodeid = tblNodes.nodeid group by tblNodesInventory.invid;";


   $sql = $dbh->prepare($xstr);   
   $sql->execute;
   
   while(my($SQLinvID,$SQLResourcesEnabled,$SQLResourcesAlias)=$sql->fetchrow_array) {
    
    
    if ($SQLResourcesEnabled ne 1){
    	$dbh->disconnect;
    	$dbhn->disconnect;
    	return "500: Host is entirely disabled ($TmpLVSHost/$SQLResourcesAlias)";  
    }
    
    #Follow up, we try hard to check all services
    $sqln = $dbhn->prepare("SELECT invID,enabled,active,maintenance,weightdown,link FROM $LVSDB.tblNodesInventory where invID = $SQLinvID;" );  
    $sqln->execute;
    while ((my ($SQLchk,$SQLenabled,$SQLactive,$SQLmaintenance,$SQLweightdown,$SQLlink)=$sqln->fetchrow_array)) {   
     $dbh->disconnect;
     $dbhn->disconnect;

     if ($SQLenabled ne 1) {
    	return "500: Service is disabled (Link:$SQLlink/INV-ID:$SQLinvID)";  
     }

     if ($SQLmaintenance eq 1) {
    	return "500: Service has the maintenance flag set (Link:$SQLlink/INV-ID:$SQLinvID)";  
     }

     if ($SQLactive ne 1) {
    	return "500: Service is set to be INACTIVE (Link:$SQLlink/INV-ID:$SQLinvID-$SQLactive)";  
     }

     if ($SQLweightdown eq 1) {
      return "500: Service has weightdown set set (Link:$SQLlink/INV-ID:$SQLinvID)";  
     }
     
    }   #While 
   }
       	
       	
   #No Maintenance set and nothing else disabled so go ahead!
   my $sql = ("UPDATE $LVSDB.tblMaintenance set requestDOWN='1',response='0',message='0' ,WeightDownTime='" . $wdTime . "',TurnOffTime='" . $toTime . "' where ip = '".$TmpLVSHost."';");   
   #my $sql = ("UPDATE $LVSDB.tblMaintenance set requestDOWN='1',WeightDownTime='" . $wdTime . "',TurnOffTime='" . $toTime . "' where ip = '".$TmpLVSHost."';");   
   my $sqlret  = $dbh->do($sql);
   if ($sqlret){
    return "200: Host has been set to turn off, please check the status later - $TmpLVSHost";
   } else {  #if ($sqlret)
    return "501: Update failed, contact IT-Admin";
    #return "UPDATE tblMaintenance set requestDOWN='1',response='0',message='0' ,WeightDownTime='" . $wdTime . "',TurnOffTime='" . $toTime . "' where ip = '".$c."';";
   }         #if ($sqlret)
  } else {
   return "500: Access denied - No permission to send from $TmpLVSHost";
  } #Get Permisssion
}           #sub requestWeightDown 



sub REQUESTWEIGHTUP {

 ###############################################################
 #Webservice/SOAP Function to add a host using the maintenance table (used by mylvsmon)
 #Return: 200=OK or 500=Failed (Error description)
 ###############################################################
 
 use DBI;
 use DBD::mysql;


  &GetConfig;
  if (&GetPermission){  #Access granted, go and proceed!!!
   my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });

   my $dbhn = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });
  
   my ($WARNTxt,$sql,$sqln);
   #my ($class, $c) = @_;   #use $c for the passed var
   
   
   
   #Check tblMaintenace first
   $sql = $dbh->prepare("SELECT requestUP,requestDOWN,updatepending,DSLMaintenance,enabled,response,message FROM tblMaintenance where ip = '".$TmpLVSHost."';" );  
   $sql->execute;
   (my ($SQLrequestUP,$SQLrequestDOWN,$SQLupdatepending,$SQLDSLMaintenance,$SQLenabled,$SQLresponse,$SQLmessage)=$sql->fetchrow_array);
   if (($SQLrequestUP eq 1) or ($SQLrequestDOWN eq 1) or ($SQLupdatepending ne 1) or ($SQLDSLMaintenance eq 1) or ($SQLenabled ne 1) or ($SQLresponse =~ /401/)){
    $dbh->disconnect;
    $dbhn->disconnect;
    if ($SQLresponse =~ /401/) {
    	return "$SQLresponse:  $SQLmessage on $TmpLVSHost";  
    }

    if ($SQLrequestUP eq 1) {
     return "500: REQUESTWEIGHTUP is already set on $TmpLVSHost";  
    }
  	if ($SQLrequestDOWN eq 1){
  	 return "500: REQUESTWEIGHTDOWN is already set on $TmpLVSHost";
  	}
  	if ($SQLupdatepending ne 1){
  	 return "500: updatepending is not set on $TmpLVSHost";
  	}
  	if ($SQLDSLMaintenance eq 1){
  	 return "500: DSLMaintenance has been set on $TmpLVSHost";
  	}
  	if ($SQLenabled ne 1){
  	 return "500: Host is disabled - $TmpLVSHost";
  	}	
   }         #if (($SQLrequestUP eq 0) and ($SQLrequestDOWN eq 0) and ($SQLupdatepending eq 0))
   my $sql = ("UPDATE $LVSDB.tblMaintenance set requestUP='1',response='0',message='0' ,WeightDownTime='" . $wdTime . "',TurnOffTime='" . $toTime . "' where ip = '".$TmpLVSHost."';");   
   my $sqlret  = $dbh->do($sql);
   if ($sqlret){
    return "200: Host has been set to go online, please check the status later - $TmpLVSHost";
   } else {  #if ($sqlret)
    $dbh->disconnect;
    $dbhn->disconnect;
    return "501: Update failed, contact IT-Admin";
    #return "UPDATE tblMaintenance set requestDOWN='1',response='0',message='0' ,WeightDownTime='" . $wdTime . "',TurnOffTime='" . $toTime . "' where ip = '".$TmpLVSHost."';";
   }         #if ($sqlret)
  } else {
   return "500: Access denied - No permission to send from $TmpLVSHost";
  } #Get Permisssion
}           #sub requestWeightDown 



sub REQUESTWEIGHTSTATUS {

 ###############################################################
 #Webservice/SOAP Function to remove a host using the maintenance table (used by mylvsmon)
 #Return: 200=OK or 500=Failed (Error description)
 ###############################################################
 
 use DBI;
 use DBD::mysql;


  &GetConfig;
  if (&GetPermission){  #Access granted, go and proceed!!!
   my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });

   my $dbhn = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });
  
   my ($WARNTxt,$sql,$sqln);

   #Check tblMaintenace first
   $sql = $dbh->prepare("SELECT enabled,requestUP,requestDOWN,updatepending,DSLMaintenance,response,message FROM tblMaintenance where ip = '".$TmpLVSHost."' and enabled=1;" );  
   $sql->execute;
   (my ($SQLenabled,$SQLrequestUP,$SQLrequestDOWN,$SQLupdatepending,$SQLDSLMaintenance,$SQLresponse,$SQLmessage)=$sql->fetchrow_array);
   if (($SQLrequestUP eq 1) or ($SQLrequestDOWN eq 1) or ($SQLupdatepending eq 1) or ($SQLDSLMaintenance eq 1) or ($SQLenabled ne 1) or ($SQLresponse =~ /30/) or ($SQLresponse =~ /401/)  ){
  	$dbh->disconnect;
    $dbhn->disconnect;
  	if ($SQLenabled ne 1){
    	$WARNTxt= "500: Host is disabled on $TmpLVSHost";
  		return $WARNTxt;
  	}
  	if ($SQLrequestUP eq 1){
    	return "300: REQUESTWEIGHTUP in progress, please come back later -  $TmpLVSHost";
  	}
  	if ($SQLrequestDOWN eq 1){
    	if ($SQLupdatepending){
  		 if ($SQLresponse){
  		  return "$SQLresponse: $SQLmessage -> $TmpLVSHost";   #=> Final Message to update the system
  		 } else {
  		 	return "500: No status present";
  		 } 
  	  } else {
       if ($SQLresponse =~ /30/){
       	return "$SQLresponse: $SQLmessage -> $TmpLVSHost";   #=> Final Message to update the system
       } else {	
        return "500: REQUESTWEIGHTDOWN is already set on $TmpLVSHost";
       } 
      }	
  	}
  	
   	if ($SQLresponse =~ /401/){
 		 return "$SQLresponse: $SQLmessage - on $TmpLVSHost";
 	  }

  	
		if ($SQLupdatepending){
    	return "200: Host is waiting for a update (updatepending) - on $TmpLVSHost";
    }  	
  	if ($SQLDSLMaintenance){
    	return "301: DSL Maintenance pending, please come back again later - on $TmpLVSHost";
  	}
   }         #   if (($SQLrequestUP eq 1) or ($SQLrequestDOWN eq 1) or ($SQLupdatepending eq 1) or ($SQLDSLMaintenance eq 1) or ($SQLenabled ne 1))


   my $xstr = "SELECT tblNodesInventory.invid,tblResources.enabled,tblResources.alias FROM $LVSDB.tblNodesInventory,$LVSDB.tblResources,$LVSDB.tblMaintenance,$LVSDB.tblNodes where tblResources.realip = '".$TmpLVSHost."' and tblResources.resID = tblNodesInventory.resID and tblNodesInventory.nodeid = tblNodes.nodeid group by tblNodesInventory.invid;";
   $sql = $dbh->prepare($xstr);   
   $sql->execute;
   while(my($SQLinvID,$SQLResourcesEnabled,$SQLResourcesAlias)=$sql->fetchrow_array) {
    if ($SQLResourcesEnabled ne 1){
    	$dbh->disconnect;
    	$dbhn->disconnect;
    	return "500: Host is entirely disabled ($TmpLVSHost/$SQLResourcesAlias)";  
    }
    #Follow up, we try hard to check all services
    $sqln = $dbhn->prepare("SELECT invID,enabled,active,maintenance,weightdown,link FROM $LVSDB.tblNodesInventory where invID = $SQLinvID;" );  
    $sqln->execute;
    while ((my ($SQLchk,$SQLenabled,$SQLactive,$SQLmaintenance,$SQLweightdown,$SQLlink)=$sqln->fetchrow_array)) {   
     if ($SQLweightdown eq 1) {
    	$dbh->disconnect;
    	$dbhn->disconnect;
      return "500: Service has weightdown set set (Link:$SQLlink/INV-ID:$SQLinvID)";  
     }
    }   #While 
   }

   $dbh->disconnect;
   $dbhn->disconnect;
   return "200: Host is turned on";
  } else {
   return "500: Access denied - No permission to send from $TmpLVSHost";
  } #Get Permisssion

}           #sub requestWeightstatus



sub REQUESTGROUPINFORMATION {

 #########################################################################
 #Webservice/SOAP Function to list the amount of servers within this group
 #Return: 200=OK or 500=Failed (Error description)
 #########################################################################
 
 use DBI;
 use DBD::mysql;

 
  &GetConfig;
 
 
  if (&GetPermission){  #Access granted, go and proceed!!!
  
   my $dbh = DBI->connect("DBI:mysql:$LVSDB:$LVSServer:3306",$LVSUser,$LVSPass,{
  	PrintError => 1, # warn() on errors
    RaiseError => 0, # don't die on error
    AutoCommit => 1, # commit executes
   });
  
   my ($sql);
   $sql = $dbh->prepare("SELECT groupid FROM tblMaintenance where ip = '".$TmpLVSHost."';" );  
   $sql->execute;
   (my ($SQLGroupID)=$sql->fetchrow_array);
   if ($SQLGroupID){
    $sql = $dbh->prepare("SELECT count(*) as expr FROM tblMaintenance where groupid = '".$SQLGroupID."' and enabled=1;" );  
    $sql->execute;
   	(my ($SQLAmount)=$sql->fetchrow_array);
   	if ($SQLAmount) {
   		#Keep the position of Servers=... for the vb clients
    	$dbh->disconnect;
    	return "200: Servers=$SQLAmount;GroupID=$SQLGroupID";  
    }
   }
   $dbh->disconnect;
   return "500: Unable to get informations";  
  } else {
   return "500: Access denied - No permission to send from $TmpLVSHost";
  } #Get Permisssion

}           #sub requestWeightstatus



sub GetPermission {
  #Should only be good for inside usage, no external call
  my $LVSHost;
  $TmpLVSHost=undef;
  use CGI ':standard';
  my $RemoteAddr=$ENV{REMOTE_ADDR};
  my ($class, $c) = @_;   #use $c for the passed var
  $tAccess=undef;
  if ( ($UnlimitedAccess)){
   if ($c){
    $TmpLVSHost=$c;  #Use the parameter for LVSHost
   } else {
   	$TmpLVSHost=$RemoteAddr;  #No parameter given, set the request ip as LVSHost
   }
  } else {
   $TmpLVSHost=$RemoteAddr; #Unlimited access not allowed, force the request ip as LVSHost
  }  #if ( ($UnlimitedAccess))
  for my $pnt ( sort keys %AccessHost ) { #Security: enum all allowed requesting Hosts
   if ( $RemoteAddr =~ /$AccessHost{$pnt}/i){  #Host found in configuration -> allow request
    #$tAccess=1;
    return 1;
   } 
  }
  return undef;
 } 

 
 sub GetConfig {
  my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
  my $data = $xml->XMLin("$Conffile");
  #print Dumper($data);  #Use me for debugging ...
  my $xmlcnt=0;
  $LVSServer=$data->{SQL}->{LVSServer};
  $LVSUser=$data->{SQL}->{LVSUser};
  $LVSPass=$data->{SQL}->{LVSPass};
  $LVSDB=$data->{SQL}->{LVSDB};
  #$AllowParameter=$data->{System}->{AllowParameter};
 
  $UnlimitedAccess=$data->{System}->{UnlimitedAccess};
  $StormProtection=$data->{System}->{StormProtection};
  $AllowReset=$data->{System}->{AllowReset};
  
 
  $wdTime=$data->{System}->{WeightDownTime};
  $toTime=$data->{System}->{TurnOffTime};
  
  #Repen with forced array set!
  my $data = $xml->XMLin("$Conffile",ForceArray => 1);	
  foreach my $e (@{$data->{AllowAccess}}){	
   $AccessHost{$xmlcnt}=$e->{IP};
   
   $xmlcnt++;
  }
}


1;