#!/usr/bin/perl


#Install tip for http::date
#apt-get install libhttp-proxy-perl


###########################################################################################################################################
#NOTE ABOUT AUTOMOVE SERVICES: This works only - and only - if the inventory flag has been turned on and you need a second service running 
#on that host - DO NOT LEAVE INVENTORY CHECK OFF!!!!
###########################################################################################################################################



#Hint for return Codes:
#			200: Request accepted, go ahead
#     300: Request accepted, weigthdown in progress, wait for further messages
#     301: Request accepted, turn off in progress, wait for further messages
#     302: Another maintenance service is already running, please come back later
#Refuse requests due to:
#     401: Host is down due to operations
#     403: Useless request, Host is already set to be Down or Host is already set to be Up

#Not needed since we allow all requests
#     402: Operator has set the service down -  please come back later
#     404: Another request is pending - please come back later
#     405: Another Service or Host runs already maintenance - please come back later



#Maintenance Workflow
#If a maintenance request is set (requestUp or requestDown) the check for the timer
# If a weightdown timer has been set then wait for
#  WeightDown Host
# else
#  wait
# If a turnoff timer has been set then wait for
#  turnoff Host
# else
#  wait
#else
#turnoff Host


#Maintenance Workflow 2008
#Get Group Information
#Enum for each loop through all maintenance entries
#Get Amount of Maintenancehosts and amount of updatependinghosts, decide if host remove is permited
#Set updatepending
#Time manager: weightdown host



#2.0.0.0 Starting new montoring project Jan2006
#2.0.3.5 add chk time_to_die during rchecks 
#2.0.3.6 Start newoperations interface
#2.0.3.7 Start maintenance interface 19Nov06
#2.0.3.8 Maintenance interface is going live at 08Dec.06
#2.0.3.9 Add Logrotate 02Jan2007
#2.0.3.10 small mods, ignore sendmail in case of success if it was manualy set
#2.0.3.11 start blackout functionality - 07Jan07
#2.0.3.12 Hotfix - Avoid to set Unknown status because the host didnt got checked again the message was: #No route to host
#2.0.3.13 Unknown Crash. message: Can't call method "execute" on unblessed reference at /usr/local/lvs//mylvsmon.pl line 1600.
# 2.0.3.13 ==>> crash beacue of this var: $$sqlins vs $sqlins->execute !!!   - May07
#2.0.3.14 Add another failure string "UNKNOWN", apparetnly the search string "No route to host doesnt work, maybe spaces ? however
#         We try "UNKNOWN" instead whis is in full: "Unable to open TCP socket"
#2.0.3.15 Start Grouping and multiple host maintenance - Mar08
#					Todo: Add MaxHostDown,GroupingEnable value in /etc/lvs/lvs.conf.xml
#					ToDo: Add in sql tablemaintenance 'groupID','Hostname' optional
#2.0.3.16 Fixed a DBI connection/dbi problem, addning two new filehandles: $dbhFCurMain,$dbhFCurNext to be used within 
#         sub ManagageMaintenanceRequest only. MK 27Aug2010
#2.0.3.17 Removed $dbhFCurMain,$dbhFCurNext and added sql keepalives instead, use the value $CNTKeepAlive as timer value - MK30Aug2010
#2.0.4.1 - Mar08 - Finaly add grouping and multiple maintenance down reqeuests per group
#2.0.4.2 - Mar08 - change behaviour of updatepending -always set to 1 until turnON is complete
#2.0.4.3 - Mar08 - add apply and sync command only if if(!$SQLFxnd) has been set 
#2.0.4.4 - Mar08 - add daily maintenance for sql
#2.0.4.5 - Nov10 - Sanity 
#2.0.4.6 - Minor release changes and fine tuning - Jul2015



use warnings;
use strict;
use DBI;
use POSIX;

use Mail::Sendmail;
use XML::Simple;
use Data::Dumper;
use HTTP::Date qw/str2time/;


##### CONFIGURATION ######
my $time_to_die = 0;#Enable loop
my $loglevel = 1;   #set base log level
my $setdaemon = 1;  #set daemonice mode either to 1 or 0
my $mntLoop=3;

####################### XML CONFIGURATION #######################
my $ver = "2.0.4.6";
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($MaxLogDays,$gzip,$logname,$logpath,$bkupreplcommand,$pid,$servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$bkupenabled,$simulate,$Mailserver,$Mailfrom,$MailTo,$MailCC,$MailBCC,$FileAge,$SQLAge);
&getconfig;
mkdir $logpath;
my $logfile = $logpath . $logname;
my $oneday = 24 * 60 * 60;
my $ReplCmd=$bkupreplcommand;   #Requires valid ssh keys - see the sehll script



####################### XML CONFIGURATION #######################
 my (%LvsBlackoutEnabled,%LvsBlackoutName,%LvsBlackoutGID,%LvsBlackoutFrom,%LvsBlackoutTo,%LVSBlackoutChange);
 my ($SQLDBid,$SQLDBGid,$SQLDBname,$SQLDBfrom,$SQLDBto,$bid,$bgid);
 my (%LvsMsgID,%LvsMsgType,%LvsMsgServer,%LvsMsgFrom,%LvsMsgTo,%LvsMsgCC,%LvsMsgBCC,$SQLMsgID,$SQLMsgType,$SQLMsgFrom,$SQLMsgServer,$SQLMsgTo,$SQLMsgCC,$SQLMsgBCC,%LvsMonStateFrom);
 my ($NodeID,$NodeName,$NodeScheduler,$NodeService,$NodeVIP,$NodePersistent,$NodeMonitor);
 my ($InvID,$InvResID,$InvNodeID,$InvMethod,$invLink,$InvWeight,$InvAutomovePoolID,$InvPort,$InvFailstate,$InvBid);
 my ($ResAlias,$ResIP,$sqlcmd,$CurDate,$sqlstat,$dbhCur,$dbhCurMain,$dbhCurNext,$dbh,$sqlmon,$nodecnt,$srvcnt,$hstcnt );
 my ($MonID,$MonTimeout,$MonInterval,$monRechecks,$monrecheckwait,$MonNotificationClock,$MonImmediaterecoverid,$MonLastCheck,%LvsMonCurInterval,$MonLastStatus,$MonCommandID,$MonEnabled,%LvsMonCurFailInterval,%LvsMonFailInterval,$MonFailInterval,$MonrecTaskID,%LvsMonrecTaskID,%LVSMonMessageID,$MonMessageID);
 my ($CurEpoche,$NewEpoche,$statechange,$ErrorReason,$ibereturn,$Time,$recID,%LvsMonCheckinventory,$MonChkInv,%LvsMonInvID,%LVSMonBid,$cmds,$AMoved,$sqlset);
 my (%LvsMonNodeName,%LvsMonAlias,%LvsMonIP,%LvsMonPort,%LvsMonInterval,%LvsMonTimeout,%LvsMonCurStat,%LvsCommandID,%LvsMonEnabled,%LvsMonImmediaterecoverid,%LvsCurTaskClock,%LvsRecTaskClock,%LvsRecTask,%LvsRecTaskID,%LvsMonInvWeight,%LvsMonInvMethodID);
 my (%LvsCMDName,%LvsCMD,%LvsCMDEnabled,%LvsMonRechecks,%LvsMonrecheckwait,%LvsMonCurRechecks,%LvsMonCurrecheckwait,%LvsMonCurrechecksretry,%LvsMonCurrecheckwaitretry,%LvsRecName,%LvsRec,%LvsRecEnabled,%LvsMonNotificationClock,%LvsMonCurNotificationClock);
 my ($SQLCMDID,$SQLCMDEnabled,$SQLCMDName,$SQLCMD,$cmdret,$cmdsend,$SQLTID,$SQLID,$SQLCLOCK,$SSubject,$SBody,$SQLrequestUP,$SQLrequestDOWN,$SQLrequesitIP,$SQLrequestdate,$SQLreceivedfrom,$SQLweightdowntime,$SQLresID,$SQLenabled,$SQLactive,$SQLmaintenance,$SQLweightdown);
 my (%UDGroupRemoveMax,%UDGroupMinAvailable,$CNTCurKeepAlive);  #2.0.3.15
 my $CNTKeepAlive = 600;  #2.0.3.17
 my $RefDate=0;
 my $mntLoopCur=0;
 my $startup=0;
 if ($setdaemon eq 1) {&SetDaemon;}
 $CurEpoche=0;
 my $WeightDownTimer=0;
 my $WeightDownCurrentTimer=0;
 my $SQLTurnOffTime=0;
 my $TurnOffCurrentTimer=0;
 $dbhCur = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword) or &sqldead;
 $dbhCurMain = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword) or &sqldead;
 $dbhCurNext = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword) or &sqldead;
 &GetConfig;      #Read my inventory
 &lvslog(9,"LVS monitor ($ver) startup complete, Nodes: $nodecnt, Services: $srvcnt","monitor");
 &syslog ("LVS monitor ($ver) startup complete, Nodes: $nodecnt, Services: $srvcnt",1);
 my $sqlmain = $dbhCur->prepare("SELECT mID FROM tblMaintenance;" ) or &sqldead;
 $sqlmain->execute ;  


 until ($time_to_die) {        #Loop into application
 	$Time=time;
 	$NewEpoche=time;
  $CurDate = strftime("%Y%m%d", localtime(time));
  if ($RefDate ne $CurDate) {
   if ($RefDate ne 0){  #avoid logrotation at startup 
    &syslog ("**** Daychange occured $RefDate/$CurDate  ****",1);
    &LogRotate;
   }
   $RefDate = $CurDate;
   &syslog ("**** Daychange occured  $RefDate/$CurDate ****",1);
   #Temp only
   #&LogRotate;
  } 
 	
 	if ($NewEpoche ne $CurEpoche){
   #Display counter
   #&syslog ("-> $NewEpoche",1);
   #Keeplalive Output
   #&syslog ("$NewEpoche ne $CurEpoche",1);
   $CurEpoche=time;
   #please change this into a non sql call
   my $sqlcur = $dbhCur->prepare("SELECT statechange FROM tblState" ) or &sqldead;
   $sqlcur->execute ;  #Get Nodes
   ($statechange)=$sqlcur->fetchrow_array;
   if (!$statechange) {$statechange=0}; #2.0.4.6
   if ($statechange eq "1"){     #Reread config
    #&syslog ("-> $statechange",1);
    &lvslog(3,"Reinit request received","monitor");sleep 1;    
    &GetConfig ;
    &lvslog(3,"LVS monitor reload complete, Nodes: $nodecnt, Services: $srvcnt","monitor");
    my $sqlrr = $dbhCur->prepare("UPDATE tblState SET statechange = '0' where stateID='1';" ) or &sqldead;
    $sqlrr->execute ;  #Get Nodes
    #Apply replication in the background
    #aloa11
    my $sqlxid = $dbhCurNext->prepare("SELECT mID from tblMaintenance where updatepending='1';" ) or &sqldead; 	 
    $sqlxid->execute ;  
    #2.0.4.3
    (my($SQLFxnd)=$sqlxid->fetchrow_array);
    if(!$SQLFxnd){
     if ($bkupenabled){
      &syslog ("-> Apply mysql synchronization",1);
      &lvslog(10,"Apply background mysql database synchronization to backup server","monitor");sleep 1;    
      &chk_time_to_die; 
      `$ReplCmd &`;
     } else {
     	&syslog ("-> Skip mysql synchronization",1);
     } 
    } 
   } 
   
   #Check for maintenance request
   my $sqlmain = $dbhCur->prepare("SELECT requestUP,requestDOWN FROM tblMaintenance where (requestUP = '1' or requestDOWN = '1') and enabled = '1';" ) or &sqldead;
   $sqlmain->execute ;  
   (($SQLrequestUP,$SQLrequestDOWN)=$sqlmain->fetchrow_array) ;
   if (($SQLrequestUP) or ($SQLrequestDOWN)){
    &syslog("",1);
    &syslog("Maintenance request received $SQLrequestUP-$SQLrequestDOWN",1);
    #&lvslog(3,"Maintenance request received","monitor");
    &ManagageMaintenanceRequest;
    #&syslog("Maintenance check",1);
    &chk_time_to_die; 
   } else {
   	#$initUD=undef;
   }
   
   
   
   for my $monhost (sort keys %LvsMonNodeName ){  #Get actual host and check it's timer
    # &CheckBlackout($LVSMonBid)
    if (($LvsMonEnabled{$monhost} eq 1) and (!&CheckBlackout($LVSMonBid{$monhost}))){   #===>>>> Plugin here the maintenance filter !!!!!
     #2.0.4.5 add ($LvsMonCurStat{$monhost} eq "FAIL")
     if (($LvsMonInterval{$monhost} <= $LvsMonCurInterval{$monhost}) and ($LvsMonCurStat{$monhost} ne "FAIL")) {
      $LvsMonCurrechecksretry{$monhost}++;
      $LvsMonCurInterval{$monhost}=0;
      $Time=time;
      #if ($LvsMonCurStat{$monhost} eq "FAIL") {
        #New 21.11.06 .. testing
        #$Time=time;
  	    $sqlstat = $dbhCur->prepare("UPDATE tblMonitor SET lastcheck = '". $Time ."' where monID ='".$monhost."';")  or &sqldead;
        $sqlstat->execute ;  #Get Nodes
      
      #if ($LvsMonCurStat{$monhost} ne "SRV") {
       &chk_time_to_die; 
       $cmdsend=&GetChkCmd($LvsCMD{$LvsCommandID{$monhost}},$monhost);
       &syslog ("--> Apply: $cmdsend ",1);
       
       &chk_time_to_die; 
       $cmdret=`$cmdsend`;   #Run command
       chomp;
       &syslog ("-> $cmdsend => Returns: $cmdret",1);
        #} else {    #CATCH MAINTENANCE !!!! AND FAKE RESPONSE
        #	$cmdsend=&GetChkCmd($LvsCMD{$LvsCommandID{$monhost}},$monhost);
        #	&syslog ("-> Skip Apply: $cmdsend ",1);
        #	&syslog ("-> Host is down for maintenance - $LvsMonInvID{$monhost} - $LvsMonAlias{$monhost}  ",1);
        #	$cmdret = "Ok";  #Send a faked OK since the service os marked for maintenance
        #}
      
        #if (($cmdret =~ /Ok/i) and ($LvsMonCurStat{$monhost} ne "SRV")) {
       if (($cmdret =~ /Ok/i) ) {
        #if ($cmdret =~ /Ok/i){ 
        &syslog ("-> Status OK - $Time",1);
        if ($LvsMonCurStat{$monhost} ne "OK") {
         &syslog ("****************************",1);
         &syslog ("  STATUS CHANGE TO OK  " ,1);
         &syslog ("****************************",1);
         &lvslog(6,"STATUS CHANGE TO OK","monitor");
         &SuccessManager($monhost,$LvsMonInvID{$monhost},$LvsMonCheckinventory{$monhost},1);
        }
          #} 
       } else {  #if (($cmdret =~ /Ok/i)) 
       if (($cmdret =~ /Error/i) or ($cmdret =~ /CRITICAL/i)  or ($cmdret =~ /WARNING/i)  or ($cmdret =~ /CONNECTION REFUSED/i)) {
        &syslog ("-> Status FAIL - $Time ->$LvsMonCurStat{$monhost}<-",1);
        if ($LvsMonCurStat{$monhost} ne "FAIL"){
         ###################
         #Add RetryCounter
         ###################
         for my $lpp (1..($LvsMonRechecks{$monhost})) {
          &syslog ("Rechecks: $lpp - $LvsMonRechecks{$monhost} - Wait: $LvsMonrecheckwait{$monhost} - $lpp",1);
          $cmdsend=&GetChkCmd($LvsCMD{$LvsCommandID{$monhost}},$monhost);
          &chk_time_to_die; 
          $cmdret=`$cmdsend`;   #Run command
          #$LvsMonCurStat{$monhost} =`$cmdsend`;   #Run command
          chomp;
          &syslog ("-> $cmdsend => Returns: $cmdret ",1);
          &lvslog(2,"Retry $cmdsend => Returns: $cmdret => ","monitor");
          if ($cmdret =~ /Ok/i) {
          	last;
          }
          sleep $LvsMonrecheckwait{$monhost};
         }
	       #2.0.3.14  #Add Unable to open ...
       	 if (($cmdret =~ /Error/i) or ($cmdret =~ /CRITICAL/i)  or ($cmdret =~ /WARNING/i)  or ($cmdret =~ /REFUSED/i) or (($cmdret =~ /UNABLE/i) and ($cmdret =~ /socket/i)) or ($cmdret =~ /No route to host/i) ) {
       	 	if ($LvsMonCurStat{$monhost} ne "FAIL") {
       	   &syslog ("****************************",1);
           &syslog (" STATUS CHANGE TO FAIL  ",1);
           &syslog ("****************************",1);
           &lvslog(1,"STATUS CHANGE TO FAIL","monitor");
           &FailManager($monhost,$LvsMonInvID{$monhost},$LvsMonCheckinventory{$monhost},1);
           #
           if ($LvsMonImmediaterecoverid{$monhost} > 0){
            my $sqlrec = $dbhCur->prepare("SELECT command FROM tblRecover where recID = '" . $LvsMonImmediaterecoverid{$monhost} ."'" ) or &sqldead;
            $sqlrec->execute ;  #Get Nodes
            $recID=$sqlrec->fetchrow_array;
            &chk_time_to_die; 
            #$cmdret=`$_`;   #Run command
            #not needed &syslog ("-> xxxxxxxxxxxxxxx  $_ ",1);
            $cmdsend=&GetChkCmd($recID,$monhost);
            $cmdret=`$cmdsend`;   #Run command
            chomp;
            &syslog ("-> Recover ID: $LvsMonImmediaterecoverid{$monhost} - $cmdsend => Returns: $cmdret",1);
            &lvslog(5,"Apply Recover: $cmdsend => Returns: $cmdret","monitor");
           }	         #if ($LvsMonImmediaterecoverid{$monhost} > 0)
           $SSubject="Failure from $LvsMonAlias{$monhost}";
           $SBody="Status change to fail from: $LvsMonAlias{$monhost}\n";
           $SBody.="Local Date: " . &getDate ."\n";
           $SBody.="Removed Service: $LvsMonIP{$monhost}:$LvsMonPort{$monhost}\n";
           if ($cmdsend) {
           	$SBody.="Selfhealing applied: $cmdsend"."\n\n";
           }
           if ($LvsMonCheckinventory{$monhost}) {
            $SBody.="Note: Inventory has been removed\n";
           }
           if (($LvsMsgType{$LvsMsgID{$LVSMonMessageID{$monhost}}} eq "1") and ($LvsMsgTo{$LvsMsgID{$LVSMonMessageID{$monhost}}})) {
            &Sendmail ($LvsMsgTo{$LvsMsgID{$LVSMonMessageID{$monhost}}},$LvsMsgFrom{$LvsMsgID{$LVSMonMessageID{$monhost}}},$SSubject,$SBody,$LvsMsgServer{$LvsMsgID{$LVSMonMessageID{$monhost}}},$LvsMsgCC{$LvsMsgID{$LVSMonMessageID{$monhost}}},$LvsMsgBCC{$LvsMsgID{$LVSMonMessageID{$monhost}}});
           }
          }	           #if ($LvsMonCurStat{$monhost} eq "FAIL") 
         }             #if ($cmdret =~ /Error/i) {
        }              #if ($LvsMonCurStat{$monhost} ne "FAIL") )
       } else {        #if (($cmdret =~ /Error/i) or ($cmdret =~ /CRITICAL/i)  or ($cmdret =~ /WARNING/i)  or ($cmdret =~ /CONNECTION REFUSED/i)  ) {
        #if ($LvsMonCurStat{$monhost} ne "SRV") {
         &syslog ("Warning, unknown status",1);
         &lvslog(1,"UNKNOWN STATUS","monitor");
         #Removed due to hotfix 2.0.3.12
         #$sqlstat = $dbhCur->prepare("UPDATE tblMonitor SET lastcheck = '". $Time ."', status='UNKNOWN' where monID ='".$monhost."';") or &sqldead;
         #$sqlstat->execute ;  #Get Nodes
         #$LvsMonCurStat{$monhost}="UNKNOWN";
        #} 
       }               #if ($cmdret =~ /Error/i) {
      }                #if ($cmdret =~ /Ok/i) {
     } else {          #if ($LvsMonInterval{$monhost} <= $LvsMonCurInterval{$monhost}) 
      $LvsMonCurInterval{$monhost}++;
     }                 #if ($LvsMonInterval{$monhost} =< $LvsMonCurInterval{$monhost})
    
     #######################
     ##Add Fail RetryCounter
     #######################
     if ($LvsMonCurStat{$monhost} eq "FAIL") {
      if ($LvsMonNotificationClock{$monhost} <= $LvsMonCurNotificationClock{$monhost}) { #Email reminder
       $LvsMonCurNotificationClock{$monhost}=0;
       $SSubject="Reminder: Failure from $LvsMonAlias{$monhost}";
       $SBody="Status: Fail from: $LvsMonAlias{$monhost}\n";
       $SBody.="Local Date: " . &getDate ."\n";
       $SBody.="Notification Clock: " . $LvsMonNotificationClock{$monhost} ."\n";
       $SBody.="Removed Service: $LvsMonIP{$monhost}:$LvsMonPort{$monhost}\n";
       if ($cmdsend) {
        $SBody.="Selfhealing applied: $cmdsend"."\n\n";
       }
       if ($LvsMonCheckinventory{$monhost}) {
        $SBody.="Note: Inventory has been removed\n";
       }
       if (($LvsMsgType{$LvsMsgID{$LVSMonMessageID{$monhost}}} eq "1") and ($LvsMsgTo{$LvsMsgID{$LVSMonMessageID{$monhost}}})) {
        &Sendmail ($LvsMsgTo{$LvsMsgID{$LVSMonMessageID{$monhost}}},$LvsMsgFrom{$LvsMsgID{$LVSMonMessageID{$monhost}}},$SSubject,$SBody,$LvsMsgServer{$LvsMsgID{$LVSMonMessageID{$monhost}}},$LvsMsgCC{$LvsMsgID{$LVSMonMessageID{$monhost}}},$LvsMsgBCC{$LvsMsgID{$LVSMonMessageID{$monhost}}});
       }
      } else {
       	$LvsMonCurNotificationClock{$monhost}++;
        #&syslog ("==> DEB $LvsMonNotificationClock{$monhost}/$LvsMonCurNotificationClock{$monhost}",1); 
      }  #if ($LvsMonNotificationClock{$monhost} <= $LvsMonCurNotificationClock{$monhost}) #Email reminder
      if ($LvsMonFailInterval{$monhost} <= $LvsMonCurFailInterval{$monhost}){        
       $LvsMonCurFailInterval{$monhost}=0;
       $cmdsend=&GetChkCmd($LvsCMD{$LvsCommandID{$monhost}},$monhost);
       &chk_time_to_die; 
       $cmdret=`$cmdsend`;   #Run command
       &syslog ("Manage FailCounter -> Check ID: $cmdsend => Returns: $cmdret -- $monhost -- $LvsMonCurStat{$monhost} -- $LvsCommandID{$monhost} -- $LvsCMD{$LvsCommandID{$monhost}} -- $LvsMonIP{$monhost} -- $LvsMonrecTaskID{$monhost}",1);
       &lvslog(2,"Failstate Retry $cmdsend","monitor");
       if ($cmdret =~ /Ok/i) {
        #&Syslog ("-> STATUS OK ***** Check ID: $cmdsend => Returns: $cmdret");
        &syslog ("****************************",1);
    	  &syslog (" RETRY STATUS CHANGE TO OK  ",1);
    	  &syslog ("****************************",1);
    	  &lvslog(6,"RETRY STATUS CHANGE TO OK","monitor");
    	  &SuccessManager($monhost,$LvsMonInvID{$monhost},$LvsMonCheckinventory{$monhost},1);
       }   #if ($cmdret =~ /Ok/i)
       if (($cmdret =~ /Error/i) or ($cmdret =~ /CRITICAL/i)  or ($cmdret =~ /WARNING/i)  or ($cmdret =~ /REFUSED/i) or ($cmdret =~ /No route to host/i) ) {
     	  for my $cmdid (sort keys %LvsRecTaskClock ){ 
         #$cmdsend=&GetChkCmd($LvsRec{$LvsRecTaskID{$cmdid}},$monhost); #DEEEEEB
         #&syslog ("****DEBx $LvsRecTask{$cmdid}<-->$LvsMonrecTaskID{$monhost}--CMDID:$cmdid--MONHOST:$monhost-->>$LvsRecEnabled{$LvsRecTaskID{$cmdid}}",1);
         #&lvslog(5,"****DEBx $LvsRecTask{$cmdid}<-->$LvsMonrecTaskID{$monhost}--CMDID:$cmdid--MONHOST:$monhost-->>$LvsRecEnabled{$LvsRecTaskID{$cmdid}}","monitor");
         #&lvslog(5,"****DEByyy $cmdsend","monitor");
         #$LvsCurTaskClock
         if (($LvsRecTask{$cmdid} eq $LvsMonrecTaskID{$monhost}) and ($LvsRecEnabled{$LvsRecTaskID{$cmdid}} ge 1)) {
         	#&syslog ("****OK1",1);
         	#&syslog ("****DEB OK1 $LvsRecTask{$cmdid}--$LvsMonrecTaskID{$monhost}--$cmdid--$monhost",1);
         	#&syslog ("****DEB OK1 $LvsCurTaskClock{$cmdid} => $LvsRecTaskClock{$cmdid} - $cmdid",1);
          if ( $LvsCurTaskClock{$cmdid} >=  $LvsRecTaskClock{$cmdid}) {
           &syslog ("RUN: RecID:$cmdid - RunID:$LvsRecTask{$cmdid} - RecoverID: $LvsRecTaskID{$cmdid}",1);
           &chk_time_to_die; 
           $cmdsend=&GetChkCmd($LvsRec{$LvsRecTaskID{$cmdid}},$monhost);
           $cmdret=`$cmdsend`;   #Run command
           &syslog ("RUN: $LvsRecTaskID{$cmdid} - $cmdsend return: $cmdret" ,1);
           &lvslog(5,"Retry Selfhealing: $LvsRecTaskID{$cmdid} - $cmdsend return: $cmdret - $cmdid $LvsCurTaskClock{$cmdid} => $LvsRecTaskClock{$cmdid} - $monhost ","monitor");
           $LvsCurTaskClock{$cmdid}=1;
          } else { 
           $LvsCurTaskClock{$cmdid}++;
          }       #if ( $LvsCurTaskClock{$cmdid} >=  $LvsRecTaskClock{$cmdid})
         }	      #if (($LvsRecTask{$cmdid} eq $LvsMonrecTaskID{$monhost}) and ($LvsRecEnabled{$LvsRecTaskID{$cmdid}} eq 1)) 
        }         #for my $cmdid (sort keys %LvsRecTaskClock )
       }          #if ($cmdret =~ /Error/i) {
      }  else {   #if ($LvsMonFailInterval{$monhost} <= $LvsMonCurFailInterval{$monhost}z
       $LvsMonCurFailInterval{$monhost}++;
      }           #if ($LvsMonFailInterval{$monhost} <= $LvsMonCurFailInterval{$monhost}z
     }            #if ($LvsMonCurStat{$monhost} eq "FAIL") 
    }             #if ($LvsMonEnabled{$monhost} eq 1) {
   }              #for my $monhost (sort keys %LvsMonNodeName )
  }               #if ($NewEpoche ne $CurEpoche)
  sleep 1;
  $startup=1;
  #2.0.3.17
  $CNTCurKeepAlive++;
  if ($CNTCurKeepAlive > $CNTKeepAlive){
  	#Send dummy sql keepalive for $dbhCurMain and $dbhCurNext
 	  &syslog("Send SQL keepalive",1);
    $sqlstat=undef;
    $sqlcmd = $dbhCurMain->prepare("SELECT count(*) as expr FROM tblMaintenance;" ) or &sqldead; 	
    $sqlcmd->execute ;  #Get Nodes
    ($sqlstat)=$sqlcmd->fetchrow_array;
    if ($sqlstat) {
    	&syslog("Keepalive OK - $sqlstat",1);
    }
    $sqlstat=undef;
    $sqlcmd = $dbhCurNext->prepare("SELECT count(*) as expr FROM tblMaintenance;" ) or &sqldead; 	
    $sqlcmd->execute ;  #Get Nodes
    ($sqlstat)=$sqlcmd->fetchrow_array;
    if ($sqlstat) {
    	&syslog("Keepalive OK - $sqlstat",1);
    }
   $CNTCurKeepAlive=0;	
  }               #if ($CNTCurKeepAlive > $CNTKeepAlive){
 }                #until ($time_to_die)
 
 if ($time_to_die eq 1) {
 	&lvslog(8,"Caught SIGTERM, shutting down...","monitor");
  &syslog("Caught SIGTERM, shutting down...",1);
 }

 
 #######################################
 #######################################
 #######################################
 
sub GetConfig {
 #Delete Inventory from my runtime vars if present
 $nodecnt=0;
 $srvcnt=0;
 
 for my $monhost (keys %LvsMonNodeName ){  #Get actual host and check it's timer
  delete $LvsMonNodeName{$monhost};
  delete $LvsMonAlias{$monhost};
  delete $LvsMonIP{$monhost};
  delete $LvsMonPort{$monhost};
  delete $LvsMonInterval{$monhost};
  delete $LvsMonFailInterval{$monhost};
  delete $LvsMonCurInterval{$monhost};
  delete $LvsMonCurFailInterval{$monhost};
  delete $LvsMonTimeout{$monhost};
  delete $LvsMonCurStat{$monhost};
  delete $LvsMonEnabled{$monhost};
  delete $LvsCommandID{$monhost};
  delete $LvsMonImmediaterecoverid{$monhost};
  delete $LvsMonRechecks{$monhost};
  delete $LvsMonrecheckwait{$monhost};
  delete $LVSMonBid{$monhost};
  delete $LvsMonCheckinventory{$monhost};
  delete $LvsMonInvID{$monhost};
  delete $LVSMonMessageID{$monhost};
  delete $LvsMonNotificationClock{$monhost};
  delete $LvsMonCurNotificationClock{$monhost};
  delete $LvsMonInvWeight{$monhost};
  delete $LvsMonInvMethodID{$monhost};
  #if ($startup eq 0) {  => this happens during init
  # delete $LvsMonStateFrom{$monhost};
  #}
  
 }
 #Get Inventory from mySQL 
 $dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword)  or &sqldead;
 my $sqlnode = $dbh->prepare("SELECT nodeID,Name,scheduler,service,vip,persistent FROM tblNodes where monitor='1' and enabled='1'" );
 $sqlnode->execute ;  #Get Nodes
 #print "DEB $database:$servername\n";
 while(($NodeID,$NodeName,$NodeScheduler,$NodeService,$NodeVIP,$NodePersistent)=$sqlnode->fetchrow_array) {
  $nodecnt++;
  
  #2.0.3.8 do not add maintenance marked inventory entries
  my $sqlnodeinv = $dbh->prepare("SELECT invID,resID,Method,Link,Weight,AutomovePoolID,Port,Failstate,bid FROM tblNodesInventory where nodeID='" . $NodeID ."' and enabled='1' and maintenance <> '1';" );
  $sqlnodeinv->execute ;  #Get NodesInentory
  while(($InvID,$InvResID,$InvMethod,$invLink,$InvWeight,$InvAutomovePoolID,$InvPort,$InvFailstate,$InvBid)=$sqlnodeinv->fetchrow_array) {
   my $sqlnoderes = $dbh->prepare("SELECT alias,realip FROM tblResources where resID='" . $InvResID ."' and enabled='1';" );
   $sqlnoderes->execute ; #Get Resources
   while (($ResAlias,$ResIP)=$sqlnoderes->fetchrow_array) {
    $hstcnt++;
    my $sqlmon = $dbh->prepare("SELECT monid,timeout,recTaskID,checkinterval,failcheckinterval,rechecks,recheckwait,notificationclock,Immediaterecoverid,commandid,lastcheck,status,enabled,checkinventory,messageid FROM tblMonitor where invID='" . $InvID ."' and checkalive='1';" ); 
    $sqlmon->execute ;  #Get Monitor conf
    while(($MonID,$MonTimeout,$MonrecTaskID,$MonInterval,$MonFailInterval,$monRechecks,$monrecheckwait,$MonNotificationClock,$MonImmediaterecoverid,$MonCommandID,$MonLastCheck,$MonLastStatus,$MonEnabled,$MonChkInv,$MonMessageID)=$sqlmon->fetchrow_array) {
     &syslog("ReadNode: $NodeName - Alias: $ResAlias  - IP: $ResIP - Status: $MonLastStatus",1);
     #&lvslog(3,"ReadNode: $NodeName - Alias: $ResAlias  - IP: $ResIP - Status: $MonLastStatus"),"monitor";
     #Building the hashes for the current monitor runtime config
     $LvsMonNodeName{$MonID}=$NodeName;
     $LvsMonAlias{$MonID}=$ResAlias;
     $LvsMonIP{$MonID}=$ResIP;
     $LvsMonPort{$MonID}=$InvPort;
     $LvsMonTimeout{$MonID}=$MonTimeout;
     $LvsMonCurStat{$MonID}=$MonLastStatus;
     $LvsMonEnabled{$MonID}=$MonEnabled;
     $LvsCommandID{$MonID}=$MonCommandID;
     $LvsMonInterval{$MonID}=$MonInterval;
     $LvsMonImmediaterecoverid{$MonID}=$MonImmediaterecoverid;
     $LvsMonFailInterval{$MonID}=$MonFailInterval;
     $LvsMonCurInterval{$MonID}=$MonInterval;     #Check immedialtly after application start, otherwise set "0"
     $LvsMonCurFailInterval{$MonID}=0;
     $LvsMonCheckinventory{$MonID}=$MonChkInv;
     $LvsMonInvID{$MonID}=$InvID;
     $LVSMonBid{$MonID}=$InvBid;
     $LvsMonInvWeight{$MonID}=$InvWeight;
     $LvsMonNotificationClock{$MonID}=$MonNotificationClock;
     $LvsMonCurNotificationClock{$MonID}=0;
     $LvsMonInvMethodID{$MonID}=$InvMethod;
     $LvsMonrecTaskID{$MonID}=$MonrecTaskID;
     #$LvsMonCurRechecks{$MonID}=0;
     #$LvsMonCurrecheckwait{$MonID}=0;
     #$LvsMonCurrechecksretry{$MonID}=0;
     #$LvsMonCurrecheckwaitretry{$MonID}=0;
     $LvsMonRechecks{$MonID}=$monRechecks;
     $LvsMonrecheckwait{$MonID}=$monrecheckwait;
     $LVSMonMessageID{$MonID}=$MonMessageID;
     if ($startup eq 0) {
      $LvsMonStateFrom{$MonID}=0;
      $LVSBlackoutChange{$MonID}=undef;
     } 
     $srvcnt++;
    }  #while(($MonTimeout,$MonInterval,$monRechecks,$MonNotificationClock,$MonImmediaterecoverid,$MonCommandID,$MonLastCheck)=$sqlmon->fetchrow_array) 
    last;
   }  #while (($ResAlias,$ResIP)=$sqlnoderes->fetchrow_array)
  }   #while(($InvResID,$InvMethod,$invLink,$InvWeight,$InvAutomovePoolID)=$sqlnodeinv->fetchrow_array) 
 }    #while(($NodeID,$NodeName,$NodeScheduler,$NodeService,$NodeVIP,$NodePersistent)=$sqlnode->fetchrow_array) 



 #Delete Command Inventory from my runtime vars if present
 for $cmds (keys %LvsCMDName ){  #Get actual host and check it's timer
  delete $LvsCMDName{$cmds};
  delete $LvsCMDEnabled{$cmds};
  delete $LvsCMD{$cmds};
 }


 $sqlcmd = $dbh->prepare("SELECT cmdID,Enabled,Name,command FROM tblCommands" ) or &sqldead;
 $sqlcmd->execute ;  #Get Nodes
 while(($SQLCMDID,$SQLCMDEnabled,$SQLCMDName,$SQLCMD)=$sqlcmd->fetchrow_array) {
  $LvsCMDName{$SQLCMDID}=$SQLCMDName;
  $LvsCMD{$SQLCMDID}=$SQLCMD;
  $LvsCMDEnabled{$SQLCMDID}=$SQLCMDEnabled;
 }

 #Delete RecoverCommand Inventory from my runtime vars if present
 for $cmds (keys %LvsRecName ){  #Get actual host and check it's timer
  delete $LvsRecName{$cmds};
  delete $LvsRecEnabled{$cmds};
  delete $LvsRec{$cmds};
 }


 $sqlcmd = $dbh->prepare("SELECT recID,Enabled,Name,command FROM tblRecover" ) or &sqldead;
 $sqlcmd->execute ;  #Get Nodes
 while(($SQLCMDID,$SQLCMDEnabled,$SQLCMDName,$SQLCMD)=$sqlcmd->fetchrow_array) {
  $LvsRecName{$SQLCMDID}=$SQLCMDName;
  $LvsRec{$SQLCMDID}=$SQLCMD;
  $LvsRecEnabled{$SQLCMDID}=$SQLCMDEnabled;
 }

#Delete RecoverTasks from my runtime vars if present
 for $cmds (keys %LvsRecTask ){  #Get actual host and check it's timer
  delete $LvsRecTask{$cmds};
  delete $LvsRecTaskID{$cmds};
  delete $LvsRecTaskClock{$cmds};
  delete $LvsCurTaskClock{$cmds};
 }

 $sqlcmd = $dbh->prepare("SELECT TaskID,recTaskID,recID,recClock FROM tblRecoverTasks" ) or &sqldead;
 $sqlcmd->execute ;  #Get Nodes
 while(($SQLCMDID,$SQLTID,$SQLID,$SQLCLOCK)=$sqlcmd->fetchrow_array) {
  $LvsRecTask{$SQLCMDID}=$SQLTID;
  $LvsRecTaskID{$SQLCMDID}=$SQLID;
  $LvsRecTaskClock{$SQLCMDID}=$SQLCLOCK;
  #&Syslog ("===>Assign: $SQLCLOCK");
  #exit;
  $LvsCurTaskClock{$SQLCMDID}=1;
 }

#Delete mailIDs from my runtime vars if present
 for $cmds (keys %LvsMsgID ){  #Get actual host and check it's timer
  delete $LvsMsgID{$cmds};
  delete $LvsMsgType{$cmds};
  delete $LvsMsgServer{$cmds};
  delete $LvsMsgTo{$cmds};
  delete $LvsMsgCC{$cmds};
  delete $LvsMsgBCC{$cmds};
 }

 $sqlcmd = $dbh->prepare("SELECT mid,type,mailfrom,server,mailto,mailcc,mailbcc FROM tblMessaging" ) or &sqldead;
 $sqlcmd->execute ;  #Get Nodes
 while(($SQLMsgID,$SQLMsgType,$SQLMsgFrom,$SQLMsgServer,$SQLMsgTo,$SQLMsgCC,$SQLMsgBCC)=$sqlcmd->fetchrow_array) {
  #print "$SQLMsgID-$SQLMsgType,$SQLMsgServer,$SQLMsgTo\n";
  $LvsMsgID{$SQLMsgID}=$SQLMsgID;
  $LvsMsgType{$SQLMsgID}=$SQLMsgType;
  $LvsMsgServer{$SQLMsgID}=$SQLMsgServer;
  $LvsMsgTo{$SQLMsgID}=$SQLMsgTo;
  if (!$SQLMsgCC) {$SQLMsgCC="";}
  if (!$SQLMsgBCC) {$SQLMsgBCC="";}
  $LvsMsgCC{$SQLMsgID}=$SQLMsgCC;
  $LvsMsgBCC{$SQLMsgID}=$SQLMsgBCC;
  $LvsMsgFrom{$SQLMsgID}=$SQLMsgFrom;
 }
 
 #Delete blackoutIDs from my runtime vars if present
 for $bid (keys %LvsBlackoutEnabled ){  #
  for $bgid (keys %{$LvsBlackoutEnabled{$bid}} ){  #
   delete $LvsBlackoutEnabled{$bid}{$bgid};
   delete $LvsBlackoutName{$bid}{$bgid};
   delete $LvsBlackoutGID{$bid}{$bgid};
   delete $LvsBlackoutFrom{$bid}{$bgid};
   delete $LvsBlackoutTo{$bid}{$bgid};
  }
 }



 #Get Group Information
 %UDGroupRemoveMax=();
 %UDGroupMinAvailable=();

 $sqlmain = $dbhCur->prepare("SELECT gID,GroupRemoveMax,GroupMinAvailable FROM tblMaintenanceGroup;" ) or &sqldead;
 $sqlmain->execute ;  
 while (my($SQLgID,$SQLGRMax,$SQLGMAvail)=$sqlmain->fetchrow_array) { 
  $UDGroupRemoveMax{$SQLgID}=$SQLGRMax;
  $UDGroupMinAvailable{$SQLgID}=$SQLGMAvail;
 }	


 

 $sqlcmd = $dbh->prepare("SELECT bid,groupID,name,blackoutfrom,blackoutto FROM tblDailyBlackout where enabled='1';" ) or &sqldead;
 $sqlcmd->execute ;  #Get Nodes
 while(($SQLDBid,$SQLDBGid,$SQLDBname,$SQLDBfrom,$SQLDBto)=$sqlcmd->fetchrow_array) {
 $LvsBlackoutEnabled{$SQLDBid}{$SQLDBGid}=1;
 $LvsBlackoutGID{$SQLDBid}{$SQLDBGid}=$SQLDBGid;
 $LvsBlackoutName{$SQLDBid}{$SQLDBGid}=$SQLDBname;
 $LvsBlackoutFrom{$SQLDBid}{$SQLDBGid}=$SQLDBfrom;
 $LvsBlackoutTo{$SQLDBid}{$SQLDBGid}=$SQLDBto;
 #print "\n== $LvsBlackoutEnabled{$SQLDBid}{$SQLDBGid} - $LvsBlackoutName{$SQLDBid}{$SQLDBGid} - $LvsBlackoutFrom{$SQLDBid}{$SQLDBGid} - $LvsBlackoutTo{$SQLDBid}{$SQLDBGid} - $SQLDBid - $SQLDBGid ";
 
 }

 
 
}     #sub GetConfig 


sub SuccessManager(){
	#$_[0] = monid
	#New Paramter $_[3], define a maintenance slot
	#Sample: &SuccessManager($monhost,$LvsMonInvID{$monhost},$LvsMonCheckinventory{$monhost});
	#my $sqlset;
	&syslog ("==> Apply: SucessManager: $_[0] - $_[1] - $_[2]",1);
	my $dbhs = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword)  or &sqldead;
	my ($sqlmoninv,$sqlInvID,$sqlmon,$mymonID,%TmpFailState);
	my ($InvLink,$InvNodeID,$scheduler,$NodeService,$NodeName,$NodeVIP,$InvResID,$mscheduler,$NodeIDautomovepoolid,$presID,$InvRealIP,$NodeINVactive,$NodeINVenabled,$NodeINVmethod,$NodeINVweight,$NodeINVID,$sqlmethod,$sqlweight,$mstring,$sqlalias,$sqlIPort);
	my $TmpFailTot=0;
  #Get InvID by $_[1]
  $sqlmoninv = $dbhs->prepare("SELECT link,nodeID,resID,method,weight FROM tblNodesInventory where invID = '" . $_[1] . "' and enabled='1';" ) or &sqldead;
	$sqlmoninv->execute;
	(($InvLink,$InvNodeID,$InvResID,$sqlmethod,$sqlweight)=$sqlmoninv->fetchrow_array) ;
  $sqlalias = $dbhs->prepare("SELECT alias,realip FROM tblResources where resID = '" . $InvResID . "';" ) or &sqldead;
  $sqlalias->execute ; #Get Inventory and ID's
  (my($sqlAlias,$sqlIP)=$sqlalias->fetchrow_array);
  #ADD INVENTORY PRECHECK
  #If chkInv then Check all services within this host and skip all operations if active = 0 !!!!
  #But dont do this if Maintenance/Service mode $-[3] is configured 
  if (($_[2] eq 1) ) {
   #PreCheck
   #&syslog ("=>DEBUG::: DOING PRECHECK",1);
   &syslog ("SELECT invID FROM tblNodesInventory where resID = '" . $InvResID . "' and active = '0';",1);
   $sqlmoninv = $dbhs->prepare("SELECT invID FROM tblNodesInventory where resID = '" . $InvResID . "' and active = '0';" ) or &sqldead;
	 $sqlmoninv->execute;
	 while (($sqlInvID)=$sqlmoninv->fetchrow_array) {
	  &syslog ("=>$sqlInvID - $_[1] - Not Active",1);
    if ($sqlInvID ne $_[1]){
     $TmpFailState{$sqlInvID} = undef;
     &syslog ("SELECT  monID FROM tblMonitor where invID='" . $sqlInvID ."' and checkalive='1' and status <> 'OK' ;",1);
     my $sqlmon = $dbhs->prepare("SELECT  monID FROM tblMonitor where invID='" . $sqlInvID ."' and checkalive='1' and status <> 'OK' ;" ) or &sqldead;
     $sqlmon->execute ;  #Get Monitor conf
     while (($mymonID)=$sqlmon->fetchrow_array) {
      #&syslog ("=>$mymonID - CHANGE TO OK",1);
      #&syslog ("====>>> >$sqlInvID ==>> Present in tblMonitor <<===   ",1);
      if ($LvsCommandID{$mymonID}) {
       &chk_time_to_die;  
       $cmdsend=&GetChkCmd($LvsCMD{$LvsCommandID{$mymonID}},$mymonID);
       #$cmdsend="/usr/local/dev/mysql/_check_http.pl";
       &syslog ("-> Apply: $cmdsend ",1);
       $cmdret=`$cmdsend`;   #Run command
       chomp;
       &syslog ("-> $cmdsend => Returns: $cmdret ",1);
       if (($cmdret =~ /Error/i) or ($cmdret =~ /CRITICAL/i)  or ($cmdret =~ /WARNING/i)  or ($cmdret =~ /REFUSED/i) or ($cmdret =~ /No route to host/i) ) {
        &syslog ("-> Add Failsate: $sqlInvID",1);
        $TmpFailState{$sqlInvID} = 1;
        $TmpFailTot=1;  
        $Time=time;
  	    &syslog ("UPDATE tblMonitor SET lastcheck = '". $Time ."', status='FAIL' where monID ='".$mymonID."';",1);
  	    $sqlstat = $dbhs->prepare("UPDATE tblMonitor SET lastcheck = '". $Time ."', status='FAIL' where monid ='".$mymonID."';") or &sqldead;
        $sqlstat->execute ;  #Get Nodes
       }   #if (($cmdret =~ /Error/i) or ($cmdret =~ /CRITICAL/i))
      } else {
       &syslog ("=>Check simulation or Databaseconfig or => No ReCheck configured because commandid is set to 0 or status is in fail  - skip",1);
      }    #if ($LvsCommandID{$mymonID}) 
     }    #while (($mymonID)=$sqlmon->fetchrow_array)
	  }     #if ($sqlInvID ne $_[1])
   }      #while (($sqlInvID)=$sqlmoninv->fetchrow_array) 
  }       #$sqlInvID and not service mode configured ?
  	 
	$sqlmoninv = $dbhs->prepare("SELECT link,nodeID,automovepoolid,method,weight,invID,port FROM tblNodesInventory where resID = '" . $InvResID . "';" ) or &sqldead;
	$sqlmoninv->execute;
	 
	while (($InvLink,$InvNodeID,$NodeIDautomovepoolid,$NodeINVmethod,$NodeINVweight,$NodeINVID,$sqlIPort)=$sqlmoninv->fetchrow_array) {
	 #Enum all belonging services within this host
   my $sqlnode = $dbhs->prepare("SELECT Name,service,vip FROM tblNodes where nodeID='" . $InvNodeID ."' and enabled='1'" ) or &sqldead;
   $sqlnode->execute ;  #Get Nodes
   (($NodeName,$NodeService,$NodeVIP)=$sqlnode->fetchrow_array) ;
   #&syslog ("=>DEBUG::: $_[2] - $NodeINVID - $_[0]",1);
   if (($_[2] ne 1 ) and ($NodeINVID eq $_[1]) or (($_[2] eq 1 ))) {
    if ($NodeService !~ /fwm/i) {
     $mscheduler = "-t $NodeVIP";
    } else {
     $mscheduler = "-f $NodeVIP";	
    }	
    
    if ($NodeService !~ /fwm/i) {
     $mstring = "$lvscmd -a -t $NodeVIP -r $sqlIP:$sqlIPort -$NodeINVmethod -w $NodeINVweight";
    } else {
     $mstring = "$lvscmd -a -f $NodeVIP -r $sqlIP -$NodeINVmethod -w $NodeINVweight";	
    }	
    
    if ($TmpFailTot eq 0){  
     #Need to depend on InvC
     if (!$simulate) {
      &chk_time_to_die; 
      &syslog ("=>APPLY: $mstring",1);
      &lvslog(10,"Apply: $mstring","monitor");
      $cmdret=`$mstring`;   #Run command
  	 } else {
  	  &syslog ("=>Simulate APPLY: $mstring",1);
      &lvslog(10,"Simulate Apply: $mstring","monitor");
  	 }
  	 #$NodeINVID
  	 &syslog ("=>OK APPLY: UPDATE tblNodesInventory SET active = '1' where invID ='" . $NodeINVID . "'  and enabled='1';",1) ;
	   &lvslog(3,"=>OK APPLY: UPDATE tblNodesInventory SET active = 1 where invID =" . $NodeINVID . "  and enabled=1;" ,"monitor");
     $sqlset = $dbhs->prepare("UPDATE tblNodesInventory SET active = '1' where invID ='" . $NodeINVID . "'  and enabled='1';") or &sqldead;
	   $Time=time;
	   &lvslog(3,"UPDATE tblMonitor SET lastcheck = ". $Time .", status=OK where invID =".$NodeINVID.";","monitor");
	   &syslog ("UPDATE tblMonitor SET lastcheck = '". $Time ."', status='OK' where invID ='".$NodeINVID."';",1);
	   $sqlstat = $dbhs->prepare("UPDATE tblMonitor SET lastcheck = '". $Time ."', status='OK' where invID ='".$_[1]."';");
     $sqlstat->execute ;  #Get Nodes
     $sqlset->execute ;   
    } else {
     if (!$TmpFailState{$NodeINVID}) { 
    	&lvslog(3,"=>Skip adding this service into node due to inventory check" ,"monitor");
    	&syslog ("=>Skip adding this service into node due to inventory check",1) ;
    	&syslog ("=>APPLY InvCheck: UPDATE tblNodesInventory SET active = '1' where invID ='" . $_[1] . "'  and enabled='1';",1) ;
	    &lvslog(3,"=>APPLY InvCheck: UPDATE tblNodesInventory SET active = 1 where invID =" . $_[1] . "  and enabled=1;" ,"monitor");
      $sqlset = $dbhs->prepare("UPDATE tblNodesInventory SET active = '1' where invID ='" . $_[1] . "'  and enabled='1';") or &sqldead;
      $sqlset->execute ;   
      $Time=time;
      &lvslog(3,"UPDATE tblMonitor SET lastcheck = ". $Time .", status=OK where invID =".$_[1].";","monitor");
      &syslog ("UPDATE tblMonitor SET lastcheck = '". $Time ."', status='OK' where invID ='".$_[1]."';",1);
  	  $sqlstat = $dbhs->prepare("UPDATE tblMonitor SET lastcheck = '". $Time ."', status='OK' where invID ='".$_[1]."';") or &sqldead;
      $sqlstat->execute ;  #Get Nodes
     }     #if (!$TmpFailState{$NodeINVID}) 
    }      #if ($TmpFailTot eq 0)
   }       #if (($_[2] ne 1 ) and ($NodeINVID eq $_[1]) or (($_[2] eq 1 ))) 
  }        #while (($InvLink,$InvNodeID,$NodeIDautomovepoolid,$NodeINVmethod,$NodeINVweight,$NodeINVID)=$sqlmoninv->fetchrow_array)

  if ($_[2] eq 1 )  {
  	if ($TmpFailTot eq 0) {
     &syslog ("=> *** Server: " . $LvsMonIP{$_[0]} . " has been added into inventory *** <==",3);
     &lvslog(3,"=> *** Server: " . $LvsMonIP{$_[0]} . " has been added into inventory *** <==","monitor");
    } 
  } else {
   &syslog ("=> *** The Service on: " . $LvsMonIP{$_[0]} . " has been added into inventory *** <==",3);
   &lvslog(3,"=> *** The Service on: " . $LvsMonIP{$_[0]} . " has been added into inventory *** <==","monitor");
  }

  if (($LvsMsgType{$LvsMsgID{$LVSMonMessageID{$_[0]}}} eq "1") and ($LvsMsgTo{$LvsMsgID{$LVSMonMessageID{$_[0]}}})) {
   if ($LvsMonStateFrom{$_[0]}	ne 0) {
   	&syslog ("=> Set Sendmail -  $_[0]",3);
  	$SSubject="OK from $LvsMonAlias{$_[0]}";
    $SBody="Status change to OK from: $LvsMonAlias{$_[0]}\n";
    $SBody.="Local Date: " . &getDate ."\n";
    $SBody.="Added Service: $LvsMonIP{$_[0]}:$LvsMonPort{$_[0]}\n";
    if ($_[2] eq 1 )  {
  	 if ($TmpFailTot eq 0) {
      $SBody.="Info: Service " . $LvsMonIP{$_[0]} . " has been added into inventory\n";
     } else {
     	$SBody.="Info: Server " . $LvsMonIP{$_[0]} . " has not been added into inventory due to other failed services\n";
     }
    } else {
      $SBody.="Info: Service " . $LvsMonIP{$_[0]} . " has been added into inventory\n";
    } 
    &Sendmail ($LvsMsgTo{$LvsMsgID{$LVSMonMessageID{$_[0]}}},$LvsMsgFrom{$LvsMsgID{$LVSMonMessageID{$_[0]}}},$SSubject,$SBody,$LvsMsgServer{$LvsMsgID{$LVSMonMessageID{$_[0]}}},$LvsMsgCC{$LvsMsgID{$LVSMonMessageID{$_[0]}}},$LvsMsgBCC{$LvsMsgID{$LVSMonMessageID{$_[0]}}});
    $LvsMonStateFrom{$_[0]}=0;
   } else {
  	&syslog ("=> Skip Sendmail - Manual Turn On - $_[0]",3);
   }
  }

  #Reset temp. counters for this host 
  $LvsMonCurRechecks{$_[0]}=0;
  $LvsMonCurrecheckwait{$_[0]}=0;
  $LvsMonCurrechecksretry{$_[0]}=0;
  $LvsMonCurrecheckwaitretry{$_[0]}=0;

	#dont forget!
	&GetConfig ;

}


sub FailManager(){
	####################################################################################################
	#remove and automove realservers in case of failures
	#Paramater:	1: Monitoring ID, 2: Inventory ID, 3: CheckInventoryFlag, 4: CheckMaintenance Flag
	#ATTENTION: Automove service works only with a flagged checkinventory value
	#Usage: &FailManager (MonitorID,InventoryID,CheckInventoryFlag)
	#Current Sample: &FailManager($monhost,$LvsMonInvID{$monhost},$LvsMonCheckinventory{$monhost});
	####################################################################################################
	
	#$LvsMonStateFrom{$_[0]}=1;
	
	my $dbhf = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword)  or &sqldead;
	my $sqlmoninv;
	my ($sqlResID,$sqlAlias,$presHost,$myCHost,$var,$value,$sqlLink,$InvRealAlias,$myCurID);
	my ($InvLink,$InvNodeID,$scheduler,$NodeService,$NodeName,$NodeVIP,$InvResID,$mscheduler,$NodeIDautomovepoolid,$presID,$InvRealIP,$NodeINVactive,$NodeINVenabled,$NodeINVmethod,$NodeINVweight,$NodeINVID,$sqlstat);
	&syslog("=>APPLY: Function FailManager =>$_[0]<=>$_[1]<=>$_[2]<=",1);
  #Get InvID by $_[1]
  &syslog("DEBUG SELECT link,nodeID,resID,automovepoolid FROM tblNodesInventory where invID = '" . $_[1] . "' and enabled='1';",1);
  $sqlmoninv = $dbhf->prepare("SELECT link,nodeID,resID,automovepoolid FROM tblNodesInventory where invID = '" . $_[1] . "' and enabled='1';" ) or &sqldead;
	$sqlmoninv->execute;
	(($InvLink,$InvNodeID,$InvResID,$NodeIDautomovepoolid)=$sqlmoninv->fetchrow_array) ;
	&syslog("DEBUG Response $InvLink,$InvNodeID,$InvResID,$NodeIDautomovepoolid",1);
	&syslog("DEBUG SELECT link,nodeID,automovepoolid,method,weight,invID FROM tblNodesInventory where resID = '" . $InvResID . "';",1);
	$sqlmoninv = $dbhf->prepare("SELECT link,nodeID,automovepoolid,method,weight,invID FROM tblNodesInventory where resID = '" . $InvResID . "';" ) or &sqldead;
	$sqlmoninv->execute;
	while (($InvLink,$InvNodeID,$NodeIDautomovepoolid,$NodeINVmethod,$NodeINVweight,$NodeINVID)=$sqlmoninv->fetchrow_array) {
	 &syslog("DEBUG Response $InvLink,$InvNodeID,$NodeIDautomovepoolid,$NodeINVmethod,$NodeINVweight,$NodeINVID",1);
	 #Enum all belonging services within this host
   &syslog("DEBUG SELECT Name,service,vip FROM tblNodes where nodeID='" . $InvNodeID ."' and enabled='1'",1);
   my $sqlnode = $dbhf->prepare("SELECT Name,service,vip FROM tblNodes where nodeID='" . $InvNodeID ."' and enabled='1'" ) or &sqldead;
   $sqlnode->execute ;  #Get Nodes
   (($NodeName,$NodeService,$NodeVIP)=$sqlnode->fetchrow_array) ;
   &syslog("DEBUG Compare $NodeName,$NodeService,$NodeVIP,$NodeINVID,$_[0],$_[1],$_[2]",1);
   if ((($_[2] ne 1 ) and ($NodeINVID eq $_[1])) or ($_[2] eq 1 )) {
    if ($NodeService !~ /fwm/i) {
     $mscheduler = "-t $NodeVIP";
    } else {
     $mscheduler = "-f $NodeVIP";	
    }	
    if (!$simulate) {
     &chk_time_to_die; 
     $cmdret=`$lvscmd -d $mscheduler -r $LvsMonIP{$_[0]}`;   #Run command
     &syslog ("=>APPLY: $lvscmd -d $mscheduler -r $LvsMonIP{$_[0]}",1);
     $LvsMonStateFrom{$_[0]}=1;
     &lvslog(10,"Apply: $lvscmd -d $mscheduler -r $LvsMonIP{$_[0]}","monitor");
    } else {
     &syslog ("=>Simulate APPLY: $lvscmd -d $mscheduler -r $LvsMonIP{$_[0]}",1);
     $LvsMonStateFrom{$_[0]}=1;
     &lvslog(10,"Simulate Apply: $lvscmd -d $mscheduler -r $LvsMonIP{$_[0]}","monitor");
    }
    
    #if ($_[3] ne 1) {
     &syslog ("=>APPLY: UPDATE tblNodesInventory SET active = '0', failstate = '1'  where invID ='" . $NodeINVID . "'",1) ;
     $sqlset = $dbhf->prepare("UPDATE tblNodesInventory SET active = '0', failstate = '1' where invID ='" . $NodeINVID . "'") or &sqldead;
     $sqlset->execute ; 
     
    $Time=time;
    
    #if ($_[3] ne 1) {
     $sqlstat = $dbhf->prepare("UPDATE tblMonitor SET lastcheck = '". $Time ."', status='FAIL' where invid ='".$NodeINVID."';") or &sqldead;
     $sqlstat->execute ; 
    #} else {
    # $sqlstat = $dbhf->prepare("UPDATE tblMonitor SET lastcheck = '". $Time ."', status='SRV' where invid ='".$NodeINVID."';") or &sqldead;
    # $sqlstat->execute ; 
    #}
    #### MANAGE AUTOMOVE SERVICE  ##### 
    if ($NodeIDautomovepoolid ne 0){
   	 &syslog ("=>QUERY: SELECT resID,Alias FROM tblPoolResources where poolID='" . $NodeIDautomovepoolid,1);
     my $sqlpool = $dbhf->prepare("SELECT resID FROM tblPoolResources where poolID='" . $NodeIDautomovepoolid ."';" ) or &sqldead;
     $sqlpool->execute ; 
     while (($presID,$presHost)=$sqlpool->fetchrow_array) {
      &syslog ("=>APPLY: SELECT resID from tblNodesInventory  where resID ='" . $presID . "' and active='1' and weightdown='0';",1) ;
      $sqlset = $dbhf->prepare("SELECT resID from tblNodesInventory  where resID ='" . $presID . "' and active='1' and weightdown='0';") or &sqldead;
      $sqlset->execute ; 
      (($myCurID)=$sqlset->fetchrow_array);
      if ($myCurID) {
       if ($presID != $InvResID){
        $AMoved=undef;
        $myCHost=$presHost;
     	  &syslog ("=>QUERY: SELECT realip,alias FROM tblResources where enabled = '1' and resID = '" . $presID . "';",1);
     	  my $sqlres = $dbhf->prepare("SELECT realip,alias FROM tblResources where enabled = '1' and resID = '" . $presID . "';" ) or &sqldead;
     	  $sqlres->execute ;  #Get Nodes
     	  while (($InvRealIP,$InvRealAlias)=$sqlres->fetchrow_array) {
     		 #walk through resources
     		 my $sqlnodee = $dbhf->prepare("SELECT Name,service,vip FROM tblNodes where nodeID='" . $InvNodeID ."'" ) or &sqldead;
         $sqlnodee->execute ;  #Get Nodes
         (($NodeName,$NodeService,$NodeVIP)=$sqlnodee->fetchrow_array) ;
         if ($NodeService !~ /fwm/i) {
          #$mscheduler = "-t $NodeVIP";
          $mscheduler = "$lvscmd -a -t $NodeVIP -r $InvRealIP:$LvsMonPort{$_[0]} -$LvsMonInvMethodID{$_[0]} -w $NodeINVweight";
          #$LvsMonInvWeight{$_[0]}
         } else {
          $mscheduler = "$lvscmd -a -f $NodeVIP -r $InvRealIP -$LvsMonInvMethodID{$_[0]} -w $NodeINVweight";	
         }	
         if (!$simulate) {
          &chk_time_to_die; 
          $cmdret=`$mscheduler`;   #Run command
          &lvslog(10,"Apply Automove: $mscheduler","monitor");
          $LvsMonStateFrom{$_[0]}=1;
          &syslog ("=>APPLY: $mscheduler",1);
        	} else {
        	 &syslog ("=>Simulate APPLY: $mscheduler",1);
        	 &lvslog(10,"Simulate Apply Automove: $mscheduler","monitor");
        	 $LvsMonStateFrom{$_[0]}=1;
         }
        	&syslog ("=>APPLY: UPDATE tblNodesInventory SET active = '1',resID='". $presID . "' where invID ='" . $NodeINVID,1);
    	    $sqlset = $dbhf->prepare("UPDATE tblNodesInventory SET active = '1',resID='". $presID . "' where invID ='" . $NodeINVID . "'") or &sqldead;
          $sqlset->execute ; 
        
         #Get Old Link
         $sqlset = $dbhf->prepare("SELECT resID,link from tblNodesInventory where invID ='" . $_[1] . "'") or &sqldead;
         #&syslog ("=>DEBUG: " . "SELECT resID,link from tblNodesInventory where invID ='" . $_[1] . "'" ,1);
         $sqlset->execute ; 
         (($sqlResID,$sqlLink)=$sqlset->fetchrow_array);
         #Get Old Alias
         $sqlset = $dbhf->prepare("SELECT alias from tblResources where resID ='" . $sqlResID . "'") or &sqldead;
         $sqlset->execute ; 
         (($sqlAlias)=$sqlset->fetchrow_array) ;
         #Replace old alias with new ...
         ($var,$value) = split(/$sqlAlias\s*/,$sqlLink,2);     #Get Full Command 
         #&syslog ("=>DEBUG:  SQL: UPDATE tblNodesInventory SET link = '".$var.$InvRealAlias.$value."' where invID ='" . $NodeINVID,1);
         my $sqlii = $dbhf->prepare("UPDATE tblNodesInventory SET link = '".$var.$InvRealAlias.$value."' where invID ='" . $NodeINVID . "';" ) or &sqldead;
         $sqlii->execute;
         $AMoved=1;
     		 last;       	 
       
        }     		   #while (($InvRealIP,$InvRealAlias)=$sqlres->fetchrow_array) 
        if ($AMoved) {last}
     	 }            #if ($presID != $InvResID)
      }  else {
       &syslog ("=>Resource ID not valid: $presID",1) ;	
      }            #$myCurID
     }	           #while (($presID)=$sqlpool->fetchrow_array) 
    }              #if ($NodeIDautomovepoolid ne 0)
	 }               #if (($_[2] ne 1 ) and ($NodeINVID eq $_[1]) or (($_[2] eq 1 ))) 
	}               #while (($InvLink,$InvNodeID,$NodeIDautomovepoolid,$NodeINVmethod,$NodeINVweight,$NodeINVID)=$sqlmoninv->fetchrow_array) 
  if ($_[2] eq 1 ) {
   &syslog ("=> *** Server: " . $LvsMonIP{$_[0]} . " has been removed from inventory *** <==",3);
   &lvslog(3,"=> *** Server: " . $LvsMonIP{$_[0]} . " has been removed from inventory *** <==","monitor");
  } else {
   &syslog ("=> *** The Service on: " . $LvsMonIP{$_[0]} . " has been removed from inventory *** <==",3);
   &lvslog(3,"=> *** The Service on: " . $LvsMonIP{$_[0]} . " has been removed from inventory *** <==","monitor");
  }
	&GetConfig ;
}

sub GetChkCmd {

      $_=$_[0];  #Prepare string filter
      s/%HOST%/$LvsMonIP{$_[1]}/;
      s/%PORT%/$LvsMonPort{$_[1]}/;
      s/%TIMEOUT%/$LvsMonTimeout{$_[1]}/;
      #print "$_\n";
      return $_;

}


sub syslog {
	if ($_[1] >= $loglevel) {
		my $tldate = strftime("%d-%m-%Y %H:%M:%S", localtime(time));
    open LOGGING, ">>$logfile" or die "Can not write logfile: daemon.txt $!\n";
    print LOGGING "$tldate $_[0] \n";
    close LOGGING;
    if ($setdaemon eq 0) {
     #print "$date $pid $arg\n";	
     print $tldate . " $_[0]\n";
    }
	}	
}


sub getconfig {
 #Read xml config file
 my %xmlcmd;
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupenabled=$data->{SQLServerBackup}->{Enabled};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
 $bkupreplcommand=$data->{SQLServerBackup}->{ReplCommand};
 $simulate=$data->{Operation}->{MonSimulate};
 $Mailserver=$data->{Operator}->{Mailserver};
 $Mailfrom=$data->{Operator}->{Mailfrom};
 $MailTo=$data->{Operator}->{MailTo};
 $MailCC=$data->{Operator}->{MailCC};
 $MailBCC=$data->{Operator}->{MailBCC};
 if (!$MailCC) {$MailCC="";}
 if (!$MailBCC) {$MailBCC="";}
 $FileAge=$data->{Maintenance}->{FileAge};
 $SQLAge=$data->{Maintenance}->{SQLAge};
 $logpath=$data->{Log}->{Path};
 $logname=$data->{Log}->{Name};
 $gzip=$data->{Log}->{gzip};
 $MaxLogDays=$data->{Log}->{Days};
}


sub getDate {
	return strftime("%d", localtime(time))."-".strftime("%m", localtime(time))."-".strftime("%Y", localtime(time))." ".strftime("%H", localtime(time)).":".strftime("%M", localtime(time)).":".strftime("%S", localtime(time));
}

sub lvslog {
 #Logs into sql
 #$_[0] = Code (used for the image)
 #$_[1] = Message
 my $sqlcur = $dbhCur->prepare("INSERT into tblLogging (code,user,day,month,year,hour,minute,second,message,epoche) VALUES('".$_[0]."','".$_[2]."','".strftime("%d", localtime(time))."','".strftime("%m", localtime(time))."','".strftime("%Y", localtime(time))."','".strftime("%H", localtime(time))."','".strftime("%M", localtime(time))."','".strftime("%S", localtime(time))."','".$_[1]."','".time."');" );
 $sqlcur->execute;
}



sub Sendmail {
 my %mail = ( To      => "$_[0]",
  From    => "$_[1]",
  Subject => "$_[2]",
  Message => "$_[3]",
  smtp  => "$_[4]",
  Cc  => "$_[5]",
  Bcc  => "$_[6]"
 );
 &syslog("Send mail to: $_[0] cc: $_[5] bcc: $_[6] - $_[2]",1);
 sendmail(%mail) ;#or &lvslog(7,"Sendmail error","monitor");
 &syslog("OK. Log says:" . $Mail::Sendmail::log,3);
 &lvslog(7,"Send mail to: $_[0] cc: $_[5] bcc: $_[6] - $_[2]","monitor");
}

sub SetDaemon {
 $pid = fork;
 exit if $pid;
 die "Error with fork: $!" unless defined($pid);
 POSIX::setsid() or die "Cant start: $!";
 $SIG{TERM} = $SIG{HUP} = \&signal_handler;  #Catch signals and send to signal_handler
} 

sub signal_handler {
 #Part of SetDaemon, pls leave !
 $time_to_die = 1;
 
 &lvslog(8,"Caught SIGTERM, shutting down...","monitor");   #2.0.4.5
 &syslog ("Caught SIGTERM, shutting down...",1);            #2.0.4.5

}


sub sqldead {
	my ($tsubject,$tbody);
	my $tldate = strftime("%d-%m-%Y %H:%M:%S", localtime(time));
  #  open LOGGING, ">>/var/log/mylvsmon.log" or die "Can not write logfile: daemon.txt $!\n";
  $tsubject="Fatal Error - can not connect to mysql";
  $tbody="Localdate: $tldate\n";
  $tbody.="Connection string: DBI:mysql:$database:$servername:3306,$sqluser,xxxx\n";
	print "=>SQL Link down !!!\n";
	&syslog ("=>SQL Link down !!!",1);
	$time_to_die = 1; 	
  &Sendmail($MailTo,$Mailfrom,$tsubject,$tbody,$Mailserver,$MailCC,$MailBCC);
  exit;	
}	

sub chk_time_to_die () {
 if ($time_to_die eq 1) {
 	&lvslog(8,"Caught SIGTERM, shutting down...","monitor");
  &syslog("Caught SIGTERM, shutting down...",1);
  exit;
 }
}

sub WeightDownHost {
	#Independant service function - Nov06
  my $fdbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword)  or &sqldead;
  
  my ($fResID,$simulate);
  $simulate="0";
	$fResID=$_[0];
  my ($fsqliID,$fsqliWeight,$fsqlNodeID,$fsqlLink,$fsqlIPort,$fsqlactive,$fsqlmethod,$fsqlweight,$fsqlPoolID);
  my ($fNodeService,$fNodeVip,$fmstring,$fmdstring,$fsqlPoolReource,$fmyCurID,$fmxstring,$sqli,$sqln,$sqla,$myIP,$myHost);
  my ($sqls,$fmyCHost,$fauto_ok,$fvar,$fvalue,$fsqlcur,$fweightdownstate,$fsqliTID,$fsqlpool,$fsqlIP,$fsqlaEnabled,$fsqlHostName);
  
  $sqla = $fdbh->prepare("SELECT alias,realip,alias FROM tblResources where resID = '" . $fResID . "';" ); 
  $sqla->execute ; #Get Inventory and ID's
  (($sqla,$fsqlIP)=$sqla->fetchrow_array);
  $myIP=$fsqlIP;
  $myHost=$sqla;
  $sqli = $fdbh->prepare("SELECT invID,weight,nodeID,link,port,active,method,weight,automovepoolid FROM tblNodesInventory where resID = '" . $fResID . "';" ); 
  $sqli->execute ; #Get Inventory and ID's
  while (($fsqliID,$fsqliWeight,$fsqlNodeID,$fsqlLink,$fsqlIPort,$fsqlactive,$fsqlmethod,$fsqlweight,$fsqlPoolID)=$sqli->fetchrow_array) {
   $sqln = $fdbh->prepare("SELECT service,vip FROM tblNodes where nodeid = '" . $fsqlNodeID . "';" ); 
   $sqln->execute ; 
   ($fNodeService,$fNodeVip)=$sqln->fetchrow_array ;
   if ($fNodeService !~ /fwm/i) {
   	
    $fmstring = "$lvscmd -e -t $fNodeVip -r $fsqlIP:$fsqlIPort -$fsqlmethod -w 0";
    $fmdstring = "$lvscmd -d -t $fNodeVip -r $fsqlIP:$fsqlIPort";
   } else {
    $fmstring = "$lvscmd -e -f $fNodeVip -r $fsqlIP -$fsqlmethod -w 0";	
    $fmdstring = "$lvscmd -d -f $fNodeVip -r $fsqlIP";	
   }	
   #	APPLY: /usr/bin/sudo /sbin/ipvsadm -e -t 10.0.1.4:7000 -r 10.0.1.11:7000 -g -w 0
   #	APPLY: /usr/bin/sudo /sbin/ipvsadm -e -f 5 -r 10.0.1.11 -g -w 0
   &syslog("MGR: Apply: $fmstring",2);
   if ($simulate eq "0") {
    `$fmstring`;
   } 
   &lvslog(11,"Drain down service by: $fmstring","system");
   
   &syslog("MGR: SQL: UPDATE tblNodesInventory SET weightdown = '1' where invID ='" . $fsqliID,2);
   if ($simulate eq "0") {
    $fsqlcur = $fdbh->prepare("UPDATE tblNodesInventory SET weightdown = '1' where invID ='" . $fsqliID . "';" );
    $fsqlcur->execute;
   } 
   $fauto_ok=1;
   ##########################################
   ##############   AUTOMOVE   ##############
   ##########################################
   
   
   if (($fsqlPoolID) and ($fsqlPoolID ne "0")) {
   	$fauto_ok=undef;
    &syslog("MGR: ATTENTION: Automovemove Service to: $fsqlPoolID",2);
    &syslog("MGR: SQL: SELECT resID FROM tblPoolResources where poolID = '" . $fsqlPoolID,2);
    $fsqlpool = $fdbh->prepare("SELECT resID FROM tblPoolResources where poolID = '" . $fsqlPoolID . "';" ); 
    $fsqlpool->execute ; #Get Inventory and ID's
    while (($fsqlPoolReource)=$fsqlpool->fetchrow_array) {
     if ($fsqlPoolReource ne $fResID) {
     	&syslog("MGR: SQL: SELECT realip,enabled,alias FROM tblResources where resID = '" . $fsqlPoolReource,2);
      $sqla = $fdbh->prepare("SELECT realip,enabled,alias FROM tblResources where resID = '" . $fsqlPoolReource . "';" ); 
      $sqla->execute ; #Get Inventory and ID's
      (($fsqlIP,$fsqlaEnabled,$fsqlHostName)=$sqla->fetchrow_array);
      &syslog("MGR: SQL: SELECT resID from tblNodesInventory  where resID ='" . $fsqlPoolReource . "' and active='1' and weightdown='0'",2);
      $sqls = $fdbh->prepare("SELECT resID from tblNodesInventory  where resID ='" . $fsqlPoolReource . "' and active='1' and weightdown='0';");
      $sqls->execute ; 
      (($fmyCurID)=$sqls->fetchrow_array);
      &syslog("MGR: CurID: $fmyCurID",2);
      if ($fmyCurID) {

      
      
       if ($fsqlaEnabled eq "1") {
       	#print "Next CurID: $fmyCurID <BR>";
        $fweightdownstate=undef;
        
        &syslog("MGR: Check State: SELECT invID FROM tblNodesInventory where weightdown = '1' and resID = '" . $fsqlPoolReource . "';",2);
        $sqli = $fdbh->prepare("SELECT invID FROM tblNodesInventory where weightdown = '1' and resID = '" . $fsqlPoolReource . "';" ); 
        $sqli->execute ; #Get Inventory and ID's
        while (($fsqliTID)=$sqli->fetchrow_array) {
         $fweightdownstate=1;  
        }
        &syslog("MGR: State: $fweightdownstate",2);
        if (!$fweightdownstate) {
         &syslog("MGR: Resource is good for takeover $fsqlIP -- $fsqlPoolReource",2);
         $fmyCHost=$fsqlHostName;
         $fauto_ok=1;
    	   if ($fNodeService !~ /fwm/i) {
          $fmxstring = "$lvscmd -a -t $fNodeVip -r $fsqlIP:$fsqlIPort -$fsqlmethod -w $fsqlweight";
         } else {  
          $fmxstring = "$lvscmd -a -f $fNodeVip -r $fsqlIP -$fsqlmethod -w $fsqlweight";	
         }	
         &syslog("MGR: ReApply: $fmdstring",2);
         if ($simulate eq "0") {
          `$fmxstring`;
         } 
         &syslog("MGR: ReApply: $fmxstring",2);
         if ($simulate eq "0") {
          `$fmdstring`;
         } 
         &lvslog(11,"Move service by service by: $fmxstring","system");
         &lvslog(11,"Move service by service by: $fmdstring","system");
         #Set New Node
         #print "=> SQL: UPDATE tblNodesInventory SET resID = '" . $fsqlPoolReource . "' where invID ='" . $fsqliID . "';\n" ;
         &syslog("MGR: SQL: UPDATE tblNodesInventory SET resID = '" . $fsqlPoolReource . "' where invID ='" . $fsqliID,2);
         if ($simulate eq "0") {
          $fsqlcur = $fdbh->prepare("UPDATE tblNodesInventory SET resID = '" . $fsqlPoolReource . "' where invID ='" . $fsqliID . "';" );
          $fsqlcur->execute;
         } 
         &syslog("MGR: SQL: UPDATE tblNodesInventory SET enabled = '1' where invID ='" . $fsqliID,2);
         if ($simulate eq "0") {
          $fsqlcur = $fdbh->prepare("UPDATE tblNodesInventory SET enabled = '1' where invID ='" . $fsqliID . "';" );
          $fsqlcur->execute;
         } 
         &syslog("MGR: SQL: UPDATE tblNodesInventory SET weightdown = '0' where invID ='" . $fsqliID,2);
         if ($simulate eq "0") {
          $fsqlcur = $fdbh->prepare("UPDATE tblNodesInventory SET weightdown = '0' where invID ='" . $fsqliID . "';" );
          $fsqlcur->execute;
         } 
         ($fvar,$fvalue) = split(/$myHost\s*/,$fsqlLink,2);     #Get Full Command 
         #print " REPLACE - $fvar - $fvalue  <BR> \n";       
         &syslog("MGR: SQL: UPDATE tblNodesInventory SET link = '".$fvar.$fmyCHost.$fvalue."' where invID ='" . $fsqliID,2);
         #print " DEBUG $myHost-$fsqlLink  -- $fvar-$fmyCHost-$fvalue <BR>\n";       
         if ($simulate eq "0") {
          $fsqlcur = $fdbh->prepare("UPDATE tblNodesInventory SET link = '".$fvar.$fmyCHost.$fvalue."' where invID ='" . $fsqliID . "';" );
          $fsqlcur->execute;
         } 
         last;
        } else { #if (!$fweightdownstate) { 
         &syslog("MGR: WARNING: Resource is bad for takeover -- $fsqlPoolReource",2);
        } #if (!$fweightdownstate) { 
       }  #if ($fsqlaEnabled eq "1") {
      
      } 
       
     }	 #if ($fsqlPoolReource ne $fResID)  
    }    #while (($fsqlPoolReource)=$fsqlpool->fetchrow_array) 	    

    if (!$fauto_ok) {
   	 &syslog("MGR: ==>> CRITICAL <<== - No Server found for automove",2);
   	 #SendEmergencyEMail
    }
   }     #if (($fsqlPoolID) and ($fsqlPoolID ne "0"))
   ##########################################
   ###########  DONE AUTOMOVE  ##############
   ##########################################
  }   #while (my($fsqliID,$fsqliWeight,$fsqlNodeID,$fsqlLink,$fsqlIPort)=$sqli->fetchrow_array) 

  
}     #sub WeightDownHost





sub TurnOffHost {
	#Independant service function - Nov06
  my $fdbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword)  or &sqldead;
  

  my ($fsqlInvID,$fsqlInvWeight,$fsqlNodeID,$fsqlLink,$fsqlIPort,$fsqlactive,$fsqlmethod,$fsqlweight,$fsqlPoolID);
  my ($fsqlAlias,$fsqlIP,$fsqlpoolReource,$fweightdownstate,$fsqlinv,$fsqlinvTID,$fmyCHost,$fmxstring,$fResID);
  my ($fNodeService,$fNodeVip,$fmyIP,$fmyHost,$fmstring,$sqlc,$fauto_ok,$fsqlpool,$fvar,$fvalue,$simulate);
  $simulate="0";
	$fResID=$_[0];
  my $fsqla = $fdbh->prepare("SELECT alias,realip FROM tblResources where resID = '" . $fResID . "';" ); 
  $fsqla->execute ; #Get Inventory and ID's
  (($fsqlAlias,$fsqlIP)=$fsqla->fetchrow_array);
  $fmyIP=$fsqlIP;
  $fmyHost=$fsqlAlias;
  my $sqli = $fdbh->prepare("SELECT invID,weight,nodeID,link,port,active,method,weight,automovepoolid FROM tblNodesInventory where resID = '" . $fResID . "';" ); 
  $sqli->execute ; #Get Inventory and ID's
  while (($fsqlInvID,$fsqlInvWeight,$fsqlNodeID,$fsqlLink,$fsqlIPort,$fsqlactive,$fsqlmethod,$fsqlweight,$fsqlPoolID)=$sqli->fetchrow_array) {
   my $sqln = $fdbh->prepare("SELECT service,vip FROM tblNodes where nodeid = '" . $fsqlNodeID . "';" ); 
   $sqln->execute ; 
   ($fNodeService,$fNodeVip)=$sqln->fetchrow_array ;
   if ($fNodeService !~ /fwm/i) {
    $fmstring = "$lvscmd -d -t $fNodeVip -r $fsqlIP:$fsqlIPort";
   } else {
    $fmstring = "$lvscmd -d -f $fNodeVip -r $fsqlIP";	
   }	
   &syslog ("MGR: Apply -$fsqlPoolID: $fmstring",1);
   if ($simulate eq "0") {
    `$fmstring`;
   } 
   &lvslog(11,"Turn off service by: $fmstring","system");
   #print "SQL:: UPDATE tblNodesInventory SET enabled = '0',maintenance='1' where invID = $fsqlInvID\n";
   &syslog ("MGR: SQL:: UPDATE tblNodesInventory SET enabled='0',maintenance='1' where invID = $fsqlInvID",2);
   if ($simulate eq "0") {
    $sqlc = $fdbh->prepare("UPDATE tblNodesInventory SET enabled='0',maintenance='1' where invID ='" . $fsqlInvID . "';" );
    $sqlc->execute;
   } 
   $fauto_ok=1; 
   ##########################################
   ##############   AUTOMOVE   ##############
   ##########################################
   
   if (($fsqlPoolID) and ($fsqlPoolID ne "0")) {
   	$fauto_ok=undef;
    &syslog ("MGR: ATTENTION: Automove Service Applied To Pool: $fsqlPoolID",2);
    &syslog ("MGR: SQL: SELECT resID FROM tblPoolResources where poolID = '" . $fsqlPoolID,2);
    $fsqlpool = $fdbh->prepare("SELECT resID FROM tblPoolResources where poolID = '" . $fsqlPoolID . "';" ); 
    $fsqlpool->execute ; #Get Inventory and ID's
    while (($fsqlpoolReource)=$fsqlpool->fetchrow_array) {
     if ($fsqlpoolReource ne $fResID) {
      $fsqlAlias = $fdbh->prepare("SELECT realip,enabled,alias FROM tblResources where resID = '" . $fsqlpoolReource . "';" ); 
      $fsqlAlias->execute ; #Get Inventory and ID's
      (my($fsqlIP,$fsqlAliasEnabled,$sqlHostName)=$fsqlAlias->fetchrow_array);
      $fweightdownstate=undef;
      $fsqlinv = $fdbh->prepare("SELECT invID FROM tblNodesInventory where weightdown = '1' and resID = '" . $fsqlpoolReource . "';" ); 
      $fsqlinv->execute ; #Get Inventory and ID's
      while (($fsqlinvTID)=$fsqlinv->fetchrow_array) {
        $fweightdownstate=1;  
      }
      if (($fsqlAliasEnabled eq "1") and ( !$fweightdownstate)) {
      $fauto_ok=1;
       &syslog ("MGR: Resource is good for takeover $fsqlIP - $sqlHostName",2);
       $fmyCHost=$sqlHostName;
    	 if ($fNodeService !~ /fwm/i) {
        $fmxstring = "$lvscmd -a -t $fNodeVip -r $fsqlIP:$fsqlIPort -$fsqlmethod -w $fsqlweight";
       } else {  
        $fmxstring = "$lvscmd -a -f $fNodeVip -r $fsqlIP -$fsqlmethod -w $fsqlweight";	
       }	
       #print "=>ReApply: $fmxstring\n";
       #print "ReApply: $fmxstring \n";       
       &syslog ("MGR: ReApply: $fmxstring",2);
       if ($simulate eq "0") {
        `$fmxstring`;
       } 
       &lvslog(11,"Move service by: $fmxstring","system");
       #Set New Node
       &syslog ("MGR: SQL: UPDATE tblNodesInventory SET resID = '" . $fsqlpoolReource . "' where invID ='" . $fsqlInvID,2);
       if ($simulate eq "0") {
        $sqlc = $fdbh->prepare("UPDATE tblNodesInventory SET resID = '" . $fsqlpoolReource . "' where invID ='" . $fsqlInvID . "';" );
        $sqlc->execute;
       } 
       &syslog ("MGR: SQL: UPDATE tblNodesInventory SET enabled = '1' where invID ='" . $fsqlInvID,2);
       if ($simulate eq "0") {
        $sqlc = $fdbh->prepare("UPDATE tblNodesInventory SET enabled = '1' where invID ='" . $fsqlInvID . "';" );
        $sqlc->execute;
       } 
       ($fvar,$fvalue) = split(/$fmyHost\s*/,$fsqlLink,2);     #Get Full Command 
       &syslog ("MGR: SQL: UPDATE tblNodesInventory SET link = '".$fvar.$fmyCHost.$fvalue."' where invID ='" . $fsqlInvID,2);
       if ($simulate eq "0") {
        $sqlc = $fdbh->prepare("UPDATE tblNodesInventory SET link = '".$fvar.$fmyCHost.$fvalue."' where invID ='" . $fsqlInvID . "';" );
        $sqlc->execute;
       } 
       last;
      } else {
      	#print "Warning: Resource is bad for takeover $fsqlIP - $sqlHostName\n";
      	&syslog ("MGR: Warning: Resource is bad for takeover $fsqlIP - $sqlHostName",2);
      }
     }	#if ($fsqlpoolReource ne $fResID)  
    }   #while (($fsqlpoolReource)=$fsqlpool->fetchrow_array) 	    
   }    #if (($fsqlPoolID) and ($fsqlPoolID ne "0"))
   ##########################################
   ###########  DONE AUTOMOVE  ##############
   ##########################################
  }   #while (my($fsqlInvID,$fsqlInvWeight,$fsqlNodeID,$fsqlLink,$fsqlIPort)=$fsqlinv->fetchrow_array) 
  if (!$fauto_ok) {
   &syslog ("==>>MGR: CRITICAL <<== - No Server found for automove",2);
  }
  &syslog ("MGR: SQL: UPDATE tblResources SET enabled = '0' where resID = '" . $fResID,2);
  if ($simulate eq "0") {
   $sqlc = $fdbh->prepare("UPDATE tblResources SET enabled = '0' where resID = '" . $fResID . "';");
   $sqlc->execute;
  } 
  &syslog ("MGR: SQL: UPDATE tblState SET statechange = '1' where stateID ='1'",2);
  if ($simulate eq "0") {
   $sqlc = $fdbh->prepare("UPDATE tblState SET statechange = '1' where stateID ='1';");
   $sqlc->execute;
  } 
 
}      #sub TurnOffHost 



sub TurnOnHost {
	#Independant service function - Nov06
  my $fdbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword)  or &sqldead;
  my ($fResID,$simulate);
  $simulate="0";
	$fResID=$_[0];
  my ($fmyIP,$sqli,$fsqlAlias,$fsqlIP,$sqln,$fmstring,$sqlc);
  my ($fsqlInvID,$fsqlInvWeight,$fsqlNodeID,$fsqlLink,$fsqlIPort,$fsqlactive,$fsqlmethod,$fsqlweight,$fNodeService,$fNodeVip);
  $fsqlAlias = $fdbh->prepare("SELECT alias,realip FROM tblResources where resID = '" . $fResID . "';" ); 
  $fsqlAlias->execute ; #Get Inventory and ID's
  (($fsqlAlias,$fsqlIP)=$fsqlAlias->fetchrow_array);
  $fmyIP=$fsqlIP;
  $sqli = $fdbh->prepare("SELECT invID,weight,nodeID,link,port,active,method,weight FROM tblNodesInventory where resID = '" . $fResID . "';" ); 
  $sqli->execute ; #Get Inventory and ID's
  while (($fsqlInvID,$fsqlInvWeight,$fsqlNodeID,$fsqlLink,$fsqlIPort,$fsqlactive,$fsqlmethod,$fsqlweight)=$sqli->fetchrow_array) {
   $sqln = $fdbh->prepare("SELECT service,vip FROM tblNodes where nodeid = '" . $fsqlNodeID . "';" ); 
   $sqln->execute ; 
   ($fNodeService,$fNodeVip)=$sqln->fetchrow_array ;
   if ($fNodeService !~ /fwm/i) {
    $fmstring = "$lvscmd -a -t $fNodeVip -r $fsqlIP:$fsqlIPort -$fsqlmethod -w $fsqlweight";
   } else {
    $fmstring = "$lvscmd -a -f $fNodeVip -r $fsqlIP -$fsqlmethod -w $fsqlweight";	
   }	
   if ($fsqlactive eq "0") {
    &syslog("MGR: WARNING: Host $fsqlIP:$fsqlIPort is in down state.",2);
   }
   if ($simulate eq "0") {
   &syslog("MGR: Apply: $fmstring",2);
   `$fmstring`;
   } 
   &lvslog(11,"Turn on service by: $fmstring","system");
   if ($simulate eq "0") {
    $sqlc = $fdbh->prepare("UPDATE tblNodesInventory SET enabled = '1',maintenance='0',active='1' where invID ='" . $fsqlInvID . "';" );
    $sqlc->execute;
   } 
   &syslog("MGR: SQL: UPDATE tblNodesInventory SET weightdown = '0',maintenance='0' where invID ='" . $fsqlInvID,2);       
   if ($simulate eq "0") {
    $sqlc = $fdbh->prepare("UPDATE tblNodesInventory SET weightdown = '0',maintenance='0' where invID ='" . $fsqlInvID . "';" );
    $sqlc->execute;
   } 
  }   #while (my($fsqlInvID,$fsqlInvWeight,$fsqlNodeID,$fsqlLink,$fsqlIPort)=$sqlinv->fetchrow_array) 
   &syslog("MGR: SQL: UPDATE tblResources SET enabled = '1' where resID = '" . $fResID,2);
   if ($simulate eq "0") {
    $sqlc = $fdbh->prepare("UPDATE tblResources SET enabled = '1' where resID = '" . $fResID . "';");
    $sqlc->execute;
   } 
   &syslog("MGR: SQL: UPDATE tblState SET statechange = '1' where stateID ='1'",2);
   if ($simulate eq "0") {
    $sqlc = $fdbh->prepare("UPDATE tblState SET statechange = '1' where stateID ='1';");
    $sqlc->execute;
   } 
 }  #sub TurnOnHost



sub subGetHostAvail {

     #Count Available hosts for this groupID
     #&syslog("=>$SQLMip $SQLRid ",1);
   if ($_[0]){  
     my ($SQLInvenabled,$SQLInvmaintenance,$SQLInvactive,$SQLInvweightdown);
     my $AvblHst;
     my $AvblHost=1;
     #SELECT count(*) as expr FROM tblNodesInventory where resID = '14' and enabled='1' and maintenance='0' and active='1' and weightdown='0';
     my $sqlid = $dbhCurNext->prepare("SELECT enabled,maintenance,active,weightdown FROM tblNodesInventory where resID = '".$_[0]."';" ) or &sqldead; 	 
     #my $sqlid = $dbhCurNext->prepare("SELECT count(*) as expr FROM tblNodesInventory where resID = '14' and enabled='1' and maintenance='0' and active='1' and weightdown='0';" ) or &sqldead; 	 
     #print "SELECT enabled,maintenance,active,weightdown FROM tblNodesInventory where resID = '$_[0]';\n";
     $sqlid->execute ;  
     #while (($SQLInvenabled,$SQLInvmaintenance,$SQLInvactive,$SQLInvweightdown)=$sqlid->fetchrow_array){
     while (($SQLInvenabled,$SQLInvmaintenance,$SQLInvactive,$SQLInvweightdown)=$sqlid->fetchrow_array){
      #print "DEB $SQLInvenabled,$SQLInvmaintenance,$SQLInvactive,$SQLInvweightdown\n";
      if ((!$SQLInvenabled) or ($SQLInvmaintenance) or (!$SQLInvactive) or ($SQLInvweightdown)){
       $AvblHost=undef;
       last;
      } 
     } 
     if ($AvblHost){
     	#&syslog ("===>>>>Avbl:",1);
     	return 1;
     };
     
    } else {
     &syslog ("Warning: Did not receive any parameter -> subGetHostAvail ",1);
    }
     return undef;
}

sub subGetHostMaintenance {
 if ($_[0]) {
     my ($SQLInvenabled,$SQLInvmaintenance,$SQLInvactive,$SQLInvweightdown);
     my $AvblHst;
     my $AvblHost=1;
     my $sqlid = $dbhCurNext->prepare("SELECT enabled,maintenance,active,weightdown FROM tblNodesInventory where resID = '".$_[0]."';" ) or &sqldead; 	 
     $sqlid->execute ;  
     while (($SQLInvenabled,$SQLInvmaintenance,$SQLInvactive,$SQLInvweightdown)=$sqlid->fetchrow_array){
      if (!$SQLInvmaintenance){
       $AvblHost=undef;
       last;
      } 
     } 
     if ($AvblHost){
     	return 1;
     };
     
  }  else {
  	  &syslog ("Warning: Did not receive any parameter -> subGetHostMaintenance ",1);
  } 
     return undef;
}


 sub subGetResourceID {
  # Get ResourceID
  my $SQSRid;
  my $sqlid = $dbhCurNext->prepare("SELECT resID FROM tblResources where realip = '".$_[0]."';" ) or &sqldead; 	 
  $sqlid->execute ;  
  (($SQSRid)=$sqlid->fetchrow_array);
  return $SQSRid;
 }


sub ManagageMaintenanceRequest {
 #ToDo: Move sql-sync to the end of the process - don not want to be synch with each drain down process
 #2.0.3.15
 #Apply Config Array:
 #GoupID=n GroupRemoveMax=n GroupMinAvailable=n
 
 
 #my ($dbhFCurMain,$dbhFCurNext);  #2.0.3.16
 #$dbhFCurMain = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword) or &sqldead; #2.0.3.16
 #$dbhFCurNext = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword) or &sqldead; #2.0.3.16

 
 my $sqlmain;
 my $tldate = strftime("%Y%m%d%H%M%S", localtime(time));	
 #2.0.3.15
  my ($SQLid,$SQLip,$SQLhostname,$SQLgroupID,$SQLrequestUP,$SQLrequestDown,$SQLWeightDownTime,$SQLWeightDownPending,$SQLTurnOffTime,$SQLTurnOffPending,$SQLUpdatepending,$SQLCurWeightDownTime,$SQLCurTurnOffTime);
  my ($SQLMax,$SQLMip,$SQLRid,$SQLInvID,$SQLCurOut,$sqlmax,$sqlins,$SQLMaint,$SQLCurCnt,$SQLResCnt,$SQLCRid,$SQLFnd);
  
  #Get current maintenance request
  #&syslog("SELECT mid,ip,hostname,groupID,requestUP,requestDown,WeightDownTime,WeightDownPending,TurnOffTime,TurnOffPending,Updatepending,CurWeightDownTime,CurTurnOffTime FROM tblMaintenance where (requestUP = '1' or requestDOWN = '1') and enabled = '1';",1);
  $sqlmain = $dbhCur->prepare("SELECT mid,ip,hostname,groupID,requestUP,requestDown,WeightDownTime,WeightDownPending,TurnOffTime,TurnOffPending,Updatepending,CurWeightDownTime,CurTurnOffTime FROM tblMaintenance where (requestUP = '1' or requestDOWN = '1') and enabled = '1';" ) or &sqldead;
  $sqlmain->execute ;  
  #&syslog("Deb Aug2010: SELECT mid,ip,hostname,groupID,requestUP,requestDown,WeightDownTime,WeightDownPending,TurnOffTime,TurnOffPending,Updatepending,CurWeightDownTime,CurTurnOffTime FROM tblMaintenance where (requestUP = '1' or requestDOWN = '1') and enabled = '1';",1);
  while (($SQLid,$SQLip,$SQLhostname,$SQLgroupID,$SQLrequestUP,$SQLrequestDown,$SQLWeightDownTime,$SQLWeightDownPending,$SQLTurnOffTime,$SQLTurnOffPending,$SQLUpdatepending,$SQLCurWeightDownTime,$SQLCurTurnOffTime)=$sqlmain->fetchrow_array){

   #&syslog("Deb Aug2010: $SQLid,$SQLip,$SQLhostname,$SQLgroupID,$SQLrequestUP,$SQLrequestDown,$SQLWeightDownTime,$SQLWeightDownPending,$SQLTurnOffTime,$SQLTurnOffPending,$SQLUpdatepending,$SQLCurWeightDownTime,$SQLCurTurnOffTime",1);


   ##### RESET #####
   if (!$SQLgroupID){  #If no groupID is given then reset to defaults 9999
    $UDGroupMinAvailable{9999}=1;
    $UDGroupRemoveMax{9999}=1;
    $SQLgroupID=9999;
   } 
   if (!$UDGroupMinAvailable{$SQLgroupID}){ #If amount of avaail hosts corrsponding to tblmaintenance is not geive then reset to defaults
    $UDGroupMinAvailable{$SQLgroupID}=1;
   }
   if (!$UDGroupRemoveMax{$SQLgroupID}){ #If no group id corrsponding to tblmaintenance was found then reset to defaults
    $UDGroupRemoveMax{$SQLgroupID}=1;   
   }
   if (!$SQLCurWeightDownTime){$SQLCurWeightDownTime=0} #SetDef
   if(!$SQLCurTurnOffTime){$SQLCurTurnOffTime=0}        #SetDef 
   ##### FIN RESET #####




   if (($SQLrequestDown eq 1) and ($SQLrequestUP eq 0)  and ($SQLWeightDownPending eq 0)) {
   	#Add CheckFuntion !
   	##############################################################
   	#########     Get Maximum Down For this Group    #############
    #Get Amount of avil. hosts for this GroupID
    my $AvblHosts=0;
    my $MaintenanceHosts=0;  
    #&syslog("Deb Aug2010a: SELECT count(*) as expr FROM tblMaintenance where groupID = '".$UDGroupRemoveMax{$SQLgroupID}."';",1);
    $sqlmax = $dbhCurMain->prepare("SELECT count(*) as expr FROM tblMaintenance where groupID = '".$UDGroupRemoveMax{$SQLgroupID}."';" ) or &sqldead; 	
    $sqlmax->execute ;  
    (($SQLMax)=$sqlmax->fetchrow_array);
    #&syslog("Deb Aug2010a: => $SQLMax",1);
    #List all maintenance host and see if the host is available
    $sqlmax = $dbhCurMain->prepare("SELECT ip FROM tblMaintenance where groupID = '".$SQLgroupID."';" ) or &sqldead; 	
    $sqlmax->execute ;  
    while (($SQLMip)=$sqlmax->fetchrow_array){
     ## Get ResourceID
     $SQLRid=&subGetResourceID($SQLMip);
     if ($SQLRid) {
      #&syslog("Deb ResID $SQLRid $SQLMip - GID $SQLgroupID",1);
     } 
     if (&subGetHostAvail($SQLRid)){      #Calc amount of available hosts
      $AvblHosts++;
     }
    
     if (&subGetHostMaintenance($SQLRid)){  #Calc Current amount of maintenance hosts
      #Fix: Count only if updatepending = 0
      #&syslog("Deb Aug2010b: SELECT mID from tblMaintenance where ip='".$SQLMip."' and updatepending='0';",1);
      my $sqliid = $dbhCurNext->prepare("SELECT mID from tblMaintenance where ip='".$SQLMip."' and updatepending='0';" ) or &sqldead; 	 
      $sqliid->execute ;  
      (($SQLFnd)=$sqliid->fetchrow_array);
       if ($SQLFnd){
       #	&syslog("Deb Aug2010b: => $SQLFnd ",1);
        $MaintenanceHosts++;
       } 
     }
    
     #Finished List all maintenance host and see if the host is available
    }   #while (($SQLMip)=$sqlmax->fetchrow_array)
    #########    Finished  Get Maximum Down For this Group    #############
    #######################################################################



    #Get Current amount of removed hosts for this group
    #&syslog("Deb Aug2010b: => SELECT count(*) FROM tblMaintenance where updatepending ='1' and groupID='".$SQLgroupID."'; ",1);
    my $sqlcur = $dbhCurMain->prepare("SELECT count(*) FROM tblMaintenance where updatepending ='1' and groupID='".$SQLgroupID."';" ) or &sqldead; 	
    $sqlcur->execute ;  
    (($SQLCurOut)=$sqlcur->fetchrow_array);
   	#&syslog("Deb Aug2010b: => $SQLCurOut",1);

    #####   Final Host Down Sequence	  #####
    #&syslog("Deb Aug2010b: => SELECT count(*) FROM tblMaintenance where updatepending='1' and groupID='".$SQLgroupID."';",1);
    my $sqlins = $dbhCurMain->prepare("SELECT count(*) FROM tblMaintenance where updatepending='1' and groupID='".$SQLgroupID."';" ) or &sqldead; 	
    $sqlins->execute ;  
    (($SQLCurCnt)=$sqlins->fetchrow_array);
    #&syslog("Deb Aug2010b: => $SQLCurCnt",1);
    $MaintenanceHosts+=$SQLCurCnt;
    #&syslog("CurDownTimer $SQLCurCnt",1);
    
    $SQLCRid=&subGetResourceID($SQLip);
    #&syslog("Deb Aug2010b: => SELECT count(*) as expr FROM tblNodesInventory where (enabled='0' or maintenance='1' or active='0' or weightdown='1') and resID='".$SQLCRid."';",1);
    $sqlins = $dbhCurMain->prepare("SELECT count(*) as expr FROM tblNodesInventory where (enabled='0' or maintenance='1' or active='0' or weightdown='1') and resID='".$SQLCRid."';" ) or &sqldead; 	
    $sqlins->execute ;  
    (($SQLResCnt)=$sqlins->fetchrow_array);
    #&syslog("Deb Aug2010b: => $SQLResCnt",1);
    
    #WeightDown Manager
   	if (($AvblHosts > $UDGroupMinAvailable{$SQLgroupID}) and ($MaintenanceHosts < $UDGroupRemoveMax{$SQLgroupID}) and (!$SQLUpdatepending) and (!$SQLResCnt)){
   	 #&syslog("RequestDown: $SQLip ==> $SQLhostname => $SQLMax => $UDGroupRemoveMax{$SQLgroupID} => $UDGroupMinAvailable{$SQLgroupID} => $SQLgroupID => $AvblHosts =>$SQLCurOut => => $MaintenanceHosts",1);
     #&syslog("update tblMaintenance set response='300', message = 'WeightDown in progress, please stand by', updatepending='1', responsedate='".$tldate."' where mID = '" .$SQLid. "';" ,1);
     $sqlins = $dbhCurMain->prepare("update tblMaintenance set response='300', message = 'WeightDown in progress, please stand by', updatepending='1', responsedate='".$tldate."' where mID = '" .$SQLid. "';" );
     $sqlins->execute;
   	} else {
   	 if ((!$SQLUpdatepending) and (!$SQLResCnt)) {
      &syslog("Max DownSequence reached, set to hold: GroupID => $SQLgroupID IP/Hostname => $SQLip/$SQLhostname ",1);
      &syslog("    AvailableHosts/MinRequiredHosts  => $AvblHosts/$UDGroupMinAvailable{$SQLgroupID} CurMaintenanceHosts/MaxRemoveHosts => $MaintenanceHosts/$UDGroupRemoveMax{$SQLgroupID}",1);
      $sqlins = $dbhCurMain->prepare("update tblMaintenance set response='302', message = 'Another maintenance service is already running, please come back later', responsedate='".$tldate."' where mID = '" .$SQLid. "';" );
      $sqlins->execute;
     }          #if (!$SQLUpdatepending) 
     if (($SQLResCnt) and (!$SQLUpdatepending)){
      #Problem falls vorheriges update fehlschlug, dann wird der Host als entfernt angesehen - 29Nov besteht immer noch
      &syslog("Host has already maintenance set or is turned off: $SQLResCnt GroupID => $SQLgroupID IP/Hostname => $SQLip/$SQLhostname ",1);
      &syslog("Host Reset: IP/Hostname => $SQLip/$SQLhostname ",1);
      &syslog("update tblMaintenance set CurWeightDownTime='0',RequestDown='0', RequestUp='0', WeightDownPending='0',TurnOffPending='0',CurTurnOffTime='0', updatepending='0', response='401', message = 'Host is turned off due to operations', responsedate='".$tldate."' where mID = '" .$SQLid);
      $sqlins = $dbhCurMain->prepare("update tblMaintenance set CurWeightDownTime='0',RequestDown='0', RequestUp='0', WeightDownPending='0',TurnOffPending='0',CurTurnOffTime='0', updatepending='0', response='401', message = 'Host is turned off due to operations', responsedate='".$tldate."' where mID = '" .$SQLid. "';" );
      $sqlins->execute;
     }
   	}           #if (($AvblHosts > .... 
   	####   Final Host Down Sequence	  #####
   	
   	
   }            #if (($SQLrequestDown eq 1) and ($SQLrequestUP eq 0)) 

   
   if ($SQLrequestUP eq 1) {  #Turn On Host Sequence
    $SQLRid=&subGetResourceID($SQLip);
    #Check if maintenance has been set, otherwise turn on makes no sense
    $sqlins = $dbhCurMain->prepare("SELECT maintenance FROM tblNodesInventory where resID = '".$SQLRid."' and (maintenance = '1' or weightdown='1');" ) or &sqldead;
    $sqlins->execute ;  
    (($SQLMaint)=$sqlins->fetchrow_array);
    if ($SQLMaint) {
     &TurnOnHost($SQLRid);
     &syslog("Turn on host -> $SQLip - $SQLhostname",1); #Moegliches Problem an dieser Stelle, SQL Exec scheint nicht zu funktionieren 29Nov2011
     #&syslog("Deb Sequenze follwoing",1);
     &syslog("update tblMaintenance set response='200', CurWeightDownTime='0',RequestDown='0', RequestUp='0', WeightDownPending='0',TurnOffPending='0',CurTurnOffTime='0', updatepending='0',responsedate='".$tldate."', message='Host has been turned on' where mID = '" .$SQLid . "';",1);
     $sqlins = $dbhCurMain->prepare("update tblMaintenance set response='200', CurWeightDownTime='0',RequestDown='0', RequestUp='0', WeightDownPending='0',TurnOffPending='0',CurTurnOffTime='0', updatepending='0',responsedate='".$tldate."', message='Host has been turned on' where mID = '" .$SQLid. "';");
     $sqlins->execute;
    } else {
     &syslog("Can not turn on host $SQLip - $SQLhostname - there is no maintenance set",1);
     &syslog("Reset host $SQLip - $SQLhostname",1);
     $sqlins = $dbhCurMain->prepare("update tblMaintenance set response='403', CurWeightDownTime='0',RequestDown='0', RequestUp='0', WeightDownPending='0',TurnOffPending='0',CurTurnOffTime='0', updatepending='0',responsedate='".$tldate."', message='Host already set' where mID = '" .$SQLid. "';");
     $sqlins->execute;
    } 
   }            #if (($SQLrequestDown eq 0) and ($SQLrequestUP eq 1)) 

    ###  Timimg manager  ###
    if ($SQLUpdatepending) {
      if (($SQLrequestDown eq 1) and ($SQLrequestUP eq 0) and ($SQLTurnOffPending eq 0 ) ) {
       $SQLCurWeightDownTime++;
       #&syslog("Check HostTimer: $SQLip $SQLWeightDownTime -- $SQLCurWeightDownTime",1);
       &syslog("Check Drain Down Timer: GroupID => $SQLgroupID IP/Hostname => $SQLip/$SQLhostname ",1);
       &syslog("   WeightDownTime/Counter $SQLWeightDownTime/$SQLCurWeightDownTime",1);
       if ($SQLWeightDownPending eq 0){
        $SQLRid=&subGetResourceID($SQLip);
        &WeightDownHost($SQLRid);
        $sqlins = $dbhCurMain->prepare("update tblMaintenance set WeightDownPending='1' where mID = '" .$SQLid. "';" );
        $sqlins->execute;
       } 

       $sqlins = $dbhCurMain->prepare("update tblMaintenance set response='300', message = 'WeightDown in progress, please stand by', CurWeightDownTime='".$SQLCurWeightDownTime."',responsedate='".$tldate."' where mID = '" .$SQLid. "';" );
       $sqlins->execute;
       
       if ($SQLCurWeightDownTime > $SQLWeightDownTime){
       	&syslog("WEIGHTDOWN COMPLETE: GroupID => $SQLgroupID IP/Hostname => $SQLip/$SQLhostname",1);
       	#$SQLRid=&subGetResourceID($SQLip);
       	#&WeightDownHost($SQLRid);
       	$SQLRid=&subGetResourceID($SQLip);
        &TurnOffHost($SQLRid);
        $sqlins = $dbhCurMain->prepare("update tblMaintenance set CurWeightDownTime='0',RequestDown='1',WeightDownPending='0',TurnOffPending='1',responsedate='".$tldate."', message='TurnOff in progress, please stand by' where mID = '" .$SQLid. "';");
        $sqlins->execute;
        #&syslog("update tblMaintenance set CurWeightDownTime='0',RequestDown='1',WeightDownPending='0',TurnOffPending='1',responsedate='".$tldate."', message='TurnOff in progress, please stand by' where mID = '" .$SQLid. "';",1);
       }
      }

      if (($SQLrequestDown eq 1) and ($SQLrequestUP eq 0) and  ($SQLTurnOffPending eq 1 ) ) {
        $SQLCurTurnOffTime++;
        my $sqlinsx = $dbhCurMain->prepare("update tblMaintenance set response='301',WeightDownPending='0', CurTurnOffTime='".$SQLCurTurnOffTime."', responseDate='".$tldate."',message='TurnOff in progress, please stand by' where mID = '" .$SQLid. "';" );
        $sqlinsx->execute;
        &syslog("Check Turn Off Timer: GroupID => $SQLgroupID IP/Hostname => $SQLip/$SQLhostname ",1);
        &syslog("   TurnOffTime/Counter $SQLTurnOffTime/$SQLCurTurnOffTime",1);
        if ($SQLCurTurnOffTime > $SQLTurnOffTime){
        	#&syslog("TURN OFF COMPLETE: $SQLip -- $SQLRid",1);
        	&syslog("TURN OFF COMPLETE: GroupID => $SQLgroupID IP/Hostname => $SQLip/$SQLhostname",1);
          #&syslog("update tblMaintenance set response='200', CurWeightDownTime='0',RequestDown='0',WeightDownPending='0',TurnOffPending='0',CurTurnOffTime='0', updatepending='1',responsedate='".$tldate."', message='Host has been removed from inventory' where ip = '" .$SQLip. "';" .$SQLip. "';",1);
          $sqlins = $dbhCurMain->prepare("update tblMaintenance set response='200', CurWeightDownTime='0',RequestDown='0',WeightDownPending='0',TurnOffPending='0',CurTurnOffTime='0', updatepending='1',responsedate='".$tldate."', message='Host has been removed from inventory' where ip = '" .$SQLip. "';");
          $sqlins->execute;
        }       #if ($SQLCurTurnOffTime > $SQLTurnOffTime) 
      }         #if (($SQLrequestDown eq 1) and ($SQLrequestUP eq 0) and  ($SQLTurnOffPending eq 1 ) ) 
    }           #if ($SQLUpdatepending) #Timimg manager 
    ###  Timimg manager  ###
  }             #while (($SQLip, .....
 
 
 #$dbhFCurMain->disconnect;    #Sanity!  #2.0.3.16
 #$dbhFCurNext->disconnect;   #Sanity!   #2.0.3.16

 
 return 0;
 
}	        #sub ManagageMaintenanceRequest


sub LogRotate () {
	
  #ToDo: Add Logrotation / delete logs older then n days
  
	my $FDate = strftime("%Y%m%d%H%M%S", localtime(time));
  my $syslogfileGZ = $logfile . "-$FDate.gz" ;
  my @cmdret = `$gzip -c $logfile > $syslogfileGZ`; 
  unlink $logfile;
  &syslog ("Daily Logrotation has been completed: $syslogfileGZ",1); 
  &lvslog(12,"Daily Logrotation has been completed: $syslogfileGZ","monitor");
  #open LOGGING, ">$logfile" or die "Can not write logfile: daemon.txt $!\n";
  #print LOGGING "Daily Logrotation has been completed: $syslogfileGZ \n";
  #close LOGGING;

  opendir(DIR, $logpath); #Get files
  my @files = grep(/\.*$/,readdir(DIR));
  closedir(DIR); 	
 	
 	foreach (@files) {
 	 if (/$logname/){
 		#open(FHVER, "$logpath$logname");
 		open(FHVER, "$logpath$_");
 		my $date = (stat FHVER)[9];
 		close FHVER;
 		#print time . "--" . (time - ($oneday * $FileAge)) . "\n";
 		if ((time - ($oneday * $FileAge)) > $date) {
 	    &syslog("unlink $logpath$_",1);
 		  unlink "$logpath$_";
 		}
 	 }
 	}
 	
 	#SQL
  my $sqlmain = $dbhCur->prepare("Delete FROM tblLogging where epoche < ".(time - ($oneday * $SQLAge)).";" ) or &sqldead;
  &syslog("SQL Maintenance: Delete FROM tblLogging where epoche < ".(time - ($oneday * $SQLAge)).";",1);
  $sqlmain->execute ;  
 	return 0;	
 }






sub CheckBlackout {

 #Sample:  
 #if (&CheckBlackout(1)) {
 #	print "BLACKOUT\n";
 #}
	
 #print " Done \n";
 my ($tday,$tmonth,$tyear,$thour,$tmin,$tsec);
 my ($BlFrom,$BlTo,$BlCur,$BlTod,$BlTom,$fnd,$ftxt,$fname);
 #Delete blackoutIDs from my runtime vars if present
 $fnd=undef;
 for $bid (keys %LvsBlackoutEnabled ){  #
 	 #print " $bid \n";
  for $bgid (keys %{$LvsBlackoutEnabled{$bid}} ){  #
   my $tm = localtime;
   #print " Current time:" .time  ." \n";
   #print $LvsBlackoutEnabled{$bid}{$bgid} . "\n";
   #print  $LvsBlackoutName{$bid}{$bgid} . "\n";
   #print  $LvsBlackoutGID{$bid}{$bgid} . "\n";
   #print  $LvsBlackoutFrom{$bid}{$bgid} . "\n";
   #print  $LvsBlackoutTo{$bid}{$bgid} . "\n";
   
   
   if ($LvsBlackoutGID{$bid}{$bgid} eq $_[0]){
   
    $tday=strftime("%d", localtime(time));   
    $tmonth=strftime("%m", localtime(time));   
    $tyear=strftime("20%y", localtime(time));   
   
   
    
    if ($LvsBlackoutFrom{$bid}{$bgid} =~ m/(\d{2}):(\d{2})/){
    
     $thour=$1;
     $tmin=$2;
     $tsec="00";
     #print "FROM=== $tday-$tmonth-$tyear $thour:$tmin:$tsec\n";
     #print "FROM=== " . str2time("$tday-$tmonth-$tyear $thour:$tmin:$tsec")."\n";
     $BlFrom=str2time("$tday-$tmonth-$tyear $thour:$tmin:$tsec");
     $ftxt="$thour:$tmin:$tsec"
    }


    if ($LvsBlackoutTo{$bid}{$bgid} =~ m/(\d{2}):(\d{2})/){
     $thour=$1;
     $tmin=$2;
     $tsec="00";
     #print "TO=== $tday-$tmonth-$tyear $thour:$tmin:$tsec\n";
     #print "TO=== " . str2time("$tday-$tmonth-$tyear $thour:$tmin:$tsec")."\n";
     $BlTo=str2time("$tday-$tmonth-$tyear $thour:$tmin:$tsec");
     $ftxt.=" - $thour:$tmin:$tsec"
    }



    $thour=strftime("%H", localtime(time));   
    $tmin=strftime("%M", localtime(time));   
    $tsec=strftime("%S", localtime(time));   
   
   
    #print "=== $tday-$tmonth-$tyear $thour:$tmin:$tsec\n";
    #print "=== " . str2time("$tday-$tmonth-$tyear $thour:$tmin:$tsec")."\n";
    $BlCur=str2time("$tday-$tmonth-$tyear $thour:$tmin:$tsec");
   
    $BlTod=str2time("$tday-$tmonth-$tyear 00:00:00");
    $BlTom=$BlTod+$oneday;
    #print "Today: $BlTod\n";
    #print "Tomor: $BlTom\n";
   
   
    if (($BlCur > $BlFrom) and ($BlCur < $BlTo)) {
   	 #print "==>> BLACKOUT <<==\n";
	    $fname = $LvsBlackoutName{$bid}{$bgid} . " => " . $ftxt;
	    $fnd=1;
	    last;
    } else {
   	 #print "NONE BLACKOUT\n";
   	 
    }
   
   
    if (($BlCur > $BlFrom) and ($BlFrom > $BlTo)) { #Midnight in between like: 23:00 - 01:00
    	#print "==>> ON BLACKOUT <<==\n";
	    $fname = $LvsBlackoutName{$bid}{$bgid} . " => " . $ftxt;
    	$fnd=1;
    	last;
    } else {
    	#print "NONE ON BLACKOUT\n";
    }
   
   } 
  }
 }


 
 if ($fnd) {
 	if (!$LVSBlackoutChange{$_[0]}) {
 	 &syslog("Blackout occured, ID: $_[0]: $fname",1);	
 	 &lvslog(3,"Blackout occured, ID: $_[0]: $fname","monitor");
 	 $LVSBlackoutChange{$_[0]}=1;
 	}
 	return 1;
 } else {
 	
 	if ($LVSBlackoutChange{$_[0]}) {
 	 &syslog("Blackout disappeared, ID: $_[0]",1);	
 	 &lvslog(3,"Blackout has been stopped, ID: $_[0]","monitor");
 	 $LVSBlackoutChange{$_[0]}=undef;
 	}
 	return undef;
 }	
 	
	
}