#!/usr/bin/perl
#Script to load and apply te mylvs database.

use strict;
use DBI;
use POSIX;

####################### CONFIGURATION #######################
use XML::Simple;
use Data::Dumper;
my $conffile="/etc/mylvs/mylvs.conf.xml";
my ($servername,$database,$sqluser,$sqlpassword,$lvscmd,$bkupdatabase,$bkupsqluser,$bkupsqlpassword,$bkupservername,$apply);
&getconfig;
####################### CONFIGURATION #######################


#Get Parameter
my $apply = undef;
my ($arg1,$STRactive);
($arg1) = (@ARGV);
 if ($arg1 =~ /-a/){
	print "Apply\n";
	$apply=1;
}	
if ($arg1 eq "-ia"){
 print "$arg1\n";
 $STRactive="and enabled='1'";
} else {
 if ($arg1 eq "-it"){
  print "$arg1\n";
  $STRactive="";
 } else {
  $STRactive="and active='1' and enabled='1' ";
 }
}




if ($arg1 eq "-h"){
 print "use: -ia list even inactive server | -it list total even if disabled or incative | -a apply to system rather then print only\n";
 exit;
}


my ($NodeID,$NodeName,$NodeScheduler,$NodeService,$NodeVIP,$NodePersistent,$ResAlias,$ResRealIP,$ResEnabled);
my ($InvID,$InvResID,$InvMethod,$invLink,$InvWeight,$InvAutomovePoolID,$InvPort,$InvFailstate);
my ($scheduler,$persistent);

if ($apply) {
        print "Apply: $lvscmd -C \n";
	`$lvscmd -C`;
} else {
        print "$lvscmd -C \n";
}
#Get Inventory from mySQL 
 my $dbh = DBI->connect("DBI:mysql:$database:$servername:3306",$sqluser,$sqlpassword);
 my $sqlnode = $dbh->prepare("SELECT nodeID,Name,scheduler,service,vip,persistent FROM tblNodes" );
 $sqlnode->execute ;  #Get Nodes
 while(($NodeID,$NodeName,$NodeScheduler,$NodeService,$NodeVIP,$NodePersistent)=$sqlnode->fetchrow_array) {
  print "#Create Node: $NodeName\n";
  if ($NodeService !~ /fwm/i) {
   $scheduler = "-t $NodeVIP";
  } else {
   $scheduler = "-f $NodeVIP";	
  }	
  
  if ($NodePersistent ne "0"){
   $persistent = "-p $NodePersistent";
  } else {
   $persistent="";
  }	 
  if ($apply) {
          print "Apply: $lvscmd -A $scheduler -s $NodeScheduler $persistent\n";
 	 `$lvscmd -A $scheduler -s $NodeScheduler $persistent`
  } else {
          print "$lvscmd -A $scheduler -s $NodeScheduler $persistent\n";
  }	

  my $sqlnodeinv = $dbh->prepare("SELECT invID,resID,Method,Link,Weight,AutomovePoolID,Port,Failstate FROM tblNodesInventory where active='1' and nodeID='" . $NodeID ."' $STRactive;" );
  $sqlnodeinv->execute ;  #Get NodesInentory
  print "#Create Realserver: \n";
  while(($InvID,$InvResID,$InvMethod,$invLink,$InvWeight,$InvAutomovePoolID,$InvPort,$InvFailstate)=$sqlnodeinv->fetchrow_array) {
   #my $sqlnoderes = $dbh->prepare("SELECT alias,realip FROM tblResources where resID='" . $InvResID ."';" );
   #$sqlnoderes->execute ; #Get Resources
   my $sqlresource = $dbh->prepare("SELECT alias,realip,enabled FROM tblResources where resID='" . $InvResID ."';" );
   $sqlresource->execute;
   (($ResAlias,$ResRealIP,$ResEnabled)=$sqlresource->fetchrow_array)   ;
   if ($ResEnabled) {
    if ($apply) {
        print "Apply: $lvscmd -a $scheduler -r $ResRealIP -$InvMethod -w $InvWeight #$NodeID-$InvID\n";
    	`$lvscmd -a $scheduler -r $ResRealIP -$InvMethod -w $InvWeight`
    }else {
        print "$lvscmd -a $scheduler -r $ResRealIP -$InvMethod -w $InvWeight #$NodeID-$InvID\n";
    }	
   } 
  }
 } 
 
 
 sub getconfig {
 #Read xml config file
 my $xml = new XML::Simple (KeyAttr=>[]); # create XML object
 my $data = $xml->XMLin("$conffile");
 #print Dumper($data);
 $servername=$data->{SQLServer}->{Address};
 $database=$data->{SQLServer}->{Database};
 $sqluser=$data->{SQLServer}->{User};
 $sqlpassword=$data->{SQLServer}->{Password};
 $lvscmd=$data->{LVS}->{Command};
 $bkupservername=$data->{SQLServerBackup}->{Address};
 $bkupdatabase=$data->{SQLServerBackup}->{Database};
 $bkupsqluser=$data->{SQLServerBackup}->{User};
 $bkupsqlpassword=$data->{SQLServerBackup}->{Password};
}