#!/usr/bin/perl
#HTTP File Transfer (hcp)
#see: https://coolscript.org/index.php/HTTP_Copy

use strict;
use IO::Uncompress::Gunzip qw(gunzip $GunzipError );

#####################################
my $SyslogHost=0; #DISABLED FOR DOCKER
#my $SyslogHost='127.0.0.1';  #apt-get install build-essential & cpan install Net::Syslog
my $uploadpath='/usr/local/hft-data/';
#####################################

#BEGIN, do not change anything below unless you know what youre doing
my ($isgzipped,$hcpFilename,$slog,$buffer,$uncompresedBUFFER);
if ($SyslogHost) {
#DISABLED FOR DOCKER
# use Net::Syslog;  #apt-get install build-essential &  cpan install Net::Syslog
# $slog=new Net::Syslog(Facility=>'local1',Priority=>'info',SyslogHost=>$SyslogHost);
}
syslog("HTTP FILE COPY ");
syslog("Receiving data from " . $ENV{REMOTE_ADDR});
for my $code ( sort keys %ENV ){  #Enumerate http environmend
 if (($code eq 'HTTP_GZIP' ) and ($ENV{$code} eq 1)) {
   syslog("Info: Content is gzipped");
   $isgzipped=1;  #Gzip Flag
# } else {
 #  $isgzipped=false;
 }
 if (($code eq 'HTTP_FILENAME' ) and ($ENV{$code})) {
  $hcpFilename=$ENV{$code}; #Get Fileanme
 }
}

my $Content_type=$ENV{CONTENT_TYPE};

# ***  SECURITY CHECKS  *****
if (!$hcpFilename) {errorandler("SYNTAX ERROR - No Filename");} #Filename is mandatory!

#Check for invalid chars in file string, i do not like injections at this point
if ($hcpFilename =~ /(\.\.|\/|\$|\\|\@|\!|\#|\%|\*|\(|\)|\=|\+|\"|\'|\;|\:|\<|\>|\|\|\?)/ ) {
 &errorandler("SYNTAX ERROR - Invalid Filename");
}
# ***  // SECURITY CHECKS  *****
if($ENV{CONTENT_LENGTH}) { read(STDIN,$buffer,$ENV{CONTENT_LENGTH}); }
print "Content-type: $Content_type\n\n";
if( ! length($buffer) ) { $buffer = '[No POST data received]'; }
if (length($buffer)) {
 syslog('Post data is (' . length($buffer) . " chars)");
 syslog("FileName: " . $ENV{HTTP_FILENAME});
 syslog("Content Type: " . $ENV{CONTENT_TYPE});
 syslog("Length: " . length($buffer));
 syslog("Write data to: $uploadpath$hcpFilename");
 open FHB, ">$uploadpath$hcpFilename" or errorandler("ACCESS DENIED: $hcpFilename $!");
 if ($isgzipped){
  syslog("Gunzip data $hcpFilename");
  gunzip \$buffer => \$uncompresedBUFFER or die;
  syslog("Gunzip complete");
  syslog("Write data to: $uploadpath$hcpFilename");
  print FHB $uncompresedBUFFER;
 } else {
  syslog("Write data to: $uploadpath$hcpFilename");
  print FHB $buffer;
 }
 syslog("Writing data complete");
}
close FHB;
print "200 Process complete\n";  #No error until here means OK - Keep the string
exit;


sub syslog {
 #Note: if you're in trouble with syslog then use the logger command
 if ($SyslogHost) {
  #$slog->send("HFT " . $_[0],Priority=>'info');
 }
}


sub errorandler() {
    syslog($_[0]);
    print "\n\n";
    print "500 $_[0]";
    exit;
}