#!/usr/bin/perl
#Perl script to copy data using http/https
#See: https://coolscript.org/index.php/HTTP_Copy

use strict;
use LWP::UserAgent;
use Getopt::Long;
use File::Basename;
use IO::Compress::Gzip qw(gzip $GzipError) ;  #1.1.36
my ($opt_file,$opt_url,$opt_user,$opt_password,$buffer,$flag_gzip,$datalength,$gzip,$response,$flag_ssl_ignore,$ua);
my $progname=$0;
GetOptions
    ("f=s" => \$opt_file, 
     "url=s" => \$opt_url, 
     "u=s" => \$opt_user, 
     "p=s" => \$opt_password, 
     "g" => \$flag_gzip, 
     "i" => \$flag_ssl_ignore, 
);
if (!$opt_file) {
 print "No filename given\n";
 &print_help;
 exit;
}
if (!$opt_file) {
 print "No url given\n";
 &print_help;
 exit;
}




if (($opt_user) and ($opt_password)) {
 if ($opt_url=~/^https:\/\//) {
  $opt_url=~s/https:\/\///g;
  $opt_url='https://'.$opt_user.":".$opt_password.'@'.$opt_url;
 } else {
 if ($opt_url=~/^http:\/\//) {
   $opt_url=~s/http:\/\///g;
   $opt_url='http://'.$opt_user.":".$opt_password.'@'.$opt_url;
  }	else {
   print "Invalid URL\n"	;
   exit;
  }
 }
}    

my $size=-s $opt_file;;
my $filebasename=basename($opt_file);

if ($flag_gzip) {
 my $input = new IO::File "<$opt_file" or die "Cannot open $opt_file: $!";
 gzip $input => \$buffer or syslog("zip failed: $!");
 $gzip=1;
} else {
 open (IN,"<$opt_file") || die "cannot open file: $!";
 binmode(IN);
 read(IN,$buffer,$size);
 close IN;
 $gzip=0;
} 

#print "$opt_url $filebasename\n";

$datalength=length($buffer);

#Note: Remove SSL verify to enable ssl full verification
if ($flag_ssl_ignore) {
 $ua = LWP::UserAgent->new(ssl_opts => { SSL_verify_mode => 0, verify_hostname => 0 });
} else {
 $ua = LWP::UserAgent->new;
}

$ua->timeout(300);
if ($flag_gzip) {
 #Note: FileCode and FileDescription is reserved for future usage
 $response = $ua->post( $opt_url,
  Content_Type => 'application/octet-stream',
  Content =>  "$buffer" ,
  FileName=> "$filebasename",
  FileCode=> "MyCode",
  FileDescription=> "MyDescription",
  Content_Encoding => 'gzip',
  GZIP => "1"
 );
} else {  #No gzip!
 $response = $ua->post( $opt_url,
  Content_Type => 'application/octet-stream',
  Content =>  "$buffer" ,
  FileName=> "$filebasename",
  FileCode=> "MyCode",
  FileDescription=> "MyDescription"
 );
}



if ($response->is_success){
 if ($response->as_string =~ /200 Process complete/) {
  if ($flag_gzip) {
   print "Gzipped transfer complete - $size/$datalength Bytes\n";
  } else {
   print "Transfer complete - $size Bytes\n";
  }
  #print $response->as_string();
 } else {
  print $response->as_string();
 }
} else {
  print $response->as_string();
}

sub print_help {
 print "Usage: $progname 
 -f <filename> 
 -url <url> 
 -u <username> - Optional, if given then -p must be set too
 -p <password> 
 -g (optional gzip data) 
 -i (optional ignore ssl host/cer checks)\n\n";
 print "Sample:\n";
 print "perl $progname -f c:\\path\\to\\file\\myfile.doc  -url https://myserver.com -u myUser -p myPwd -g -i\n\n";
}

sub syslog {
    print "$_[0] \n";
}